import { AsyncLocalStorage } from 'async_hooks';
import { Logger } from '@yandex-int/yandex-logger';
import { injectable, inject } from 'inversify';
import { NAppHostProtocol } from '@crm/protos';
import { BaseContext } from './typings/BaseContext';
import { NextFunction } from './typings/NextFunction';
import { TYPES } from './typings/TYPES';
import { BaseMiddleware } from './BaseMiddleware';
import { AsyncLocalStorageStore } from './typings/AsyncLocalStorageStore';

@injectable()
export class RequestLoggerMiddleware<
    Context extends BaseContext,
> extends BaseMiddleware<Context> {
    constructor(
        @inject(TYPES.Logger) private logger: Logger,
        @inject(TYPES.Request)
        private requestData: NAppHostProtocol.TServiceRequest,
        @inject(TYPES.AsyncLocalStorage)
        private asyncLocalStorage: AsyncLocalStorage<AsyncLocalStorageStore>,
    ) {
        super();
    }

    public async handler(_ctx: Context, next: NextFunction) {
        const store = this.asyncLocalStorage.getStore();
        const requestId = String(this.requestData.Ruid);
        const requestGuid = this.requestData.Guid;
        store?.set('requestId', requestId);
        store?.set('requestGuid', requestGuid);

        this.logger.info('request start');

        await next();
    }
}
