import { AsyncLocalStorage } from 'async_hooks';
import createYaLogger, {
    LogLevel,
    LoggerOptions,
} from '@yandex-int/yandex-logger';
import deploy from '@yandex-int/yandex-logger/streams/deploy';
import presetDefault from '@yandex-int/yandex-logger/middleware/preset-default';
import { Container } from 'inversify';
import { AsyncLocalStorageStore } from './typings/AsyncLocalStorageStore';
import { TYPES } from './typings/TYPES';

const config = {
    name: 'crm-apphost-logger',
    streams:
        process.env.NODE_ENV === 'test'
            ? []
            : [
                  {
                      level: 'info' as LogLevel,
                      stream: deploy(),
                  },
              ],
    middleware: [presetDefault()],
    fields: {},
};

export const createLogger = (container: Container) => {
    const perRequestMiddleware = (record: Record<string, unknown>) => {
        const asyncLocalStorage = container.get<
            AsyncLocalStorage<AsyncLocalStorageStore>
        >(TYPES.AsyncLocalStorage);

        const store = asyncLocalStorage.getStore();
        const requestId = store?.get('requestId');
        if (requestId) {
            record.requestId = requestId;
        }

        const requestGuid = store?.get('requestGuid');
        if (requestGuid) {
            record.requestGuid = requestGuid;
        }
    };

    return createYaLogger({
        ...config,
        middleware: [...config.middleware, perRequestMiddleware],
    } as unknown as LoggerOptions);
};
