import * as $protobuf from "protobufjs";
/** Namespace NAppHostHttp. */
export namespace NAppHostHttp {

    /** Properties of a THeader. */
    interface ITHeader {

        /** THeader Name */
        Name?: (string|null);

        /** THeader Value */
        Value?: (string|null);
    }

    /** Represents a THeader. */
    class THeader implements ITHeader {

        /**
         * Constructs a new THeader.
         * @param [properties] Properties to set
         */
        constructor(properties?: NAppHostHttp.ITHeader);

        /** THeader Name. */
        public Name: string;

        /** THeader Value. */
        public Value: string;

        /**
         * Creates a new THeader instance using the specified properties.
         * @param [properties] Properties to set
         * @returns THeader instance
         */
        public static create(properties?: NAppHostHttp.ITHeader): NAppHostHttp.THeader;

        /**
         * Encodes the specified THeader message. Does not implicitly {@link NAppHostHttp.THeader.verify|verify} messages.
         * @param message THeader message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NAppHostHttp.ITHeader, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified THeader message, length delimited. Does not implicitly {@link NAppHostHttp.THeader.verify|verify} messages.
         * @param message THeader message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NAppHostHttp.ITHeader, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a THeader message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns THeader
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAppHostHttp.THeader;

        /**
         * Decodes a THeader message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns THeader
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAppHostHttp.THeader;

        /**
         * Verifies a THeader message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a THeader message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns THeader
         */
        public static fromObject(object: { [k: string]: any }): NAppHostHttp.THeader;

        /**
         * Creates a plain object from a THeader message. Also converts values to other types if specified.
         * @param message THeader
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NAppHostHttp.THeader, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this THeader to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a THttpRequest. */
    interface ITHttpRequest {

        /** THttpRequest Method */
        Method?: (NAppHostHttp.THttpRequest.EMethod|null);

        /** THttpRequest Scheme */
        Scheme?: (NAppHostHttp.THttpRequest.EScheme|null);

        /** THttpRequest Path */
        Path?: (string|null);

        /** THttpRequest Headers */
        Headers?: (NAppHostHttp.ITHeader[]|null);

        /** THttpRequest Content */
        Content?: (Uint8Array|null);

        /** THttpRequest RemoteIP */
        RemoteIP?: (string|null);
    }

    /** Represents a THttpRequest. */
    class THttpRequest implements ITHttpRequest {

        /**
         * Constructs a new THttpRequest.
         * @param [properties] Properties to set
         */
        constructor(properties?: NAppHostHttp.ITHttpRequest);

        /** THttpRequest Method. */
        public Method: NAppHostHttp.THttpRequest.EMethod;

        /** THttpRequest Scheme. */
        public Scheme: NAppHostHttp.THttpRequest.EScheme;

        /** THttpRequest Path. */
        public Path: string;

        /** THttpRequest Headers. */
        public Headers: NAppHostHttp.ITHeader[];

        /** THttpRequest Content. */
        public Content: Uint8Array;

        /** THttpRequest RemoteIP. */
        public RemoteIP: string;

        /**
         * Creates a new THttpRequest instance using the specified properties.
         * @param [properties] Properties to set
         * @returns THttpRequest instance
         */
        public static create(properties?: NAppHostHttp.ITHttpRequest): NAppHostHttp.THttpRequest;

        /**
         * Encodes the specified THttpRequest message. Does not implicitly {@link NAppHostHttp.THttpRequest.verify|verify} messages.
         * @param message THttpRequest message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NAppHostHttp.ITHttpRequest, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified THttpRequest message, length delimited. Does not implicitly {@link NAppHostHttp.THttpRequest.verify|verify} messages.
         * @param message THttpRequest message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NAppHostHttp.ITHttpRequest, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a THttpRequest message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns THttpRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAppHostHttp.THttpRequest;

        /**
         * Decodes a THttpRequest message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns THttpRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAppHostHttp.THttpRequest;

        /**
         * Verifies a THttpRequest message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a THttpRequest message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns THttpRequest
         */
        public static fromObject(object: { [k: string]: any }): NAppHostHttp.THttpRequest;

        /**
         * Creates a plain object from a THttpRequest message. Also converts values to other types if specified.
         * @param message THttpRequest
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NAppHostHttp.THttpRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this THttpRequest to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    namespace THttpRequest {

        /** EMethod enum. */
        enum EMethod {
            Get = 0,
            Post = 1,
            Put = 2,
            Delete = 3,
            Head = 4,
            Connect = 5,
            Options = 6,
            Trace = 7,
            Patch = 8
        }

        /** EScheme enum. */
        enum EScheme {
            None = 0,
            Http = 1,
            Https = 2
        }
    }

    /** Properties of a THttpResponse. */
    interface ITHttpResponse {

        /** THttpResponse StatusCode */
        StatusCode?: (number|null);

        /** THttpResponse Headers */
        Headers?: (NAppHostHttp.ITHeader[]|null);

        /** THttpResponse Content */
        Content?: (Uint8Array|null);

        /** THttpResponse IsSdchEncoded */
        IsSdchEncoded?: (boolean|null);

        /** THttpResponse FromHttpProxy */
        FromHttpProxy?: (boolean|null);
    }

    /** Represents a THttpResponse. */
    class THttpResponse implements ITHttpResponse {

        /**
         * Constructs a new THttpResponse.
         * @param [properties] Properties to set
         */
        constructor(properties?: NAppHostHttp.ITHttpResponse);

        /** THttpResponse StatusCode. */
        public StatusCode: number;

        /** THttpResponse Headers. */
        public Headers: NAppHostHttp.ITHeader[];

        /** THttpResponse Content. */
        public Content: Uint8Array;

        /** THttpResponse IsSdchEncoded. */
        public IsSdchEncoded: boolean;

        /** THttpResponse FromHttpProxy. */
        public FromHttpProxy: boolean;

        /**
         * Creates a new THttpResponse instance using the specified properties.
         * @param [properties] Properties to set
         * @returns THttpResponse instance
         */
        public static create(properties?: NAppHostHttp.ITHttpResponse): NAppHostHttp.THttpResponse;

        /**
         * Encodes the specified THttpResponse message. Does not implicitly {@link NAppHostHttp.THttpResponse.verify|verify} messages.
         * @param message THttpResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NAppHostHttp.ITHttpResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified THttpResponse message, length delimited. Does not implicitly {@link NAppHostHttp.THttpResponse.verify|verify} messages.
         * @param message THttpResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NAppHostHttp.ITHttpResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a THttpResponse message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns THttpResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAppHostHttp.THttpResponse;

        /**
         * Decodes a THttpResponse message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns THttpResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAppHostHttp.THttpResponse;

        /**
         * Verifies a THttpResponse message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a THttpResponse message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns THttpResponse
         */
        public static fromObject(object: { [k: string]: any }): NAppHostHttp.THttpResponse;

        /**
         * Creates a plain object from a THttpResponse message. Also converts values to other types if specified.
         * @param message THttpResponse
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NAppHostHttp.THttpResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this THttpResponse to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }
}

/** Namespace NAppHostTvmUserTicket. */
export namespace NAppHostTvmUserTicket {

    /** Properties of a TTvmUserTicket. */
    interface ITTvmUserTicket {

        /** TTvmUserTicket UserTicket */
        UserTicket?: (string|null);
    }

    /** Represents a TTvmUserTicket. */
    class TTvmUserTicket implements ITTvmUserTicket {

        /**
         * Constructs a new TTvmUserTicket.
         * @param [properties] Properties to set
         */
        constructor(properties?: NAppHostTvmUserTicket.ITTvmUserTicket);

        /** TTvmUserTicket UserTicket. */
        public UserTicket: string;

        /**
         * Creates a new TTvmUserTicket instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TTvmUserTicket instance
         */
        public static create(properties?: NAppHostTvmUserTicket.ITTvmUserTicket): NAppHostTvmUserTicket.TTvmUserTicket;

        /**
         * Encodes the specified TTvmUserTicket message. Does not implicitly {@link NAppHostTvmUserTicket.TTvmUserTicket.verify|verify} messages.
         * @param message TTvmUserTicket message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NAppHostTvmUserTicket.ITTvmUserTicket, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TTvmUserTicket message, length delimited. Does not implicitly {@link NAppHostTvmUserTicket.TTvmUserTicket.verify|verify} messages.
         * @param message TTvmUserTicket message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NAppHostTvmUserTicket.ITTvmUserTicket, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TTvmUserTicket message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TTvmUserTicket
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAppHostTvmUserTicket.TTvmUserTicket;

        /**
         * Decodes a TTvmUserTicket message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TTvmUserTicket
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAppHostTvmUserTicket.TTvmUserTicket;

        /**
         * Verifies a TTvmUserTicket message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TTvmUserTicket message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TTvmUserTicket
         */
        public static fromObject(object: { [k: string]: any }): NAppHostTvmUserTicket.TTvmUserTicket;

        /**
         * Creates a plain object from a TTvmUserTicket message. Also converts values to other types if specified.
         * @param message TTvmUserTicket
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NAppHostTvmUserTicket.TTvmUserTicket, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TTvmUserTicket to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }
}

/** Namespace NAppHostProtocol. */
export namespace NAppHostProtocol {

    /** Represents a TServant */
    class TServant extends $protobuf.rpc.Service {

        /**
         * Constructs a new TServant service.
         * @param rpcImpl RPC implementation
         * @param [requestDelimited=false] Whether requests are length-delimited
         * @param [responseDelimited=false] Whether responses are length-delimited
         */
        constructor(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean);

        /**
         * Creates new TServant service using the specified rpc implementation.
         * @param rpcImpl RPC implementation
         * @param [requestDelimited=false] Whether requests are length-delimited
         * @param [responseDelimited=false] Whether responses are length-delimited
         * @returns RPC service. Useful where requests and/or responses are streamed.
         */
        public static create(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean): TServant;

        /**
         * Calls Invoke.
         * @param request TServiceRequest message or plain object
         * @param callback Node-style callback called with the error, if any, and TServiceResponse
         */
        public invoke(request: NAppHostProtocol.ITServiceRequest, callback: NAppHostProtocol.TServant.InvokeCallback): void;

        /**
         * Calls Invoke.
         * @param request TServiceRequest message or plain object
         * @returns Promise
         */
        public invoke(request: NAppHostProtocol.ITServiceRequest): Promise<NAppHostProtocol.TServiceResponse>;

        /**
         * Calls Ping.
         * @param request TPingRequest message or plain object
         * @param callback Node-style callback called with the error, if any, and TPingResponse
         */
        public ping(request: NAppHostProtocol.ITPingRequest, callback: NAppHostProtocol.TServant.PingCallback): void;

        /**
         * Calls Ping.
         * @param request TPingRequest message or plain object
         * @returns Promise
         */
        public ping(request: NAppHostProtocol.ITPingRequest): Promise<NAppHostProtocol.TPingResponse>;

        /**
         * Calls InvokeEx.
         * @param request TServiceRequest message or plain object
         * @param callback Node-style callback called with the error, if any, and TServiceResponse
         */
        public invokeEx(request: NAppHostProtocol.ITServiceRequest, callback: NAppHostProtocol.TServant.InvokeExCallback): void;

        /**
         * Calls InvokeEx.
         * @param request TServiceRequest message or plain object
         * @returns Promise
         */
        public invokeEx(request: NAppHostProtocol.ITServiceRequest): Promise<NAppHostProtocol.TServiceResponse>;
    }

    namespace TServant {

        /**
         * Callback as used by {@link NAppHostProtocol.TServant#invoke}.
         * @param error Error, if any
         * @param [response] TServiceResponse
         */
        type InvokeCallback = (error: (Error|null), response?: NAppHostProtocol.TServiceResponse) => void;

        /**
         * Callback as used by {@link NAppHostProtocol.TServant#ping}.
         * @param error Error, if any
         * @param [response] TPingResponse
         */
        type PingCallback = (error: (Error|null), response?: NAppHostProtocol.TPingResponse) => void;

        /**
         * Callback as used by {@link NAppHostProtocol.TServant#invokeEx}.
         * @param error Error, if any
         * @param [response] TServiceResponse
         */
        type InvokeExCallback = (error: (Error|null), response?: NAppHostProtocol.TServiceResponse) => void;
    }

    /** Properties of a TPingRequest. */
    interface ITPingRequest {
    }

    /** Represents a TPingRequest. */
    class TPingRequest implements ITPingRequest {

        /**
         * Constructs a new TPingRequest.
         * @param [properties] Properties to set
         */
        constructor(properties?: NAppHostProtocol.ITPingRequest);

        /**
         * Creates a new TPingRequest instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TPingRequest instance
         */
        public static create(properties?: NAppHostProtocol.ITPingRequest): NAppHostProtocol.TPingRequest;

        /**
         * Encodes the specified TPingRequest message. Does not implicitly {@link NAppHostProtocol.TPingRequest.verify|verify} messages.
         * @param message TPingRequest message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NAppHostProtocol.ITPingRequest, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TPingRequest message, length delimited. Does not implicitly {@link NAppHostProtocol.TPingRequest.verify|verify} messages.
         * @param message TPingRequest message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NAppHostProtocol.ITPingRequest, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TPingRequest message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TPingRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAppHostProtocol.TPingRequest;

        /**
         * Decodes a TPingRequest message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TPingRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAppHostProtocol.TPingRequest;

        /**
         * Verifies a TPingRequest message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TPingRequest message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TPingRequest
         */
        public static fromObject(object: { [k: string]: any }): NAppHostProtocol.TPingRequest;

        /**
         * Creates a plain object from a TPingRequest message. Also converts values to other types if specified.
         * @param message TPingRequest
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NAppHostProtocol.TPingRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TPingRequest to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TPingResponse. */
    interface ITPingResponse {
    }

    /** Represents a TPingResponse. */
    class TPingResponse implements ITPingResponse {

        /**
         * Constructs a new TPingResponse.
         * @param [properties] Properties to set
         */
        constructor(properties?: NAppHostProtocol.ITPingResponse);

        /**
         * Creates a new TPingResponse instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TPingResponse instance
         */
        public static create(properties?: NAppHostProtocol.ITPingResponse): NAppHostProtocol.TPingResponse;

        /**
         * Encodes the specified TPingResponse message. Does not implicitly {@link NAppHostProtocol.TPingResponse.verify|verify} messages.
         * @param message TPingResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NAppHostProtocol.ITPingResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TPingResponse message, length delimited. Does not implicitly {@link NAppHostProtocol.TPingResponse.verify|verify} messages.
         * @param message TPingResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NAppHostProtocol.ITPingResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TPingResponse message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TPingResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAppHostProtocol.TPingResponse;

        /**
         * Decodes a TPingResponse message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TPingResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAppHostProtocol.TPingResponse;

        /**
         * Verifies a TPingResponse message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TPingResponse message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TPingResponse
         */
        public static fromObject(object: { [k: string]: any }): NAppHostProtocol.TPingResponse;

        /**
         * Creates a plain object from a TPingResponse message. Also converts values to other types if specified.
         * @param message TPingResponse
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NAppHostProtocol.TPingResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TPingResponse to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TAnswer. */
    interface ITAnswer {

        /** TAnswer SourceName */
        SourceName?: (string|null);

        /** TAnswer Type */
        Type?: (string|null);

        /** TAnswer Data */
        Data?: (Uint8Array|null);

        /** TAnswer Schema */
        Schema?: (Uint8Array|null);

        /** TAnswer OriginNodeName */
        OriginNodeName?: (string|null);
    }

    /** Represents a TAnswer. */
    class TAnswer implements ITAnswer {

        /**
         * Constructs a new TAnswer.
         * @param [properties] Properties to set
         */
        constructor(properties?: NAppHostProtocol.ITAnswer);

        /** TAnswer SourceName. */
        public SourceName: string;

        /** TAnswer Type. */
        public Type: string;

        /** TAnswer Data. */
        public Data: Uint8Array;

        /** TAnswer Schema. */
        public Schema: Uint8Array;

        /** TAnswer OriginNodeName. */
        public OriginNodeName: string;

        /**
         * Creates a new TAnswer instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TAnswer instance
         */
        public static create(properties?: NAppHostProtocol.ITAnswer): NAppHostProtocol.TAnswer;

        /**
         * Encodes the specified TAnswer message. Does not implicitly {@link NAppHostProtocol.TAnswer.verify|verify} messages.
         * @param message TAnswer message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NAppHostProtocol.ITAnswer, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TAnswer message, length delimited. Does not implicitly {@link NAppHostProtocol.TAnswer.verify|verify} messages.
         * @param message TAnswer message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NAppHostProtocol.ITAnswer, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TAnswer message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TAnswer
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAppHostProtocol.TAnswer;

        /**
         * Decodes a TAnswer message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TAnswer
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAppHostProtocol.TAnswer;

        /**
         * Verifies a TAnswer message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TAnswer message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TAnswer
         */
        public static fromObject(object: { [k: string]: any }): NAppHostProtocol.TAnswer;

        /**
         * Creates a plain object from a TAnswer message. Also converts values to other types if specified.
         * @param message TAnswer
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NAppHostProtocol.TAnswer, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TAnswer to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TCodecs. */
    interface ITCodecs {

        /** TCodecs CodecIds */
        CodecIds?: (number[]|null);
    }

    /** Represents a TCodecs. */
    class TCodecs implements ITCodecs {

        /**
         * Constructs a new TCodecs.
         * @param [properties] Properties to set
         */
        constructor(properties?: NAppHostProtocol.ITCodecs);

        /** TCodecs CodecIds. */
        public CodecIds: number[];

        /**
         * Creates a new TCodecs instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TCodecs instance
         */
        public static create(properties?: NAppHostProtocol.ITCodecs): NAppHostProtocol.TCodecs;

        /**
         * Encodes the specified TCodecs message. Does not implicitly {@link NAppHostProtocol.TCodecs.verify|verify} messages.
         * @param message TCodecs message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NAppHostProtocol.ITCodecs, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TCodecs message, length delimited. Does not implicitly {@link NAppHostProtocol.TCodecs.verify|verify} messages.
         * @param message TCodecs message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NAppHostProtocol.ITCodecs, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TCodecs message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TCodecs
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAppHostProtocol.TCodecs;

        /**
         * Decodes a TCodecs message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TCodecs
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAppHostProtocol.TCodecs;

        /**
         * Verifies a TCodecs message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TCodecs message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TCodecs
         */
        public static fromObject(object: { [k: string]: any }): NAppHostProtocol.TCodecs;

        /**
         * Creates a plain object from a TCodecs message. Also converts values to other types if specified.
         * @param message TCodecs
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NAppHostProtocol.TCodecs, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TCodecs to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TMetaFlag. */
    interface ITMetaFlag {

        /** TMetaFlag SourceName */
        SourceName?: (string|null);

        /** TMetaFlag FlagName */
        FlagName?: (string|null);
    }

    /** Represents a TMetaFlag. */
    class TMetaFlag implements ITMetaFlag {

        /**
         * Constructs a new TMetaFlag.
         * @param [properties] Properties to set
         */
        constructor(properties?: NAppHostProtocol.ITMetaFlag);

        /** TMetaFlag SourceName. */
        public SourceName: string;

        /** TMetaFlag FlagName. */
        public FlagName: string;

        /**
         * Creates a new TMetaFlag instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TMetaFlag instance
         */
        public static create(properties?: NAppHostProtocol.ITMetaFlag): NAppHostProtocol.TMetaFlag;

        /**
         * Encodes the specified TMetaFlag message. Does not implicitly {@link NAppHostProtocol.TMetaFlag.verify|verify} messages.
         * @param message TMetaFlag message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NAppHostProtocol.ITMetaFlag, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TMetaFlag message, length delimited. Does not implicitly {@link NAppHostProtocol.TMetaFlag.verify|verify} messages.
         * @param message TMetaFlag message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NAppHostProtocol.ITMetaFlag, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TMetaFlag message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TMetaFlag
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAppHostProtocol.TMetaFlag;

        /**
         * Decodes a TMetaFlag message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TMetaFlag
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAppHostProtocol.TMetaFlag;

        /**
         * Verifies a TMetaFlag message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TMetaFlag message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TMetaFlag
         */
        public static fromObject(object: { [k: string]: any }): NAppHostProtocol.TMetaFlag;

        /**
         * Creates a plain object from a TMetaFlag message. Also converts values to other types if specified.
         * @param message TMetaFlag
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NAppHostProtocol.TMetaFlag, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TMetaFlag to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TTestId. */
    interface ITTestId {

        /** TTestId TestId */
        TestId?: (number|null);

        /** TTestId Slot */
        Slot?: (number|null);

        /** TTestId Bucket */
        Bucket?: (number|null);
    }

    /** Represents a TTestId. */
    class TTestId implements ITTestId {

        /**
         * Constructs a new TTestId.
         * @param [properties] Properties to set
         */
        constructor(properties?: NAppHostProtocol.ITTestId);

        /** TTestId TestId. */
        public TestId: number;

        /** TTestId Slot. */
        public Slot: number;

        /** TTestId Bucket. */
        public Bucket: number;

        /**
         * Creates a new TTestId instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TTestId instance
         */
        public static create(properties?: NAppHostProtocol.ITTestId): NAppHostProtocol.TTestId;

        /**
         * Encodes the specified TTestId message. Does not implicitly {@link NAppHostProtocol.TTestId.verify|verify} messages.
         * @param message TTestId message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NAppHostProtocol.ITTestId, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TTestId message, length delimited. Does not implicitly {@link NAppHostProtocol.TTestId.verify|verify} messages.
         * @param message TTestId message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NAppHostProtocol.ITTestId, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TTestId message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TTestId
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAppHostProtocol.TTestId;

        /**
         * Decodes a TTestId message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TTestId
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAppHostProtocol.TTestId;

        /**
         * Verifies a TTestId message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TTestId message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TTestId
         */
        public static fromObject(object: { [k: string]: any }): NAppHostProtocol.TTestId;

        /**
         * Creates a plain object from a TTestId message. Also converts values to other types if specified.
         * @param message TTestId
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NAppHostProtocol.TTestId, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TTestId to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TTestIds. */
    interface ITTestIds {

        /** TTestIds TestIds */
        TestIds?: (NAppHostProtocol.ITTestId[]|null);
    }

    /** Represents a TTestIds. */
    class TTestIds implements ITTestIds {

        /**
         * Constructs a new TTestIds.
         * @param [properties] Properties to set
         */
        constructor(properties?: NAppHostProtocol.ITTestIds);

        /** TTestIds TestIds. */
        public TestIds: NAppHostProtocol.ITTestId[];

        /**
         * Creates a new TTestIds instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TTestIds instance
         */
        public static create(properties?: NAppHostProtocol.ITTestIds): NAppHostProtocol.TTestIds;

        /**
         * Encodes the specified TTestIds message. Does not implicitly {@link NAppHostProtocol.TTestIds.verify|verify} messages.
         * @param message TTestIds message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NAppHostProtocol.ITTestIds, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TTestIds message, length delimited. Does not implicitly {@link NAppHostProtocol.TTestIds.verify|verify} messages.
         * @param message TTestIds message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NAppHostProtocol.ITTestIds, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TTestIds message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TTestIds
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAppHostProtocol.TTestIds;

        /**
         * Decodes a TTestIds message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TTestIds
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAppHostProtocol.TTestIds;

        /**
         * Verifies a TTestIds message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TTestIds message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TTestIds
         */
        public static fromObject(object: { [k: string]: any }): NAppHostProtocol.TTestIds;

        /**
         * Creates a plain object from a TTestIds message. Also converts values to other types if specified.
         * @param message TTestIds
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NAppHostProtocol.TTestIds, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TTestIds to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TLocation. */
    interface ITLocation {

        /** TLocation Path */
        Path?: (string|null);

        /** TLocation Name */
        Name?: (string|null);
    }

    /** Represents a TLocation. */
    class TLocation implements ITLocation {

        /**
         * Constructs a new TLocation.
         * @param [properties] Properties to set
         */
        constructor(properties?: NAppHostProtocol.ITLocation);

        /** TLocation Path. */
        public Path: string;

        /** TLocation Name. */
        public Name: string;

        /**
         * Creates a new TLocation instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TLocation instance
         */
        public static create(properties?: NAppHostProtocol.ITLocation): NAppHostProtocol.TLocation;

        /**
         * Encodes the specified TLocation message. Does not implicitly {@link NAppHostProtocol.TLocation.verify|verify} messages.
         * @param message TLocation message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NAppHostProtocol.ITLocation, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TLocation message, length delimited. Does not implicitly {@link NAppHostProtocol.TLocation.verify|verify} messages.
         * @param message TLocation message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NAppHostProtocol.ITLocation, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TLocation message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TLocation
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAppHostProtocol.TLocation;

        /**
         * Decodes a TLocation message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TLocation
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAppHostProtocol.TLocation;

        /**
         * Verifies a TLocation message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TLocation message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TLocation
         */
        public static fromObject(object: { [k: string]: any }): NAppHostProtocol.TLocation;

        /**
         * Creates a plain object from a TLocation message. Also converts values to other types if specified.
         * @param message TLocation
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NAppHostProtocol.TLocation, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TLocation to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TRequestInfo. */
    interface ITRequestInfo {

        /** TRequestInfo Reqid */
        Reqid?: (string|null);

        /** TRequestInfo Guid */
        Guid?: (string|null);

        /** TRequestInfo Ruid */
        Ruid?: (number|null);

        /** TRequestInfo Location */
        Location?: (NAppHostProtocol.ITLocation|null);
    }

    /** Represents a TRequestInfo. */
    class TRequestInfo implements ITRequestInfo {

        /**
         * Constructs a new TRequestInfo.
         * @param [properties] Properties to set
         */
        constructor(properties?: NAppHostProtocol.ITRequestInfo);

        /** TRequestInfo Reqid. */
        public Reqid: string;

        /** TRequestInfo Guid. */
        public Guid: string;

        /** TRequestInfo Ruid. */
        public Ruid: number;

        /** TRequestInfo Location. */
        public Location?: (NAppHostProtocol.ITLocation|null);

        /**
         * Creates a new TRequestInfo instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TRequestInfo instance
         */
        public static create(properties?: NAppHostProtocol.ITRequestInfo): NAppHostProtocol.TRequestInfo;

        /**
         * Encodes the specified TRequestInfo message. Does not implicitly {@link NAppHostProtocol.TRequestInfo.verify|verify} messages.
         * @param message TRequestInfo message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NAppHostProtocol.ITRequestInfo, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TRequestInfo message, length delimited. Does not implicitly {@link NAppHostProtocol.TRequestInfo.verify|verify} messages.
         * @param message TRequestInfo message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NAppHostProtocol.ITRequestInfo, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TRequestInfo message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TRequestInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAppHostProtocol.TRequestInfo;

        /**
         * Decodes a TRequestInfo message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TRequestInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAppHostProtocol.TRequestInfo;

        /**
         * Verifies a TRequestInfo message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TRequestInfo message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TRequestInfo
         */
        public static fromObject(object: { [k: string]: any }): NAppHostProtocol.TRequestInfo;

        /**
         * Creates a plain object from a TRequestInfo message. Also converts values to other types if specified.
         * @param message TRequestInfo
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NAppHostProtocol.TRequestInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TRequestInfo to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TServiceRequest. */
    interface ITServiceRequest {

        /** TServiceRequest Guid */
        Guid?: (string|null);

        /** TServiceRequest Answers */
        Answers?: (NAppHostProtocol.ITAnswer[]|null);

        /** TServiceRequest Codecs */
        Codecs?: (NAppHostProtocol.ITCodecs|null);

        /** TServiceRequest Path */
        Path?: (string|null);

        /** TServiceRequest Ruid */
        Ruid?: (number|null);

        /** TServiceRequest Last */
        Last?: (boolean|null);

        /** TServiceRequest MetaFlags */
        MetaFlags?: (NAppHostProtocol.ITMetaFlag[]|null);

        /** TServiceRequest Ticket */
        Ticket?: (string|null);

        /** TServiceRequest Json2YsonMode */
        Json2YsonMode?: (number|null);

        /** TServiceRequest JsonSerializationFormat */
        JsonSerializationFormat?: (NAppHost.ESerializationFormat|null);

        /** TServiceRequest FinishedDeps */
        FinishedDeps?: (string[]|null);

        /** TServiceRequest DumpProtobufSchema */
        DumpProtobufSchema?: (boolean|null);

        /** TServiceRequest RequestAttemptType */
        RequestAttemptType?: (NAppHostProtocol.TServiceRequest.ERequestAttemptType|null);

        /** TServiceRequest EnableDumpRequest */
        EnableDumpRequest?: (boolean|null);

        /** TServiceRequest SendTimestamp */
        SendTimestamp?: (number|null);

        /** TServiceRequest JsonToProto */
        JsonToProto?: (boolean|null);

        /** TServiceRequest ProtoToJson */
        ProtoToJson?: (boolean|null);

        /** TServiceRequest Hints */
        Hints?: (NAppHostProtocol.ITHint[]|null);

        /** TServiceRequest TestIds */
        TestIds?: (NAppHostProtocol.ITTestIds|null);

        /** TServiceRequest RequestInfo */
        RequestInfo?: (NAppHostProtocol.ITRequestInfo|null);

        /** TServiceRequest RtLog */
        RtLog?: (string|null);
    }

    /** Represents a TServiceRequest. */
    class TServiceRequest implements ITServiceRequest {

        /**
         * Constructs a new TServiceRequest.
         * @param [properties] Properties to set
         */
        constructor(properties?: NAppHostProtocol.ITServiceRequest);

        /** TServiceRequest Guid. */
        public Guid: string;

        /** TServiceRequest Answers. */
        public Answers: NAppHostProtocol.ITAnswer[];

        /** TServiceRequest Codecs. */
        public Codecs?: (NAppHostProtocol.ITCodecs|null);

        /** TServiceRequest Path. */
        public Path: string;

        /** TServiceRequest Ruid. */
        public Ruid: number;

        /** TServiceRequest Last. */
        public Last: boolean;

        /** TServiceRequest MetaFlags. */
        public MetaFlags: NAppHostProtocol.ITMetaFlag[];

        /** TServiceRequest Ticket. */
        public Ticket: string;

        /** TServiceRequest Json2YsonMode. */
        public Json2YsonMode: number;

        /** TServiceRequest JsonSerializationFormat. */
        public JsonSerializationFormat: NAppHost.ESerializationFormat;

        /** TServiceRequest FinishedDeps. */
        public FinishedDeps: string[];

        /** TServiceRequest DumpProtobufSchema. */
        public DumpProtobufSchema: boolean;

        /** TServiceRequest RequestAttemptType. */
        public RequestAttemptType: NAppHostProtocol.TServiceRequest.ERequestAttemptType;

        /** TServiceRequest EnableDumpRequest. */
        public EnableDumpRequest: boolean;

        /** TServiceRequest SendTimestamp. */
        public SendTimestamp: number;

        /** TServiceRequest JsonToProto. */
        public JsonToProto: boolean;

        /** TServiceRequest ProtoToJson. */
        public ProtoToJson: boolean;

        /** TServiceRequest Hints. */
        public Hints: NAppHostProtocol.ITHint[];

        /** TServiceRequest TestIds. */
        public TestIds?: (NAppHostProtocol.ITTestIds|null);

        /** TServiceRequest RequestInfo. */
        public RequestInfo?: (NAppHostProtocol.ITRequestInfo|null);

        /** TServiceRequest RtLog. */
        public RtLog: string;

        /**
         * Creates a new TServiceRequest instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TServiceRequest instance
         */
        public static create(properties?: NAppHostProtocol.ITServiceRequest): NAppHostProtocol.TServiceRequest;

        /**
         * Encodes the specified TServiceRequest message. Does not implicitly {@link NAppHostProtocol.TServiceRequest.verify|verify} messages.
         * @param message TServiceRequest message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NAppHostProtocol.ITServiceRequest, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TServiceRequest message, length delimited. Does not implicitly {@link NAppHostProtocol.TServiceRequest.verify|verify} messages.
         * @param message TServiceRequest message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NAppHostProtocol.ITServiceRequest, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TServiceRequest message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TServiceRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAppHostProtocol.TServiceRequest;

        /**
         * Decodes a TServiceRequest message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TServiceRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAppHostProtocol.TServiceRequest;

        /**
         * Verifies a TServiceRequest message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TServiceRequest message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TServiceRequest
         */
        public static fromObject(object: { [k: string]: any }): NAppHostProtocol.TServiceRequest;

        /**
         * Creates a plain object from a TServiceRequest message. Also converts values to other types if specified.
         * @param message TServiceRequest
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NAppHostProtocol.TServiceRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TServiceRequest to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    namespace TServiceRequest {

        /** ERequestAttemptType enum. */
        enum ERequestAttemptType {
            First = 0,
            Retry = 1,
            Hedged = 2
        }
    }

    /** Properties of a TBucket. */
    interface ITBucket {

        /** TBucket Index */
        Index?: (number|null);

        /** TBucket Count */
        Count?: (number|null);
    }

    /** Represents a TBucket. */
    class TBucket implements ITBucket {

        /**
         * Constructs a new TBucket.
         * @param [properties] Properties to set
         */
        constructor(properties?: NAppHostProtocol.ITBucket);

        /** TBucket Index. */
        public Index: number;

        /** TBucket Count. */
        public Count: number;

        /**
         * Creates a new TBucket instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TBucket instance
         */
        public static create(properties?: NAppHostProtocol.ITBucket): NAppHostProtocol.TBucket;

        /**
         * Encodes the specified TBucket message. Does not implicitly {@link NAppHostProtocol.TBucket.verify|verify} messages.
         * @param message TBucket message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NAppHostProtocol.ITBucket, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TBucket message, length delimited. Does not implicitly {@link NAppHostProtocol.TBucket.verify|verify} messages.
         * @param message TBucket message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NAppHostProtocol.ITBucket, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TBucket message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TBucket
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAppHostProtocol.TBucket;

        /**
         * Decodes a TBucket message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TBucket
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAppHostProtocol.TBucket;

        /**
         * Verifies a TBucket message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TBucket message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TBucket
         */
        public static fromObject(object: { [k: string]: any }): NAppHostProtocol.TBucket;

        /**
         * Creates a plain object from a TBucket message. Also converts values to other types if specified.
         * @param message TBucket
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NAppHostProtocol.TBucket, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TBucket to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a THistogram. */
    interface ITHistogram {

        /** THistogram Buckets */
        Buckets?: (NAppHostProtocol.ITBucket[]|null);
    }

    /** Represents a THistogram. */
    class THistogram implements ITHistogram {

        /**
         * Constructs a new THistogram.
         * @param [properties] Properties to set
         */
        constructor(properties?: NAppHostProtocol.ITHistogram);

        /** THistogram Buckets. */
        public Buckets: NAppHostProtocol.ITBucket[];

        /**
         * Creates a new THistogram instance using the specified properties.
         * @param [properties] Properties to set
         * @returns THistogram instance
         */
        public static create(properties?: NAppHostProtocol.ITHistogram): NAppHostProtocol.THistogram;

        /**
         * Encodes the specified THistogram message. Does not implicitly {@link NAppHostProtocol.THistogram.verify|verify} messages.
         * @param message THistogram message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NAppHostProtocol.ITHistogram, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified THistogram message, length delimited. Does not implicitly {@link NAppHostProtocol.THistogram.verify|verify} messages.
         * @param message THistogram message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NAppHostProtocol.ITHistogram, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a THistogram message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns THistogram
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAppHostProtocol.THistogram;

        /**
         * Decodes a THistogram message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns THistogram
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAppHostProtocol.THistogram;

        /**
         * Verifies a THistogram message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a THistogram message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns THistogram
         */
        public static fromObject(object: { [k: string]: any }): NAppHostProtocol.THistogram;

        /**
         * Creates a plain object from a THistogram message. Also converts values to other types if specified.
         * @param message THistogram
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NAppHostProtocol.THistogram, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this THistogram to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TBackendStats. */
    interface ITBackendStats {

        /** TBackendStats Address */
        Address?: (string|null);

        /** TBackendStats Duration */
        Duration?: (number|null);

        /** TBackendStats Success */
        Success?: (boolean|null);
    }

    /** Represents a TBackendStats. */
    class TBackendStats implements ITBackendStats {

        /**
         * Constructs a new TBackendStats.
         * @param [properties] Properties to set
         */
        constructor(properties?: NAppHostProtocol.ITBackendStats);

        /** TBackendStats Address. */
        public Address: string;

        /** TBackendStats Duration. */
        public Duration: number;

        /** TBackendStats Success. */
        public Success: boolean;

        /**
         * Creates a new TBackendStats instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TBackendStats instance
         */
        public static create(properties?: NAppHostProtocol.ITBackendStats): NAppHostProtocol.TBackendStats;

        /**
         * Encodes the specified TBackendStats message. Does not implicitly {@link NAppHostProtocol.TBackendStats.verify|verify} messages.
         * @param message TBackendStats message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NAppHostProtocol.ITBackendStats, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TBackendStats message, length delimited. Does not implicitly {@link NAppHostProtocol.TBackendStats.verify|verify} messages.
         * @param message TBackendStats message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NAppHostProtocol.ITBackendStats, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TBackendStats message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TBackendStats
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAppHostProtocol.TBackendStats;

        /**
         * Decodes a TBackendStats message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TBackendStats
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAppHostProtocol.TBackendStats;

        /**
         * Verifies a TBackendStats message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TBackendStats message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TBackendStats
         */
        public static fromObject(object: { [k: string]: any }): NAppHostProtocol.TBackendStats;

        /**
         * Creates a plain object from a TBackendStats message. Also converts values to other types if specified.
         * @param message TBackendStats
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NAppHostProtocol.TBackendStats, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TBackendStats to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a THint. */
    interface ITHint {

        /** THint TargetNode */
        TargetNode?: (string|null);

        /** THint Value */
        Value?: (number|null);

        /** THint Origin */
        Origin?: (string|null);
    }

    /** Represents a THint. */
    class THint implements ITHint {

        /**
         * Constructs a new THint.
         * @param [properties] Properties to set
         */
        constructor(properties?: NAppHostProtocol.ITHint);

        /** THint TargetNode. */
        public TargetNode: string;

        /** THint Value. */
        public Value: number;

        /** THint Origin. */
        public Origin: string;

        /**
         * Creates a new THint instance using the specified properties.
         * @param [properties] Properties to set
         * @returns THint instance
         */
        public static create(properties?: NAppHostProtocol.ITHint): NAppHostProtocol.THint;

        /**
         * Encodes the specified THint message. Does not implicitly {@link NAppHostProtocol.THint.verify|verify} messages.
         * @param message THint message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NAppHostProtocol.ITHint, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified THint message, length delimited. Does not implicitly {@link NAppHostProtocol.THint.verify|verify} messages.
         * @param message THint message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NAppHostProtocol.ITHint, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a THint message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns THint
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAppHostProtocol.THint;

        /**
         * Decodes a THint message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns THint
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAppHostProtocol.THint;

        /**
         * Verifies a THint message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a THint message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns THint
         */
        public static fromObject(object: { [k: string]: any }): NAppHostProtocol.THint;

        /**
         * Creates a plain object from a THint message. Also converts values to other types if specified.
         * @param message THint
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NAppHostProtocol.THint, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this THint to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TServiceResponse. */
    interface ITServiceResponse {

        /** TServiceResponse Answers */
        Answers?: (NAppHostProtocol.ITAnswer[]|null);

        /** TServiceResponse Hints */
        Hints?: (NAppHostProtocol.ITHint[]|null);

        /** TServiceResponse Flags */
        Flags?: (string[]|null);

        /** TServiceResponse ProtoLogEvents */
        ProtoLogEvents?: (NAppHostProtocol.ITProtoEvent[]|null);

        /** TServiceResponse LogLines */
        LogLines?: (Uint8Array[]|null);

        /** TServiceResponse Exception */
        Exception?: (Uint8Array|null);

        /** TServiceResponse RequestId */
        RequestId?: (number|null);

        /** TServiceResponse InitTime */
        InitTime?: (number|null);

        /** TServiceResponse FinTime */
        FinTime?: (number|null);

        /** TServiceResponse LogicTime */
        LogicTime?: (number|null);

        /** TServiceResponse DeserialTime */
        DeserialTime?: (number|null);

        /** TServiceResponse DecomprTime */
        DecomprTime?: (number|null);

        /** TServiceResponse ComprTime */
        ComprTime?: (number|null);

        /** TServiceResponse UncompressedSize */
        UncompressedSize?: (number|null);

        /** TServiceResponse FQDNHostName */
        FQDNHostName?: (string|null);

        /** TServiceResponse BackendTime */
        BackendTime?: (number|null);

        /** TServiceResponse ForceRetry */
        ForceRetry?: (boolean|null);

        /** TServiceResponse SerialTime */
        SerialTime?: (number|null);
    }

    /** Represents a TServiceResponse. */
    class TServiceResponse implements ITServiceResponse {

        /**
         * Constructs a new TServiceResponse.
         * @param [properties] Properties to set
         */
        constructor(properties?: NAppHostProtocol.ITServiceResponse);

        /** TServiceResponse Answers. */
        public Answers: NAppHostProtocol.ITAnswer[];

        /** TServiceResponse Hints. */
        public Hints: NAppHostProtocol.ITHint[];

        /** TServiceResponse Flags. */
        public Flags: string[];

        /** TServiceResponse ProtoLogEvents. */
        public ProtoLogEvents: NAppHostProtocol.ITProtoEvent[];

        /** TServiceResponse LogLines. */
        public LogLines: Uint8Array[];

        /** TServiceResponse Exception. */
        public Exception: Uint8Array;

        /** TServiceResponse RequestId. */
        public RequestId: number;

        /** TServiceResponse InitTime. */
        public InitTime: number;

        /** TServiceResponse FinTime. */
        public FinTime: number;

        /** TServiceResponse LogicTime. */
        public LogicTime: number;

        /** TServiceResponse DeserialTime. */
        public DeserialTime: number;

        /** TServiceResponse DecomprTime. */
        public DecomprTime: number;

        /** TServiceResponse ComprTime. */
        public ComprTime: number;

        /** TServiceResponse UncompressedSize. */
        public UncompressedSize: number;

        /** TServiceResponse FQDNHostName. */
        public FQDNHostName: string;

        /** TServiceResponse BackendTime. */
        public BackendTime: number;

        /** TServiceResponse ForceRetry. */
        public ForceRetry: boolean;

        /** TServiceResponse SerialTime. */
        public SerialTime: number;

        /**
         * Creates a new TServiceResponse instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TServiceResponse instance
         */
        public static create(properties?: NAppHostProtocol.ITServiceResponse): NAppHostProtocol.TServiceResponse;

        /**
         * Encodes the specified TServiceResponse message. Does not implicitly {@link NAppHostProtocol.TServiceResponse.verify|verify} messages.
         * @param message TServiceResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NAppHostProtocol.ITServiceResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TServiceResponse message, length delimited. Does not implicitly {@link NAppHostProtocol.TServiceResponse.verify|verify} messages.
         * @param message TServiceResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NAppHostProtocol.ITServiceResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TServiceResponse message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TServiceResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAppHostProtocol.TServiceResponse;

        /**
         * Decodes a TServiceResponse message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TServiceResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAppHostProtocol.TServiceResponse;

        /**
         * Verifies a TServiceResponse message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TServiceResponse message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TServiceResponse
         */
        public static fromObject(object: { [k: string]: any }): NAppHostProtocol.TServiceResponse;

        /**
         * Creates a plain object from a TServiceResponse message. Also converts values to other types if specified.
         * @param message TServiceResponse
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NAppHostProtocol.TServiceResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TServiceResponse to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TProtoEvent. */
    interface ITProtoEvent {

        /** TProtoEvent Timestamp */
        Timestamp?: (number|null);

        /** TProtoEvent ClassId */
        ClassId?: (number|null);

        /** TProtoEvent SubSourcesPath */
        SubSourcesPath?: (string[]|null);

        /** TProtoEvent Event */
        Event?: (google.protobuf.IAny|null);
    }

    /** Represents a TProtoEvent. */
    class TProtoEvent implements ITProtoEvent {

        /**
         * Constructs a new TProtoEvent.
         * @param [properties] Properties to set
         */
        constructor(properties?: NAppHostProtocol.ITProtoEvent);

        /** TProtoEvent Timestamp. */
        public Timestamp: number;

        /** TProtoEvent ClassId. */
        public ClassId: number;

        /** TProtoEvent SubSourcesPath. */
        public SubSourcesPath: string[];

        /** TProtoEvent Event. */
        public Event?: (google.protobuf.IAny|null);

        /**
         * Creates a new TProtoEvent instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TProtoEvent instance
         */
        public static create(properties?: NAppHostProtocol.ITProtoEvent): NAppHostProtocol.TProtoEvent;

        /**
         * Encodes the specified TProtoEvent message. Does not implicitly {@link NAppHostProtocol.TProtoEvent.verify|verify} messages.
         * @param message TProtoEvent message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NAppHostProtocol.ITProtoEvent, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TProtoEvent message, length delimited. Does not implicitly {@link NAppHostProtocol.TProtoEvent.verify|verify} messages.
         * @param message TProtoEvent message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NAppHostProtocol.ITProtoEvent, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TProtoEvent message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TProtoEvent
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAppHostProtocol.TProtoEvent;

        /**
         * Decodes a TProtoEvent message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TProtoEvent
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAppHostProtocol.TProtoEvent;

        /**
         * Verifies a TProtoEvent message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TProtoEvent message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TProtoEvent
         */
        public static fromObject(object: { [k: string]: any }): NAppHostProtocol.TProtoEvent;

        /**
         * Creates a plain object from a TProtoEvent message. Also converts values to other types if specified.
         * @param message TProtoEvent
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NAppHostProtocol.TProtoEvent, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TProtoEvent to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TProtoEventLogDump. */
    interface ITProtoEventLogDump {

        /** TProtoEventLogDump LogEvent */
        LogEvent?: (NAppHostProtocol.ITProtoEvent[]|null);
    }

    /** Represents a TProtoEventLogDump. */
    class TProtoEventLogDump implements ITProtoEventLogDump {

        /**
         * Constructs a new TProtoEventLogDump.
         * @param [properties] Properties to set
         */
        constructor(properties?: NAppHostProtocol.ITProtoEventLogDump);

        /** TProtoEventLogDump LogEvent. */
        public LogEvent: NAppHostProtocol.ITProtoEvent[];

        /**
         * Creates a new TProtoEventLogDump instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TProtoEventLogDump instance
         */
        public static create(properties?: NAppHostProtocol.ITProtoEventLogDump): NAppHostProtocol.TProtoEventLogDump;

        /**
         * Encodes the specified TProtoEventLogDump message. Does not implicitly {@link NAppHostProtocol.TProtoEventLogDump.verify|verify} messages.
         * @param message TProtoEventLogDump message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NAppHostProtocol.ITProtoEventLogDump, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TProtoEventLogDump message, length delimited. Does not implicitly {@link NAppHostProtocol.TProtoEventLogDump.verify|verify} messages.
         * @param message TProtoEventLogDump message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NAppHostProtocol.ITProtoEventLogDump, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TProtoEventLogDump message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TProtoEventLogDump
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NAppHostProtocol.TProtoEventLogDump;

        /**
         * Decodes a TProtoEventLogDump message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TProtoEventLogDump
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NAppHostProtocol.TProtoEventLogDump;

        /**
         * Verifies a TProtoEventLogDump message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TProtoEventLogDump message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TProtoEventLogDump
         */
        public static fromObject(object: { [k: string]: any }): NAppHostProtocol.TProtoEventLogDump;

        /**
         * Creates a plain object from a TProtoEventLogDump message. Also converts values to other types if specified.
         * @param message TProtoEventLogDump
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NAppHostProtocol.TProtoEventLogDump, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TProtoEventLogDump to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }
}

/** Namespace google. */
export namespace google {

    /** Namespace protobuf. */
    namespace protobuf {

        /** Properties of an Any. */
        interface IAny {

            /** Any type_url */
            type_url?: (string|null);

            /** Any value */
            value?: (Uint8Array|null);
        }

        /** Represents an Any. */
        class Any implements IAny {

            /**
             * Constructs a new Any.
             * @param [properties] Properties to set
             */
            constructor(properties?: google.protobuf.IAny);

            /** Any type_url. */
            public type_url: string;

            /** Any value. */
            public value: Uint8Array;

            /**
             * Creates a new Any instance using the specified properties.
             * @param [properties] Properties to set
             * @returns Any instance
             */
            public static create(properties?: google.protobuf.IAny): google.protobuf.Any;

            /**
             * Encodes the specified Any message. Does not implicitly {@link google.protobuf.Any.verify|verify} messages.
             * @param message Any message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: google.protobuf.IAny, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified Any message, length delimited. Does not implicitly {@link google.protobuf.Any.verify|verify} messages.
             * @param message Any message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: google.protobuf.IAny, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an Any message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns Any
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.protobuf.Any;

            /**
             * Decodes an Any message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns Any
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.protobuf.Any;

            /**
             * Verifies an Any message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an Any message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns Any
             */
            public static fromObject(object: { [k: string]: any }): google.protobuf.Any;

            /**
             * Creates a plain object from an Any message. Also converts values to other types if specified.
             * @param message Any
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: google.protobuf.Any, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this Any to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a FileDescriptorSet. */
        interface IFileDescriptorSet {

            /** FileDescriptorSet file */
            file?: (google.protobuf.IFileDescriptorProto[]|null);
        }

        /** Represents a FileDescriptorSet. */
        class FileDescriptorSet implements IFileDescriptorSet {

            /**
             * Constructs a new FileDescriptorSet.
             * @param [properties] Properties to set
             */
            constructor(properties?: google.protobuf.IFileDescriptorSet);

            /** FileDescriptorSet file. */
            public file: google.protobuf.IFileDescriptorProto[];

            /**
             * Creates a new FileDescriptorSet instance using the specified properties.
             * @param [properties] Properties to set
             * @returns FileDescriptorSet instance
             */
            public static create(properties?: google.protobuf.IFileDescriptorSet): google.protobuf.FileDescriptorSet;

            /**
             * Encodes the specified FileDescriptorSet message. Does not implicitly {@link google.protobuf.FileDescriptorSet.verify|verify} messages.
             * @param message FileDescriptorSet message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: google.protobuf.IFileDescriptorSet, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified FileDescriptorSet message, length delimited. Does not implicitly {@link google.protobuf.FileDescriptorSet.verify|verify} messages.
             * @param message FileDescriptorSet message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: google.protobuf.IFileDescriptorSet, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a FileDescriptorSet message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns FileDescriptorSet
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.protobuf.FileDescriptorSet;

            /**
             * Decodes a FileDescriptorSet message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns FileDescriptorSet
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.protobuf.FileDescriptorSet;

            /**
             * Verifies a FileDescriptorSet message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a FileDescriptorSet message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns FileDescriptorSet
             */
            public static fromObject(object: { [k: string]: any }): google.protobuf.FileDescriptorSet;

            /**
             * Creates a plain object from a FileDescriptorSet message. Also converts values to other types if specified.
             * @param message FileDescriptorSet
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: google.protobuf.FileDescriptorSet, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this FileDescriptorSet to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a FileDescriptorProto. */
        interface IFileDescriptorProto {

            /** FileDescriptorProto name */
            name?: (string|null);

            /** FileDescriptorProto package */
            "package"?: (string|null);

            /** FileDescriptorProto dependency */
            dependency?: (string[]|null);

            /** FileDescriptorProto publicDependency */
            publicDependency?: (number[]|null);

            /** FileDescriptorProto weakDependency */
            weakDependency?: (number[]|null);

            /** FileDescriptorProto messageType */
            messageType?: (google.protobuf.IDescriptorProto[]|null);

            /** FileDescriptorProto enumType */
            enumType?: (google.protobuf.IEnumDescriptorProto[]|null);

            /** FileDescriptorProto service */
            service?: (google.protobuf.IServiceDescriptorProto[]|null);

            /** FileDescriptorProto extension */
            extension?: (google.protobuf.IFieldDescriptorProto[]|null);

            /** FileDescriptorProto options */
            options?: (google.protobuf.IFileOptions|null);

            /** FileDescriptorProto sourceCodeInfo */
            sourceCodeInfo?: (google.protobuf.ISourceCodeInfo|null);

            /** FileDescriptorProto syntax */
            syntax?: (string|null);
        }

        /** Represents a FileDescriptorProto. */
        class FileDescriptorProto implements IFileDescriptorProto {

            /**
             * Constructs a new FileDescriptorProto.
             * @param [properties] Properties to set
             */
            constructor(properties?: google.protobuf.IFileDescriptorProto);

            /** FileDescriptorProto name. */
            public name: string;

            /** FileDescriptorProto package. */
            public package: string;

            /** FileDescriptorProto dependency. */
            public dependency: string[];

            /** FileDescriptorProto publicDependency. */
            public publicDependency: number[];

            /** FileDescriptorProto weakDependency. */
            public weakDependency: number[];

            /** FileDescriptorProto messageType. */
            public messageType: google.protobuf.IDescriptorProto[];

            /** FileDescriptorProto enumType. */
            public enumType: google.protobuf.IEnumDescriptorProto[];

            /** FileDescriptorProto service. */
            public service: google.protobuf.IServiceDescriptorProto[];

            /** FileDescriptorProto extension. */
            public extension: google.protobuf.IFieldDescriptorProto[];

            /** FileDescriptorProto options. */
            public options?: (google.protobuf.IFileOptions|null);

            /** FileDescriptorProto sourceCodeInfo. */
            public sourceCodeInfo?: (google.protobuf.ISourceCodeInfo|null);

            /** FileDescriptorProto syntax. */
            public syntax: string;

            /**
             * Creates a new FileDescriptorProto instance using the specified properties.
             * @param [properties] Properties to set
             * @returns FileDescriptorProto instance
             */
            public static create(properties?: google.protobuf.IFileDescriptorProto): google.protobuf.FileDescriptorProto;

            /**
             * Encodes the specified FileDescriptorProto message. Does not implicitly {@link google.protobuf.FileDescriptorProto.verify|verify} messages.
             * @param message FileDescriptorProto message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: google.protobuf.IFileDescriptorProto, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified FileDescriptorProto message, length delimited. Does not implicitly {@link google.protobuf.FileDescriptorProto.verify|verify} messages.
             * @param message FileDescriptorProto message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: google.protobuf.IFileDescriptorProto, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a FileDescriptorProto message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns FileDescriptorProto
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.protobuf.FileDescriptorProto;

            /**
             * Decodes a FileDescriptorProto message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns FileDescriptorProto
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.protobuf.FileDescriptorProto;

            /**
             * Verifies a FileDescriptorProto message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a FileDescriptorProto message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns FileDescriptorProto
             */
            public static fromObject(object: { [k: string]: any }): google.protobuf.FileDescriptorProto;

            /**
             * Creates a plain object from a FileDescriptorProto message. Also converts values to other types if specified.
             * @param message FileDescriptorProto
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: google.protobuf.FileDescriptorProto, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this FileDescriptorProto to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a DescriptorProto. */
        interface IDescriptorProto {

            /** DescriptorProto name */
            name?: (string|null);

            /** DescriptorProto field */
            field?: (google.protobuf.IFieldDescriptorProto[]|null);

            /** DescriptorProto extension */
            extension?: (google.protobuf.IFieldDescriptorProto[]|null);

            /** DescriptorProto nestedType */
            nestedType?: (google.protobuf.IDescriptorProto[]|null);

            /** DescriptorProto enumType */
            enumType?: (google.protobuf.IEnumDescriptorProto[]|null);

            /** DescriptorProto extensionRange */
            extensionRange?: (google.protobuf.DescriptorProto.IExtensionRange[]|null);

            /** DescriptorProto oneofDecl */
            oneofDecl?: (google.protobuf.IOneofDescriptorProto[]|null);

            /** DescriptorProto options */
            options?: (google.protobuf.IMessageOptions|null);

            /** DescriptorProto reservedRange */
            reservedRange?: (google.protobuf.DescriptorProto.IReservedRange[]|null);

            /** DescriptorProto reservedName */
            reservedName?: (string[]|null);
        }

        /** Represents a DescriptorProto. */
        class DescriptorProto implements IDescriptorProto {

            /**
             * Constructs a new DescriptorProto.
             * @param [properties] Properties to set
             */
            constructor(properties?: google.protobuf.IDescriptorProto);

            /** DescriptorProto name. */
            public name: string;

            /** DescriptorProto field. */
            public field: google.protobuf.IFieldDescriptorProto[];

            /** DescriptorProto extension. */
            public extension: google.protobuf.IFieldDescriptorProto[];

            /** DescriptorProto nestedType. */
            public nestedType: google.protobuf.IDescriptorProto[];

            /** DescriptorProto enumType. */
            public enumType: google.protobuf.IEnumDescriptorProto[];

            /** DescriptorProto extensionRange. */
            public extensionRange: google.protobuf.DescriptorProto.IExtensionRange[];

            /** DescriptorProto oneofDecl. */
            public oneofDecl: google.protobuf.IOneofDescriptorProto[];

            /** DescriptorProto options. */
            public options?: (google.protobuf.IMessageOptions|null);

            /** DescriptorProto reservedRange. */
            public reservedRange: google.protobuf.DescriptorProto.IReservedRange[];

            /** DescriptorProto reservedName. */
            public reservedName: string[];

            /**
             * Creates a new DescriptorProto instance using the specified properties.
             * @param [properties] Properties to set
             * @returns DescriptorProto instance
             */
            public static create(properties?: google.protobuf.IDescriptorProto): google.protobuf.DescriptorProto;

            /**
             * Encodes the specified DescriptorProto message. Does not implicitly {@link google.protobuf.DescriptorProto.verify|verify} messages.
             * @param message DescriptorProto message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: google.protobuf.IDescriptorProto, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified DescriptorProto message, length delimited. Does not implicitly {@link google.protobuf.DescriptorProto.verify|verify} messages.
             * @param message DescriptorProto message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: google.protobuf.IDescriptorProto, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a DescriptorProto message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns DescriptorProto
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.protobuf.DescriptorProto;

            /**
             * Decodes a DescriptorProto message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns DescriptorProto
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.protobuf.DescriptorProto;

            /**
             * Verifies a DescriptorProto message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a DescriptorProto message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns DescriptorProto
             */
            public static fromObject(object: { [k: string]: any }): google.protobuf.DescriptorProto;

            /**
             * Creates a plain object from a DescriptorProto message. Also converts values to other types if specified.
             * @param message DescriptorProto
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: google.protobuf.DescriptorProto, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this DescriptorProto to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace DescriptorProto {

            /** Properties of an ExtensionRange. */
            interface IExtensionRange {

                /** ExtensionRange start */
                start?: (number|null);

                /** ExtensionRange end */
                end?: (number|null);
            }

            /** Represents an ExtensionRange. */
            class ExtensionRange implements IExtensionRange {

                /**
                 * Constructs a new ExtensionRange.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: google.protobuf.DescriptorProto.IExtensionRange);

                /** ExtensionRange start. */
                public start: number;

                /** ExtensionRange end. */
                public end: number;

                /**
                 * Creates a new ExtensionRange instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns ExtensionRange instance
                 */
                public static create(properties?: google.protobuf.DescriptorProto.IExtensionRange): google.protobuf.DescriptorProto.ExtensionRange;

                /**
                 * Encodes the specified ExtensionRange message. Does not implicitly {@link google.protobuf.DescriptorProto.ExtensionRange.verify|verify} messages.
                 * @param message ExtensionRange message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: google.protobuf.DescriptorProto.IExtensionRange, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified ExtensionRange message, length delimited. Does not implicitly {@link google.protobuf.DescriptorProto.ExtensionRange.verify|verify} messages.
                 * @param message ExtensionRange message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: google.protobuf.DescriptorProto.IExtensionRange, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes an ExtensionRange message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns ExtensionRange
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.protobuf.DescriptorProto.ExtensionRange;

                /**
                 * Decodes an ExtensionRange message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns ExtensionRange
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.protobuf.DescriptorProto.ExtensionRange;

                /**
                 * Verifies an ExtensionRange message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates an ExtensionRange message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns ExtensionRange
                 */
                public static fromObject(object: { [k: string]: any }): google.protobuf.DescriptorProto.ExtensionRange;

                /**
                 * Creates a plain object from an ExtensionRange message. Also converts values to other types if specified.
                 * @param message ExtensionRange
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: google.protobuf.DescriptorProto.ExtensionRange, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this ExtensionRange to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }

            /** Properties of a ReservedRange. */
            interface IReservedRange {

                /** ReservedRange start */
                start?: (number|null);

                /** ReservedRange end */
                end?: (number|null);
            }

            /** Represents a ReservedRange. */
            class ReservedRange implements IReservedRange {

                /**
                 * Constructs a new ReservedRange.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: google.protobuf.DescriptorProto.IReservedRange);

                /** ReservedRange start. */
                public start: number;

                /** ReservedRange end. */
                public end: number;

                /**
                 * Creates a new ReservedRange instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns ReservedRange instance
                 */
                public static create(properties?: google.protobuf.DescriptorProto.IReservedRange): google.protobuf.DescriptorProto.ReservedRange;

                /**
                 * Encodes the specified ReservedRange message. Does not implicitly {@link google.protobuf.DescriptorProto.ReservedRange.verify|verify} messages.
                 * @param message ReservedRange message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: google.protobuf.DescriptorProto.IReservedRange, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified ReservedRange message, length delimited. Does not implicitly {@link google.protobuf.DescriptorProto.ReservedRange.verify|verify} messages.
                 * @param message ReservedRange message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: google.protobuf.DescriptorProto.IReservedRange, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a ReservedRange message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns ReservedRange
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.protobuf.DescriptorProto.ReservedRange;

                /**
                 * Decodes a ReservedRange message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns ReservedRange
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.protobuf.DescriptorProto.ReservedRange;

                /**
                 * Verifies a ReservedRange message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a ReservedRange message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns ReservedRange
                 */
                public static fromObject(object: { [k: string]: any }): google.protobuf.DescriptorProto.ReservedRange;

                /**
                 * Creates a plain object from a ReservedRange message. Also converts values to other types if specified.
                 * @param message ReservedRange
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: google.protobuf.DescriptorProto.ReservedRange, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this ReservedRange to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }
        }

        /** Properties of a FieldDescriptorProto. */
        interface IFieldDescriptorProto {

            /** FieldDescriptorProto name */
            name?: (string|null);

            /** FieldDescriptorProto number */
            number?: (number|null);

            /** FieldDescriptorProto label */
            label?: (google.protobuf.FieldDescriptorProto.Label|null);

            /** FieldDescriptorProto type */
            type?: (google.protobuf.FieldDescriptorProto.Type|null);

            /** FieldDescriptorProto typeName */
            typeName?: (string|null);

            /** FieldDescriptorProto extendee */
            extendee?: (string|null);

            /** FieldDescriptorProto defaultValue */
            defaultValue?: (string|null);

            /** FieldDescriptorProto oneofIndex */
            oneofIndex?: (number|null);

            /** FieldDescriptorProto jsonName */
            jsonName?: (string|null);

            /** FieldDescriptorProto options */
            options?: (google.protobuf.IFieldOptions|null);
        }

        /** Represents a FieldDescriptorProto. */
        class FieldDescriptorProto implements IFieldDescriptorProto {

            /**
             * Constructs a new FieldDescriptorProto.
             * @param [properties] Properties to set
             */
            constructor(properties?: google.protobuf.IFieldDescriptorProto);

            /** FieldDescriptorProto name. */
            public name: string;

            /** FieldDescriptorProto number. */
            public number: number;

            /** FieldDescriptorProto label. */
            public label: google.protobuf.FieldDescriptorProto.Label;

            /** FieldDescriptorProto type. */
            public type: google.protobuf.FieldDescriptorProto.Type;

            /** FieldDescriptorProto typeName. */
            public typeName: string;

            /** FieldDescriptorProto extendee. */
            public extendee: string;

            /** FieldDescriptorProto defaultValue. */
            public defaultValue: string;

            /** FieldDescriptorProto oneofIndex. */
            public oneofIndex: number;

            /** FieldDescriptorProto jsonName. */
            public jsonName: string;

            /** FieldDescriptorProto options. */
            public options?: (google.protobuf.IFieldOptions|null);

            /**
             * Creates a new FieldDescriptorProto instance using the specified properties.
             * @param [properties] Properties to set
             * @returns FieldDescriptorProto instance
             */
            public static create(properties?: google.protobuf.IFieldDescriptorProto): google.protobuf.FieldDescriptorProto;

            /**
             * Encodes the specified FieldDescriptorProto message. Does not implicitly {@link google.protobuf.FieldDescriptorProto.verify|verify} messages.
             * @param message FieldDescriptorProto message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: google.protobuf.IFieldDescriptorProto, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified FieldDescriptorProto message, length delimited. Does not implicitly {@link google.protobuf.FieldDescriptorProto.verify|verify} messages.
             * @param message FieldDescriptorProto message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: google.protobuf.IFieldDescriptorProto, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a FieldDescriptorProto message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns FieldDescriptorProto
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.protobuf.FieldDescriptorProto;

            /**
             * Decodes a FieldDescriptorProto message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns FieldDescriptorProto
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.protobuf.FieldDescriptorProto;

            /**
             * Verifies a FieldDescriptorProto message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a FieldDescriptorProto message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns FieldDescriptorProto
             */
            public static fromObject(object: { [k: string]: any }): google.protobuf.FieldDescriptorProto;

            /**
             * Creates a plain object from a FieldDescriptorProto message. Also converts values to other types if specified.
             * @param message FieldDescriptorProto
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: google.protobuf.FieldDescriptorProto, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this FieldDescriptorProto to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace FieldDescriptorProto {

            /** Type enum. */
            enum Type {
                TYPE_DOUBLE = 1,
                TYPE_FLOAT = 2,
                TYPE_INT64 = 3,
                TYPE_UINT64 = 4,
                TYPE_INT32 = 5,
                TYPE_FIXED64 = 6,
                TYPE_FIXED32 = 7,
                TYPE_BOOL = 8,
                TYPE_STRING = 9,
                TYPE_GROUP = 10,
                TYPE_MESSAGE = 11,
                TYPE_BYTES = 12,
                TYPE_UINT32 = 13,
                TYPE_ENUM = 14,
                TYPE_SFIXED32 = 15,
                TYPE_SFIXED64 = 16,
                TYPE_SINT32 = 17,
                TYPE_SINT64 = 18
            }

            /** Label enum. */
            enum Label {
                LABEL_OPTIONAL = 1,
                LABEL_REQUIRED = 2,
                LABEL_REPEATED = 3
            }
        }

        /** Properties of an OneofDescriptorProto. */
        interface IOneofDescriptorProto {

            /** OneofDescriptorProto name */
            name?: (string|null);

            /** OneofDescriptorProto options */
            options?: (google.protobuf.IOneofOptions|null);
        }

        /** Represents an OneofDescriptorProto. */
        class OneofDescriptorProto implements IOneofDescriptorProto {

            /**
             * Constructs a new OneofDescriptorProto.
             * @param [properties] Properties to set
             */
            constructor(properties?: google.protobuf.IOneofDescriptorProto);

            /** OneofDescriptorProto name. */
            public name: string;

            /** OneofDescriptorProto options. */
            public options?: (google.protobuf.IOneofOptions|null);

            /**
             * Creates a new OneofDescriptorProto instance using the specified properties.
             * @param [properties] Properties to set
             * @returns OneofDescriptorProto instance
             */
            public static create(properties?: google.protobuf.IOneofDescriptorProto): google.protobuf.OneofDescriptorProto;

            /**
             * Encodes the specified OneofDescriptorProto message. Does not implicitly {@link google.protobuf.OneofDescriptorProto.verify|verify} messages.
             * @param message OneofDescriptorProto message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: google.protobuf.IOneofDescriptorProto, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified OneofDescriptorProto message, length delimited. Does not implicitly {@link google.protobuf.OneofDescriptorProto.verify|verify} messages.
             * @param message OneofDescriptorProto message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: google.protobuf.IOneofDescriptorProto, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an OneofDescriptorProto message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns OneofDescriptorProto
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.protobuf.OneofDescriptorProto;

            /**
             * Decodes an OneofDescriptorProto message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns OneofDescriptorProto
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.protobuf.OneofDescriptorProto;

            /**
             * Verifies an OneofDescriptorProto message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an OneofDescriptorProto message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns OneofDescriptorProto
             */
            public static fromObject(object: { [k: string]: any }): google.protobuf.OneofDescriptorProto;

            /**
             * Creates a plain object from an OneofDescriptorProto message. Also converts values to other types if specified.
             * @param message OneofDescriptorProto
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: google.protobuf.OneofDescriptorProto, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this OneofDescriptorProto to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of an EnumDescriptorProto. */
        interface IEnumDescriptorProto {

            /** EnumDescriptorProto name */
            name?: (string|null);

            /** EnumDescriptorProto value */
            value?: (google.protobuf.IEnumValueDescriptorProto[]|null);

            /** EnumDescriptorProto options */
            options?: (google.protobuf.IEnumOptions|null);
        }

        /** Represents an EnumDescriptorProto. */
        class EnumDescriptorProto implements IEnumDescriptorProto {

            /**
             * Constructs a new EnumDescriptorProto.
             * @param [properties] Properties to set
             */
            constructor(properties?: google.protobuf.IEnumDescriptorProto);

            /** EnumDescriptorProto name. */
            public name: string;

            /** EnumDescriptorProto value. */
            public value: google.protobuf.IEnumValueDescriptorProto[];

            /** EnumDescriptorProto options. */
            public options?: (google.protobuf.IEnumOptions|null);

            /**
             * Creates a new EnumDescriptorProto instance using the specified properties.
             * @param [properties] Properties to set
             * @returns EnumDescriptorProto instance
             */
            public static create(properties?: google.protobuf.IEnumDescriptorProto): google.protobuf.EnumDescriptorProto;

            /**
             * Encodes the specified EnumDescriptorProto message. Does not implicitly {@link google.protobuf.EnumDescriptorProto.verify|verify} messages.
             * @param message EnumDescriptorProto message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: google.protobuf.IEnumDescriptorProto, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified EnumDescriptorProto message, length delimited. Does not implicitly {@link google.protobuf.EnumDescriptorProto.verify|verify} messages.
             * @param message EnumDescriptorProto message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: google.protobuf.IEnumDescriptorProto, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an EnumDescriptorProto message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns EnumDescriptorProto
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.protobuf.EnumDescriptorProto;

            /**
             * Decodes an EnumDescriptorProto message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns EnumDescriptorProto
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.protobuf.EnumDescriptorProto;

            /**
             * Verifies an EnumDescriptorProto message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an EnumDescriptorProto message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns EnumDescriptorProto
             */
            public static fromObject(object: { [k: string]: any }): google.protobuf.EnumDescriptorProto;

            /**
             * Creates a plain object from an EnumDescriptorProto message. Also converts values to other types if specified.
             * @param message EnumDescriptorProto
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: google.protobuf.EnumDescriptorProto, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this EnumDescriptorProto to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of an EnumValueDescriptorProto. */
        interface IEnumValueDescriptorProto {

            /** EnumValueDescriptorProto name */
            name?: (string|null);

            /** EnumValueDescriptorProto number */
            number?: (number|null);

            /** EnumValueDescriptorProto options */
            options?: (google.protobuf.IEnumValueOptions|null);
        }

        /** Represents an EnumValueDescriptorProto. */
        class EnumValueDescriptorProto implements IEnumValueDescriptorProto {

            /**
             * Constructs a new EnumValueDescriptorProto.
             * @param [properties] Properties to set
             */
            constructor(properties?: google.protobuf.IEnumValueDescriptorProto);

            /** EnumValueDescriptorProto name. */
            public name: string;

            /** EnumValueDescriptorProto number. */
            public number: number;

            /** EnumValueDescriptorProto options. */
            public options?: (google.protobuf.IEnumValueOptions|null);

            /**
             * Creates a new EnumValueDescriptorProto instance using the specified properties.
             * @param [properties] Properties to set
             * @returns EnumValueDescriptorProto instance
             */
            public static create(properties?: google.protobuf.IEnumValueDescriptorProto): google.protobuf.EnumValueDescriptorProto;

            /**
             * Encodes the specified EnumValueDescriptorProto message. Does not implicitly {@link google.protobuf.EnumValueDescriptorProto.verify|verify} messages.
             * @param message EnumValueDescriptorProto message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: google.protobuf.IEnumValueDescriptorProto, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified EnumValueDescriptorProto message, length delimited. Does not implicitly {@link google.protobuf.EnumValueDescriptorProto.verify|verify} messages.
             * @param message EnumValueDescriptorProto message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: google.protobuf.IEnumValueDescriptorProto, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an EnumValueDescriptorProto message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns EnumValueDescriptorProto
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.protobuf.EnumValueDescriptorProto;

            /**
             * Decodes an EnumValueDescriptorProto message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns EnumValueDescriptorProto
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.protobuf.EnumValueDescriptorProto;

            /**
             * Verifies an EnumValueDescriptorProto message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an EnumValueDescriptorProto message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns EnumValueDescriptorProto
             */
            public static fromObject(object: { [k: string]: any }): google.protobuf.EnumValueDescriptorProto;

            /**
             * Creates a plain object from an EnumValueDescriptorProto message. Also converts values to other types if specified.
             * @param message EnumValueDescriptorProto
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: google.protobuf.EnumValueDescriptorProto, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this EnumValueDescriptorProto to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a ServiceDescriptorProto. */
        interface IServiceDescriptorProto {

            /** ServiceDescriptorProto name */
            name?: (string|null);

            /** ServiceDescriptorProto method */
            method?: (google.protobuf.IMethodDescriptorProto[]|null);

            /** ServiceDescriptorProto options */
            options?: (google.protobuf.IServiceOptions|null);
        }

        /** Represents a ServiceDescriptorProto. */
        class ServiceDescriptorProto implements IServiceDescriptorProto {

            /**
             * Constructs a new ServiceDescriptorProto.
             * @param [properties] Properties to set
             */
            constructor(properties?: google.protobuf.IServiceDescriptorProto);

            /** ServiceDescriptorProto name. */
            public name: string;

            /** ServiceDescriptorProto method. */
            public method: google.protobuf.IMethodDescriptorProto[];

            /** ServiceDescriptorProto options. */
            public options?: (google.protobuf.IServiceOptions|null);

            /**
             * Creates a new ServiceDescriptorProto instance using the specified properties.
             * @param [properties] Properties to set
             * @returns ServiceDescriptorProto instance
             */
            public static create(properties?: google.protobuf.IServiceDescriptorProto): google.protobuf.ServiceDescriptorProto;

            /**
             * Encodes the specified ServiceDescriptorProto message. Does not implicitly {@link google.protobuf.ServiceDescriptorProto.verify|verify} messages.
             * @param message ServiceDescriptorProto message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: google.protobuf.IServiceDescriptorProto, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified ServiceDescriptorProto message, length delimited. Does not implicitly {@link google.protobuf.ServiceDescriptorProto.verify|verify} messages.
             * @param message ServiceDescriptorProto message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: google.protobuf.IServiceDescriptorProto, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a ServiceDescriptorProto message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns ServiceDescriptorProto
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.protobuf.ServiceDescriptorProto;

            /**
             * Decodes a ServiceDescriptorProto message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns ServiceDescriptorProto
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.protobuf.ServiceDescriptorProto;

            /**
             * Verifies a ServiceDescriptorProto message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a ServiceDescriptorProto message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns ServiceDescriptorProto
             */
            public static fromObject(object: { [k: string]: any }): google.protobuf.ServiceDescriptorProto;

            /**
             * Creates a plain object from a ServiceDescriptorProto message. Also converts values to other types if specified.
             * @param message ServiceDescriptorProto
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: google.protobuf.ServiceDescriptorProto, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this ServiceDescriptorProto to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a MethodDescriptorProto. */
        interface IMethodDescriptorProto {

            /** MethodDescriptorProto name */
            name?: (string|null);

            /** MethodDescriptorProto inputType */
            inputType?: (string|null);

            /** MethodDescriptorProto outputType */
            outputType?: (string|null);

            /** MethodDescriptorProto options */
            options?: (google.protobuf.IMethodOptions|null);

            /** MethodDescriptorProto clientStreaming */
            clientStreaming?: (boolean|null);

            /** MethodDescriptorProto serverStreaming */
            serverStreaming?: (boolean|null);
        }

        /** Represents a MethodDescriptorProto. */
        class MethodDescriptorProto implements IMethodDescriptorProto {

            /**
             * Constructs a new MethodDescriptorProto.
             * @param [properties] Properties to set
             */
            constructor(properties?: google.protobuf.IMethodDescriptorProto);

            /** MethodDescriptorProto name. */
            public name: string;

            /** MethodDescriptorProto inputType. */
            public inputType: string;

            /** MethodDescriptorProto outputType. */
            public outputType: string;

            /** MethodDescriptorProto options. */
            public options?: (google.protobuf.IMethodOptions|null);

            /** MethodDescriptorProto clientStreaming. */
            public clientStreaming: boolean;

            /** MethodDescriptorProto serverStreaming. */
            public serverStreaming: boolean;

            /**
             * Creates a new MethodDescriptorProto instance using the specified properties.
             * @param [properties] Properties to set
             * @returns MethodDescriptorProto instance
             */
            public static create(properties?: google.protobuf.IMethodDescriptorProto): google.protobuf.MethodDescriptorProto;

            /**
             * Encodes the specified MethodDescriptorProto message. Does not implicitly {@link google.protobuf.MethodDescriptorProto.verify|verify} messages.
             * @param message MethodDescriptorProto message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: google.protobuf.IMethodDescriptorProto, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified MethodDescriptorProto message, length delimited. Does not implicitly {@link google.protobuf.MethodDescriptorProto.verify|verify} messages.
             * @param message MethodDescriptorProto message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: google.protobuf.IMethodDescriptorProto, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a MethodDescriptorProto message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns MethodDescriptorProto
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.protobuf.MethodDescriptorProto;

            /**
             * Decodes a MethodDescriptorProto message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns MethodDescriptorProto
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.protobuf.MethodDescriptorProto;

            /**
             * Verifies a MethodDescriptorProto message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a MethodDescriptorProto message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns MethodDescriptorProto
             */
            public static fromObject(object: { [k: string]: any }): google.protobuf.MethodDescriptorProto;

            /**
             * Creates a plain object from a MethodDescriptorProto message. Also converts values to other types if specified.
             * @param message MethodDescriptorProto
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: google.protobuf.MethodDescriptorProto, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this MethodDescriptorProto to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a FileOptions. */
        interface IFileOptions {

            /** FileOptions javaPackage */
            javaPackage?: (string|null);

            /** FileOptions javaOuterClassname */
            javaOuterClassname?: (string|null);

            /** FileOptions javaMultipleFiles */
            javaMultipleFiles?: (boolean|null);

            /** FileOptions javaGenerateEqualsAndHash */
            javaGenerateEqualsAndHash?: (boolean|null);

            /** FileOptions javaStringCheckUtf8 */
            javaStringCheckUtf8?: (boolean|null);

            /** FileOptions optimizeFor */
            optimizeFor?: (google.protobuf.FileOptions.OptimizeMode|null);

            /** FileOptions goPackage */
            goPackage?: (string|null);

            /** FileOptions ccGenericServices */
            ccGenericServices?: (boolean|null);

            /** FileOptions javaGenericServices */
            javaGenericServices?: (boolean|null);

            /** FileOptions pyGenericServices */
            pyGenericServices?: (boolean|null);

            /** FileOptions deprecated */
            deprecated?: (boolean|null);

            /** FileOptions ccEnableArenas */
            ccEnableArenas?: (boolean|null);

            /** FileOptions objcClassPrefix */
            objcClassPrefix?: (string|null);

            /** FileOptions csharpNamespace */
            csharpNamespace?: (string|null);

            /** FileOptions uninterpretedOption */
            uninterpretedOption?: (google.protobuf.IUninterpretedOption[]|null);
        }

        /** Represents a FileOptions. */
        class FileOptions implements IFileOptions {

            /**
             * Constructs a new FileOptions.
             * @param [properties] Properties to set
             */
            constructor(properties?: google.protobuf.IFileOptions);

            /** FileOptions javaPackage. */
            public javaPackage: string;

            /** FileOptions javaOuterClassname. */
            public javaOuterClassname: string;

            /** FileOptions javaMultipleFiles. */
            public javaMultipleFiles: boolean;

            /** FileOptions javaGenerateEqualsAndHash. */
            public javaGenerateEqualsAndHash: boolean;

            /** FileOptions javaStringCheckUtf8. */
            public javaStringCheckUtf8: boolean;

            /** FileOptions optimizeFor. */
            public optimizeFor: google.protobuf.FileOptions.OptimizeMode;

            /** FileOptions goPackage. */
            public goPackage: string;

            /** FileOptions ccGenericServices. */
            public ccGenericServices: boolean;

            /** FileOptions javaGenericServices. */
            public javaGenericServices: boolean;

            /** FileOptions pyGenericServices. */
            public pyGenericServices: boolean;

            /** FileOptions deprecated. */
            public deprecated: boolean;

            /** FileOptions ccEnableArenas. */
            public ccEnableArenas: boolean;

            /** FileOptions objcClassPrefix. */
            public objcClassPrefix: string;

            /** FileOptions csharpNamespace. */
            public csharpNamespace: string;

            /** FileOptions uninterpretedOption. */
            public uninterpretedOption: google.protobuf.IUninterpretedOption[];

            /**
             * Creates a new FileOptions instance using the specified properties.
             * @param [properties] Properties to set
             * @returns FileOptions instance
             */
            public static create(properties?: google.protobuf.IFileOptions): google.protobuf.FileOptions;

            /**
             * Encodes the specified FileOptions message. Does not implicitly {@link google.protobuf.FileOptions.verify|verify} messages.
             * @param message FileOptions message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: google.protobuf.IFileOptions, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified FileOptions message, length delimited. Does not implicitly {@link google.protobuf.FileOptions.verify|verify} messages.
             * @param message FileOptions message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: google.protobuf.IFileOptions, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a FileOptions message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns FileOptions
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.protobuf.FileOptions;

            /**
             * Decodes a FileOptions message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns FileOptions
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.protobuf.FileOptions;

            /**
             * Verifies a FileOptions message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a FileOptions message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns FileOptions
             */
            public static fromObject(object: { [k: string]: any }): google.protobuf.FileOptions;

            /**
             * Creates a plain object from a FileOptions message. Also converts values to other types if specified.
             * @param message FileOptions
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: google.protobuf.FileOptions, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this FileOptions to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace FileOptions {

            /** OptimizeMode enum. */
            enum OptimizeMode {
                SPEED = 1,
                CODE_SIZE = 2,
                LITE_RUNTIME = 3
            }
        }

        /** Properties of a MessageOptions. */
        interface IMessageOptions {

            /** MessageOptions messageSetWireFormat */
            messageSetWireFormat?: (boolean|null);

            /** MessageOptions noStandardDescriptorAccessor */
            noStandardDescriptorAccessor?: (boolean|null);

            /** MessageOptions deprecated */
            deprecated?: (boolean|null);

            /** MessageOptions mapEntry */
            mapEntry?: (boolean|null);

            /** MessageOptions uninterpretedOption */
            uninterpretedOption?: (google.protobuf.IUninterpretedOption[]|null);

            /** MessageOptions .alwaysProto */
            ".alwaysProto"?: (boolean|null);

            /** MessageOptions .apphostType */
            ".apphostType"?: (string|null);
        }

        /** Represents a MessageOptions. */
        class MessageOptions implements IMessageOptions {

            /**
             * Constructs a new MessageOptions.
             * @param [properties] Properties to set
             */
            constructor(properties?: google.protobuf.IMessageOptions);

            /** MessageOptions messageSetWireFormat. */
            public messageSetWireFormat: boolean;

            /** MessageOptions noStandardDescriptorAccessor. */
            public noStandardDescriptorAccessor: boolean;

            /** MessageOptions deprecated. */
            public deprecated: boolean;

            /** MessageOptions mapEntry. */
            public mapEntry: boolean;

            /** MessageOptions uninterpretedOption. */
            public uninterpretedOption: google.protobuf.IUninterpretedOption[];

            /** MessageOptions .alwaysProto. */
            public alwaysProto: boolean;

            /** MessageOptions .apphostType. */
            public apphostType: string;

            /**
             * Creates a new MessageOptions instance using the specified properties.
             * @param [properties] Properties to set
             * @returns MessageOptions instance
             */
            public static create(properties?: google.protobuf.IMessageOptions): google.protobuf.MessageOptions;

            /**
             * Encodes the specified MessageOptions message. Does not implicitly {@link google.protobuf.MessageOptions.verify|verify} messages.
             * @param message MessageOptions message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: google.protobuf.IMessageOptions, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified MessageOptions message, length delimited. Does not implicitly {@link google.protobuf.MessageOptions.verify|verify} messages.
             * @param message MessageOptions message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: google.protobuf.IMessageOptions, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a MessageOptions message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns MessageOptions
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.protobuf.MessageOptions;

            /**
             * Decodes a MessageOptions message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns MessageOptions
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.protobuf.MessageOptions;

            /**
             * Verifies a MessageOptions message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a MessageOptions message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns MessageOptions
             */
            public static fromObject(object: { [k: string]: any }): google.protobuf.MessageOptions;

            /**
             * Creates a plain object from a MessageOptions message. Also converts values to other types if specified.
             * @param message MessageOptions
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: google.protobuf.MessageOptions, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this MessageOptions to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a FieldOptions. */
        interface IFieldOptions {

            /** FieldOptions ctype */
            ctype?: (google.protobuf.FieldOptions.CType|null);

            /** FieldOptions packed */
            packed?: (boolean|null);

            /** FieldOptions jstype */
            jstype?: (google.protobuf.FieldOptions.JSType|null);

            /** FieldOptions lazy */
            lazy?: (boolean|null);

            /** FieldOptions deprecated */
            deprecated?: (boolean|null);

            /** FieldOptions weak */
            weak?: (boolean|null);

            /** FieldOptions uninterpretedOption */
            uninterpretedOption?: (google.protobuf.IUninterpretedOption[]|null);

            /** FieldOptions .typingApphostType */
            ".typingApphostType"?: (string|null);
        }

        /** Represents a FieldOptions. */
        class FieldOptions implements IFieldOptions {

            /**
             * Constructs a new FieldOptions.
             * @param [properties] Properties to set
             */
            constructor(properties?: google.protobuf.IFieldOptions);

            /** FieldOptions ctype. */
            public ctype: google.protobuf.FieldOptions.CType;

            /** FieldOptions packed. */
            public packed: boolean;

            /** FieldOptions jstype. */
            public jstype: google.protobuf.FieldOptions.JSType;

            /** FieldOptions lazy. */
            public lazy: boolean;

            /** FieldOptions deprecated. */
            public deprecated: boolean;

            /** FieldOptions weak. */
            public weak: boolean;

            /** FieldOptions uninterpretedOption. */
            public uninterpretedOption: google.protobuf.IUninterpretedOption[];

            /** FieldOptions .typingApphostType. */
            public typingApphostType: string;

            /**
             * Creates a new FieldOptions instance using the specified properties.
             * @param [properties] Properties to set
             * @returns FieldOptions instance
             */
            public static create(properties?: google.protobuf.IFieldOptions): google.protobuf.FieldOptions;

            /**
             * Encodes the specified FieldOptions message. Does not implicitly {@link google.protobuf.FieldOptions.verify|verify} messages.
             * @param message FieldOptions message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: google.protobuf.IFieldOptions, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified FieldOptions message, length delimited. Does not implicitly {@link google.protobuf.FieldOptions.verify|verify} messages.
             * @param message FieldOptions message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: google.protobuf.IFieldOptions, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a FieldOptions message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns FieldOptions
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.protobuf.FieldOptions;

            /**
             * Decodes a FieldOptions message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns FieldOptions
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.protobuf.FieldOptions;

            /**
             * Verifies a FieldOptions message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a FieldOptions message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns FieldOptions
             */
            public static fromObject(object: { [k: string]: any }): google.protobuf.FieldOptions;

            /**
             * Creates a plain object from a FieldOptions message. Also converts values to other types if specified.
             * @param message FieldOptions
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: google.protobuf.FieldOptions, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this FieldOptions to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace FieldOptions {

            /** CType enum. */
            enum CType {
                STRING = 0,
                CORD = 1,
                STRING_PIECE = 2
            }

            /** JSType enum. */
            enum JSType {
                JS_NORMAL = 0,
                JS_STRING = 1,
                JS_NUMBER = 2
            }
        }

        /** Properties of an OneofOptions. */
        interface IOneofOptions {

            /** OneofOptions uninterpretedOption */
            uninterpretedOption?: (google.protobuf.IUninterpretedOption[]|null);
        }

        /** Represents an OneofOptions. */
        class OneofOptions implements IOneofOptions {

            /**
             * Constructs a new OneofOptions.
             * @param [properties] Properties to set
             */
            constructor(properties?: google.protobuf.IOneofOptions);

            /** OneofOptions uninterpretedOption. */
            public uninterpretedOption: google.protobuf.IUninterpretedOption[];

            /**
             * Creates a new OneofOptions instance using the specified properties.
             * @param [properties] Properties to set
             * @returns OneofOptions instance
             */
            public static create(properties?: google.protobuf.IOneofOptions): google.protobuf.OneofOptions;

            /**
             * Encodes the specified OneofOptions message. Does not implicitly {@link google.protobuf.OneofOptions.verify|verify} messages.
             * @param message OneofOptions message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: google.protobuf.IOneofOptions, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified OneofOptions message, length delimited. Does not implicitly {@link google.protobuf.OneofOptions.verify|verify} messages.
             * @param message OneofOptions message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: google.protobuf.IOneofOptions, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an OneofOptions message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns OneofOptions
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.protobuf.OneofOptions;

            /**
             * Decodes an OneofOptions message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns OneofOptions
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.protobuf.OneofOptions;

            /**
             * Verifies an OneofOptions message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an OneofOptions message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns OneofOptions
             */
            public static fromObject(object: { [k: string]: any }): google.protobuf.OneofOptions;

            /**
             * Creates a plain object from an OneofOptions message. Also converts values to other types if specified.
             * @param message OneofOptions
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: google.protobuf.OneofOptions, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this OneofOptions to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of an EnumOptions. */
        interface IEnumOptions {

            /** EnumOptions allowAlias */
            allowAlias?: (boolean|null);

            /** EnumOptions deprecated */
            deprecated?: (boolean|null);

            /** EnumOptions uninterpretedOption */
            uninterpretedOption?: (google.protobuf.IUninterpretedOption[]|null);
        }

        /** Represents an EnumOptions. */
        class EnumOptions implements IEnumOptions {

            /**
             * Constructs a new EnumOptions.
             * @param [properties] Properties to set
             */
            constructor(properties?: google.protobuf.IEnumOptions);

            /** EnumOptions allowAlias. */
            public allowAlias: boolean;

            /** EnumOptions deprecated. */
            public deprecated: boolean;

            /** EnumOptions uninterpretedOption. */
            public uninterpretedOption: google.protobuf.IUninterpretedOption[];

            /**
             * Creates a new EnumOptions instance using the specified properties.
             * @param [properties] Properties to set
             * @returns EnumOptions instance
             */
            public static create(properties?: google.protobuf.IEnumOptions): google.protobuf.EnumOptions;

            /**
             * Encodes the specified EnumOptions message. Does not implicitly {@link google.protobuf.EnumOptions.verify|verify} messages.
             * @param message EnumOptions message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: google.protobuf.IEnumOptions, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified EnumOptions message, length delimited. Does not implicitly {@link google.protobuf.EnumOptions.verify|verify} messages.
             * @param message EnumOptions message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: google.protobuf.IEnumOptions, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an EnumOptions message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns EnumOptions
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.protobuf.EnumOptions;

            /**
             * Decodes an EnumOptions message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns EnumOptions
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.protobuf.EnumOptions;

            /**
             * Verifies an EnumOptions message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an EnumOptions message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns EnumOptions
             */
            public static fromObject(object: { [k: string]: any }): google.protobuf.EnumOptions;

            /**
             * Creates a plain object from an EnumOptions message. Also converts values to other types if specified.
             * @param message EnumOptions
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: google.protobuf.EnumOptions, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this EnumOptions to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of an EnumValueOptions. */
        interface IEnumValueOptions {

            /** EnumValueOptions deprecated */
            deprecated?: (boolean|null);

            /** EnumValueOptions uninterpretedOption */
            uninterpretedOption?: (google.protobuf.IUninterpretedOption[]|null);
        }

        /** Represents an EnumValueOptions. */
        class EnumValueOptions implements IEnumValueOptions {

            /**
             * Constructs a new EnumValueOptions.
             * @param [properties] Properties to set
             */
            constructor(properties?: google.protobuf.IEnumValueOptions);

            /** EnumValueOptions deprecated. */
            public deprecated: boolean;

            /** EnumValueOptions uninterpretedOption. */
            public uninterpretedOption: google.protobuf.IUninterpretedOption[];

            /**
             * Creates a new EnumValueOptions instance using the specified properties.
             * @param [properties] Properties to set
             * @returns EnumValueOptions instance
             */
            public static create(properties?: google.protobuf.IEnumValueOptions): google.protobuf.EnumValueOptions;

            /**
             * Encodes the specified EnumValueOptions message. Does not implicitly {@link google.protobuf.EnumValueOptions.verify|verify} messages.
             * @param message EnumValueOptions message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: google.protobuf.IEnumValueOptions, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified EnumValueOptions message, length delimited. Does not implicitly {@link google.protobuf.EnumValueOptions.verify|verify} messages.
             * @param message EnumValueOptions message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: google.protobuf.IEnumValueOptions, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an EnumValueOptions message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns EnumValueOptions
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.protobuf.EnumValueOptions;

            /**
             * Decodes an EnumValueOptions message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns EnumValueOptions
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.protobuf.EnumValueOptions;

            /**
             * Verifies an EnumValueOptions message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an EnumValueOptions message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns EnumValueOptions
             */
            public static fromObject(object: { [k: string]: any }): google.protobuf.EnumValueOptions;

            /**
             * Creates a plain object from an EnumValueOptions message. Also converts values to other types if specified.
             * @param message EnumValueOptions
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: google.protobuf.EnumValueOptions, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this EnumValueOptions to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a ServiceOptions. */
        interface IServiceOptions {

            /** ServiceOptions deprecated */
            deprecated?: (boolean|null);

            /** ServiceOptions uninterpretedOption */
            uninterpretedOption?: (google.protobuf.IUninterpretedOption[]|null);
        }

        /** Represents a ServiceOptions. */
        class ServiceOptions implements IServiceOptions {

            /**
             * Constructs a new ServiceOptions.
             * @param [properties] Properties to set
             */
            constructor(properties?: google.protobuf.IServiceOptions);

            /** ServiceOptions deprecated. */
            public deprecated: boolean;

            /** ServiceOptions uninterpretedOption. */
            public uninterpretedOption: google.protobuf.IUninterpretedOption[];

            /**
             * Creates a new ServiceOptions instance using the specified properties.
             * @param [properties] Properties to set
             * @returns ServiceOptions instance
             */
            public static create(properties?: google.protobuf.IServiceOptions): google.protobuf.ServiceOptions;

            /**
             * Encodes the specified ServiceOptions message. Does not implicitly {@link google.protobuf.ServiceOptions.verify|verify} messages.
             * @param message ServiceOptions message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: google.protobuf.IServiceOptions, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified ServiceOptions message, length delimited. Does not implicitly {@link google.protobuf.ServiceOptions.verify|verify} messages.
             * @param message ServiceOptions message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: google.protobuf.IServiceOptions, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a ServiceOptions message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns ServiceOptions
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.protobuf.ServiceOptions;

            /**
             * Decodes a ServiceOptions message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns ServiceOptions
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.protobuf.ServiceOptions;

            /**
             * Verifies a ServiceOptions message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a ServiceOptions message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns ServiceOptions
             */
            public static fromObject(object: { [k: string]: any }): google.protobuf.ServiceOptions;

            /**
             * Creates a plain object from a ServiceOptions message. Also converts values to other types if specified.
             * @param message ServiceOptions
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: google.protobuf.ServiceOptions, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this ServiceOptions to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a MethodOptions. */
        interface IMethodOptions {

            /** MethodOptions deprecated */
            deprecated?: (boolean|null);

            /** MethodOptions uninterpretedOption */
            uninterpretedOption?: (google.protobuf.IUninterpretedOption[]|null);

            /** MethodOptions .path */
            ".path"?: (string|null);
        }

        /** Represents a MethodOptions. */
        class MethodOptions implements IMethodOptions {

            /**
             * Constructs a new MethodOptions.
             * @param [properties] Properties to set
             */
            constructor(properties?: google.protobuf.IMethodOptions);

            /** MethodOptions deprecated. */
            public deprecated: boolean;

            /** MethodOptions uninterpretedOption. */
            public uninterpretedOption: google.protobuf.IUninterpretedOption[];

            /** MethodOptions .path. */
            public path: string;

            /**
             * Creates a new MethodOptions instance using the specified properties.
             * @param [properties] Properties to set
             * @returns MethodOptions instance
             */
            public static create(properties?: google.protobuf.IMethodOptions): google.protobuf.MethodOptions;

            /**
             * Encodes the specified MethodOptions message. Does not implicitly {@link google.protobuf.MethodOptions.verify|verify} messages.
             * @param message MethodOptions message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: google.protobuf.IMethodOptions, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified MethodOptions message, length delimited. Does not implicitly {@link google.protobuf.MethodOptions.verify|verify} messages.
             * @param message MethodOptions message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: google.protobuf.IMethodOptions, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a MethodOptions message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns MethodOptions
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.protobuf.MethodOptions;

            /**
             * Decodes a MethodOptions message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns MethodOptions
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.protobuf.MethodOptions;

            /**
             * Verifies a MethodOptions message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a MethodOptions message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns MethodOptions
             */
            public static fromObject(object: { [k: string]: any }): google.protobuf.MethodOptions;

            /**
             * Creates a plain object from a MethodOptions message. Also converts values to other types if specified.
             * @param message MethodOptions
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: google.protobuf.MethodOptions, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this MethodOptions to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of an UninterpretedOption. */
        interface IUninterpretedOption {

            /** UninterpretedOption name */
            name?: (google.protobuf.UninterpretedOption.INamePart[]|null);

            /** UninterpretedOption identifierValue */
            identifierValue?: (string|null);

            /** UninterpretedOption positiveIntValue */
            positiveIntValue?: (number|null);

            /** UninterpretedOption negativeIntValue */
            negativeIntValue?: (number|null);

            /** UninterpretedOption doubleValue */
            doubleValue?: (number|null);

            /** UninterpretedOption stringValue */
            stringValue?: (Uint8Array|null);

            /** UninterpretedOption aggregateValue */
            aggregateValue?: (string|null);
        }

        /** Represents an UninterpretedOption. */
        class UninterpretedOption implements IUninterpretedOption {

            /**
             * Constructs a new UninterpretedOption.
             * @param [properties] Properties to set
             */
            constructor(properties?: google.protobuf.IUninterpretedOption);

            /** UninterpretedOption name. */
            public name: google.protobuf.UninterpretedOption.INamePart[];

            /** UninterpretedOption identifierValue. */
            public identifierValue: string;

            /** UninterpretedOption positiveIntValue. */
            public positiveIntValue: number;

            /** UninterpretedOption negativeIntValue. */
            public negativeIntValue: number;

            /** UninterpretedOption doubleValue. */
            public doubleValue: number;

            /** UninterpretedOption stringValue. */
            public stringValue: Uint8Array;

            /** UninterpretedOption aggregateValue. */
            public aggregateValue: string;

            /**
             * Creates a new UninterpretedOption instance using the specified properties.
             * @param [properties] Properties to set
             * @returns UninterpretedOption instance
             */
            public static create(properties?: google.protobuf.IUninterpretedOption): google.protobuf.UninterpretedOption;

            /**
             * Encodes the specified UninterpretedOption message. Does not implicitly {@link google.protobuf.UninterpretedOption.verify|verify} messages.
             * @param message UninterpretedOption message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: google.protobuf.IUninterpretedOption, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified UninterpretedOption message, length delimited. Does not implicitly {@link google.protobuf.UninterpretedOption.verify|verify} messages.
             * @param message UninterpretedOption message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: google.protobuf.IUninterpretedOption, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an UninterpretedOption message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns UninterpretedOption
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.protobuf.UninterpretedOption;

            /**
             * Decodes an UninterpretedOption message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns UninterpretedOption
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.protobuf.UninterpretedOption;

            /**
             * Verifies an UninterpretedOption message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an UninterpretedOption message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns UninterpretedOption
             */
            public static fromObject(object: { [k: string]: any }): google.protobuf.UninterpretedOption;

            /**
             * Creates a plain object from an UninterpretedOption message. Also converts values to other types if specified.
             * @param message UninterpretedOption
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: google.protobuf.UninterpretedOption, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this UninterpretedOption to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace UninterpretedOption {

            /** Properties of a NamePart. */
            interface INamePart {

                /** NamePart namePart */
                namePart: string;

                /** NamePart isExtension */
                isExtension: boolean;
            }

            /** Represents a NamePart. */
            class NamePart implements INamePart {

                /**
                 * Constructs a new NamePart.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: google.protobuf.UninterpretedOption.INamePart);

                /** NamePart namePart. */
                public namePart: string;

                /** NamePart isExtension. */
                public isExtension: boolean;

                /**
                 * Creates a new NamePart instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns NamePart instance
                 */
                public static create(properties?: google.protobuf.UninterpretedOption.INamePart): google.protobuf.UninterpretedOption.NamePart;

                /**
                 * Encodes the specified NamePart message. Does not implicitly {@link google.protobuf.UninterpretedOption.NamePart.verify|verify} messages.
                 * @param message NamePart message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: google.protobuf.UninterpretedOption.INamePart, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified NamePart message, length delimited. Does not implicitly {@link google.protobuf.UninterpretedOption.NamePart.verify|verify} messages.
                 * @param message NamePart message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: google.protobuf.UninterpretedOption.INamePart, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a NamePart message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns NamePart
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.protobuf.UninterpretedOption.NamePart;

                /**
                 * Decodes a NamePart message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns NamePart
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.protobuf.UninterpretedOption.NamePart;

                /**
                 * Verifies a NamePart message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a NamePart message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns NamePart
                 */
                public static fromObject(object: { [k: string]: any }): google.protobuf.UninterpretedOption.NamePart;

                /**
                 * Creates a plain object from a NamePart message. Also converts values to other types if specified.
                 * @param message NamePart
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: google.protobuf.UninterpretedOption.NamePart, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this NamePart to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }
        }

        /** Properties of a SourceCodeInfo. */
        interface ISourceCodeInfo {

            /** SourceCodeInfo location */
            location?: (google.protobuf.SourceCodeInfo.ILocation[]|null);
        }

        /** Represents a SourceCodeInfo. */
        class SourceCodeInfo implements ISourceCodeInfo {

            /**
             * Constructs a new SourceCodeInfo.
             * @param [properties] Properties to set
             */
            constructor(properties?: google.protobuf.ISourceCodeInfo);

            /** SourceCodeInfo location. */
            public location: google.protobuf.SourceCodeInfo.ILocation[];

            /**
             * Creates a new SourceCodeInfo instance using the specified properties.
             * @param [properties] Properties to set
             * @returns SourceCodeInfo instance
             */
            public static create(properties?: google.protobuf.ISourceCodeInfo): google.protobuf.SourceCodeInfo;

            /**
             * Encodes the specified SourceCodeInfo message. Does not implicitly {@link google.protobuf.SourceCodeInfo.verify|verify} messages.
             * @param message SourceCodeInfo message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: google.protobuf.ISourceCodeInfo, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified SourceCodeInfo message, length delimited. Does not implicitly {@link google.protobuf.SourceCodeInfo.verify|verify} messages.
             * @param message SourceCodeInfo message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: google.protobuf.ISourceCodeInfo, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a SourceCodeInfo message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns SourceCodeInfo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.protobuf.SourceCodeInfo;

            /**
             * Decodes a SourceCodeInfo message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns SourceCodeInfo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.protobuf.SourceCodeInfo;

            /**
             * Verifies a SourceCodeInfo message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a SourceCodeInfo message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns SourceCodeInfo
             */
            public static fromObject(object: { [k: string]: any }): google.protobuf.SourceCodeInfo;

            /**
             * Creates a plain object from a SourceCodeInfo message. Also converts values to other types if specified.
             * @param message SourceCodeInfo
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: google.protobuf.SourceCodeInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this SourceCodeInfo to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace SourceCodeInfo {

            /** Properties of a Location. */
            interface ILocation {

                /** Location path */
                path?: (number[]|null);

                /** Location span */
                span?: (number[]|null);

                /** Location leadingComments */
                leadingComments?: (string|null);

                /** Location trailingComments */
                trailingComments?: (string|null);

                /** Location leadingDetachedComments */
                leadingDetachedComments?: (string[]|null);
            }

            /** Represents a Location. */
            class Location implements ILocation {

                /**
                 * Constructs a new Location.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: google.protobuf.SourceCodeInfo.ILocation);

                /** Location path. */
                public path: number[];

                /** Location span. */
                public span: number[];

                /** Location leadingComments. */
                public leadingComments: string;

                /** Location trailingComments. */
                public trailingComments: string;

                /** Location leadingDetachedComments. */
                public leadingDetachedComments: string[];

                /**
                 * Creates a new Location instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns Location instance
                 */
                public static create(properties?: google.protobuf.SourceCodeInfo.ILocation): google.protobuf.SourceCodeInfo.Location;

                /**
                 * Encodes the specified Location message. Does not implicitly {@link google.protobuf.SourceCodeInfo.Location.verify|verify} messages.
                 * @param message Location message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: google.protobuf.SourceCodeInfo.ILocation, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified Location message, length delimited. Does not implicitly {@link google.protobuf.SourceCodeInfo.Location.verify|verify} messages.
                 * @param message Location message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: google.protobuf.SourceCodeInfo.ILocation, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a Location message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns Location
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.protobuf.SourceCodeInfo.Location;

                /**
                 * Decodes a Location message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns Location
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.protobuf.SourceCodeInfo.Location;

                /**
                 * Verifies a Location message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a Location message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns Location
                 */
                public static fromObject(object: { [k: string]: any }): google.protobuf.SourceCodeInfo.Location;

                /**
                 * Creates a plain object from a Location message. Also converts values to other types if specified.
                 * @param message Location
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: google.protobuf.SourceCodeInfo.Location, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this Location to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }
        }

        /** Properties of a GeneratedCodeInfo. */
        interface IGeneratedCodeInfo {

            /** GeneratedCodeInfo annotation */
            annotation?: (google.protobuf.GeneratedCodeInfo.IAnnotation[]|null);
        }

        /** Represents a GeneratedCodeInfo. */
        class GeneratedCodeInfo implements IGeneratedCodeInfo {

            /**
             * Constructs a new GeneratedCodeInfo.
             * @param [properties] Properties to set
             */
            constructor(properties?: google.protobuf.IGeneratedCodeInfo);

            /** GeneratedCodeInfo annotation. */
            public annotation: google.protobuf.GeneratedCodeInfo.IAnnotation[];

            /**
             * Creates a new GeneratedCodeInfo instance using the specified properties.
             * @param [properties] Properties to set
             * @returns GeneratedCodeInfo instance
             */
            public static create(properties?: google.protobuf.IGeneratedCodeInfo): google.protobuf.GeneratedCodeInfo;

            /**
             * Encodes the specified GeneratedCodeInfo message. Does not implicitly {@link google.protobuf.GeneratedCodeInfo.verify|verify} messages.
             * @param message GeneratedCodeInfo message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: google.protobuf.IGeneratedCodeInfo, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified GeneratedCodeInfo message, length delimited. Does not implicitly {@link google.protobuf.GeneratedCodeInfo.verify|verify} messages.
             * @param message GeneratedCodeInfo message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: google.protobuf.IGeneratedCodeInfo, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a GeneratedCodeInfo message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns GeneratedCodeInfo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.protobuf.GeneratedCodeInfo;

            /**
             * Decodes a GeneratedCodeInfo message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns GeneratedCodeInfo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.protobuf.GeneratedCodeInfo;

            /**
             * Verifies a GeneratedCodeInfo message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a GeneratedCodeInfo message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns GeneratedCodeInfo
             */
            public static fromObject(object: { [k: string]: any }): google.protobuf.GeneratedCodeInfo;

            /**
             * Creates a plain object from a GeneratedCodeInfo message. Also converts values to other types if specified.
             * @param message GeneratedCodeInfo
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: google.protobuf.GeneratedCodeInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this GeneratedCodeInfo to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        namespace GeneratedCodeInfo {

            /** Properties of an Annotation. */
            interface IAnnotation {

                /** Annotation path */
                path?: (number[]|null);

                /** Annotation sourceFile */
                sourceFile?: (string|null);

                /** Annotation begin */
                begin?: (number|null);

                /** Annotation end */
                end?: (number|null);
            }

            /** Represents an Annotation. */
            class Annotation implements IAnnotation {

                /**
                 * Constructs a new Annotation.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: google.protobuf.GeneratedCodeInfo.IAnnotation);

                /** Annotation path. */
                public path: number[];

                /** Annotation sourceFile. */
                public sourceFile: string;

                /** Annotation begin. */
                public begin: number;

                /** Annotation end. */
                public end: number;

                /**
                 * Creates a new Annotation instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns Annotation instance
                 */
                public static create(properties?: google.protobuf.GeneratedCodeInfo.IAnnotation): google.protobuf.GeneratedCodeInfo.Annotation;

                /**
                 * Encodes the specified Annotation message. Does not implicitly {@link google.protobuf.GeneratedCodeInfo.Annotation.verify|verify} messages.
                 * @param message Annotation message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: google.protobuf.GeneratedCodeInfo.IAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified Annotation message, length delimited. Does not implicitly {@link google.protobuf.GeneratedCodeInfo.Annotation.verify|verify} messages.
                 * @param message Annotation message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: google.protobuf.GeneratedCodeInfo.IAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes an Annotation message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns Annotation
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.protobuf.GeneratedCodeInfo.Annotation;

                /**
                 * Decodes an Annotation message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns Annotation
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.protobuf.GeneratedCodeInfo.Annotation;

                /**
                 * Verifies an Annotation message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates an Annotation message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns Annotation
                 */
                public static fromObject(object: { [k: string]: any }): google.protobuf.GeneratedCodeInfo.Annotation;

                /**
                 * Creates a plain object from an Annotation message. Also converts values to other types if specified.
                 * @param message Annotation
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: google.protobuf.GeneratedCodeInfo.Annotation, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this Annotation to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };
            }
        }
    }
}

/** Namespace NAppHost. */
export namespace NAppHost {

    /** ESerializationFormat enum. */
    enum ESerializationFormat {
        DEFAULT = 0,
        JSON = 1,
        YSON = 2
    }
}

/** Namespace userselector. */
export namespace userselector {

    /** Properties of a User. */
    interface IUser {

        /** User userId */
        userId?: (number|null);

        /** User authenticationType */
        authenticationType?: (userselector.User.AuthenticationType|null);
    }

    /** Represents a User. */
    class User implements IUser {

        /**
         * Constructs a new User.
         * @param [properties] Properties to set
         */
        constructor(properties?: userselector.IUser);

        /** User userId. */
        public userId: number;

        /** User authenticationType. */
        public authenticationType: userselector.User.AuthenticationType;

        /**
         * Creates a new User instance using the specified properties.
         * @param [properties] Properties to set
         * @returns User instance
         */
        public static create(properties?: userselector.IUser): userselector.User;

        /**
         * Encodes the specified User message. Does not implicitly {@link userselector.User.verify|verify} messages.
         * @param message User message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: userselector.IUser, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified User message, length delimited. Does not implicitly {@link userselector.User.verify|verify} messages.
         * @param message User message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: userselector.IUser, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a User message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns User
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): userselector.User;

        /**
         * Decodes a User message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns User
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): userselector.User;

        /**
         * Verifies a User message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a User message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns User
         */
        public static fromObject(object: { [k: string]: any }): userselector.User;

        /**
         * Creates a plain object from a User message. Also converts values to other types if specified.
         * @param message User
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: userselector.User, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this User to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    namespace User {

        /** AuthenticationType enum. */
        enum AuthenticationType {
            YaStaffUser = 0,
            YaService = 1
        }
    }

    /** Properties of an Organization. */
    interface IOrganization {

        /** Organization OrganizationId */
        OrganizationId?: (number|null);

        /** Organization PoolId */
        PoolId?: (number|null);
    }

    /** Represents an Organization. */
    class Organization implements IOrganization {

        /**
         * Constructs a new Organization.
         * @param [properties] Properties to set
         */
        constructor(properties?: userselector.IOrganization);

        /** Organization OrganizationId. */
        public OrganizationId: number;

        /** Organization PoolId. */
        public PoolId: number;

        /**
         * Creates a new Organization instance using the specified properties.
         * @param [properties] Properties to set
         * @returns Organization instance
         */
        public static create(properties?: userselector.IOrganization): userselector.Organization;

        /**
         * Encodes the specified Organization message. Does not implicitly {@link userselector.Organization.verify|verify} messages.
         * @param message Organization message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: userselector.IOrganization, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified Organization message, length delimited. Does not implicitly {@link userselector.Organization.verify|verify} messages.
         * @param message Organization message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: userselector.IOrganization, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an Organization message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns Organization
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): userselector.Organization;

        /**
         * Decodes an Organization message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns Organization
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): userselector.Organization;

        /**
         * Verifies an Organization message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an Organization message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns Organization
         */
        public static fromObject(object: { [k: string]: any }): userselector.Organization;

        /**
         * Creates a plain object from an Organization message. Also converts values to other types if specified.
         * @param message Organization
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: userselector.Organization, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this Organization to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a Delegation. */
    interface IDelegation {
    }

    /** Represents a Delegation. */
    class Delegation implements IDelegation {

        /**
         * Constructs a new Delegation.
         * @param [properties] Properties to set
         */
        constructor(properties?: userselector.IDelegation);

        /**
         * Creates a new Delegation instance using the specified properties.
         * @param [properties] Properties to set
         * @returns Delegation instance
         */
        public static create(properties?: userselector.IDelegation): userselector.Delegation;

        /**
         * Encodes the specified Delegation message. Does not implicitly {@link userselector.Delegation.verify|verify} messages.
         * @param message Delegation message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: userselector.IDelegation, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified Delegation message, length delimited. Does not implicitly {@link userselector.Delegation.verify|verify} messages.
         * @param message Delegation message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: userselector.IDelegation, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a Delegation message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns Delegation
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): userselector.Delegation;

        /**
         * Decodes a Delegation message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns Delegation
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): userselector.Delegation;

        /**
         * Verifies a Delegation message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a Delegation message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns Delegation
         */
        public static fromObject(object: { [k: string]: any }): userselector.Delegation;

        /**
         * Creates a plain object from a Delegation message. Also converts values to other types if specified.
         * @param message Delegation
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: userselector.Delegation, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this Delegation to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a YandexUser. */
    interface IYandexUser {

        /** YandexUser uId */
        uId?: (number|null);
    }

    /** Represents a YandexUser. */
    class YandexUser implements IYandexUser {

        /**
         * Constructs a new YandexUser.
         * @param [properties] Properties to set
         */
        constructor(properties?: userselector.IYandexUser);

        /** YandexUser uId. */
        public uId: number;

        /**
         * Creates a new YandexUser instance using the specified properties.
         * @param [properties] Properties to set
         * @returns YandexUser instance
         */
        public static create(properties?: userselector.IYandexUser): userselector.YandexUser;

        /**
         * Encodes the specified YandexUser message. Does not implicitly {@link userselector.YandexUser.verify|verify} messages.
         * @param message YandexUser message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: userselector.IYandexUser, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified YandexUser message, length delimited. Does not implicitly {@link userselector.YandexUser.verify|verify} messages.
         * @param message YandexUser message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: userselector.IYandexUser, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a YandexUser message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns YandexUser
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): userselector.YandexUser;

        /**
         * Decodes a YandexUser message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns YandexUser
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): userselector.YandexUser;

        /**
         * Verifies a YandexUser message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a YandexUser message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns YandexUser
         */
        public static fromObject(object: { [k: string]: any }): userselector.YandexUser;

        /**
         * Creates a plain object from a YandexUser message. Also converts values to other types if specified.
         * @param message YandexUser
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: userselector.YandexUser, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this YandexUser to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a YandexService. */
    interface IYandexService {

        /** YandexService tvmId */
        tvmId?: (number|null);
    }

    /** Represents a YandexService. */
    class YandexService implements IYandexService {

        /**
         * Constructs a new YandexService.
         * @param [properties] Properties to set
         */
        constructor(properties?: userselector.IYandexService);

        /** YandexService tvmId. */
        public tvmId: number;

        /**
         * Creates a new YandexService instance using the specified properties.
         * @param [properties] Properties to set
         * @returns YandexService instance
         */
        public static create(properties?: userselector.IYandexService): userselector.YandexService;

        /**
         * Encodes the specified YandexService message. Does not implicitly {@link userselector.YandexService.verify|verify} messages.
         * @param message YandexService message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: userselector.IYandexService, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified YandexService message, length delimited. Does not implicitly {@link userselector.YandexService.verify|verify} messages.
         * @param message YandexService message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: userselector.IYandexService, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a YandexService message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns YandexService
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): userselector.YandexService;

        /**
         * Decodes a YandexService message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns YandexService
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): userselector.YandexService;

        /**
         * Verifies a YandexService message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a YandexService message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns YandexService
         */
        public static fromObject(object: { [k: string]: any }): userselector.YandexService;

        /**
         * Creates a plain object from a YandexService message. Also converts values to other types if specified.
         * @param message YandexService
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: userselector.YandexService, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this YandexService to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }
}

/** Namespace NBlackbox. */
export namespace NBlackbox {

    /** Properties of a TUser. */
    interface ITUser {

        /** TUser Login */
        Login?: (string|null);

        /** TUser Uid */
        Uid?: (string|null);
    }

    /** Represents a TUser. */
    class TUser implements ITUser {

        /**
         * Constructs a new TUser.
         * @param [properties] Properties to set
         */
        constructor(properties?: NBlackbox.ITUser);

        /** TUser Login. */
        public Login: string;

        /** TUser Uid. */
        public Uid: string;

        /**
         * Creates a new TUser instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TUser instance
         */
        public static create(properties?: NBlackbox.ITUser): NBlackbox.TUser;

        /**
         * Encodes the specified TUser message. Does not implicitly {@link NBlackbox.TUser.verify|verify} messages.
         * @param message TUser message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NBlackbox.ITUser, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TUser message, length delimited. Does not implicitly {@link NBlackbox.TUser.verify|verify} messages.
         * @param message TUser message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NBlackbox.ITUser, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TUser message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TUser
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NBlackbox.TUser;

        /**
         * Decodes a TUser message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TUser
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NBlackbox.TUser;

        /**
         * Verifies a TUser message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TUser message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TUser
         */
        public static fromObject(object: { [k: string]: any }): NBlackbox.TUser;

        /**
         * Creates a plain object from a TUser message. Also converts values to other types if specified.
         * @param message TUser
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NBlackbox.TUser, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TUser to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }
}

/** Namespace usermanager. */
export namespace usermanager {

    /** Properties of a User. */
    interface IUser {

        /** User userId */
        userId?: (number|null);

        /** User data */
        data?: (usermanager.IUserData|null);
    }

    /** Represents a User. */
    class User implements IUser {

        /**
         * Constructs a new User.
         * @param [properties] Properties to set
         */
        constructor(properties?: usermanager.IUser);

        /** User userId. */
        public userId: number;

        /** User data. */
        public data?: (usermanager.IUserData|null);

        /**
         * Creates a new User instance using the specified properties.
         * @param [properties] Properties to set
         * @returns User instance
         */
        public static create(properties?: usermanager.IUser): usermanager.User;

        /**
         * Encodes the specified User message. Does not implicitly {@link usermanager.User.verify|verify} messages.
         * @param message User message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: usermanager.IUser, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified User message, length delimited. Does not implicitly {@link usermanager.User.verify|verify} messages.
         * @param message User message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: usermanager.IUser, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a User message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns User
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): usermanager.User;

        /**
         * Decodes a User message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns User
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): usermanager.User;

        /**
         * Verifies a User message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a User message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns User
         */
        public static fromObject(object: { [k: string]: any }): usermanager.User;

        /**
         * Creates a plain object from a User message. Also converts values to other types if specified.
         * @param message User
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: usermanager.User, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this User to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a UserData. */
    interface IUserData {

        /** UserData firstName */
        firstName?: (string|null);

        /** UserData secondName */
        secondName?: (string|null);
    }

    /** Represents a UserData. */
    class UserData implements IUserData {

        /**
         * Constructs a new UserData.
         * @param [properties] Properties to set
         */
        constructor(properties?: usermanager.IUserData);

        /** UserData firstName. */
        public firstName: string;

        /** UserData secondName. */
        public secondName: string;

        /**
         * Creates a new UserData instance using the specified properties.
         * @param [properties] Properties to set
         * @returns UserData instance
         */
        public static create(properties?: usermanager.IUserData): usermanager.UserData;

        /**
         * Encodes the specified UserData message. Does not implicitly {@link usermanager.UserData.verify|verify} messages.
         * @param message UserData message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: usermanager.IUserData, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified UserData message, length delimited. Does not implicitly {@link usermanager.UserData.verify|verify} messages.
         * @param message UserData message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: usermanager.IUserData, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a UserData message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns UserData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): usermanager.UserData;

        /**
         * Decodes a UserData message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns UserData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): usermanager.UserData;

        /**
         * Verifies a UserData message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a UserData message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns UserData
         */
        public static fromObject(object: { [k: string]: any }): usermanager.UserData;

        /**
         * Creates a plain object from a UserData message. Also converts values to other types if specified.
         * @param message UserData
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: usermanager.UserData, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this UserData to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of an UpdateUserData. */
    interface IUpdateUserData {

        /** UpdateUserData newFirstName */
        newFirstName?: (string|null);

        /** UpdateUserData newSecondName */
        newSecondName?: (string|null);
    }

    /** Represents an UpdateUserData. */
    class UpdateUserData implements IUpdateUserData {

        /**
         * Constructs a new UpdateUserData.
         * @param [properties] Properties to set
         */
        constructor(properties?: usermanager.IUpdateUserData);

        /** UpdateUserData newFirstName. */
        public newFirstName?: (string|null);

        /** UpdateUserData newSecondName. */
        public newSecondName?: (string|null);

        /** UpdateUserData _newFirstName. */
        public _newFirstName?: "newFirstName";

        /** UpdateUserData _newSecondName. */
        public _newSecondName?: "newSecondName";

        /**
         * Creates a new UpdateUserData instance using the specified properties.
         * @param [properties] Properties to set
         * @returns UpdateUserData instance
         */
        public static create(properties?: usermanager.IUpdateUserData): usermanager.UpdateUserData;

        /**
         * Encodes the specified UpdateUserData message. Does not implicitly {@link usermanager.UpdateUserData.verify|verify} messages.
         * @param message UpdateUserData message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: usermanager.IUpdateUserData, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified UpdateUserData message, length delimited. Does not implicitly {@link usermanager.UpdateUserData.verify|verify} messages.
         * @param message UpdateUserData message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: usermanager.IUpdateUserData, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an UpdateUserData message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns UpdateUserData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): usermanager.UpdateUserData;

        /**
         * Decodes an UpdateUserData message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns UpdateUserData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): usermanager.UpdateUserData;

        /**
         * Verifies an UpdateUserData message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an UpdateUserData message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns UpdateUserData
         */
        public static fromObject(object: { [k: string]: any }): usermanager.UpdateUserData;

        /**
         * Creates a plain object from an UpdateUserData message. Also converts values to other types if specified.
         * @param message UpdateUserData
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: usermanager.UpdateUserData, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this UpdateUserData to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a YandexUser. */
    interface IYandexUser {

        /** YandexUser yandexUserId */
        yandexUserId?: (number|null);

        /** YandexUser userId */
        userId?: (number|null);

        /** YandexUser uid */
        uid?: (number|null);

        /** YandexUser login */
        login?: (string|null);
    }

    /** Represents a YandexUser. */
    class YandexUser implements IYandexUser {

        /**
         * Constructs a new YandexUser.
         * @param [properties] Properties to set
         */
        constructor(properties?: usermanager.IYandexUser);

        /** YandexUser yandexUserId. */
        public yandexUserId: number;

        /** YandexUser userId. */
        public userId: number;

        /** YandexUser uid. */
        public uid: number;

        /** YandexUser login. */
        public login: string;

        /**
         * Creates a new YandexUser instance using the specified properties.
         * @param [properties] Properties to set
         * @returns YandexUser instance
         */
        public static create(properties?: usermanager.IYandexUser): usermanager.YandexUser;

        /**
         * Encodes the specified YandexUser message. Does not implicitly {@link usermanager.YandexUser.verify|verify} messages.
         * @param message YandexUser message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: usermanager.IYandexUser, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified YandexUser message, length delimited. Does not implicitly {@link usermanager.YandexUser.verify|verify} messages.
         * @param message YandexUser message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: usermanager.IYandexUser, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a YandexUser message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns YandexUser
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): usermanager.YandexUser;

        /**
         * Decodes a YandexUser message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns YandexUser
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): usermanager.YandexUser;

        /**
         * Verifies a YandexUser message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a YandexUser message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns YandexUser
         */
        public static fromObject(object: { [k: string]: any }): usermanager.YandexUser;

        /**
         * Creates a plain object from a YandexUser message. Also converts values to other types if specified.
         * @param message YandexUser
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: usermanager.YandexUser, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this YandexUser to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a YandexUserData. */
    interface IYandexUserData {

        /** YandexUserData userId */
        userId?: (number|null);

        /** YandexUserData uid */
        uid?: (number|null);

        /** YandexUserData login */
        login?: (string|null);
    }

    /** Represents a YandexUserData. */
    class YandexUserData implements IYandexUserData {

        /**
         * Constructs a new YandexUserData.
         * @param [properties] Properties to set
         */
        constructor(properties?: usermanager.IYandexUserData);

        /** YandexUserData userId. */
        public userId: number;

        /** YandexUserData uid. */
        public uid: number;

        /** YandexUserData login. */
        public login: string;

        /**
         * Creates a new YandexUserData instance using the specified properties.
         * @param [properties] Properties to set
         * @returns YandexUserData instance
         */
        public static create(properties?: usermanager.IYandexUserData): usermanager.YandexUserData;

        /**
         * Encodes the specified YandexUserData message. Does not implicitly {@link usermanager.YandexUserData.verify|verify} messages.
         * @param message YandexUserData message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: usermanager.IYandexUserData, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified YandexUserData message, length delimited. Does not implicitly {@link usermanager.YandexUserData.verify|verify} messages.
         * @param message YandexUserData message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: usermanager.IYandexUserData, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a YandexUserData message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns YandexUserData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): usermanager.YandexUserData;

        /**
         * Decodes a YandexUserData message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns YandexUserData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): usermanager.YandexUserData;

        /**
         * Verifies a YandexUserData message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a YandexUserData message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns YandexUserData
         */
        public static fromObject(object: { [k: string]: any }): usermanager.YandexUserData;

        /**
         * Creates a plain object from a YandexUserData message. Also converts values to other types if specified.
         * @param message YandexUserData
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: usermanager.YandexUserData, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this YandexUserData to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of an UpdateYandexUserData. */
    interface IUpdateYandexUserData {

        /** UpdateYandexUserData newUserId */
        newUserId?: (number|null);

        /** UpdateYandexUserData newUid */
        newUid?: (number|null);

        /** UpdateYandexUserData newLogin */
        newLogin?: (string|null);
    }

    /** Represents an UpdateYandexUserData. */
    class UpdateYandexUserData implements IUpdateYandexUserData {

        /**
         * Constructs a new UpdateYandexUserData.
         * @param [properties] Properties to set
         */
        constructor(properties?: usermanager.IUpdateYandexUserData);

        /** UpdateYandexUserData newUserId. */
        public newUserId?: (number|null);

        /** UpdateYandexUserData newUid. */
        public newUid?: (number|null);

        /** UpdateYandexUserData newLogin. */
        public newLogin?: (string|null);

        /** UpdateYandexUserData updateUserId. */
        public updateUserId?: "newUserId";

        /** UpdateYandexUserData updateUid. */
        public updateUid?: "newUid";

        /** UpdateYandexUserData _newLogin. */
        public _newLogin?: "newLogin";

        /**
         * Creates a new UpdateYandexUserData instance using the specified properties.
         * @param [properties] Properties to set
         * @returns UpdateYandexUserData instance
         */
        public static create(properties?: usermanager.IUpdateYandexUserData): usermanager.UpdateYandexUserData;

        /**
         * Encodes the specified UpdateYandexUserData message. Does not implicitly {@link usermanager.UpdateYandexUserData.verify|verify} messages.
         * @param message UpdateYandexUserData message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: usermanager.IUpdateYandexUserData, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified UpdateYandexUserData message, length delimited. Does not implicitly {@link usermanager.UpdateYandexUserData.verify|verify} messages.
         * @param message UpdateYandexUserData message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: usermanager.IUpdateYandexUserData, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an UpdateYandexUserData message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns UpdateYandexUserData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): usermanager.UpdateYandexUserData;

        /**
         * Decodes an UpdateYandexUserData message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns UpdateYandexUserData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): usermanager.UpdateYandexUserData;

        /**
         * Verifies an UpdateYandexUserData message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an UpdateYandexUserData message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns UpdateYandexUserData
         */
        public static fromObject(object: { [k: string]: any }): usermanager.UpdateYandexUserData;

        /**
         * Creates a plain object from an UpdateYandexUserData message. Also converts values to other types if specified.
         * @param message UpdateYandexUserData
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: usermanager.UpdateYandexUserData, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this UpdateYandexUserData to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a UserResponse. */
    interface IUserResponse {

        /** UserResponse user */
        user?: (usermanager.IUser|null);
    }

    /** Represents a UserResponse. */
    class UserResponse implements IUserResponse {

        /**
         * Constructs a new UserResponse.
         * @param [properties] Properties to set
         */
        constructor(properties?: usermanager.IUserResponse);

        /** UserResponse user. */
        public user?: (usermanager.IUser|null);

        /**
         * Creates a new UserResponse instance using the specified properties.
         * @param [properties] Properties to set
         * @returns UserResponse instance
         */
        public static create(properties?: usermanager.IUserResponse): usermanager.UserResponse;

        /**
         * Encodes the specified UserResponse message. Does not implicitly {@link usermanager.UserResponse.verify|verify} messages.
         * @param message UserResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: usermanager.IUserResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified UserResponse message, length delimited. Does not implicitly {@link usermanager.UserResponse.verify|verify} messages.
         * @param message UserResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: usermanager.IUserResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a UserResponse message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns UserResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): usermanager.UserResponse;

        /**
         * Decodes a UserResponse message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns UserResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): usermanager.UserResponse;

        /**
         * Verifies a UserResponse message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a UserResponse message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns UserResponse
         */
        public static fromObject(object: { [k: string]: any }): usermanager.UserResponse;

        /**
         * Creates a plain object from a UserResponse message. Also converts values to other types if specified.
         * @param message UserResponse
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: usermanager.UserResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this UserResponse to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a UsersResponse. */
    interface IUsersResponse {

        /** UsersResponse users */
        users?: (usermanager.IUser[]|null);
    }

    /** Represents a UsersResponse. */
    class UsersResponse implements IUsersResponse {

        /**
         * Constructs a new UsersResponse.
         * @param [properties] Properties to set
         */
        constructor(properties?: usermanager.IUsersResponse);

        /** UsersResponse users. */
        public users: usermanager.IUser[];

        /**
         * Creates a new UsersResponse instance using the specified properties.
         * @param [properties] Properties to set
         * @returns UsersResponse instance
         */
        public static create(properties?: usermanager.IUsersResponse): usermanager.UsersResponse;

        /**
         * Encodes the specified UsersResponse message. Does not implicitly {@link usermanager.UsersResponse.verify|verify} messages.
         * @param message UsersResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: usermanager.IUsersResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified UsersResponse message, length delimited. Does not implicitly {@link usermanager.UsersResponse.verify|verify} messages.
         * @param message UsersResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: usermanager.IUsersResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a UsersResponse message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns UsersResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): usermanager.UsersResponse;

        /**
         * Decodes a UsersResponse message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns UsersResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): usermanager.UsersResponse;

        /**
         * Verifies a UsersResponse message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a UsersResponse message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns UsersResponse
         */
        public static fromObject(object: { [k: string]: any }): usermanager.UsersResponse;

        /**
         * Creates a plain object from a UsersResponse message. Also converts values to other types if specified.
         * @param message UsersResponse
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: usermanager.UsersResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this UsersResponse to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of an OrganizationUsersResponse. */
    interface IOrganizationUsersResponse {

        /** OrganizationUsersResponse usersId */
        usersId?: (number[]|null);
    }

    /** Represents an OrganizationUsersResponse. */
    class OrganizationUsersResponse implements IOrganizationUsersResponse {

        /**
         * Constructs a new OrganizationUsersResponse.
         * @param [properties] Properties to set
         */
        constructor(properties?: usermanager.IOrganizationUsersResponse);

        /** OrganizationUsersResponse usersId. */
        public usersId: number[];

        /**
         * Creates a new OrganizationUsersResponse instance using the specified properties.
         * @param [properties] Properties to set
         * @returns OrganizationUsersResponse instance
         */
        public static create(properties?: usermanager.IOrganizationUsersResponse): usermanager.OrganizationUsersResponse;

        /**
         * Encodes the specified OrganizationUsersResponse message. Does not implicitly {@link usermanager.OrganizationUsersResponse.verify|verify} messages.
         * @param message OrganizationUsersResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: usermanager.IOrganizationUsersResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified OrganizationUsersResponse message, length delimited. Does not implicitly {@link usermanager.OrganizationUsersResponse.verify|verify} messages.
         * @param message OrganizationUsersResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: usermanager.IOrganizationUsersResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an OrganizationUsersResponse message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns OrganizationUsersResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): usermanager.OrganizationUsersResponse;

        /**
         * Decodes an OrganizationUsersResponse message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns OrganizationUsersResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): usermanager.OrganizationUsersResponse;

        /**
         * Verifies an OrganizationUsersResponse message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an OrganizationUsersResponse message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns OrganizationUsersResponse
         */
        public static fromObject(object: { [k: string]: any }): usermanager.OrganizationUsersResponse;

        /**
         * Creates a plain object from an OrganizationUsersResponse message. Also converts values to other types if specified.
         * @param message OrganizationUsersResponse
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: usermanager.OrganizationUsersResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this OrganizationUsersResponse to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }
}

/** Namespace organizationmanager. */
export namespace organizationmanager {

    /** Properties of an Organization. */
    interface IOrganization {

        /** Organization id */
        id?: (organizationmanager.IOrganizationId|null);

        /** Organization data */
        data?: (organizationmanager.IOrganizationData|null);
    }

    /** Represents an Organization. */
    class Organization implements IOrganization {

        /**
         * Constructs a new Organization.
         * @param [properties] Properties to set
         */
        constructor(properties?: organizationmanager.IOrganization);

        /** Organization id. */
        public id?: (organizationmanager.IOrganizationId|null);

        /** Organization data. */
        public data?: (organizationmanager.IOrganizationData|null);

        /**
         * Creates a new Organization instance using the specified properties.
         * @param [properties] Properties to set
         * @returns Organization instance
         */
        public static create(properties?: organizationmanager.IOrganization): organizationmanager.Organization;

        /**
         * Encodes the specified Organization message. Does not implicitly {@link organizationmanager.Organization.verify|verify} messages.
         * @param message Organization message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: organizationmanager.IOrganization, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified Organization message, length delimited. Does not implicitly {@link organizationmanager.Organization.verify|verify} messages.
         * @param message Organization message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: organizationmanager.IOrganization, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an Organization message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns Organization
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): organizationmanager.Organization;

        /**
         * Decodes an Organization message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns Organization
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): organizationmanager.Organization;

        /**
         * Verifies an Organization message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an Organization message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns Organization
         */
        public static fromObject(object: { [k: string]: any }): organizationmanager.Organization;

        /**
         * Creates a plain object from an Organization message. Also converts values to other types if specified.
         * @param message Organization
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: organizationmanager.Organization, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this Organization to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of an OrganizationId. */
    interface IOrganizationId {

        /** OrganizationId value */
        value?: (number|null);
    }

    /** Represents an OrganizationId. */
    class OrganizationId implements IOrganizationId {

        /**
         * Constructs a new OrganizationId.
         * @param [properties] Properties to set
         */
        constructor(properties?: organizationmanager.IOrganizationId);

        /** OrganizationId value. */
        public value: number;

        /**
         * Creates a new OrganizationId instance using the specified properties.
         * @param [properties] Properties to set
         * @returns OrganizationId instance
         */
        public static create(properties?: organizationmanager.IOrganizationId): organizationmanager.OrganizationId;

        /**
         * Encodes the specified OrganizationId message. Does not implicitly {@link organizationmanager.OrganizationId.verify|verify} messages.
         * @param message OrganizationId message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: organizationmanager.IOrganizationId, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified OrganizationId message, length delimited. Does not implicitly {@link organizationmanager.OrganizationId.verify|verify} messages.
         * @param message OrganizationId message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: organizationmanager.IOrganizationId, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an OrganizationId message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns OrganizationId
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): organizationmanager.OrganizationId;

        /**
         * Decodes an OrganizationId message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns OrganizationId
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): organizationmanager.OrganizationId;

        /**
         * Verifies an OrganizationId message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an OrganizationId message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns OrganizationId
         */
        public static fromObject(object: { [k: string]: any }): organizationmanager.OrganizationId;

        /**
         * Creates a plain object from an OrganizationId message. Also converts values to other types if specified.
         * @param message OrganizationId
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: organizationmanager.OrganizationId, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this OrganizationId to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of an OrganizationData. */
    interface IOrganizationData {

        /** OrganizationData pool */
        pool?: (number|null);

        /** OrganizationData slug */
        slug?: (string|null);

        /** OrganizationData name */
        name?: (string|null);
    }

    /** Represents an OrganizationData. */
    class OrganizationData implements IOrganizationData {

        /**
         * Constructs a new OrganizationData.
         * @param [properties] Properties to set
         */
        constructor(properties?: organizationmanager.IOrganizationData);

        /** OrganizationData pool. */
        public pool: number;

        /** OrganizationData slug. */
        public slug: string;

        /** OrganizationData name. */
        public name: string;

        /**
         * Creates a new OrganizationData instance using the specified properties.
         * @param [properties] Properties to set
         * @returns OrganizationData instance
         */
        public static create(properties?: organizationmanager.IOrganizationData): organizationmanager.OrganizationData;

        /**
         * Encodes the specified OrganizationData message. Does not implicitly {@link organizationmanager.OrganizationData.verify|verify} messages.
         * @param message OrganizationData message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: organizationmanager.IOrganizationData, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified OrganizationData message, length delimited. Does not implicitly {@link organizationmanager.OrganizationData.verify|verify} messages.
         * @param message OrganizationData message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: organizationmanager.IOrganizationData, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an OrganizationData message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns OrganizationData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): organizationmanager.OrganizationData;

        /**
         * Decodes an OrganizationData message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns OrganizationData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): organizationmanager.OrganizationData;

        /**
         * Verifies an OrganizationData message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an OrganizationData message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns OrganizationData
         */
        public static fromObject(object: { [k: string]: any }): organizationmanager.OrganizationData;

        /**
         * Creates a plain object from an OrganizationData message. Also converts values to other types if specified.
         * @param message OrganizationData
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: organizationmanager.OrganizationData, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this OrganizationData to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of an UpdateOrganizationData. */
    interface IUpdateOrganizationData {

        /** UpdateOrganizationData newPool */
        newPool?: (number|null);

        /** UpdateOrganizationData newSlug */
        newSlug?: (string|null);

        /** UpdateOrganizationData newName */
        newName?: (string|null);
    }

    /** Represents an UpdateOrganizationData. */
    class UpdateOrganizationData implements IUpdateOrganizationData {

        /**
         * Constructs a new UpdateOrganizationData.
         * @param [properties] Properties to set
         */
        constructor(properties?: organizationmanager.IUpdateOrganizationData);

        /** UpdateOrganizationData newPool. */
        public newPool?: (number|null);

        /** UpdateOrganizationData newSlug. */
        public newSlug?: (string|null);

        /** UpdateOrganizationData newName. */
        public newName?: (string|null);

        /** UpdateOrganizationData updatePool. */
        public updatePool?: "newPool";

        /** UpdateOrganizationData _newSlug. */
        public _newSlug?: "newSlug";

        /** UpdateOrganizationData _newName. */
        public _newName?: "newName";

        /**
         * Creates a new UpdateOrganizationData instance using the specified properties.
         * @param [properties] Properties to set
         * @returns UpdateOrganizationData instance
         */
        public static create(properties?: organizationmanager.IUpdateOrganizationData): organizationmanager.UpdateOrganizationData;

        /**
         * Encodes the specified UpdateOrganizationData message. Does not implicitly {@link organizationmanager.UpdateOrganizationData.verify|verify} messages.
         * @param message UpdateOrganizationData message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: organizationmanager.IUpdateOrganizationData, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified UpdateOrganizationData message, length delimited. Does not implicitly {@link organizationmanager.UpdateOrganizationData.verify|verify} messages.
         * @param message UpdateOrganizationData message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: organizationmanager.IUpdateOrganizationData, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an UpdateOrganizationData message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns UpdateOrganizationData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): organizationmanager.UpdateOrganizationData;

        /**
         * Decodes an UpdateOrganizationData message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns UpdateOrganizationData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): organizationmanager.UpdateOrganizationData;

        /**
         * Verifies an UpdateOrganizationData message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an UpdateOrganizationData message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns UpdateOrganizationData
         */
        public static fromObject(object: { [k: string]: any }): organizationmanager.UpdateOrganizationData;

        /**
         * Creates a plain object from an UpdateOrganizationData message. Also converts values to other types if specified.
         * @param message UpdateOrganizationData
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: organizationmanager.UpdateOrganizationData, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this UpdateOrganizationData to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of an OrganizationResponse. */
    interface IOrganizationResponse {

        /** OrganizationResponse organization */
        organization?: (organizationmanager.IOrganization|null);
    }

    /** Represents an OrganizationResponse. */
    class OrganizationResponse implements IOrganizationResponse {

        /**
         * Constructs a new OrganizationResponse.
         * @param [properties] Properties to set
         */
        constructor(properties?: organizationmanager.IOrganizationResponse);

        /** OrganizationResponse organization. */
        public organization?: (organizationmanager.IOrganization|null);

        /**
         * Creates a new OrganizationResponse instance using the specified properties.
         * @param [properties] Properties to set
         * @returns OrganizationResponse instance
         */
        public static create(properties?: organizationmanager.IOrganizationResponse): organizationmanager.OrganizationResponse;

        /**
         * Encodes the specified OrganizationResponse message. Does not implicitly {@link organizationmanager.OrganizationResponse.verify|verify} messages.
         * @param message OrganizationResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: organizationmanager.IOrganizationResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified OrganizationResponse message, length delimited. Does not implicitly {@link organizationmanager.OrganizationResponse.verify|verify} messages.
         * @param message OrganizationResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: organizationmanager.IOrganizationResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an OrganizationResponse message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns OrganizationResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): organizationmanager.OrganizationResponse;

        /**
         * Decodes an OrganizationResponse message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns OrganizationResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): organizationmanager.OrganizationResponse;

        /**
         * Verifies an OrganizationResponse message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an OrganizationResponse message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns OrganizationResponse
         */
        public static fromObject(object: { [k: string]: any }): organizationmanager.OrganizationResponse;

        /**
         * Creates a plain object from an OrganizationResponse message. Also converts values to other types if specified.
         * @param message OrganizationResponse
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: organizationmanager.OrganizationResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this OrganizationResponse to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of an OrganizationsResponse. */
    interface IOrganizationsResponse {

        /** OrganizationsResponse organizations */
        organizations?: (organizationmanager.IOrganization[]|null);
    }

    /** Represents an OrganizationsResponse. */
    class OrganizationsResponse implements IOrganizationsResponse {

        /**
         * Constructs a new OrganizationsResponse.
         * @param [properties] Properties to set
         */
        constructor(properties?: organizationmanager.IOrganizationsResponse);

        /** OrganizationsResponse organizations. */
        public organizations: organizationmanager.IOrganization[];

        /**
         * Creates a new OrganizationsResponse instance using the specified properties.
         * @param [properties] Properties to set
         * @returns OrganizationsResponse instance
         */
        public static create(properties?: organizationmanager.IOrganizationsResponse): organizationmanager.OrganizationsResponse;

        /**
         * Encodes the specified OrganizationsResponse message. Does not implicitly {@link organizationmanager.OrganizationsResponse.verify|verify} messages.
         * @param message OrganizationsResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: organizationmanager.IOrganizationsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified OrganizationsResponse message, length delimited. Does not implicitly {@link organizationmanager.OrganizationsResponse.verify|verify} messages.
         * @param message OrganizationsResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: organizationmanager.IOrganizationsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an OrganizationsResponse message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns OrganizationsResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): organizationmanager.OrganizationsResponse;

        /**
         * Decodes an OrganizationsResponse message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns OrganizationsResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): organizationmanager.OrganizationsResponse;

        /**
         * Verifies an OrganizationsResponse message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an OrganizationsResponse message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns OrganizationsResponse
         */
        public static fromObject(object: { [k: string]: any }): organizationmanager.OrganizationsResponse;

        /**
         * Creates a plain object from an OrganizationsResponse message. Also converts values to other types if specified.
         * @param message OrganizationsResponse
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: organizationmanager.OrganizationsResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this OrganizationsResponse to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }
}

/** Namespace departmentmanager. */
export namespace departmentmanager {

    /** Properties of a Department. */
    interface IDepartment {

        /** Department id */
        id?: (string|null);

        /** Department data */
        data?: (departmentmanager.IDepartmentData|null);
    }

    /** Represents a Department. */
    class Department implements IDepartment {

        /**
         * Constructs a new Department.
         * @param [properties] Properties to set
         */
        constructor(properties?: departmentmanager.IDepartment);

        /** Department id. */
        public id: string;

        /** Department data. */
        public data?: (departmentmanager.IDepartmentData|null);

        /**
         * Creates a new Department instance using the specified properties.
         * @param [properties] Properties to set
         * @returns Department instance
         */
        public static create(properties?: departmentmanager.IDepartment): departmentmanager.Department;

        /**
         * Encodes the specified Department message. Does not implicitly {@link departmentmanager.Department.verify|verify} messages.
         * @param message Department message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: departmentmanager.IDepartment, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified Department message, length delimited. Does not implicitly {@link departmentmanager.Department.verify|verify} messages.
         * @param message Department message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: departmentmanager.IDepartment, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a Department message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns Department
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): departmentmanager.Department;

        /**
         * Decodes a Department message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns Department
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): departmentmanager.Department;

        /**
         * Verifies a Department message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a Department message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns Department
         */
        public static fromObject(object: { [k: string]: any }): departmentmanager.Department;

        /**
         * Creates a plain object from a Department message. Also converts values to other types if specified.
         * @param message Department
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: departmentmanager.Department, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this Department to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a DepartmentData. */
    interface IDepartmentData {

        /** DepartmentData organizationId */
        organizationId?: (number|null);

        /** DepartmentData parentDepartmentId */
        parentDepartmentId?: (string|null);

        /** DepartmentData names */
        names?: (departmentmanager.IDepartmentName[]|null);
    }

    /** Represents a DepartmentData. */
    class DepartmentData implements IDepartmentData {

        /**
         * Constructs a new DepartmentData.
         * @param [properties] Properties to set
         */
        constructor(properties?: departmentmanager.IDepartmentData);

        /** DepartmentData organizationId. */
        public organizationId: number;

        /** DepartmentData parentDepartmentId. */
        public parentDepartmentId: string;

        /** DepartmentData names. */
        public names: departmentmanager.IDepartmentName[];

        /**
         * Creates a new DepartmentData instance using the specified properties.
         * @param [properties] Properties to set
         * @returns DepartmentData instance
         */
        public static create(properties?: departmentmanager.IDepartmentData): departmentmanager.DepartmentData;

        /**
         * Encodes the specified DepartmentData message. Does not implicitly {@link departmentmanager.DepartmentData.verify|verify} messages.
         * @param message DepartmentData message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: departmentmanager.IDepartmentData, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified DepartmentData message, length delimited. Does not implicitly {@link departmentmanager.DepartmentData.verify|verify} messages.
         * @param message DepartmentData message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: departmentmanager.IDepartmentData, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a DepartmentData message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns DepartmentData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): departmentmanager.DepartmentData;

        /**
         * Decodes a DepartmentData message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns DepartmentData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): departmentmanager.DepartmentData;

        /**
         * Verifies a DepartmentData message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a DepartmentData message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns DepartmentData
         */
        public static fromObject(object: { [k: string]: any }): departmentmanager.DepartmentData;

        /**
         * Creates a plain object from a DepartmentData message. Also converts values to other types if specified.
         * @param message DepartmentData
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: departmentmanager.DepartmentData, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this DepartmentData to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of an UpdateDepartmentData. */
    interface IUpdateDepartmentData {

        /** UpdateDepartmentData newOrganizationId */
        newOrganizationId?: (number|null);

        /** UpdateDepartmentData newParentDepartmentId */
        newParentDepartmentId?: (string|null);

        /** UpdateDepartmentData newNames */
        newNames?: (departmentmanager.IDepartmentName[]|null);
    }

    /** Represents an UpdateDepartmentData. */
    class UpdateDepartmentData implements IUpdateDepartmentData {

        /**
         * Constructs a new UpdateDepartmentData.
         * @param [properties] Properties to set
         */
        constructor(properties?: departmentmanager.IUpdateDepartmentData);

        /** UpdateDepartmentData newOrganizationId. */
        public newOrganizationId?: (number|null);

        /** UpdateDepartmentData newParentDepartmentId. */
        public newParentDepartmentId?: (string|null);

        /** UpdateDepartmentData newNames. */
        public newNames: departmentmanager.IDepartmentName[];

        /** UpdateDepartmentData updateOrganizationId. */
        public updateOrganizationId?: "newOrganizationId";

        /** UpdateDepartmentData _newParentDepartmentId. */
        public _newParentDepartmentId?: "newParentDepartmentId";

        /**
         * Creates a new UpdateDepartmentData instance using the specified properties.
         * @param [properties] Properties to set
         * @returns UpdateDepartmentData instance
         */
        public static create(properties?: departmentmanager.IUpdateDepartmentData): departmentmanager.UpdateDepartmentData;

        /**
         * Encodes the specified UpdateDepartmentData message. Does not implicitly {@link departmentmanager.UpdateDepartmentData.verify|verify} messages.
         * @param message UpdateDepartmentData message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: departmentmanager.IUpdateDepartmentData, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified UpdateDepartmentData message, length delimited. Does not implicitly {@link departmentmanager.UpdateDepartmentData.verify|verify} messages.
         * @param message UpdateDepartmentData message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: departmentmanager.IUpdateDepartmentData, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an UpdateDepartmentData message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns UpdateDepartmentData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): departmentmanager.UpdateDepartmentData;

        /**
         * Decodes an UpdateDepartmentData message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns UpdateDepartmentData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): departmentmanager.UpdateDepartmentData;

        /**
         * Verifies an UpdateDepartmentData message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an UpdateDepartmentData message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns UpdateDepartmentData
         */
        public static fromObject(object: { [k: string]: any }): departmentmanager.UpdateDepartmentData;

        /**
         * Creates a plain object from an UpdateDepartmentData message. Also converts values to other types if specified.
         * @param message UpdateDepartmentData
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: departmentmanager.UpdateDepartmentData, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this UpdateDepartmentData to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a DepartmentName. */
    interface IDepartmentName {

        /** DepartmentName languageCode */
        languageCode?: (string|null);

        /** DepartmentName name */
        name?: (string|null);
    }

    /** Represents a DepartmentName. */
    class DepartmentName implements IDepartmentName {

        /**
         * Constructs a new DepartmentName.
         * @param [properties] Properties to set
         */
        constructor(properties?: departmentmanager.IDepartmentName);

        /** DepartmentName languageCode. */
        public languageCode: string;

        /** DepartmentName name. */
        public name: string;

        /**
         * Creates a new DepartmentName instance using the specified properties.
         * @param [properties] Properties to set
         * @returns DepartmentName instance
         */
        public static create(properties?: departmentmanager.IDepartmentName): departmentmanager.DepartmentName;

        /**
         * Encodes the specified DepartmentName message. Does not implicitly {@link departmentmanager.DepartmentName.verify|verify} messages.
         * @param message DepartmentName message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: departmentmanager.IDepartmentName, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified DepartmentName message, length delimited. Does not implicitly {@link departmentmanager.DepartmentName.verify|verify} messages.
         * @param message DepartmentName message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: departmentmanager.IDepartmentName, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a DepartmentName message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns DepartmentName
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): departmentmanager.DepartmentName;

        /**
         * Decodes a DepartmentName message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns DepartmentName
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): departmentmanager.DepartmentName;

        /**
         * Verifies a DepartmentName message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a DepartmentName message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns DepartmentName
         */
        public static fromObject(object: { [k: string]: any }): departmentmanager.DepartmentName;

        /**
         * Creates a plain object from a DepartmentName message. Also converts values to other types if specified.
         * @param message DepartmentName
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: departmentmanager.DepartmentName, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this DepartmentName to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a DepartmentUsersCount. */
    interface IDepartmentUsersCount {

        /** DepartmentUsersCount organizationId */
        organizationId?: (number|null);

        /** DepartmentUsersCount departmentId */
        departmentId?: (string|null);

        /** DepartmentUsersCount usersCount */
        usersCount?: (number|null);
    }

    /** Represents a DepartmentUsersCount. */
    class DepartmentUsersCount implements IDepartmentUsersCount {

        /**
         * Constructs a new DepartmentUsersCount.
         * @param [properties] Properties to set
         */
        constructor(properties?: departmentmanager.IDepartmentUsersCount);

        /** DepartmentUsersCount organizationId. */
        public organizationId: number;

        /** DepartmentUsersCount departmentId. */
        public departmentId: string;

        /** DepartmentUsersCount usersCount. */
        public usersCount: number;

        /**
         * Creates a new DepartmentUsersCount instance using the specified properties.
         * @param [properties] Properties to set
         * @returns DepartmentUsersCount instance
         */
        public static create(properties?: departmentmanager.IDepartmentUsersCount): departmentmanager.DepartmentUsersCount;

        /**
         * Encodes the specified DepartmentUsersCount message. Does not implicitly {@link departmentmanager.DepartmentUsersCount.verify|verify} messages.
         * @param message DepartmentUsersCount message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: departmentmanager.IDepartmentUsersCount, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified DepartmentUsersCount message, length delimited. Does not implicitly {@link departmentmanager.DepartmentUsersCount.verify|verify} messages.
         * @param message DepartmentUsersCount message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: departmentmanager.IDepartmentUsersCount, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a DepartmentUsersCount message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns DepartmentUsersCount
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): departmentmanager.DepartmentUsersCount;

        /**
         * Decodes a DepartmentUsersCount message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns DepartmentUsersCount
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): departmentmanager.DepartmentUsersCount;

        /**
         * Verifies a DepartmentUsersCount message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a DepartmentUsersCount message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns DepartmentUsersCount
         */
        public static fromObject(object: { [k: string]: any }): departmentmanager.DepartmentUsersCount;

        /**
         * Creates a plain object from a DepartmentUsersCount message. Also converts values to other types if specified.
         * @param message DepartmentUsersCount
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: departmentmanager.DepartmentUsersCount, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this DepartmentUsersCount to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a CreateDepartmentRequest. */
    interface ICreateDepartmentRequest {

        /** CreateDepartmentRequest departmentData */
        departmentData?: (departmentmanager.IDepartmentData|null);

        /** CreateDepartmentRequest departmentResponsibleUserIds */
        departmentResponsibleUserIds?: (number[]|null);
    }

    /** Represents a CreateDepartmentRequest. */
    class CreateDepartmentRequest implements ICreateDepartmentRequest {

        /**
         * Constructs a new CreateDepartmentRequest.
         * @param [properties] Properties to set
         */
        constructor(properties?: departmentmanager.ICreateDepartmentRequest);

        /** CreateDepartmentRequest departmentData. */
        public departmentData?: (departmentmanager.IDepartmentData|null);

        /** CreateDepartmentRequest departmentResponsibleUserIds. */
        public departmentResponsibleUserIds: number[];

        /**
         * Creates a new CreateDepartmentRequest instance using the specified properties.
         * @param [properties] Properties to set
         * @returns CreateDepartmentRequest instance
         */
        public static create(properties?: departmentmanager.ICreateDepartmentRequest): departmentmanager.CreateDepartmentRequest;

        /**
         * Encodes the specified CreateDepartmentRequest message. Does not implicitly {@link departmentmanager.CreateDepartmentRequest.verify|verify} messages.
         * @param message CreateDepartmentRequest message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: departmentmanager.ICreateDepartmentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified CreateDepartmentRequest message, length delimited. Does not implicitly {@link departmentmanager.CreateDepartmentRequest.verify|verify} messages.
         * @param message CreateDepartmentRequest message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: departmentmanager.ICreateDepartmentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a CreateDepartmentRequest message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns CreateDepartmentRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): departmentmanager.CreateDepartmentRequest;

        /**
         * Decodes a CreateDepartmentRequest message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns CreateDepartmentRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): departmentmanager.CreateDepartmentRequest;

        /**
         * Verifies a CreateDepartmentRequest message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a CreateDepartmentRequest message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns CreateDepartmentRequest
         */
        public static fromObject(object: { [k: string]: any }): departmentmanager.CreateDepartmentRequest;

        /**
         * Creates a plain object from a CreateDepartmentRequest message. Also converts values to other types if specified.
         * @param message CreateDepartmentRequest
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: departmentmanager.CreateDepartmentRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this CreateDepartmentRequest to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a DepartmentsResponse. */
    interface IDepartmentsResponse {

        /** DepartmentsResponse departments */
        departments?: (departmentmanager.IDepartment[]|null);

        /** DepartmentsResponse usersCount */
        usersCount?: (departmentmanager.IDepartmentUsersCount[]|null);
    }

    /** Represents a DepartmentsResponse. */
    class DepartmentsResponse implements IDepartmentsResponse {

        /**
         * Constructs a new DepartmentsResponse.
         * @param [properties] Properties to set
         */
        constructor(properties?: departmentmanager.IDepartmentsResponse);

        /** DepartmentsResponse departments. */
        public departments: departmentmanager.IDepartment[];

        /** DepartmentsResponse usersCount. */
        public usersCount: departmentmanager.IDepartmentUsersCount[];

        /**
         * Creates a new DepartmentsResponse instance using the specified properties.
         * @param [properties] Properties to set
         * @returns DepartmentsResponse instance
         */
        public static create(properties?: departmentmanager.IDepartmentsResponse): departmentmanager.DepartmentsResponse;

        /**
         * Encodes the specified DepartmentsResponse message. Does not implicitly {@link departmentmanager.DepartmentsResponse.verify|verify} messages.
         * @param message DepartmentsResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: departmentmanager.IDepartmentsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified DepartmentsResponse message, length delimited. Does not implicitly {@link departmentmanager.DepartmentsResponse.verify|verify} messages.
         * @param message DepartmentsResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: departmentmanager.IDepartmentsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a DepartmentsResponse message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns DepartmentsResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): departmentmanager.DepartmentsResponse;

        /**
         * Decodes a DepartmentsResponse message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns DepartmentsResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): departmentmanager.DepartmentsResponse;

        /**
         * Verifies a DepartmentsResponse message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a DepartmentsResponse message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns DepartmentsResponse
         */
        public static fromObject(object: { [k: string]: any }): departmentmanager.DepartmentsResponse;

        /**
         * Creates a plain object from a DepartmentsResponse message. Also converts values to other types if specified.
         * @param message DepartmentsResponse
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: departmentmanager.DepartmentsResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this DepartmentsResponse to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a DepartmentUsersResponse. */
    interface IDepartmentUsersResponse {

        /** DepartmentUsersResponse usersId */
        usersId?: (number[]|null);
    }

    /** Represents a DepartmentUsersResponse. */
    class DepartmentUsersResponse implements IDepartmentUsersResponse {

        /**
         * Constructs a new DepartmentUsersResponse.
         * @param [properties] Properties to set
         */
        constructor(properties?: departmentmanager.IDepartmentUsersResponse);

        /** DepartmentUsersResponse usersId. */
        public usersId: number[];

        /**
         * Creates a new DepartmentUsersResponse instance using the specified properties.
         * @param [properties] Properties to set
         * @returns DepartmentUsersResponse instance
         */
        public static create(properties?: departmentmanager.IDepartmentUsersResponse): departmentmanager.DepartmentUsersResponse;

        /**
         * Encodes the specified DepartmentUsersResponse message. Does not implicitly {@link departmentmanager.DepartmentUsersResponse.verify|verify} messages.
         * @param message DepartmentUsersResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: departmentmanager.IDepartmentUsersResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified DepartmentUsersResponse message, length delimited. Does not implicitly {@link departmentmanager.DepartmentUsersResponse.verify|verify} messages.
         * @param message DepartmentUsersResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: departmentmanager.IDepartmentUsersResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a DepartmentUsersResponse message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns DepartmentUsersResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): departmentmanager.DepartmentUsersResponse;

        /**
         * Decodes a DepartmentUsersResponse message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns DepartmentUsersResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): departmentmanager.DepartmentUsersResponse;

        /**
         * Verifies a DepartmentUsersResponse message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a DepartmentUsersResponse message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns DepartmentUsersResponse
         */
        public static fromObject(object: { [k: string]: any }): departmentmanager.DepartmentUsersResponse;

        /**
         * Creates a plain object from a DepartmentUsersResponse message. Also converts values to other types if specified.
         * @param message DepartmentUsersResponse
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: departmentmanager.DepartmentUsersResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this DepartmentUsersResponse to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }
}
