/*eslint-disable block-scoped-var, id-length, no-control-regex, no-magic-numbers, no-prototype-builtins, no-redeclare, no-shadow, no-var, sort-vars*/
"use strict";

var $protobuf = require("protobufjs/minimal");

// Common aliases
var $Reader = $protobuf.Reader, $Writer = $protobuf.Writer, $util = $protobuf.util;

// Exported root namespace
var $root = $protobuf.roots["default"] || ($protobuf.roots["default"] = {});

$root.NAppHostHttp = (function() {

    /**
     * Namespace NAppHostHttp.
     * @exports NAppHostHttp
     * @namespace
     */
    var NAppHostHttp = {};

    NAppHostHttp.THeader = (function() {

        /**
         * Properties of a THeader.
         * @memberof NAppHostHttp
         * @interface ITHeader
         * @property {string|null} [Name] THeader Name
         * @property {string|null} [Value] THeader Value
         */

        /**
         * Constructs a new THeader.
         * @memberof NAppHostHttp
         * @classdesc Represents a THeader.
         * @implements ITHeader
         * @constructor
         * @param {NAppHostHttp.ITHeader=} [properties] Properties to set
         */
        function THeader(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * THeader Name.
         * @member {string} Name
         * @memberof NAppHostHttp.THeader
         * @instance
         */
        THeader.prototype.Name = "";

        /**
         * THeader Value.
         * @member {string} Value
         * @memberof NAppHostHttp.THeader
         * @instance
         */
        THeader.prototype.Value = "";

        /**
         * Creates a new THeader instance using the specified properties.
         * @function create
         * @memberof NAppHostHttp.THeader
         * @static
         * @param {NAppHostHttp.ITHeader=} [properties] Properties to set
         * @returns {NAppHostHttp.THeader} THeader instance
         */
        THeader.create = function create(properties) {
            return new THeader(properties);
        };

        /**
         * Encodes the specified THeader message. Does not implicitly {@link NAppHostHttp.THeader.verify|verify} messages.
         * @function encode
         * @memberof NAppHostHttp.THeader
         * @static
         * @param {NAppHostHttp.ITHeader} message THeader message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        THeader.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.Name != null && Object.hasOwnProperty.call(message, "Name"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.Name);
            if (message.Value != null && Object.hasOwnProperty.call(message, "Value"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.Value);
            return writer;
        };

        /**
         * Encodes the specified THeader message, length delimited. Does not implicitly {@link NAppHostHttp.THeader.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NAppHostHttp.THeader
         * @static
         * @param {NAppHostHttp.ITHeader} message THeader message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        THeader.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a THeader message from the specified reader or buffer.
         * @function decode
         * @memberof NAppHostHttp.THeader
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NAppHostHttp.THeader} THeader
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        THeader.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAppHostHttp.THeader();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.Name = reader.string();
                    break;
                case 2:
                    message.Value = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a THeader message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NAppHostHttp.THeader
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NAppHostHttp.THeader} THeader
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        THeader.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a THeader message.
         * @function verify
         * @memberof NAppHostHttp.THeader
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        THeader.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.Name != null && message.hasOwnProperty("Name"))
                if (!$util.isString(message.Name))
                    return "Name: string expected";
            if (message.Value != null && message.hasOwnProperty("Value"))
                if (!$util.isString(message.Value))
                    return "Value: string expected";
            return null;
        };

        /**
         * Creates a THeader message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NAppHostHttp.THeader
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NAppHostHttp.THeader} THeader
         */
        THeader.fromObject = function fromObject(object) {
            if (object instanceof $root.NAppHostHttp.THeader)
                return object;
            var message = new $root.NAppHostHttp.THeader();
            if (object.Name != null)
                message.Name = String(object.Name);
            if (object.Value != null)
                message.Value = String(object.Value);
            return message;
        };

        /**
         * Creates a plain object from a THeader message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NAppHostHttp.THeader
         * @static
         * @param {NAppHostHttp.THeader} message THeader
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        THeader.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.Name = "";
                object.Value = "";
            }
            if (message.Name != null && message.hasOwnProperty("Name"))
                object.Name = message.Name;
            if (message.Value != null && message.hasOwnProperty("Value"))
                object.Value = message.Value;
            return object;
        };

        /**
         * Converts this THeader to JSON.
         * @function toJSON
         * @memberof NAppHostHttp.THeader
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        THeader.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return THeader;
    })();

    NAppHostHttp.THttpRequest = (function() {

        /**
         * Properties of a THttpRequest.
         * @memberof NAppHostHttp
         * @interface ITHttpRequest
         * @property {NAppHostHttp.THttpRequest.EMethod|null} [Method] THttpRequest Method
         * @property {NAppHostHttp.THttpRequest.EScheme|null} [Scheme] THttpRequest Scheme
         * @property {string|null} [Path] THttpRequest Path
         * @property {Array.<NAppHostHttp.ITHeader>|null} [Headers] THttpRequest Headers
         * @property {Uint8Array|null} [Content] THttpRequest Content
         * @property {string|null} [RemoteIP] THttpRequest RemoteIP
         */

        /**
         * Constructs a new THttpRequest.
         * @memberof NAppHostHttp
         * @classdesc Represents a THttpRequest.
         * @implements ITHttpRequest
         * @constructor
         * @param {NAppHostHttp.ITHttpRequest=} [properties] Properties to set
         */
        function THttpRequest(properties) {
            this.Headers = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * THttpRequest Method.
         * @member {NAppHostHttp.THttpRequest.EMethod} Method
         * @memberof NAppHostHttp.THttpRequest
         * @instance
         */
        THttpRequest.prototype.Method = 0;

        /**
         * THttpRequest Scheme.
         * @member {NAppHostHttp.THttpRequest.EScheme} Scheme
         * @memberof NAppHostHttp.THttpRequest
         * @instance
         */
        THttpRequest.prototype.Scheme = 0;

        /**
         * THttpRequest Path.
         * @member {string} Path
         * @memberof NAppHostHttp.THttpRequest
         * @instance
         */
        THttpRequest.prototype.Path = "";

        /**
         * THttpRequest Headers.
         * @member {Array.<NAppHostHttp.ITHeader>} Headers
         * @memberof NAppHostHttp.THttpRequest
         * @instance
         */
        THttpRequest.prototype.Headers = $util.emptyArray;

        /**
         * THttpRequest Content.
         * @member {Uint8Array} Content
         * @memberof NAppHostHttp.THttpRequest
         * @instance
         */
        THttpRequest.prototype.Content = $util.newBuffer([]);

        /**
         * THttpRequest RemoteIP.
         * @member {string} RemoteIP
         * @memberof NAppHostHttp.THttpRequest
         * @instance
         */
        THttpRequest.prototype.RemoteIP = "";

        /**
         * Creates a new THttpRequest instance using the specified properties.
         * @function create
         * @memberof NAppHostHttp.THttpRequest
         * @static
         * @param {NAppHostHttp.ITHttpRequest=} [properties] Properties to set
         * @returns {NAppHostHttp.THttpRequest} THttpRequest instance
         */
        THttpRequest.create = function create(properties) {
            return new THttpRequest(properties);
        };

        /**
         * Encodes the specified THttpRequest message. Does not implicitly {@link NAppHostHttp.THttpRequest.verify|verify} messages.
         * @function encode
         * @memberof NAppHostHttp.THttpRequest
         * @static
         * @param {NAppHostHttp.ITHttpRequest} message THttpRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        THttpRequest.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.Method != null && Object.hasOwnProperty.call(message, "Method"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.Method);
            if (message.Scheme != null && Object.hasOwnProperty.call(message, "Scheme"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.Scheme);
            if (message.Path != null && Object.hasOwnProperty.call(message, "Path"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.Path);
            if (message.Headers != null && message.Headers.length)
                for (var i = 0; i < message.Headers.length; ++i)
                    $root.NAppHostHttp.THeader.encode(message.Headers[i], writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
            if (message.Content != null && Object.hasOwnProperty.call(message, "Content"))
                writer.uint32(/* id 5, wireType 2 =*/42).bytes(message.Content);
            if (message.RemoteIP != null && Object.hasOwnProperty.call(message, "RemoteIP"))
                writer.uint32(/* id 6, wireType 2 =*/50).string(message.RemoteIP);
            return writer;
        };

        /**
         * Encodes the specified THttpRequest message, length delimited. Does not implicitly {@link NAppHostHttp.THttpRequest.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NAppHostHttp.THttpRequest
         * @static
         * @param {NAppHostHttp.ITHttpRequest} message THttpRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        THttpRequest.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a THttpRequest message from the specified reader or buffer.
         * @function decode
         * @memberof NAppHostHttp.THttpRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NAppHostHttp.THttpRequest} THttpRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        THttpRequest.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAppHostHttp.THttpRequest();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.Method = reader.int32();
                    break;
                case 2:
                    message.Scheme = reader.int32();
                    break;
                case 3:
                    message.Path = reader.string();
                    break;
                case 4:
                    if (!(message.Headers && message.Headers.length))
                        message.Headers = [];
                    message.Headers.push($root.NAppHostHttp.THeader.decode(reader, reader.uint32()));
                    break;
                case 5:
                    message.Content = reader.bytes();
                    break;
                case 6:
                    message.RemoteIP = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a THttpRequest message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NAppHostHttp.THttpRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NAppHostHttp.THttpRequest} THttpRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        THttpRequest.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a THttpRequest message.
         * @function verify
         * @memberof NAppHostHttp.THttpRequest
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        THttpRequest.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.Method != null && message.hasOwnProperty("Method"))
                switch (message.Method) {
                default:
                    return "Method: enum value expected";
                case 0:
                case 1:
                case 2:
                case 3:
                case 4:
                case 5:
                case 6:
                case 7:
                case 8:
                    break;
                }
            if (message.Scheme != null && message.hasOwnProperty("Scheme"))
                switch (message.Scheme) {
                default:
                    return "Scheme: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            if (message.Path != null && message.hasOwnProperty("Path"))
                if (!$util.isString(message.Path))
                    return "Path: string expected";
            if (message.Headers != null && message.hasOwnProperty("Headers")) {
                if (!Array.isArray(message.Headers))
                    return "Headers: array expected";
                for (var i = 0; i < message.Headers.length; ++i) {
                    var error = $root.NAppHostHttp.THeader.verify(message.Headers[i]);
                    if (error)
                        return "Headers." + error;
                }
            }
            if (message.Content != null && message.hasOwnProperty("Content"))
                if (!(message.Content && typeof message.Content.length === "number" || $util.isString(message.Content)))
                    return "Content: buffer expected";
            if (message.RemoteIP != null && message.hasOwnProperty("RemoteIP"))
                if (!$util.isString(message.RemoteIP))
                    return "RemoteIP: string expected";
            return null;
        };

        /**
         * Creates a THttpRequest message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NAppHostHttp.THttpRequest
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NAppHostHttp.THttpRequest} THttpRequest
         */
        THttpRequest.fromObject = function fromObject(object) {
            if (object instanceof $root.NAppHostHttp.THttpRequest)
                return object;
            var message = new $root.NAppHostHttp.THttpRequest();
            switch (object.Method) {
            case "Get":
            case 0:
                message.Method = 0;
                break;
            case "Post":
            case 1:
                message.Method = 1;
                break;
            case "Put":
            case 2:
                message.Method = 2;
                break;
            case "Delete":
            case 3:
                message.Method = 3;
                break;
            case "Head":
            case 4:
                message.Method = 4;
                break;
            case "Connect":
            case 5:
                message.Method = 5;
                break;
            case "Options":
            case 6:
                message.Method = 6;
                break;
            case "Trace":
            case 7:
                message.Method = 7;
                break;
            case "Patch":
            case 8:
                message.Method = 8;
                break;
            }
            switch (object.Scheme) {
            case "None":
            case 0:
                message.Scheme = 0;
                break;
            case "Http":
            case 1:
                message.Scheme = 1;
                break;
            case "Https":
            case 2:
                message.Scheme = 2;
                break;
            }
            if (object.Path != null)
                message.Path = String(object.Path);
            if (object.Headers) {
                if (!Array.isArray(object.Headers))
                    throw TypeError(".NAppHostHttp.THttpRequest.Headers: array expected");
                message.Headers = [];
                for (var i = 0; i < object.Headers.length; ++i) {
                    if (typeof object.Headers[i] !== "object")
                        throw TypeError(".NAppHostHttp.THttpRequest.Headers: object expected");
                    message.Headers[i] = $root.NAppHostHttp.THeader.fromObject(object.Headers[i]);
                }
            }
            if (object.Content != null)
                if (typeof object.Content === "string")
                    $util.base64.decode(object.Content, message.Content = $util.newBuffer($util.base64.length(object.Content)), 0);
                else if (object.Content.length)
                    message.Content = object.Content;
            if (object.RemoteIP != null)
                message.RemoteIP = String(object.RemoteIP);
            return message;
        };

        /**
         * Creates a plain object from a THttpRequest message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NAppHostHttp.THttpRequest
         * @static
         * @param {NAppHostHttp.THttpRequest} message THttpRequest
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        THttpRequest.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.Headers = [];
            if (options.defaults) {
                object.Method = options.enums === String ? "Get" : 0;
                object.Scheme = options.enums === String ? "None" : 0;
                object.Path = "";
                if (options.bytes === String)
                    object.Content = "";
                else {
                    object.Content = [];
                    if (options.bytes !== Array)
                        object.Content = $util.newBuffer(object.Content);
                }
                object.RemoteIP = "";
            }
            if (message.Method != null && message.hasOwnProperty("Method"))
                object.Method = options.enums === String ? $root.NAppHostHttp.THttpRequest.EMethod[message.Method] : message.Method;
            if (message.Scheme != null && message.hasOwnProperty("Scheme"))
                object.Scheme = options.enums === String ? $root.NAppHostHttp.THttpRequest.EScheme[message.Scheme] : message.Scheme;
            if (message.Path != null && message.hasOwnProperty("Path"))
                object.Path = message.Path;
            if (message.Headers && message.Headers.length) {
                object.Headers = [];
                for (var j = 0; j < message.Headers.length; ++j)
                    object.Headers[j] = $root.NAppHostHttp.THeader.toObject(message.Headers[j], options);
            }
            if (message.Content != null && message.hasOwnProperty("Content"))
                object.Content = options.bytes === String ? $util.base64.encode(message.Content, 0, message.Content.length) : options.bytes === Array ? Array.prototype.slice.call(message.Content) : message.Content;
            if (message.RemoteIP != null && message.hasOwnProperty("RemoteIP"))
                object.RemoteIP = message.RemoteIP;
            return object;
        };

        /**
         * Converts this THttpRequest to JSON.
         * @function toJSON
         * @memberof NAppHostHttp.THttpRequest
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        THttpRequest.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * EMethod enum.
         * @name NAppHostHttp.THttpRequest.EMethod
         * @enum {number}
         * @property {number} Get=0 Get value
         * @property {number} Post=1 Post value
         * @property {number} Put=2 Put value
         * @property {number} Delete=3 Delete value
         * @property {number} Head=4 Head value
         * @property {number} Connect=5 Connect value
         * @property {number} Options=6 Options value
         * @property {number} Trace=7 Trace value
         * @property {number} Patch=8 Patch value
         */
        THttpRequest.EMethod = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "Get"] = 0;
            values[valuesById[1] = "Post"] = 1;
            values[valuesById[2] = "Put"] = 2;
            values[valuesById[3] = "Delete"] = 3;
            values[valuesById[4] = "Head"] = 4;
            values[valuesById[5] = "Connect"] = 5;
            values[valuesById[6] = "Options"] = 6;
            values[valuesById[7] = "Trace"] = 7;
            values[valuesById[8] = "Patch"] = 8;
            return values;
        })();

        /**
         * EScheme enum.
         * @name NAppHostHttp.THttpRequest.EScheme
         * @enum {number}
         * @property {number} None=0 None value
         * @property {number} Http=1 Http value
         * @property {number} Https=2 Https value
         */
        THttpRequest.EScheme = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "None"] = 0;
            values[valuesById[1] = "Http"] = 1;
            values[valuesById[2] = "Https"] = 2;
            return values;
        })();

        return THttpRequest;
    })();

    NAppHostHttp.THttpResponse = (function() {

        /**
         * Properties of a THttpResponse.
         * @memberof NAppHostHttp
         * @interface ITHttpResponse
         * @property {number|null} [StatusCode] THttpResponse StatusCode
         * @property {Array.<NAppHostHttp.ITHeader>|null} [Headers] THttpResponse Headers
         * @property {Uint8Array|null} [Content] THttpResponse Content
         * @property {boolean|null} [IsSdchEncoded] THttpResponse IsSdchEncoded
         * @property {boolean|null} [FromHttpProxy] THttpResponse FromHttpProxy
         */

        /**
         * Constructs a new THttpResponse.
         * @memberof NAppHostHttp
         * @classdesc Represents a THttpResponse.
         * @implements ITHttpResponse
         * @constructor
         * @param {NAppHostHttp.ITHttpResponse=} [properties] Properties to set
         */
        function THttpResponse(properties) {
            this.Headers = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * THttpResponse StatusCode.
         * @member {number} StatusCode
         * @memberof NAppHostHttp.THttpResponse
         * @instance
         */
        THttpResponse.prototype.StatusCode = 0;

        /**
         * THttpResponse Headers.
         * @member {Array.<NAppHostHttp.ITHeader>} Headers
         * @memberof NAppHostHttp.THttpResponse
         * @instance
         */
        THttpResponse.prototype.Headers = $util.emptyArray;

        /**
         * THttpResponse Content.
         * @member {Uint8Array} Content
         * @memberof NAppHostHttp.THttpResponse
         * @instance
         */
        THttpResponse.prototype.Content = $util.newBuffer([]);

        /**
         * THttpResponse IsSdchEncoded.
         * @member {boolean} IsSdchEncoded
         * @memberof NAppHostHttp.THttpResponse
         * @instance
         */
        THttpResponse.prototype.IsSdchEncoded = false;

        /**
         * THttpResponse FromHttpProxy.
         * @member {boolean} FromHttpProxy
         * @memberof NAppHostHttp.THttpResponse
         * @instance
         */
        THttpResponse.prototype.FromHttpProxy = false;

        /**
         * Creates a new THttpResponse instance using the specified properties.
         * @function create
         * @memberof NAppHostHttp.THttpResponse
         * @static
         * @param {NAppHostHttp.ITHttpResponse=} [properties] Properties to set
         * @returns {NAppHostHttp.THttpResponse} THttpResponse instance
         */
        THttpResponse.create = function create(properties) {
            return new THttpResponse(properties);
        };

        /**
         * Encodes the specified THttpResponse message. Does not implicitly {@link NAppHostHttp.THttpResponse.verify|verify} messages.
         * @function encode
         * @memberof NAppHostHttp.THttpResponse
         * @static
         * @param {NAppHostHttp.ITHttpResponse} message THttpResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        THttpResponse.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.StatusCode != null && Object.hasOwnProperty.call(message, "StatusCode"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint32(message.StatusCode);
            if (message.Headers != null && message.Headers.length)
                for (var i = 0; i < message.Headers.length; ++i)
                    $root.NAppHostHttp.THeader.encode(message.Headers[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.Content != null && Object.hasOwnProperty.call(message, "Content"))
                writer.uint32(/* id 3, wireType 2 =*/26).bytes(message.Content);
            if (message.IsSdchEncoded != null && Object.hasOwnProperty.call(message, "IsSdchEncoded"))
                writer.uint32(/* id 4, wireType 0 =*/32).bool(message.IsSdchEncoded);
            if (message.FromHttpProxy != null && Object.hasOwnProperty.call(message, "FromHttpProxy"))
                writer.uint32(/* id 5, wireType 0 =*/40).bool(message.FromHttpProxy);
            return writer;
        };

        /**
         * Encodes the specified THttpResponse message, length delimited. Does not implicitly {@link NAppHostHttp.THttpResponse.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NAppHostHttp.THttpResponse
         * @static
         * @param {NAppHostHttp.ITHttpResponse} message THttpResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        THttpResponse.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a THttpResponse message from the specified reader or buffer.
         * @function decode
         * @memberof NAppHostHttp.THttpResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NAppHostHttp.THttpResponse} THttpResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        THttpResponse.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAppHostHttp.THttpResponse();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.StatusCode = reader.uint32();
                    break;
                case 2:
                    if (!(message.Headers && message.Headers.length))
                        message.Headers = [];
                    message.Headers.push($root.NAppHostHttp.THeader.decode(reader, reader.uint32()));
                    break;
                case 3:
                    message.Content = reader.bytes();
                    break;
                case 4:
                    message.IsSdchEncoded = reader.bool();
                    break;
                case 5:
                    message.FromHttpProxy = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a THttpResponse message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NAppHostHttp.THttpResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NAppHostHttp.THttpResponse} THttpResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        THttpResponse.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a THttpResponse message.
         * @function verify
         * @memberof NAppHostHttp.THttpResponse
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        THttpResponse.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.StatusCode != null && message.hasOwnProperty("StatusCode"))
                if (!$util.isInteger(message.StatusCode))
                    return "StatusCode: integer expected";
            if (message.Headers != null && message.hasOwnProperty("Headers")) {
                if (!Array.isArray(message.Headers))
                    return "Headers: array expected";
                for (var i = 0; i < message.Headers.length; ++i) {
                    var error = $root.NAppHostHttp.THeader.verify(message.Headers[i]);
                    if (error)
                        return "Headers." + error;
                }
            }
            if (message.Content != null && message.hasOwnProperty("Content"))
                if (!(message.Content && typeof message.Content.length === "number" || $util.isString(message.Content)))
                    return "Content: buffer expected";
            if (message.IsSdchEncoded != null && message.hasOwnProperty("IsSdchEncoded"))
                if (typeof message.IsSdchEncoded !== "boolean")
                    return "IsSdchEncoded: boolean expected";
            if (message.FromHttpProxy != null && message.hasOwnProperty("FromHttpProxy"))
                if (typeof message.FromHttpProxy !== "boolean")
                    return "FromHttpProxy: boolean expected";
            return null;
        };

        /**
         * Creates a THttpResponse message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NAppHostHttp.THttpResponse
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NAppHostHttp.THttpResponse} THttpResponse
         */
        THttpResponse.fromObject = function fromObject(object) {
            if (object instanceof $root.NAppHostHttp.THttpResponse)
                return object;
            var message = new $root.NAppHostHttp.THttpResponse();
            if (object.StatusCode != null)
                message.StatusCode = object.StatusCode >>> 0;
            if (object.Headers) {
                if (!Array.isArray(object.Headers))
                    throw TypeError(".NAppHostHttp.THttpResponse.Headers: array expected");
                message.Headers = [];
                for (var i = 0; i < object.Headers.length; ++i) {
                    if (typeof object.Headers[i] !== "object")
                        throw TypeError(".NAppHostHttp.THttpResponse.Headers: object expected");
                    message.Headers[i] = $root.NAppHostHttp.THeader.fromObject(object.Headers[i]);
                }
            }
            if (object.Content != null)
                if (typeof object.Content === "string")
                    $util.base64.decode(object.Content, message.Content = $util.newBuffer($util.base64.length(object.Content)), 0);
                else if (object.Content.length)
                    message.Content = object.Content;
            if (object.IsSdchEncoded != null)
                message.IsSdchEncoded = Boolean(object.IsSdchEncoded);
            if (object.FromHttpProxy != null)
                message.FromHttpProxy = Boolean(object.FromHttpProxy);
            return message;
        };

        /**
         * Creates a plain object from a THttpResponse message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NAppHostHttp.THttpResponse
         * @static
         * @param {NAppHostHttp.THttpResponse} message THttpResponse
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        THttpResponse.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.Headers = [];
            if (options.defaults) {
                object.StatusCode = 0;
                if (options.bytes === String)
                    object.Content = "";
                else {
                    object.Content = [];
                    if (options.bytes !== Array)
                        object.Content = $util.newBuffer(object.Content);
                }
                object.IsSdchEncoded = false;
                object.FromHttpProxy = false;
            }
            if (message.StatusCode != null && message.hasOwnProperty("StatusCode"))
                object.StatusCode = message.StatusCode;
            if (message.Headers && message.Headers.length) {
                object.Headers = [];
                for (var j = 0; j < message.Headers.length; ++j)
                    object.Headers[j] = $root.NAppHostHttp.THeader.toObject(message.Headers[j], options);
            }
            if (message.Content != null && message.hasOwnProperty("Content"))
                object.Content = options.bytes === String ? $util.base64.encode(message.Content, 0, message.Content.length) : options.bytes === Array ? Array.prototype.slice.call(message.Content) : message.Content;
            if (message.IsSdchEncoded != null && message.hasOwnProperty("IsSdchEncoded"))
                object.IsSdchEncoded = message.IsSdchEncoded;
            if (message.FromHttpProxy != null && message.hasOwnProperty("FromHttpProxy"))
                object.FromHttpProxy = message.FromHttpProxy;
            return object;
        };

        /**
         * Converts this THttpResponse to JSON.
         * @function toJSON
         * @memberof NAppHostHttp.THttpResponse
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        THttpResponse.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return THttpResponse;
    })();

    return NAppHostHttp;
})();

$root.NAppHostTvmUserTicket = (function() {

    /**
     * Namespace NAppHostTvmUserTicket.
     * @exports NAppHostTvmUserTicket
     * @namespace
     */
    var NAppHostTvmUserTicket = {};

    NAppHostTvmUserTicket.TTvmUserTicket = (function() {

        /**
         * Properties of a TTvmUserTicket.
         * @memberof NAppHostTvmUserTicket
         * @interface ITTvmUserTicket
         * @property {string|null} [UserTicket] TTvmUserTicket UserTicket
         */

        /**
         * Constructs a new TTvmUserTicket.
         * @memberof NAppHostTvmUserTicket
         * @classdesc Represents a TTvmUserTicket.
         * @implements ITTvmUserTicket
         * @constructor
         * @param {NAppHostTvmUserTicket.ITTvmUserTicket=} [properties] Properties to set
         */
        function TTvmUserTicket(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TTvmUserTicket UserTicket.
         * @member {string} UserTicket
         * @memberof NAppHostTvmUserTicket.TTvmUserTicket
         * @instance
         */
        TTvmUserTicket.prototype.UserTicket = "";

        /**
         * Creates a new TTvmUserTicket instance using the specified properties.
         * @function create
         * @memberof NAppHostTvmUserTicket.TTvmUserTicket
         * @static
         * @param {NAppHostTvmUserTicket.ITTvmUserTicket=} [properties] Properties to set
         * @returns {NAppHostTvmUserTicket.TTvmUserTicket} TTvmUserTicket instance
         */
        TTvmUserTicket.create = function create(properties) {
            return new TTvmUserTicket(properties);
        };

        /**
         * Encodes the specified TTvmUserTicket message. Does not implicitly {@link NAppHostTvmUserTicket.TTvmUserTicket.verify|verify} messages.
         * @function encode
         * @memberof NAppHostTvmUserTicket.TTvmUserTicket
         * @static
         * @param {NAppHostTvmUserTicket.ITTvmUserTicket} message TTvmUserTicket message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TTvmUserTicket.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.UserTicket != null && Object.hasOwnProperty.call(message, "UserTicket"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.UserTicket);
            return writer;
        };

        /**
         * Encodes the specified TTvmUserTicket message, length delimited. Does not implicitly {@link NAppHostTvmUserTicket.TTvmUserTicket.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NAppHostTvmUserTicket.TTvmUserTicket
         * @static
         * @param {NAppHostTvmUserTicket.ITTvmUserTicket} message TTvmUserTicket message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TTvmUserTicket.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TTvmUserTicket message from the specified reader or buffer.
         * @function decode
         * @memberof NAppHostTvmUserTicket.TTvmUserTicket
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NAppHostTvmUserTicket.TTvmUserTicket} TTvmUserTicket
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TTvmUserTicket.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAppHostTvmUserTicket.TTvmUserTicket();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.UserTicket = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TTvmUserTicket message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NAppHostTvmUserTicket.TTvmUserTicket
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NAppHostTvmUserTicket.TTvmUserTicket} TTvmUserTicket
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TTvmUserTicket.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TTvmUserTicket message.
         * @function verify
         * @memberof NAppHostTvmUserTicket.TTvmUserTicket
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TTvmUserTicket.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.UserTicket != null && message.hasOwnProperty("UserTicket"))
                if (!$util.isString(message.UserTicket))
                    return "UserTicket: string expected";
            return null;
        };

        /**
         * Creates a TTvmUserTicket message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NAppHostTvmUserTicket.TTvmUserTicket
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NAppHostTvmUserTicket.TTvmUserTicket} TTvmUserTicket
         */
        TTvmUserTicket.fromObject = function fromObject(object) {
            if (object instanceof $root.NAppHostTvmUserTicket.TTvmUserTicket)
                return object;
            var message = new $root.NAppHostTvmUserTicket.TTvmUserTicket();
            if (object.UserTicket != null)
                message.UserTicket = String(object.UserTicket);
            return message;
        };

        /**
         * Creates a plain object from a TTvmUserTicket message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NAppHostTvmUserTicket.TTvmUserTicket
         * @static
         * @param {NAppHostTvmUserTicket.TTvmUserTicket} message TTvmUserTicket
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TTvmUserTicket.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.UserTicket = "";
            if (message.UserTicket != null && message.hasOwnProperty("UserTicket"))
                object.UserTicket = message.UserTicket;
            return object;
        };

        /**
         * Converts this TTvmUserTicket to JSON.
         * @function toJSON
         * @memberof NAppHostTvmUserTicket.TTvmUserTicket
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TTvmUserTicket.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TTvmUserTicket;
    })();

    return NAppHostTvmUserTicket;
})();

$root.NAppHostProtocol = (function() {

    /**
     * Namespace NAppHostProtocol.
     * @exports NAppHostProtocol
     * @namespace
     */
    var NAppHostProtocol = {};

    NAppHostProtocol.TServant = (function() {

        /**
         * Constructs a new TServant service.
         * @memberof NAppHostProtocol
         * @classdesc Represents a TServant
         * @extends $protobuf.rpc.Service
         * @constructor
         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
         */
        function TServant(rpcImpl, requestDelimited, responseDelimited) {
            $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
        }

        (TServant.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = TServant;

        /**
         * Creates new TServant service using the specified rpc implementation.
         * @function create
         * @memberof NAppHostProtocol.TServant
         * @static
         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
         * @returns {TServant} RPC service. Useful where requests and/or responses are streamed.
         */
        TServant.create = function create(rpcImpl, requestDelimited, responseDelimited) {
            return new this(rpcImpl, requestDelimited, responseDelimited);
        };

        /**
         * Callback as used by {@link NAppHostProtocol.TServant#invoke}.
         * @memberof NAppHostProtocol.TServant
         * @typedef InvokeCallback
         * @type {function}
         * @param {Error|null} error Error, if any
         * @param {NAppHostProtocol.TServiceResponse} [response] TServiceResponse
         */

        /**
         * Calls Invoke.
         * @function invoke
         * @memberof NAppHostProtocol.TServant
         * @instance
         * @param {NAppHostProtocol.ITServiceRequest} request TServiceRequest message or plain object
         * @param {NAppHostProtocol.TServant.InvokeCallback} callback Node-style callback called with the error, if any, and TServiceResponse
         * @returns {undefined}
         * @variation 1
         */
        Object.defineProperty(TServant.prototype.invoke = function invoke(request, callback) {
            return this.rpcCall(invoke, $root.NAppHostProtocol.TServiceRequest, $root.NAppHostProtocol.TServiceResponse, request, callback);
        }, "name", { value: "Invoke" });

        /**
         * Calls Invoke.
         * @function invoke
         * @memberof NAppHostProtocol.TServant
         * @instance
         * @param {NAppHostProtocol.ITServiceRequest} request TServiceRequest message or plain object
         * @returns {Promise<NAppHostProtocol.TServiceResponse>} Promise
         * @variation 2
         */

        /**
         * Callback as used by {@link NAppHostProtocol.TServant#ping}.
         * @memberof NAppHostProtocol.TServant
         * @typedef PingCallback
         * @type {function}
         * @param {Error|null} error Error, if any
         * @param {NAppHostProtocol.TPingResponse} [response] TPingResponse
         */

        /**
         * Calls Ping.
         * @function ping
         * @memberof NAppHostProtocol.TServant
         * @instance
         * @param {NAppHostProtocol.ITPingRequest} request TPingRequest message or plain object
         * @param {NAppHostProtocol.TServant.PingCallback} callback Node-style callback called with the error, if any, and TPingResponse
         * @returns {undefined}
         * @variation 1
         */
        Object.defineProperty(TServant.prototype.ping = function ping(request, callback) {
            return this.rpcCall(ping, $root.NAppHostProtocol.TPingRequest, $root.NAppHostProtocol.TPingResponse, request, callback);
        }, "name", { value: "Ping" });

        /**
         * Calls Ping.
         * @function ping
         * @memberof NAppHostProtocol.TServant
         * @instance
         * @param {NAppHostProtocol.ITPingRequest} request TPingRequest message or plain object
         * @returns {Promise<NAppHostProtocol.TPingResponse>} Promise
         * @variation 2
         */

        /**
         * Callback as used by {@link NAppHostProtocol.TServant#invokeEx}.
         * @memberof NAppHostProtocol.TServant
         * @typedef InvokeExCallback
         * @type {function}
         * @param {Error|null} error Error, if any
         * @param {NAppHostProtocol.TServiceResponse} [response] TServiceResponse
         */

        /**
         * Calls InvokeEx.
         * @function invokeEx
         * @memberof NAppHostProtocol.TServant
         * @instance
         * @param {NAppHostProtocol.ITServiceRequest} request TServiceRequest message or plain object
         * @param {NAppHostProtocol.TServant.InvokeExCallback} callback Node-style callback called with the error, if any, and TServiceResponse
         * @returns {undefined}
         * @variation 1
         */
        Object.defineProperty(TServant.prototype.invokeEx = function invokeEx(request, callback) {
            return this.rpcCall(invokeEx, $root.NAppHostProtocol.TServiceRequest, $root.NAppHostProtocol.TServiceResponse, request, callback);
        }, "name", { value: "InvokeEx" });

        /**
         * Calls InvokeEx.
         * @function invokeEx
         * @memberof NAppHostProtocol.TServant
         * @instance
         * @param {NAppHostProtocol.ITServiceRequest} request TServiceRequest message or plain object
         * @returns {Promise<NAppHostProtocol.TServiceResponse>} Promise
         * @variation 2
         */

        return TServant;
    })();

    NAppHostProtocol.TPingRequest = (function() {

        /**
         * Properties of a TPingRequest.
         * @memberof NAppHostProtocol
         * @interface ITPingRequest
         */

        /**
         * Constructs a new TPingRequest.
         * @memberof NAppHostProtocol
         * @classdesc Represents a TPingRequest.
         * @implements ITPingRequest
         * @constructor
         * @param {NAppHostProtocol.ITPingRequest=} [properties] Properties to set
         */
        function TPingRequest(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Creates a new TPingRequest instance using the specified properties.
         * @function create
         * @memberof NAppHostProtocol.TPingRequest
         * @static
         * @param {NAppHostProtocol.ITPingRequest=} [properties] Properties to set
         * @returns {NAppHostProtocol.TPingRequest} TPingRequest instance
         */
        TPingRequest.create = function create(properties) {
            return new TPingRequest(properties);
        };

        /**
         * Encodes the specified TPingRequest message. Does not implicitly {@link NAppHostProtocol.TPingRequest.verify|verify} messages.
         * @function encode
         * @memberof NAppHostProtocol.TPingRequest
         * @static
         * @param {NAppHostProtocol.ITPingRequest} message TPingRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TPingRequest.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            return writer;
        };

        /**
         * Encodes the specified TPingRequest message, length delimited. Does not implicitly {@link NAppHostProtocol.TPingRequest.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NAppHostProtocol.TPingRequest
         * @static
         * @param {NAppHostProtocol.ITPingRequest} message TPingRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TPingRequest.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TPingRequest message from the specified reader or buffer.
         * @function decode
         * @memberof NAppHostProtocol.TPingRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NAppHostProtocol.TPingRequest} TPingRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TPingRequest.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAppHostProtocol.TPingRequest();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TPingRequest message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NAppHostProtocol.TPingRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NAppHostProtocol.TPingRequest} TPingRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TPingRequest.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TPingRequest message.
         * @function verify
         * @memberof NAppHostProtocol.TPingRequest
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TPingRequest.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            return null;
        };

        /**
         * Creates a TPingRequest message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NAppHostProtocol.TPingRequest
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NAppHostProtocol.TPingRequest} TPingRequest
         */
        TPingRequest.fromObject = function fromObject(object) {
            if (object instanceof $root.NAppHostProtocol.TPingRequest)
                return object;
            return new $root.NAppHostProtocol.TPingRequest();
        };

        /**
         * Creates a plain object from a TPingRequest message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NAppHostProtocol.TPingRequest
         * @static
         * @param {NAppHostProtocol.TPingRequest} message TPingRequest
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TPingRequest.toObject = function toObject() {
            return {};
        };

        /**
         * Converts this TPingRequest to JSON.
         * @function toJSON
         * @memberof NAppHostProtocol.TPingRequest
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TPingRequest.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TPingRequest;
    })();

    NAppHostProtocol.TPingResponse = (function() {

        /**
         * Properties of a TPingResponse.
         * @memberof NAppHostProtocol
         * @interface ITPingResponse
         */

        /**
         * Constructs a new TPingResponse.
         * @memberof NAppHostProtocol
         * @classdesc Represents a TPingResponse.
         * @implements ITPingResponse
         * @constructor
         * @param {NAppHostProtocol.ITPingResponse=} [properties] Properties to set
         */
        function TPingResponse(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Creates a new TPingResponse instance using the specified properties.
         * @function create
         * @memberof NAppHostProtocol.TPingResponse
         * @static
         * @param {NAppHostProtocol.ITPingResponse=} [properties] Properties to set
         * @returns {NAppHostProtocol.TPingResponse} TPingResponse instance
         */
        TPingResponse.create = function create(properties) {
            return new TPingResponse(properties);
        };

        /**
         * Encodes the specified TPingResponse message. Does not implicitly {@link NAppHostProtocol.TPingResponse.verify|verify} messages.
         * @function encode
         * @memberof NAppHostProtocol.TPingResponse
         * @static
         * @param {NAppHostProtocol.ITPingResponse} message TPingResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TPingResponse.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            return writer;
        };

        /**
         * Encodes the specified TPingResponse message, length delimited. Does not implicitly {@link NAppHostProtocol.TPingResponse.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NAppHostProtocol.TPingResponse
         * @static
         * @param {NAppHostProtocol.ITPingResponse} message TPingResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TPingResponse.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TPingResponse message from the specified reader or buffer.
         * @function decode
         * @memberof NAppHostProtocol.TPingResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NAppHostProtocol.TPingResponse} TPingResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TPingResponse.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAppHostProtocol.TPingResponse();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TPingResponse message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NAppHostProtocol.TPingResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NAppHostProtocol.TPingResponse} TPingResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TPingResponse.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TPingResponse message.
         * @function verify
         * @memberof NAppHostProtocol.TPingResponse
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TPingResponse.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            return null;
        };

        /**
         * Creates a TPingResponse message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NAppHostProtocol.TPingResponse
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NAppHostProtocol.TPingResponse} TPingResponse
         */
        TPingResponse.fromObject = function fromObject(object) {
            if (object instanceof $root.NAppHostProtocol.TPingResponse)
                return object;
            return new $root.NAppHostProtocol.TPingResponse();
        };

        /**
         * Creates a plain object from a TPingResponse message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NAppHostProtocol.TPingResponse
         * @static
         * @param {NAppHostProtocol.TPingResponse} message TPingResponse
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TPingResponse.toObject = function toObject() {
            return {};
        };

        /**
         * Converts this TPingResponse to JSON.
         * @function toJSON
         * @memberof NAppHostProtocol.TPingResponse
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TPingResponse.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TPingResponse;
    })();

    NAppHostProtocol.TAnswer = (function() {

        /**
         * Properties of a TAnswer.
         * @memberof NAppHostProtocol
         * @interface ITAnswer
         * @property {string|null} [SourceName] TAnswer SourceName
         * @property {string|null} [Type] TAnswer Type
         * @property {Uint8Array|null} [Data] TAnswer Data
         * @property {Uint8Array|null} [Schema] TAnswer Schema
         * @property {string|null} [OriginNodeName] TAnswer OriginNodeName
         */

        /**
         * Constructs a new TAnswer.
         * @memberof NAppHostProtocol
         * @classdesc Represents a TAnswer.
         * @implements ITAnswer
         * @constructor
         * @param {NAppHostProtocol.ITAnswer=} [properties] Properties to set
         */
        function TAnswer(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TAnswer SourceName.
         * @member {string} SourceName
         * @memberof NAppHostProtocol.TAnswer
         * @instance
         */
        TAnswer.prototype.SourceName = "";

        /**
         * TAnswer Type.
         * @member {string} Type
         * @memberof NAppHostProtocol.TAnswer
         * @instance
         */
        TAnswer.prototype.Type = "";

        /**
         * TAnswer Data.
         * @member {Uint8Array} Data
         * @memberof NAppHostProtocol.TAnswer
         * @instance
         */
        TAnswer.prototype.Data = $util.newBuffer([]);

        /**
         * TAnswer Schema.
         * @member {Uint8Array} Schema
         * @memberof NAppHostProtocol.TAnswer
         * @instance
         */
        TAnswer.prototype.Schema = $util.newBuffer([]);

        /**
         * TAnswer OriginNodeName.
         * @member {string} OriginNodeName
         * @memberof NAppHostProtocol.TAnswer
         * @instance
         */
        TAnswer.prototype.OriginNodeName = "";

        /**
         * Creates a new TAnswer instance using the specified properties.
         * @function create
         * @memberof NAppHostProtocol.TAnswer
         * @static
         * @param {NAppHostProtocol.ITAnswer=} [properties] Properties to set
         * @returns {NAppHostProtocol.TAnswer} TAnswer instance
         */
        TAnswer.create = function create(properties) {
            return new TAnswer(properties);
        };

        /**
         * Encodes the specified TAnswer message. Does not implicitly {@link NAppHostProtocol.TAnswer.verify|verify} messages.
         * @function encode
         * @memberof NAppHostProtocol.TAnswer
         * @static
         * @param {NAppHostProtocol.ITAnswer} message TAnswer message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TAnswer.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.SourceName != null && Object.hasOwnProperty.call(message, "SourceName"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.SourceName);
            if (message.Type != null && Object.hasOwnProperty.call(message, "Type"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.Type);
            if (message.Data != null && Object.hasOwnProperty.call(message, "Data"))
                writer.uint32(/* id 3, wireType 2 =*/26).bytes(message.Data);
            if (message.Schema != null && Object.hasOwnProperty.call(message, "Schema"))
                writer.uint32(/* id 4, wireType 2 =*/34).bytes(message.Schema);
            if (message.OriginNodeName != null && Object.hasOwnProperty.call(message, "OriginNodeName"))
                writer.uint32(/* id 5, wireType 2 =*/42).string(message.OriginNodeName);
            return writer;
        };

        /**
         * Encodes the specified TAnswer message, length delimited. Does not implicitly {@link NAppHostProtocol.TAnswer.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NAppHostProtocol.TAnswer
         * @static
         * @param {NAppHostProtocol.ITAnswer} message TAnswer message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TAnswer.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TAnswer message from the specified reader or buffer.
         * @function decode
         * @memberof NAppHostProtocol.TAnswer
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NAppHostProtocol.TAnswer} TAnswer
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TAnswer.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAppHostProtocol.TAnswer();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.SourceName = reader.string();
                    break;
                case 2:
                    message.Type = reader.string();
                    break;
                case 3:
                    message.Data = reader.bytes();
                    break;
                case 4:
                    message.Schema = reader.bytes();
                    break;
                case 5:
                    message.OriginNodeName = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TAnswer message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NAppHostProtocol.TAnswer
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NAppHostProtocol.TAnswer} TAnswer
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TAnswer.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TAnswer message.
         * @function verify
         * @memberof NAppHostProtocol.TAnswer
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TAnswer.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.SourceName != null && message.hasOwnProperty("SourceName"))
                if (!$util.isString(message.SourceName))
                    return "SourceName: string expected";
            if (message.Type != null && message.hasOwnProperty("Type"))
                if (!$util.isString(message.Type))
                    return "Type: string expected";
            if (message.Data != null && message.hasOwnProperty("Data"))
                if (!(message.Data && typeof message.Data.length === "number" || $util.isString(message.Data)))
                    return "Data: buffer expected";
            if (message.Schema != null && message.hasOwnProperty("Schema"))
                if (!(message.Schema && typeof message.Schema.length === "number" || $util.isString(message.Schema)))
                    return "Schema: buffer expected";
            if (message.OriginNodeName != null && message.hasOwnProperty("OriginNodeName"))
                if (!$util.isString(message.OriginNodeName))
                    return "OriginNodeName: string expected";
            return null;
        };

        /**
         * Creates a TAnswer message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NAppHostProtocol.TAnswer
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NAppHostProtocol.TAnswer} TAnswer
         */
        TAnswer.fromObject = function fromObject(object) {
            if (object instanceof $root.NAppHostProtocol.TAnswer)
                return object;
            var message = new $root.NAppHostProtocol.TAnswer();
            if (object.SourceName != null)
                message.SourceName = String(object.SourceName);
            if (object.Type != null)
                message.Type = String(object.Type);
            if (object.Data != null)
                if (typeof object.Data === "string")
                    $util.base64.decode(object.Data, message.Data = $util.newBuffer($util.base64.length(object.Data)), 0);
                else if (object.Data.length)
                    message.Data = object.Data;
            if (object.Schema != null)
                if (typeof object.Schema === "string")
                    $util.base64.decode(object.Schema, message.Schema = $util.newBuffer($util.base64.length(object.Schema)), 0);
                else if (object.Schema.length)
                    message.Schema = object.Schema;
            if (object.OriginNodeName != null)
                message.OriginNodeName = String(object.OriginNodeName);
            return message;
        };

        /**
         * Creates a plain object from a TAnswer message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NAppHostProtocol.TAnswer
         * @static
         * @param {NAppHostProtocol.TAnswer} message TAnswer
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TAnswer.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.SourceName = "";
                object.Type = "";
                if (options.bytes === String)
                    object.Data = "";
                else {
                    object.Data = [];
                    if (options.bytes !== Array)
                        object.Data = $util.newBuffer(object.Data);
                }
                if (options.bytes === String)
                    object.Schema = "";
                else {
                    object.Schema = [];
                    if (options.bytes !== Array)
                        object.Schema = $util.newBuffer(object.Schema);
                }
                object.OriginNodeName = "";
            }
            if (message.SourceName != null && message.hasOwnProperty("SourceName"))
                object.SourceName = message.SourceName;
            if (message.Type != null && message.hasOwnProperty("Type"))
                object.Type = message.Type;
            if (message.Data != null && message.hasOwnProperty("Data"))
                object.Data = options.bytes === String ? $util.base64.encode(message.Data, 0, message.Data.length) : options.bytes === Array ? Array.prototype.slice.call(message.Data) : message.Data;
            if (message.Schema != null && message.hasOwnProperty("Schema"))
                object.Schema = options.bytes === String ? $util.base64.encode(message.Schema, 0, message.Schema.length) : options.bytes === Array ? Array.prototype.slice.call(message.Schema) : message.Schema;
            if (message.OriginNodeName != null && message.hasOwnProperty("OriginNodeName"))
                object.OriginNodeName = message.OriginNodeName;
            return object;
        };

        /**
         * Converts this TAnswer to JSON.
         * @function toJSON
         * @memberof NAppHostProtocol.TAnswer
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TAnswer.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TAnswer;
    })();

    NAppHostProtocol.TCodecs = (function() {

        /**
         * Properties of a TCodecs.
         * @memberof NAppHostProtocol
         * @interface ITCodecs
         * @property {Array.<number>|null} [CodecIds] TCodecs CodecIds
         */

        /**
         * Constructs a new TCodecs.
         * @memberof NAppHostProtocol
         * @classdesc Represents a TCodecs.
         * @implements ITCodecs
         * @constructor
         * @param {NAppHostProtocol.ITCodecs=} [properties] Properties to set
         */
        function TCodecs(properties) {
            this.CodecIds = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TCodecs CodecIds.
         * @member {Array.<number>} CodecIds
         * @memberof NAppHostProtocol.TCodecs
         * @instance
         */
        TCodecs.prototype.CodecIds = $util.emptyArray;

        /**
         * Creates a new TCodecs instance using the specified properties.
         * @function create
         * @memberof NAppHostProtocol.TCodecs
         * @static
         * @param {NAppHostProtocol.ITCodecs=} [properties] Properties to set
         * @returns {NAppHostProtocol.TCodecs} TCodecs instance
         */
        TCodecs.create = function create(properties) {
            return new TCodecs(properties);
        };

        /**
         * Encodes the specified TCodecs message. Does not implicitly {@link NAppHostProtocol.TCodecs.verify|verify} messages.
         * @function encode
         * @memberof NAppHostProtocol.TCodecs
         * @static
         * @param {NAppHostProtocol.ITCodecs} message TCodecs message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TCodecs.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.CodecIds != null && message.CodecIds.length) {
                writer.uint32(/* id 1, wireType 2 =*/10).fork();
                for (var i = 0; i < message.CodecIds.length; ++i)
                    writer.int32(message.CodecIds[i]);
                writer.ldelim();
            }
            return writer;
        };

        /**
         * Encodes the specified TCodecs message, length delimited. Does not implicitly {@link NAppHostProtocol.TCodecs.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NAppHostProtocol.TCodecs
         * @static
         * @param {NAppHostProtocol.ITCodecs} message TCodecs message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TCodecs.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TCodecs message from the specified reader or buffer.
         * @function decode
         * @memberof NAppHostProtocol.TCodecs
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NAppHostProtocol.TCodecs} TCodecs
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TCodecs.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAppHostProtocol.TCodecs();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    if (!(message.CodecIds && message.CodecIds.length))
                        message.CodecIds = [];
                    if ((tag & 7) === 2) {
                        var end2 = reader.uint32() + reader.pos;
                        while (reader.pos < end2)
                            message.CodecIds.push(reader.int32());
                    } else
                        message.CodecIds.push(reader.int32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TCodecs message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NAppHostProtocol.TCodecs
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NAppHostProtocol.TCodecs} TCodecs
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TCodecs.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TCodecs message.
         * @function verify
         * @memberof NAppHostProtocol.TCodecs
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TCodecs.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.CodecIds != null && message.hasOwnProperty("CodecIds")) {
                if (!Array.isArray(message.CodecIds))
                    return "CodecIds: array expected";
                for (var i = 0; i < message.CodecIds.length; ++i)
                    if (!$util.isInteger(message.CodecIds[i]))
                        return "CodecIds: integer[] expected";
            }
            return null;
        };

        /**
         * Creates a TCodecs message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NAppHostProtocol.TCodecs
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NAppHostProtocol.TCodecs} TCodecs
         */
        TCodecs.fromObject = function fromObject(object) {
            if (object instanceof $root.NAppHostProtocol.TCodecs)
                return object;
            var message = new $root.NAppHostProtocol.TCodecs();
            if (object.CodecIds) {
                if (!Array.isArray(object.CodecIds))
                    throw TypeError(".NAppHostProtocol.TCodecs.CodecIds: array expected");
                message.CodecIds = [];
                for (var i = 0; i < object.CodecIds.length; ++i)
                    message.CodecIds[i] = object.CodecIds[i] | 0;
            }
            return message;
        };

        /**
         * Creates a plain object from a TCodecs message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NAppHostProtocol.TCodecs
         * @static
         * @param {NAppHostProtocol.TCodecs} message TCodecs
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TCodecs.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.CodecIds = [];
            if (message.CodecIds && message.CodecIds.length) {
                object.CodecIds = [];
                for (var j = 0; j < message.CodecIds.length; ++j)
                    object.CodecIds[j] = message.CodecIds[j];
            }
            return object;
        };

        /**
         * Converts this TCodecs to JSON.
         * @function toJSON
         * @memberof NAppHostProtocol.TCodecs
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TCodecs.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TCodecs;
    })();

    NAppHostProtocol.TMetaFlag = (function() {

        /**
         * Properties of a TMetaFlag.
         * @memberof NAppHostProtocol
         * @interface ITMetaFlag
         * @property {string|null} [SourceName] TMetaFlag SourceName
         * @property {string|null} [FlagName] TMetaFlag FlagName
         */

        /**
         * Constructs a new TMetaFlag.
         * @memberof NAppHostProtocol
         * @classdesc Represents a TMetaFlag.
         * @implements ITMetaFlag
         * @constructor
         * @param {NAppHostProtocol.ITMetaFlag=} [properties] Properties to set
         */
        function TMetaFlag(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TMetaFlag SourceName.
         * @member {string} SourceName
         * @memberof NAppHostProtocol.TMetaFlag
         * @instance
         */
        TMetaFlag.prototype.SourceName = "";

        /**
         * TMetaFlag FlagName.
         * @member {string} FlagName
         * @memberof NAppHostProtocol.TMetaFlag
         * @instance
         */
        TMetaFlag.prototype.FlagName = "";

        /**
         * Creates a new TMetaFlag instance using the specified properties.
         * @function create
         * @memberof NAppHostProtocol.TMetaFlag
         * @static
         * @param {NAppHostProtocol.ITMetaFlag=} [properties] Properties to set
         * @returns {NAppHostProtocol.TMetaFlag} TMetaFlag instance
         */
        TMetaFlag.create = function create(properties) {
            return new TMetaFlag(properties);
        };

        /**
         * Encodes the specified TMetaFlag message. Does not implicitly {@link NAppHostProtocol.TMetaFlag.verify|verify} messages.
         * @function encode
         * @memberof NAppHostProtocol.TMetaFlag
         * @static
         * @param {NAppHostProtocol.ITMetaFlag} message TMetaFlag message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TMetaFlag.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.SourceName != null && Object.hasOwnProperty.call(message, "SourceName"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.SourceName);
            if (message.FlagName != null && Object.hasOwnProperty.call(message, "FlagName"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.FlagName);
            return writer;
        };

        /**
         * Encodes the specified TMetaFlag message, length delimited. Does not implicitly {@link NAppHostProtocol.TMetaFlag.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NAppHostProtocol.TMetaFlag
         * @static
         * @param {NAppHostProtocol.ITMetaFlag} message TMetaFlag message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TMetaFlag.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TMetaFlag message from the specified reader or buffer.
         * @function decode
         * @memberof NAppHostProtocol.TMetaFlag
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NAppHostProtocol.TMetaFlag} TMetaFlag
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TMetaFlag.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAppHostProtocol.TMetaFlag();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.SourceName = reader.string();
                    break;
                case 2:
                    message.FlagName = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TMetaFlag message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NAppHostProtocol.TMetaFlag
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NAppHostProtocol.TMetaFlag} TMetaFlag
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TMetaFlag.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TMetaFlag message.
         * @function verify
         * @memberof NAppHostProtocol.TMetaFlag
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TMetaFlag.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.SourceName != null && message.hasOwnProperty("SourceName"))
                if (!$util.isString(message.SourceName))
                    return "SourceName: string expected";
            if (message.FlagName != null && message.hasOwnProperty("FlagName"))
                if (!$util.isString(message.FlagName))
                    return "FlagName: string expected";
            return null;
        };

        /**
         * Creates a TMetaFlag message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NAppHostProtocol.TMetaFlag
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NAppHostProtocol.TMetaFlag} TMetaFlag
         */
        TMetaFlag.fromObject = function fromObject(object) {
            if (object instanceof $root.NAppHostProtocol.TMetaFlag)
                return object;
            var message = new $root.NAppHostProtocol.TMetaFlag();
            if (object.SourceName != null)
                message.SourceName = String(object.SourceName);
            if (object.FlagName != null)
                message.FlagName = String(object.FlagName);
            return message;
        };

        /**
         * Creates a plain object from a TMetaFlag message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NAppHostProtocol.TMetaFlag
         * @static
         * @param {NAppHostProtocol.TMetaFlag} message TMetaFlag
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TMetaFlag.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.SourceName = "";
                object.FlagName = "";
            }
            if (message.SourceName != null && message.hasOwnProperty("SourceName"))
                object.SourceName = message.SourceName;
            if (message.FlagName != null && message.hasOwnProperty("FlagName"))
                object.FlagName = message.FlagName;
            return object;
        };

        /**
         * Converts this TMetaFlag to JSON.
         * @function toJSON
         * @memberof NAppHostProtocol.TMetaFlag
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TMetaFlag.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TMetaFlag;
    })();

    NAppHostProtocol.TTestId = (function() {

        /**
         * Properties of a TTestId.
         * @memberof NAppHostProtocol
         * @interface ITTestId
         * @property {number|null} [TestId] TTestId TestId
         * @property {number|null} [Slot] TTestId Slot
         * @property {number|null} [Bucket] TTestId Bucket
         */

        /**
         * Constructs a new TTestId.
         * @memberof NAppHostProtocol
         * @classdesc Represents a TTestId.
         * @implements ITTestId
         * @constructor
         * @param {NAppHostProtocol.ITTestId=} [properties] Properties to set
         */
        function TTestId(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TTestId TestId.
         * @member {number} TestId
         * @memberof NAppHostProtocol.TTestId
         * @instance
         */
        TTestId.prototype.TestId = 0;

        /**
         * TTestId Slot.
         * @member {number} Slot
         * @memberof NAppHostProtocol.TTestId
         * @instance
         */
        TTestId.prototype.Slot = 0;

        /**
         * TTestId Bucket.
         * @member {number} Bucket
         * @memberof NAppHostProtocol.TTestId
         * @instance
         */
        TTestId.prototype.Bucket = 0;

        /**
         * Creates a new TTestId instance using the specified properties.
         * @function create
         * @memberof NAppHostProtocol.TTestId
         * @static
         * @param {NAppHostProtocol.ITTestId=} [properties] Properties to set
         * @returns {NAppHostProtocol.TTestId} TTestId instance
         */
        TTestId.create = function create(properties) {
            return new TTestId(properties);
        };

        /**
         * Encodes the specified TTestId message. Does not implicitly {@link NAppHostProtocol.TTestId.verify|verify} messages.
         * @function encode
         * @memberof NAppHostProtocol.TTestId
         * @static
         * @param {NAppHostProtocol.ITTestId} message TTestId message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TTestId.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.TestId != null && Object.hasOwnProperty.call(message, "TestId"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.TestId);
            if (message.Slot != null && Object.hasOwnProperty.call(message, "Slot"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.Slot);
            if (message.Bucket != null && Object.hasOwnProperty.call(message, "Bucket"))
                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.Bucket);
            return writer;
        };

        /**
         * Encodes the specified TTestId message, length delimited. Does not implicitly {@link NAppHostProtocol.TTestId.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NAppHostProtocol.TTestId
         * @static
         * @param {NAppHostProtocol.ITTestId} message TTestId message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TTestId.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TTestId message from the specified reader or buffer.
         * @function decode
         * @memberof NAppHostProtocol.TTestId
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NAppHostProtocol.TTestId} TTestId
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TTestId.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAppHostProtocol.TTestId();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.TestId = reader.int32();
                    break;
                case 2:
                    message.Slot = reader.int32();
                    break;
                case 3:
                    message.Bucket = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TTestId message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NAppHostProtocol.TTestId
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NAppHostProtocol.TTestId} TTestId
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TTestId.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TTestId message.
         * @function verify
         * @memberof NAppHostProtocol.TTestId
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TTestId.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.TestId != null && message.hasOwnProperty("TestId"))
                if (!$util.isInteger(message.TestId))
                    return "TestId: integer expected";
            if (message.Slot != null && message.hasOwnProperty("Slot"))
                if (!$util.isInteger(message.Slot))
                    return "Slot: integer expected";
            if (message.Bucket != null && message.hasOwnProperty("Bucket"))
                if (!$util.isInteger(message.Bucket))
                    return "Bucket: integer expected";
            return null;
        };

        /**
         * Creates a TTestId message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NAppHostProtocol.TTestId
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NAppHostProtocol.TTestId} TTestId
         */
        TTestId.fromObject = function fromObject(object) {
            if (object instanceof $root.NAppHostProtocol.TTestId)
                return object;
            var message = new $root.NAppHostProtocol.TTestId();
            if (object.TestId != null)
                message.TestId = object.TestId | 0;
            if (object.Slot != null)
                message.Slot = object.Slot | 0;
            if (object.Bucket != null)
                message.Bucket = object.Bucket | 0;
            return message;
        };

        /**
         * Creates a plain object from a TTestId message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NAppHostProtocol.TTestId
         * @static
         * @param {NAppHostProtocol.TTestId} message TTestId
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TTestId.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.TestId = 0;
                object.Slot = 0;
                object.Bucket = 0;
            }
            if (message.TestId != null && message.hasOwnProperty("TestId"))
                object.TestId = message.TestId;
            if (message.Slot != null && message.hasOwnProperty("Slot"))
                object.Slot = message.Slot;
            if (message.Bucket != null && message.hasOwnProperty("Bucket"))
                object.Bucket = message.Bucket;
            return object;
        };

        /**
         * Converts this TTestId to JSON.
         * @function toJSON
         * @memberof NAppHostProtocol.TTestId
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TTestId.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TTestId;
    })();

    NAppHostProtocol.TTestIds = (function() {

        /**
         * Properties of a TTestIds.
         * @memberof NAppHostProtocol
         * @interface ITTestIds
         * @property {Array.<NAppHostProtocol.ITTestId>|null} [TestIds] TTestIds TestIds
         */

        /**
         * Constructs a new TTestIds.
         * @memberof NAppHostProtocol
         * @classdesc Represents a TTestIds.
         * @implements ITTestIds
         * @constructor
         * @param {NAppHostProtocol.ITTestIds=} [properties] Properties to set
         */
        function TTestIds(properties) {
            this.TestIds = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TTestIds TestIds.
         * @member {Array.<NAppHostProtocol.ITTestId>} TestIds
         * @memberof NAppHostProtocol.TTestIds
         * @instance
         */
        TTestIds.prototype.TestIds = $util.emptyArray;

        /**
         * Creates a new TTestIds instance using the specified properties.
         * @function create
         * @memberof NAppHostProtocol.TTestIds
         * @static
         * @param {NAppHostProtocol.ITTestIds=} [properties] Properties to set
         * @returns {NAppHostProtocol.TTestIds} TTestIds instance
         */
        TTestIds.create = function create(properties) {
            return new TTestIds(properties);
        };

        /**
         * Encodes the specified TTestIds message. Does not implicitly {@link NAppHostProtocol.TTestIds.verify|verify} messages.
         * @function encode
         * @memberof NAppHostProtocol.TTestIds
         * @static
         * @param {NAppHostProtocol.ITTestIds} message TTestIds message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TTestIds.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.TestIds != null && message.TestIds.length)
                for (var i = 0; i < message.TestIds.length; ++i)
                    $root.NAppHostProtocol.TTestId.encode(message.TestIds[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified TTestIds message, length delimited. Does not implicitly {@link NAppHostProtocol.TTestIds.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NAppHostProtocol.TTestIds
         * @static
         * @param {NAppHostProtocol.ITTestIds} message TTestIds message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TTestIds.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TTestIds message from the specified reader or buffer.
         * @function decode
         * @memberof NAppHostProtocol.TTestIds
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NAppHostProtocol.TTestIds} TTestIds
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TTestIds.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAppHostProtocol.TTestIds();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    if (!(message.TestIds && message.TestIds.length))
                        message.TestIds = [];
                    message.TestIds.push($root.NAppHostProtocol.TTestId.decode(reader, reader.uint32()));
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TTestIds message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NAppHostProtocol.TTestIds
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NAppHostProtocol.TTestIds} TTestIds
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TTestIds.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TTestIds message.
         * @function verify
         * @memberof NAppHostProtocol.TTestIds
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TTestIds.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.TestIds != null && message.hasOwnProperty("TestIds")) {
                if (!Array.isArray(message.TestIds))
                    return "TestIds: array expected";
                for (var i = 0; i < message.TestIds.length; ++i) {
                    var error = $root.NAppHostProtocol.TTestId.verify(message.TestIds[i]);
                    if (error)
                        return "TestIds." + error;
                }
            }
            return null;
        };

        /**
         * Creates a TTestIds message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NAppHostProtocol.TTestIds
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NAppHostProtocol.TTestIds} TTestIds
         */
        TTestIds.fromObject = function fromObject(object) {
            if (object instanceof $root.NAppHostProtocol.TTestIds)
                return object;
            var message = new $root.NAppHostProtocol.TTestIds();
            if (object.TestIds) {
                if (!Array.isArray(object.TestIds))
                    throw TypeError(".NAppHostProtocol.TTestIds.TestIds: array expected");
                message.TestIds = [];
                for (var i = 0; i < object.TestIds.length; ++i) {
                    if (typeof object.TestIds[i] !== "object")
                        throw TypeError(".NAppHostProtocol.TTestIds.TestIds: object expected");
                    message.TestIds[i] = $root.NAppHostProtocol.TTestId.fromObject(object.TestIds[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a TTestIds message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NAppHostProtocol.TTestIds
         * @static
         * @param {NAppHostProtocol.TTestIds} message TTestIds
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TTestIds.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.TestIds = [];
            if (message.TestIds && message.TestIds.length) {
                object.TestIds = [];
                for (var j = 0; j < message.TestIds.length; ++j)
                    object.TestIds[j] = $root.NAppHostProtocol.TTestId.toObject(message.TestIds[j], options);
            }
            return object;
        };

        /**
         * Converts this TTestIds to JSON.
         * @function toJSON
         * @memberof NAppHostProtocol.TTestIds
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TTestIds.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TTestIds;
    })();

    NAppHostProtocol.TLocation = (function() {

        /**
         * Properties of a TLocation.
         * @memberof NAppHostProtocol
         * @interface ITLocation
         * @property {string|null} [Path] TLocation Path
         * @property {string|null} [Name] TLocation Name
         */

        /**
         * Constructs a new TLocation.
         * @memberof NAppHostProtocol
         * @classdesc Represents a TLocation.
         * @implements ITLocation
         * @constructor
         * @param {NAppHostProtocol.ITLocation=} [properties] Properties to set
         */
        function TLocation(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TLocation Path.
         * @member {string} Path
         * @memberof NAppHostProtocol.TLocation
         * @instance
         */
        TLocation.prototype.Path = "";

        /**
         * TLocation Name.
         * @member {string} Name
         * @memberof NAppHostProtocol.TLocation
         * @instance
         */
        TLocation.prototype.Name = "";

        /**
         * Creates a new TLocation instance using the specified properties.
         * @function create
         * @memberof NAppHostProtocol.TLocation
         * @static
         * @param {NAppHostProtocol.ITLocation=} [properties] Properties to set
         * @returns {NAppHostProtocol.TLocation} TLocation instance
         */
        TLocation.create = function create(properties) {
            return new TLocation(properties);
        };

        /**
         * Encodes the specified TLocation message. Does not implicitly {@link NAppHostProtocol.TLocation.verify|verify} messages.
         * @function encode
         * @memberof NAppHostProtocol.TLocation
         * @static
         * @param {NAppHostProtocol.ITLocation} message TLocation message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TLocation.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.Path != null && Object.hasOwnProperty.call(message, "Path"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.Path);
            if (message.Name != null && Object.hasOwnProperty.call(message, "Name"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.Name);
            return writer;
        };

        /**
         * Encodes the specified TLocation message, length delimited. Does not implicitly {@link NAppHostProtocol.TLocation.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NAppHostProtocol.TLocation
         * @static
         * @param {NAppHostProtocol.ITLocation} message TLocation message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TLocation.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TLocation message from the specified reader or buffer.
         * @function decode
         * @memberof NAppHostProtocol.TLocation
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NAppHostProtocol.TLocation} TLocation
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TLocation.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAppHostProtocol.TLocation();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.Path = reader.string();
                    break;
                case 2:
                    message.Name = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TLocation message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NAppHostProtocol.TLocation
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NAppHostProtocol.TLocation} TLocation
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TLocation.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TLocation message.
         * @function verify
         * @memberof NAppHostProtocol.TLocation
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TLocation.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.Path != null && message.hasOwnProperty("Path"))
                if (!$util.isString(message.Path))
                    return "Path: string expected";
            if (message.Name != null && message.hasOwnProperty("Name"))
                if (!$util.isString(message.Name))
                    return "Name: string expected";
            return null;
        };

        /**
         * Creates a TLocation message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NAppHostProtocol.TLocation
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NAppHostProtocol.TLocation} TLocation
         */
        TLocation.fromObject = function fromObject(object) {
            if (object instanceof $root.NAppHostProtocol.TLocation)
                return object;
            var message = new $root.NAppHostProtocol.TLocation();
            if (object.Path != null)
                message.Path = String(object.Path);
            if (object.Name != null)
                message.Name = String(object.Name);
            return message;
        };

        /**
         * Creates a plain object from a TLocation message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NAppHostProtocol.TLocation
         * @static
         * @param {NAppHostProtocol.TLocation} message TLocation
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TLocation.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.Path = "";
                object.Name = "";
            }
            if (message.Path != null && message.hasOwnProperty("Path"))
                object.Path = message.Path;
            if (message.Name != null && message.hasOwnProperty("Name"))
                object.Name = message.Name;
            return object;
        };

        /**
         * Converts this TLocation to JSON.
         * @function toJSON
         * @memberof NAppHostProtocol.TLocation
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TLocation.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TLocation;
    })();

    NAppHostProtocol.TRequestInfo = (function() {

        /**
         * Properties of a TRequestInfo.
         * @memberof NAppHostProtocol
         * @interface ITRequestInfo
         * @property {string|null} [Reqid] TRequestInfo Reqid
         * @property {string|null} [Guid] TRequestInfo Guid
         * @property {number|null} [Ruid] TRequestInfo Ruid
         * @property {NAppHostProtocol.ITLocation|null} [Location] TRequestInfo Location
         */

        /**
         * Constructs a new TRequestInfo.
         * @memberof NAppHostProtocol
         * @classdesc Represents a TRequestInfo.
         * @implements ITRequestInfo
         * @constructor
         * @param {NAppHostProtocol.ITRequestInfo=} [properties] Properties to set
         */
        function TRequestInfo(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TRequestInfo Reqid.
         * @member {string} Reqid
         * @memberof NAppHostProtocol.TRequestInfo
         * @instance
         */
        TRequestInfo.prototype.Reqid = "";

        /**
         * TRequestInfo Guid.
         * @member {string} Guid
         * @memberof NAppHostProtocol.TRequestInfo
         * @instance
         */
        TRequestInfo.prototype.Guid = "";

        /**
         * TRequestInfo Ruid.
         * @member {number} Ruid
         * @memberof NAppHostProtocol.TRequestInfo
         * @instance
         */
        TRequestInfo.prototype.Ruid = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * TRequestInfo Location.
         * @member {NAppHostProtocol.ITLocation|null|undefined} Location
         * @memberof NAppHostProtocol.TRequestInfo
         * @instance
         */
        TRequestInfo.prototype.Location = null;

        /**
         * Creates a new TRequestInfo instance using the specified properties.
         * @function create
         * @memberof NAppHostProtocol.TRequestInfo
         * @static
         * @param {NAppHostProtocol.ITRequestInfo=} [properties] Properties to set
         * @returns {NAppHostProtocol.TRequestInfo} TRequestInfo instance
         */
        TRequestInfo.create = function create(properties) {
            return new TRequestInfo(properties);
        };

        /**
         * Encodes the specified TRequestInfo message. Does not implicitly {@link NAppHostProtocol.TRequestInfo.verify|verify} messages.
         * @function encode
         * @memberof NAppHostProtocol.TRequestInfo
         * @static
         * @param {NAppHostProtocol.ITRequestInfo} message TRequestInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TRequestInfo.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.Reqid != null && Object.hasOwnProperty.call(message, "Reqid"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.Reqid);
            if (message.Guid != null && Object.hasOwnProperty.call(message, "Guid"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.Guid);
            if (message.Ruid != null && Object.hasOwnProperty.call(message, "Ruid"))
                writer.uint32(/* id 3, wireType 0 =*/24).uint64(message.Ruid);
            if (message.Location != null && Object.hasOwnProperty.call(message, "Location"))
                $root.NAppHostProtocol.TLocation.encode(message.Location, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified TRequestInfo message, length delimited. Does not implicitly {@link NAppHostProtocol.TRequestInfo.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NAppHostProtocol.TRequestInfo
         * @static
         * @param {NAppHostProtocol.ITRequestInfo} message TRequestInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TRequestInfo.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TRequestInfo message from the specified reader or buffer.
         * @function decode
         * @memberof NAppHostProtocol.TRequestInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NAppHostProtocol.TRequestInfo} TRequestInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TRequestInfo.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAppHostProtocol.TRequestInfo();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.Reqid = reader.string();
                    break;
                case 2:
                    message.Guid = reader.string();
                    break;
                case 3:
                    message.Ruid = reader.uint64();
                    break;
                case 4:
                    message.Location = $root.NAppHostProtocol.TLocation.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TRequestInfo message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NAppHostProtocol.TRequestInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NAppHostProtocol.TRequestInfo} TRequestInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TRequestInfo.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TRequestInfo message.
         * @function verify
         * @memberof NAppHostProtocol.TRequestInfo
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TRequestInfo.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.Reqid != null && message.hasOwnProperty("Reqid"))
                if (!$util.isString(message.Reqid))
                    return "Reqid: string expected";
            if (message.Guid != null && message.hasOwnProperty("Guid"))
                if (!$util.isString(message.Guid))
                    return "Guid: string expected";
            if (message.Ruid != null && message.hasOwnProperty("Ruid"))
                if (!$util.isInteger(message.Ruid) && !(message.Ruid && $util.isInteger(message.Ruid.low) && $util.isInteger(message.Ruid.high)))
                    return "Ruid: integer|Long expected";
            if (message.Location != null && message.hasOwnProperty("Location")) {
                var error = $root.NAppHostProtocol.TLocation.verify(message.Location);
                if (error)
                    return "Location." + error;
            }
            return null;
        };

        /**
         * Creates a TRequestInfo message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NAppHostProtocol.TRequestInfo
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NAppHostProtocol.TRequestInfo} TRequestInfo
         */
        TRequestInfo.fromObject = function fromObject(object) {
            if (object instanceof $root.NAppHostProtocol.TRequestInfo)
                return object;
            var message = new $root.NAppHostProtocol.TRequestInfo();
            if (object.Reqid != null)
                message.Reqid = String(object.Reqid);
            if (object.Guid != null)
                message.Guid = String(object.Guid);
            if (object.Ruid != null)
                if ($util.Long)
                    (message.Ruid = $util.Long.fromValue(object.Ruid)).unsigned = true;
                else if (typeof object.Ruid === "string")
                    message.Ruid = parseInt(object.Ruid, 10);
                else if (typeof object.Ruid === "number")
                    message.Ruid = object.Ruid;
                else if (typeof object.Ruid === "object")
                    message.Ruid = new $util.LongBits(object.Ruid.low >>> 0, object.Ruid.high >>> 0).toNumber(true);
            if (object.Location != null) {
                if (typeof object.Location !== "object")
                    throw TypeError(".NAppHostProtocol.TRequestInfo.Location: object expected");
                message.Location = $root.NAppHostProtocol.TLocation.fromObject(object.Location);
            }
            return message;
        };

        /**
         * Creates a plain object from a TRequestInfo message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NAppHostProtocol.TRequestInfo
         * @static
         * @param {NAppHostProtocol.TRequestInfo} message TRequestInfo
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TRequestInfo.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.Reqid = "";
                object.Guid = "";
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.Ruid = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.Ruid = options.longs === String ? "0" : 0;
                object.Location = null;
            }
            if (message.Reqid != null && message.hasOwnProperty("Reqid"))
                object.Reqid = message.Reqid;
            if (message.Guid != null && message.hasOwnProperty("Guid"))
                object.Guid = message.Guid;
            if (message.Ruid != null && message.hasOwnProperty("Ruid"))
                if (typeof message.Ruid === "number")
                    object.Ruid = options.longs === String ? String(message.Ruid) : message.Ruid;
                else
                    object.Ruid = options.longs === String ? $util.Long.prototype.toString.call(message.Ruid) : options.longs === Number ? new $util.LongBits(message.Ruid.low >>> 0, message.Ruid.high >>> 0).toNumber(true) : message.Ruid;
            if (message.Location != null && message.hasOwnProperty("Location"))
                object.Location = $root.NAppHostProtocol.TLocation.toObject(message.Location, options);
            return object;
        };

        /**
         * Converts this TRequestInfo to JSON.
         * @function toJSON
         * @memberof NAppHostProtocol.TRequestInfo
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TRequestInfo.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TRequestInfo;
    })();

    NAppHostProtocol.TServiceRequest = (function() {

        /**
         * Properties of a TServiceRequest.
         * @memberof NAppHostProtocol
         * @interface ITServiceRequest
         * @property {string|null} [Guid] TServiceRequest Guid
         * @property {Array.<NAppHostProtocol.ITAnswer>|null} [Answers] TServiceRequest Answers
         * @property {NAppHostProtocol.ITCodecs|null} [Codecs] TServiceRequest Codecs
         * @property {string|null} [Path] TServiceRequest Path
         * @property {number|null} [Ruid] TServiceRequest Ruid
         * @property {boolean|null} [Last] TServiceRequest Last
         * @property {Array.<NAppHostProtocol.ITMetaFlag>|null} [MetaFlags] TServiceRequest MetaFlags
         * @property {string|null} [Ticket] TServiceRequest Ticket
         * @property {number|null} [Json2YsonMode] TServiceRequest Json2YsonMode
         * @property {NAppHost.ESerializationFormat|null} [JsonSerializationFormat] TServiceRequest JsonSerializationFormat
         * @property {Array.<string>|null} [FinishedDeps] TServiceRequest FinishedDeps
         * @property {boolean|null} [DumpProtobufSchema] TServiceRequest DumpProtobufSchema
         * @property {NAppHostProtocol.TServiceRequest.ERequestAttemptType|null} [RequestAttemptType] TServiceRequest RequestAttemptType
         * @property {boolean|null} [EnableDumpRequest] TServiceRequest EnableDumpRequest
         * @property {number|null} [SendTimestamp] TServiceRequest SendTimestamp
         * @property {boolean|null} [JsonToProto] TServiceRequest JsonToProto
         * @property {boolean|null} [ProtoToJson] TServiceRequest ProtoToJson
         * @property {Array.<NAppHostProtocol.ITHint>|null} [Hints] TServiceRequest Hints
         * @property {NAppHostProtocol.ITTestIds|null} [TestIds] TServiceRequest TestIds
         * @property {NAppHostProtocol.ITRequestInfo|null} [RequestInfo] TServiceRequest RequestInfo
         * @property {string|null} [RtLog] TServiceRequest RtLog
         */

        /**
         * Constructs a new TServiceRequest.
         * @memberof NAppHostProtocol
         * @classdesc Represents a TServiceRequest.
         * @implements ITServiceRequest
         * @constructor
         * @param {NAppHostProtocol.ITServiceRequest=} [properties] Properties to set
         */
        function TServiceRequest(properties) {
            this.Answers = [];
            this.MetaFlags = [];
            this.FinishedDeps = [];
            this.Hints = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TServiceRequest Guid.
         * @member {string} Guid
         * @memberof NAppHostProtocol.TServiceRequest
         * @instance
         */
        TServiceRequest.prototype.Guid = "";

        /**
         * TServiceRequest Answers.
         * @member {Array.<NAppHostProtocol.ITAnswer>} Answers
         * @memberof NAppHostProtocol.TServiceRequest
         * @instance
         */
        TServiceRequest.prototype.Answers = $util.emptyArray;

        /**
         * TServiceRequest Codecs.
         * @member {NAppHostProtocol.ITCodecs|null|undefined} Codecs
         * @memberof NAppHostProtocol.TServiceRequest
         * @instance
         */
        TServiceRequest.prototype.Codecs = null;

        /**
         * TServiceRequest Path.
         * @member {string} Path
         * @memberof NAppHostProtocol.TServiceRequest
         * @instance
         */
        TServiceRequest.prototype.Path = "";

        /**
         * TServiceRequest Ruid.
         * @member {number} Ruid
         * @memberof NAppHostProtocol.TServiceRequest
         * @instance
         */
        TServiceRequest.prototype.Ruid = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * TServiceRequest Last.
         * @member {boolean} Last
         * @memberof NAppHostProtocol.TServiceRequest
         * @instance
         */
        TServiceRequest.prototype.Last = false;

        /**
         * TServiceRequest MetaFlags.
         * @member {Array.<NAppHostProtocol.ITMetaFlag>} MetaFlags
         * @memberof NAppHostProtocol.TServiceRequest
         * @instance
         */
        TServiceRequest.prototype.MetaFlags = $util.emptyArray;

        /**
         * TServiceRequest Ticket.
         * @member {string} Ticket
         * @memberof NAppHostProtocol.TServiceRequest
         * @instance
         */
        TServiceRequest.prototype.Ticket = "";

        /**
         * TServiceRequest Json2YsonMode.
         * @member {number} Json2YsonMode
         * @memberof NAppHostProtocol.TServiceRequest
         * @instance
         */
        TServiceRequest.prototype.Json2YsonMode = 0;

        /**
         * TServiceRequest JsonSerializationFormat.
         * @member {NAppHost.ESerializationFormat} JsonSerializationFormat
         * @memberof NAppHostProtocol.TServiceRequest
         * @instance
         */
        TServiceRequest.prototype.JsonSerializationFormat = 0;

        /**
         * TServiceRequest FinishedDeps.
         * @member {Array.<string>} FinishedDeps
         * @memberof NAppHostProtocol.TServiceRequest
         * @instance
         */
        TServiceRequest.prototype.FinishedDeps = $util.emptyArray;

        /**
         * TServiceRequest DumpProtobufSchema.
         * @member {boolean} DumpProtobufSchema
         * @memberof NAppHostProtocol.TServiceRequest
         * @instance
         */
        TServiceRequest.prototype.DumpProtobufSchema = false;

        /**
         * TServiceRequest RequestAttemptType.
         * @member {NAppHostProtocol.TServiceRequest.ERequestAttemptType} RequestAttemptType
         * @memberof NAppHostProtocol.TServiceRequest
         * @instance
         */
        TServiceRequest.prototype.RequestAttemptType = 0;

        /**
         * TServiceRequest EnableDumpRequest.
         * @member {boolean} EnableDumpRequest
         * @memberof NAppHostProtocol.TServiceRequest
         * @instance
         */
        TServiceRequest.prototype.EnableDumpRequest = false;

        /**
         * TServiceRequest SendTimestamp.
         * @member {number} SendTimestamp
         * @memberof NAppHostProtocol.TServiceRequest
         * @instance
         */
        TServiceRequest.prototype.SendTimestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * TServiceRequest JsonToProto.
         * @member {boolean} JsonToProto
         * @memberof NAppHostProtocol.TServiceRequest
         * @instance
         */
        TServiceRequest.prototype.JsonToProto = false;

        /**
         * TServiceRequest ProtoToJson.
         * @member {boolean} ProtoToJson
         * @memberof NAppHostProtocol.TServiceRequest
         * @instance
         */
        TServiceRequest.prototype.ProtoToJson = false;

        /**
         * TServiceRequest Hints.
         * @member {Array.<NAppHostProtocol.ITHint>} Hints
         * @memberof NAppHostProtocol.TServiceRequest
         * @instance
         */
        TServiceRequest.prototype.Hints = $util.emptyArray;

        /**
         * TServiceRequest TestIds.
         * @member {NAppHostProtocol.ITTestIds|null|undefined} TestIds
         * @memberof NAppHostProtocol.TServiceRequest
         * @instance
         */
        TServiceRequest.prototype.TestIds = null;

        /**
         * TServiceRequest RequestInfo.
         * @member {NAppHostProtocol.ITRequestInfo|null|undefined} RequestInfo
         * @memberof NAppHostProtocol.TServiceRequest
         * @instance
         */
        TServiceRequest.prototype.RequestInfo = null;

        /**
         * TServiceRequest RtLog.
         * @member {string} RtLog
         * @memberof NAppHostProtocol.TServiceRequest
         * @instance
         */
        TServiceRequest.prototype.RtLog = "";

        /**
         * Creates a new TServiceRequest instance using the specified properties.
         * @function create
         * @memberof NAppHostProtocol.TServiceRequest
         * @static
         * @param {NAppHostProtocol.ITServiceRequest=} [properties] Properties to set
         * @returns {NAppHostProtocol.TServiceRequest} TServiceRequest instance
         */
        TServiceRequest.create = function create(properties) {
            return new TServiceRequest(properties);
        };

        /**
         * Encodes the specified TServiceRequest message. Does not implicitly {@link NAppHostProtocol.TServiceRequest.verify|verify} messages.
         * @function encode
         * @memberof NAppHostProtocol.TServiceRequest
         * @static
         * @param {NAppHostProtocol.ITServiceRequest} message TServiceRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TServiceRequest.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.Guid != null && Object.hasOwnProperty.call(message, "Guid"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.Guid);
            if (message.Answers != null && message.Answers.length)
                for (var i = 0; i < message.Answers.length; ++i)
                    $root.NAppHostProtocol.TAnswer.encode(message.Answers[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.Codecs != null && Object.hasOwnProperty.call(message, "Codecs"))
                $root.NAppHostProtocol.TCodecs.encode(message.Codecs, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
            if (message.Path != null && Object.hasOwnProperty.call(message, "Path"))
                writer.uint32(/* id 6, wireType 2 =*/50).string(message.Path);
            if (message.Ruid != null && Object.hasOwnProperty.call(message, "Ruid"))
                writer.uint32(/* id 7, wireType 0 =*/56).uint64(message.Ruid);
            if (message.Last != null && Object.hasOwnProperty.call(message, "Last"))
                writer.uint32(/* id 8, wireType 0 =*/64).bool(message.Last);
            if (message.MetaFlags != null && message.MetaFlags.length)
                for (var i = 0; i < message.MetaFlags.length; ++i)
                    $root.NAppHostProtocol.TMetaFlag.encode(message.MetaFlags[i], writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
            if (message.Ticket != null && Object.hasOwnProperty.call(message, "Ticket"))
                writer.uint32(/* id 11, wireType 2 =*/90).string(message.Ticket);
            if (message.Json2YsonMode != null && Object.hasOwnProperty.call(message, "Json2YsonMode"))
                writer.uint32(/* id 12, wireType 0 =*/96).uint32(message.Json2YsonMode);
            if (message.FinishedDeps != null && message.FinishedDeps.length)
                for (var i = 0; i < message.FinishedDeps.length; ++i)
                    writer.uint32(/* id 15, wireType 2 =*/122).string(message.FinishedDeps[i]);
            if (message.DumpProtobufSchema != null && Object.hasOwnProperty.call(message, "DumpProtobufSchema"))
                writer.uint32(/* id 16, wireType 0 =*/128).bool(message.DumpProtobufSchema);
            if (message.RequestAttemptType != null && Object.hasOwnProperty.call(message, "RequestAttemptType"))
                writer.uint32(/* id 17, wireType 0 =*/136).int32(message.RequestAttemptType);
            if (message.JsonSerializationFormat != null && Object.hasOwnProperty.call(message, "JsonSerializationFormat"))
                writer.uint32(/* id 18, wireType 0 =*/144).int32(message.JsonSerializationFormat);
            if (message.EnableDumpRequest != null && Object.hasOwnProperty.call(message, "EnableDumpRequest"))
                writer.uint32(/* id 19, wireType 0 =*/152).bool(message.EnableDumpRequest);
            if (message.SendTimestamp != null && Object.hasOwnProperty.call(message, "SendTimestamp"))
                writer.uint32(/* id 22, wireType 0 =*/176).uint64(message.SendTimestamp);
            if (message.JsonToProto != null && Object.hasOwnProperty.call(message, "JsonToProto"))
                writer.uint32(/* id 24, wireType 0 =*/192).bool(message.JsonToProto);
            if (message.ProtoToJson != null && Object.hasOwnProperty.call(message, "ProtoToJson"))
                writer.uint32(/* id 26, wireType 0 =*/208).bool(message.ProtoToJson);
            if (message.Hints != null && message.Hints.length)
                for (var i = 0; i < message.Hints.length; ++i)
                    $root.NAppHostProtocol.THint.encode(message.Hints[i], writer.uint32(/* id 27, wireType 2 =*/218).fork()).ldelim();
            if (message.TestIds != null && Object.hasOwnProperty.call(message, "TestIds"))
                $root.NAppHostProtocol.TTestIds.encode(message.TestIds, writer.uint32(/* id 28, wireType 2 =*/226).fork()).ldelim();
            if (message.RequestInfo != null && Object.hasOwnProperty.call(message, "RequestInfo"))
                $root.NAppHostProtocol.TRequestInfo.encode(message.RequestInfo, writer.uint32(/* id 29, wireType 2 =*/234).fork()).ldelim();
            if (message.RtLog != null && Object.hasOwnProperty.call(message, "RtLog"))
                writer.uint32(/* id 30, wireType 2 =*/242).string(message.RtLog);
            return writer;
        };

        /**
         * Encodes the specified TServiceRequest message, length delimited. Does not implicitly {@link NAppHostProtocol.TServiceRequest.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NAppHostProtocol.TServiceRequest
         * @static
         * @param {NAppHostProtocol.ITServiceRequest} message TServiceRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TServiceRequest.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TServiceRequest message from the specified reader or buffer.
         * @function decode
         * @memberof NAppHostProtocol.TServiceRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NAppHostProtocol.TServiceRequest} TServiceRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TServiceRequest.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAppHostProtocol.TServiceRequest();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.Guid = reader.string();
                    break;
                case 2:
                    if (!(message.Answers && message.Answers.length))
                        message.Answers = [];
                    message.Answers.push($root.NAppHostProtocol.TAnswer.decode(reader, reader.uint32()));
                    break;
                case 5:
                    message.Codecs = $root.NAppHostProtocol.TCodecs.decode(reader, reader.uint32());
                    break;
                case 6:
                    message.Path = reader.string();
                    break;
                case 7:
                    message.Ruid = reader.uint64();
                    break;
                case 8:
                    message.Last = reader.bool();
                    break;
                case 9:
                    if (!(message.MetaFlags && message.MetaFlags.length))
                        message.MetaFlags = [];
                    message.MetaFlags.push($root.NAppHostProtocol.TMetaFlag.decode(reader, reader.uint32()));
                    break;
                case 11:
                    message.Ticket = reader.string();
                    break;
                case 12:
                    message.Json2YsonMode = reader.uint32();
                    break;
                case 18:
                    message.JsonSerializationFormat = reader.int32();
                    break;
                case 15:
                    if (!(message.FinishedDeps && message.FinishedDeps.length))
                        message.FinishedDeps = [];
                    message.FinishedDeps.push(reader.string());
                    break;
                case 16:
                    message.DumpProtobufSchema = reader.bool();
                    break;
                case 17:
                    message.RequestAttemptType = reader.int32();
                    break;
                case 19:
                    message.EnableDumpRequest = reader.bool();
                    break;
                case 22:
                    message.SendTimestamp = reader.uint64();
                    break;
                case 24:
                    message.JsonToProto = reader.bool();
                    break;
                case 26:
                    message.ProtoToJson = reader.bool();
                    break;
                case 27:
                    if (!(message.Hints && message.Hints.length))
                        message.Hints = [];
                    message.Hints.push($root.NAppHostProtocol.THint.decode(reader, reader.uint32()));
                    break;
                case 28:
                    message.TestIds = $root.NAppHostProtocol.TTestIds.decode(reader, reader.uint32());
                    break;
                case 29:
                    message.RequestInfo = $root.NAppHostProtocol.TRequestInfo.decode(reader, reader.uint32());
                    break;
                case 30:
                    message.RtLog = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TServiceRequest message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NAppHostProtocol.TServiceRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NAppHostProtocol.TServiceRequest} TServiceRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TServiceRequest.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TServiceRequest message.
         * @function verify
         * @memberof NAppHostProtocol.TServiceRequest
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TServiceRequest.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.Guid != null && message.hasOwnProperty("Guid"))
                if (!$util.isString(message.Guid))
                    return "Guid: string expected";
            if (message.Answers != null && message.hasOwnProperty("Answers")) {
                if (!Array.isArray(message.Answers))
                    return "Answers: array expected";
                for (var i = 0; i < message.Answers.length; ++i) {
                    var error = $root.NAppHostProtocol.TAnswer.verify(message.Answers[i]);
                    if (error)
                        return "Answers." + error;
                }
            }
            if (message.Codecs != null && message.hasOwnProperty("Codecs")) {
                var error = $root.NAppHostProtocol.TCodecs.verify(message.Codecs);
                if (error)
                    return "Codecs." + error;
            }
            if (message.Path != null && message.hasOwnProperty("Path"))
                if (!$util.isString(message.Path))
                    return "Path: string expected";
            if (message.Ruid != null && message.hasOwnProperty("Ruid"))
                if (!$util.isInteger(message.Ruid) && !(message.Ruid && $util.isInteger(message.Ruid.low) && $util.isInteger(message.Ruid.high)))
                    return "Ruid: integer|Long expected";
            if (message.Last != null && message.hasOwnProperty("Last"))
                if (typeof message.Last !== "boolean")
                    return "Last: boolean expected";
            if (message.MetaFlags != null && message.hasOwnProperty("MetaFlags")) {
                if (!Array.isArray(message.MetaFlags))
                    return "MetaFlags: array expected";
                for (var i = 0; i < message.MetaFlags.length; ++i) {
                    var error = $root.NAppHostProtocol.TMetaFlag.verify(message.MetaFlags[i]);
                    if (error)
                        return "MetaFlags." + error;
                }
            }
            if (message.Ticket != null && message.hasOwnProperty("Ticket"))
                if (!$util.isString(message.Ticket))
                    return "Ticket: string expected";
            if (message.Json2YsonMode != null && message.hasOwnProperty("Json2YsonMode"))
                if (!$util.isInteger(message.Json2YsonMode))
                    return "Json2YsonMode: integer expected";
            if (message.JsonSerializationFormat != null && message.hasOwnProperty("JsonSerializationFormat"))
                switch (message.JsonSerializationFormat) {
                default:
                    return "JsonSerializationFormat: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            if (message.FinishedDeps != null && message.hasOwnProperty("FinishedDeps")) {
                if (!Array.isArray(message.FinishedDeps))
                    return "FinishedDeps: array expected";
                for (var i = 0; i < message.FinishedDeps.length; ++i)
                    if (!$util.isString(message.FinishedDeps[i]))
                        return "FinishedDeps: string[] expected";
            }
            if (message.DumpProtobufSchema != null && message.hasOwnProperty("DumpProtobufSchema"))
                if (typeof message.DumpProtobufSchema !== "boolean")
                    return "DumpProtobufSchema: boolean expected";
            if (message.RequestAttemptType != null && message.hasOwnProperty("RequestAttemptType"))
                switch (message.RequestAttemptType) {
                default:
                    return "RequestAttemptType: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            if (message.EnableDumpRequest != null && message.hasOwnProperty("EnableDumpRequest"))
                if (typeof message.EnableDumpRequest !== "boolean")
                    return "EnableDumpRequest: boolean expected";
            if (message.SendTimestamp != null && message.hasOwnProperty("SendTimestamp"))
                if (!$util.isInteger(message.SendTimestamp) && !(message.SendTimestamp && $util.isInteger(message.SendTimestamp.low) && $util.isInteger(message.SendTimestamp.high)))
                    return "SendTimestamp: integer|Long expected";
            if (message.JsonToProto != null && message.hasOwnProperty("JsonToProto"))
                if (typeof message.JsonToProto !== "boolean")
                    return "JsonToProto: boolean expected";
            if (message.ProtoToJson != null && message.hasOwnProperty("ProtoToJson"))
                if (typeof message.ProtoToJson !== "boolean")
                    return "ProtoToJson: boolean expected";
            if (message.Hints != null && message.hasOwnProperty("Hints")) {
                if (!Array.isArray(message.Hints))
                    return "Hints: array expected";
                for (var i = 0; i < message.Hints.length; ++i) {
                    var error = $root.NAppHostProtocol.THint.verify(message.Hints[i]);
                    if (error)
                        return "Hints." + error;
                }
            }
            if (message.TestIds != null && message.hasOwnProperty("TestIds")) {
                var error = $root.NAppHostProtocol.TTestIds.verify(message.TestIds);
                if (error)
                    return "TestIds." + error;
            }
            if (message.RequestInfo != null && message.hasOwnProperty("RequestInfo")) {
                var error = $root.NAppHostProtocol.TRequestInfo.verify(message.RequestInfo);
                if (error)
                    return "RequestInfo." + error;
            }
            if (message.RtLog != null && message.hasOwnProperty("RtLog"))
                if (!$util.isString(message.RtLog))
                    return "RtLog: string expected";
            return null;
        };

        /**
         * Creates a TServiceRequest message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NAppHostProtocol.TServiceRequest
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NAppHostProtocol.TServiceRequest} TServiceRequest
         */
        TServiceRequest.fromObject = function fromObject(object) {
            if (object instanceof $root.NAppHostProtocol.TServiceRequest)
                return object;
            var message = new $root.NAppHostProtocol.TServiceRequest();
            if (object.Guid != null)
                message.Guid = String(object.Guid);
            if (object.Answers) {
                if (!Array.isArray(object.Answers))
                    throw TypeError(".NAppHostProtocol.TServiceRequest.Answers: array expected");
                message.Answers = [];
                for (var i = 0; i < object.Answers.length; ++i) {
                    if (typeof object.Answers[i] !== "object")
                        throw TypeError(".NAppHostProtocol.TServiceRequest.Answers: object expected");
                    message.Answers[i] = $root.NAppHostProtocol.TAnswer.fromObject(object.Answers[i]);
                }
            }
            if (object.Codecs != null) {
                if (typeof object.Codecs !== "object")
                    throw TypeError(".NAppHostProtocol.TServiceRequest.Codecs: object expected");
                message.Codecs = $root.NAppHostProtocol.TCodecs.fromObject(object.Codecs);
            }
            if (object.Path != null)
                message.Path = String(object.Path);
            if (object.Ruid != null)
                if ($util.Long)
                    (message.Ruid = $util.Long.fromValue(object.Ruid)).unsigned = true;
                else if (typeof object.Ruid === "string")
                    message.Ruid = parseInt(object.Ruid, 10);
                else if (typeof object.Ruid === "number")
                    message.Ruid = object.Ruid;
                else if (typeof object.Ruid === "object")
                    message.Ruid = new $util.LongBits(object.Ruid.low >>> 0, object.Ruid.high >>> 0).toNumber(true);
            if (object.Last != null)
                message.Last = Boolean(object.Last);
            if (object.MetaFlags) {
                if (!Array.isArray(object.MetaFlags))
                    throw TypeError(".NAppHostProtocol.TServiceRequest.MetaFlags: array expected");
                message.MetaFlags = [];
                for (var i = 0; i < object.MetaFlags.length; ++i) {
                    if (typeof object.MetaFlags[i] !== "object")
                        throw TypeError(".NAppHostProtocol.TServiceRequest.MetaFlags: object expected");
                    message.MetaFlags[i] = $root.NAppHostProtocol.TMetaFlag.fromObject(object.MetaFlags[i]);
                }
            }
            if (object.Ticket != null)
                message.Ticket = String(object.Ticket);
            if (object.Json2YsonMode != null)
                message.Json2YsonMode = object.Json2YsonMode >>> 0;
            switch (object.JsonSerializationFormat) {
            case "DEFAULT":
            case 0:
                message.JsonSerializationFormat = 0;
                break;
            case "JSON":
            case 1:
                message.JsonSerializationFormat = 1;
                break;
            case "YSON":
            case 2:
                message.JsonSerializationFormat = 2;
                break;
            }
            if (object.FinishedDeps) {
                if (!Array.isArray(object.FinishedDeps))
                    throw TypeError(".NAppHostProtocol.TServiceRequest.FinishedDeps: array expected");
                message.FinishedDeps = [];
                for (var i = 0; i < object.FinishedDeps.length; ++i)
                    message.FinishedDeps[i] = String(object.FinishedDeps[i]);
            }
            if (object.DumpProtobufSchema != null)
                message.DumpProtobufSchema = Boolean(object.DumpProtobufSchema);
            switch (object.RequestAttemptType) {
            case "First":
            case 0:
                message.RequestAttemptType = 0;
                break;
            case "Retry":
            case 1:
                message.RequestAttemptType = 1;
                break;
            case "Hedged":
            case 2:
                message.RequestAttemptType = 2;
                break;
            }
            if (object.EnableDumpRequest != null)
                message.EnableDumpRequest = Boolean(object.EnableDumpRequest);
            if (object.SendTimestamp != null)
                if ($util.Long)
                    (message.SendTimestamp = $util.Long.fromValue(object.SendTimestamp)).unsigned = true;
                else if (typeof object.SendTimestamp === "string")
                    message.SendTimestamp = parseInt(object.SendTimestamp, 10);
                else if (typeof object.SendTimestamp === "number")
                    message.SendTimestamp = object.SendTimestamp;
                else if (typeof object.SendTimestamp === "object")
                    message.SendTimestamp = new $util.LongBits(object.SendTimestamp.low >>> 0, object.SendTimestamp.high >>> 0).toNumber(true);
            if (object.JsonToProto != null)
                message.JsonToProto = Boolean(object.JsonToProto);
            if (object.ProtoToJson != null)
                message.ProtoToJson = Boolean(object.ProtoToJson);
            if (object.Hints) {
                if (!Array.isArray(object.Hints))
                    throw TypeError(".NAppHostProtocol.TServiceRequest.Hints: array expected");
                message.Hints = [];
                for (var i = 0; i < object.Hints.length; ++i) {
                    if (typeof object.Hints[i] !== "object")
                        throw TypeError(".NAppHostProtocol.TServiceRequest.Hints: object expected");
                    message.Hints[i] = $root.NAppHostProtocol.THint.fromObject(object.Hints[i]);
                }
            }
            if (object.TestIds != null) {
                if (typeof object.TestIds !== "object")
                    throw TypeError(".NAppHostProtocol.TServiceRequest.TestIds: object expected");
                message.TestIds = $root.NAppHostProtocol.TTestIds.fromObject(object.TestIds);
            }
            if (object.RequestInfo != null) {
                if (typeof object.RequestInfo !== "object")
                    throw TypeError(".NAppHostProtocol.TServiceRequest.RequestInfo: object expected");
                message.RequestInfo = $root.NAppHostProtocol.TRequestInfo.fromObject(object.RequestInfo);
            }
            if (object.RtLog != null)
                message.RtLog = String(object.RtLog);
            return message;
        };

        /**
         * Creates a plain object from a TServiceRequest message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NAppHostProtocol.TServiceRequest
         * @static
         * @param {NAppHostProtocol.TServiceRequest} message TServiceRequest
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TServiceRequest.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults) {
                object.Answers = [];
                object.MetaFlags = [];
                object.FinishedDeps = [];
                object.Hints = [];
            }
            if (options.defaults) {
                object.Guid = "";
                object.Codecs = null;
                object.Path = "";
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.Ruid = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.Ruid = options.longs === String ? "0" : 0;
                object.Last = false;
                object.Ticket = "";
                object.Json2YsonMode = 0;
                object.DumpProtobufSchema = false;
                object.RequestAttemptType = options.enums === String ? "First" : 0;
                object.JsonSerializationFormat = options.enums === String ? "DEFAULT" : 0;
                object.EnableDumpRequest = false;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.SendTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.SendTimestamp = options.longs === String ? "0" : 0;
                object.JsonToProto = false;
                object.ProtoToJson = false;
                object.TestIds = null;
                object.RequestInfo = null;
                object.RtLog = "";
            }
            if (message.Guid != null && message.hasOwnProperty("Guid"))
                object.Guid = message.Guid;
            if (message.Answers && message.Answers.length) {
                object.Answers = [];
                for (var j = 0; j < message.Answers.length; ++j)
                    object.Answers[j] = $root.NAppHostProtocol.TAnswer.toObject(message.Answers[j], options);
            }
            if (message.Codecs != null && message.hasOwnProperty("Codecs"))
                object.Codecs = $root.NAppHostProtocol.TCodecs.toObject(message.Codecs, options);
            if (message.Path != null && message.hasOwnProperty("Path"))
                object.Path = message.Path;
            if (message.Ruid != null && message.hasOwnProperty("Ruid"))
                if (typeof message.Ruid === "number")
                    object.Ruid = options.longs === String ? String(message.Ruid) : message.Ruid;
                else
                    object.Ruid = options.longs === String ? $util.Long.prototype.toString.call(message.Ruid) : options.longs === Number ? new $util.LongBits(message.Ruid.low >>> 0, message.Ruid.high >>> 0).toNumber(true) : message.Ruid;
            if (message.Last != null && message.hasOwnProperty("Last"))
                object.Last = message.Last;
            if (message.MetaFlags && message.MetaFlags.length) {
                object.MetaFlags = [];
                for (var j = 0; j < message.MetaFlags.length; ++j)
                    object.MetaFlags[j] = $root.NAppHostProtocol.TMetaFlag.toObject(message.MetaFlags[j], options);
            }
            if (message.Ticket != null && message.hasOwnProperty("Ticket"))
                object.Ticket = message.Ticket;
            if (message.Json2YsonMode != null && message.hasOwnProperty("Json2YsonMode"))
                object.Json2YsonMode = message.Json2YsonMode;
            if (message.FinishedDeps && message.FinishedDeps.length) {
                object.FinishedDeps = [];
                for (var j = 0; j < message.FinishedDeps.length; ++j)
                    object.FinishedDeps[j] = message.FinishedDeps[j];
            }
            if (message.DumpProtobufSchema != null && message.hasOwnProperty("DumpProtobufSchema"))
                object.DumpProtobufSchema = message.DumpProtobufSchema;
            if (message.RequestAttemptType != null && message.hasOwnProperty("RequestAttemptType"))
                object.RequestAttemptType = options.enums === String ? $root.NAppHostProtocol.TServiceRequest.ERequestAttemptType[message.RequestAttemptType] : message.RequestAttemptType;
            if (message.JsonSerializationFormat != null && message.hasOwnProperty("JsonSerializationFormat"))
                object.JsonSerializationFormat = options.enums === String ? $root.NAppHost.ESerializationFormat[message.JsonSerializationFormat] : message.JsonSerializationFormat;
            if (message.EnableDumpRequest != null && message.hasOwnProperty("EnableDumpRequest"))
                object.EnableDumpRequest = message.EnableDumpRequest;
            if (message.SendTimestamp != null && message.hasOwnProperty("SendTimestamp"))
                if (typeof message.SendTimestamp === "number")
                    object.SendTimestamp = options.longs === String ? String(message.SendTimestamp) : message.SendTimestamp;
                else
                    object.SendTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.SendTimestamp) : options.longs === Number ? new $util.LongBits(message.SendTimestamp.low >>> 0, message.SendTimestamp.high >>> 0).toNumber(true) : message.SendTimestamp;
            if (message.JsonToProto != null && message.hasOwnProperty("JsonToProto"))
                object.JsonToProto = message.JsonToProto;
            if (message.ProtoToJson != null && message.hasOwnProperty("ProtoToJson"))
                object.ProtoToJson = message.ProtoToJson;
            if (message.Hints && message.Hints.length) {
                object.Hints = [];
                for (var j = 0; j < message.Hints.length; ++j)
                    object.Hints[j] = $root.NAppHostProtocol.THint.toObject(message.Hints[j], options);
            }
            if (message.TestIds != null && message.hasOwnProperty("TestIds"))
                object.TestIds = $root.NAppHostProtocol.TTestIds.toObject(message.TestIds, options);
            if (message.RequestInfo != null && message.hasOwnProperty("RequestInfo"))
                object.RequestInfo = $root.NAppHostProtocol.TRequestInfo.toObject(message.RequestInfo, options);
            if (message.RtLog != null && message.hasOwnProperty("RtLog"))
                object.RtLog = message.RtLog;
            return object;
        };

        /**
         * Converts this TServiceRequest to JSON.
         * @function toJSON
         * @memberof NAppHostProtocol.TServiceRequest
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TServiceRequest.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * ERequestAttemptType enum.
         * @name NAppHostProtocol.TServiceRequest.ERequestAttemptType
         * @enum {number}
         * @property {number} First=0 First value
         * @property {number} Retry=1 Retry value
         * @property {number} Hedged=2 Hedged value
         */
        TServiceRequest.ERequestAttemptType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "First"] = 0;
            values[valuesById[1] = "Retry"] = 1;
            values[valuesById[2] = "Hedged"] = 2;
            return values;
        })();

        return TServiceRequest;
    })();

    NAppHostProtocol.TBucket = (function() {

        /**
         * Properties of a TBucket.
         * @memberof NAppHostProtocol
         * @interface ITBucket
         * @property {number|null} [Index] TBucket Index
         * @property {number|null} [Count] TBucket Count
         */

        /**
         * Constructs a new TBucket.
         * @memberof NAppHostProtocol
         * @classdesc Represents a TBucket.
         * @implements ITBucket
         * @constructor
         * @param {NAppHostProtocol.ITBucket=} [properties] Properties to set
         */
        function TBucket(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TBucket Index.
         * @member {number} Index
         * @memberof NAppHostProtocol.TBucket
         * @instance
         */
        TBucket.prototype.Index = 0;

        /**
         * TBucket Count.
         * @member {number} Count
         * @memberof NAppHostProtocol.TBucket
         * @instance
         */
        TBucket.prototype.Count = 0;

        /**
         * Creates a new TBucket instance using the specified properties.
         * @function create
         * @memberof NAppHostProtocol.TBucket
         * @static
         * @param {NAppHostProtocol.ITBucket=} [properties] Properties to set
         * @returns {NAppHostProtocol.TBucket} TBucket instance
         */
        TBucket.create = function create(properties) {
            return new TBucket(properties);
        };

        /**
         * Encodes the specified TBucket message. Does not implicitly {@link NAppHostProtocol.TBucket.verify|verify} messages.
         * @function encode
         * @memberof NAppHostProtocol.TBucket
         * @static
         * @param {NAppHostProtocol.ITBucket} message TBucket message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TBucket.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.Index != null && Object.hasOwnProperty.call(message, "Index"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.Index);
            if (message.Count != null && Object.hasOwnProperty.call(message, "Count"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint32(message.Count);
            return writer;
        };

        /**
         * Encodes the specified TBucket message, length delimited. Does not implicitly {@link NAppHostProtocol.TBucket.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NAppHostProtocol.TBucket
         * @static
         * @param {NAppHostProtocol.ITBucket} message TBucket message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TBucket.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TBucket message from the specified reader or buffer.
         * @function decode
         * @memberof NAppHostProtocol.TBucket
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NAppHostProtocol.TBucket} TBucket
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TBucket.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAppHostProtocol.TBucket();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.Index = reader.int32();
                    break;
                case 2:
                    message.Count = reader.uint32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TBucket message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NAppHostProtocol.TBucket
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NAppHostProtocol.TBucket} TBucket
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TBucket.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TBucket message.
         * @function verify
         * @memberof NAppHostProtocol.TBucket
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TBucket.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.Index != null && message.hasOwnProperty("Index"))
                if (!$util.isInteger(message.Index))
                    return "Index: integer expected";
            if (message.Count != null && message.hasOwnProperty("Count"))
                if (!$util.isInteger(message.Count))
                    return "Count: integer expected";
            return null;
        };

        /**
         * Creates a TBucket message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NAppHostProtocol.TBucket
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NAppHostProtocol.TBucket} TBucket
         */
        TBucket.fromObject = function fromObject(object) {
            if (object instanceof $root.NAppHostProtocol.TBucket)
                return object;
            var message = new $root.NAppHostProtocol.TBucket();
            if (object.Index != null)
                message.Index = object.Index | 0;
            if (object.Count != null)
                message.Count = object.Count >>> 0;
            return message;
        };

        /**
         * Creates a plain object from a TBucket message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NAppHostProtocol.TBucket
         * @static
         * @param {NAppHostProtocol.TBucket} message TBucket
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TBucket.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.Index = 0;
                object.Count = 0;
            }
            if (message.Index != null && message.hasOwnProperty("Index"))
                object.Index = message.Index;
            if (message.Count != null && message.hasOwnProperty("Count"))
                object.Count = message.Count;
            return object;
        };

        /**
         * Converts this TBucket to JSON.
         * @function toJSON
         * @memberof NAppHostProtocol.TBucket
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TBucket.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TBucket;
    })();

    NAppHostProtocol.THistogram = (function() {

        /**
         * Properties of a THistogram.
         * @memberof NAppHostProtocol
         * @interface ITHistogram
         * @property {Array.<NAppHostProtocol.ITBucket>|null} [Buckets] THistogram Buckets
         */

        /**
         * Constructs a new THistogram.
         * @memberof NAppHostProtocol
         * @classdesc Represents a THistogram.
         * @implements ITHistogram
         * @constructor
         * @param {NAppHostProtocol.ITHistogram=} [properties] Properties to set
         */
        function THistogram(properties) {
            this.Buckets = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * THistogram Buckets.
         * @member {Array.<NAppHostProtocol.ITBucket>} Buckets
         * @memberof NAppHostProtocol.THistogram
         * @instance
         */
        THistogram.prototype.Buckets = $util.emptyArray;

        /**
         * Creates a new THistogram instance using the specified properties.
         * @function create
         * @memberof NAppHostProtocol.THistogram
         * @static
         * @param {NAppHostProtocol.ITHistogram=} [properties] Properties to set
         * @returns {NAppHostProtocol.THistogram} THistogram instance
         */
        THistogram.create = function create(properties) {
            return new THistogram(properties);
        };

        /**
         * Encodes the specified THistogram message. Does not implicitly {@link NAppHostProtocol.THistogram.verify|verify} messages.
         * @function encode
         * @memberof NAppHostProtocol.THistogram
         * @static
         * @param {NAppHostProtocol.ITHistogram} message THistogram message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        THistogram.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.Buckets != null && message.Buckets.length)
                for (var i = 0; i < message.Buckets.length; ++i)
                    $root.NAppHostProtocol.TBucket.encode(message.Buckets[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified THistogram message, length delimited. Does not implicitly {@link NAppHostProtocol.THistogram.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NAppHostProtocol.THistogram
         * @static
         * @param {NAppHostProtocol.ITHistogram} message THistogram message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        THistogram.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a THistogram message from the specified reader or buffer.
         * @function decode
         * @memberof NAppHostProtocol.THistogram
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NAppHostProtocol.THistogram} THistogram
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        THistogram.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAppHostProtocol.THistogram();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    if (!(message.Buckets && message.Buckets.length))
                        message.Buckets = [];
                    message.Buckets.push($root.NAppHostProtocol.TBucket.decode(reader, reader.uint32()));
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a THistogram message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NAppHostProtocol.THistogram
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NAppHostProtocol.THistogram} THistogram
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        THistogram.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a THistogram message.
         * @function verify
         * @memberof NAppHostProtocol.THistogram
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        THistogram.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.Buckets != null && message.hasOwnProperty("Buckets")) {
                if (!Array.isArray(message.Buckets))
                    return "Buckets: array expected";
                for (var i = 0; i < message.Buckets.length; ++i) {
                    var error = $root.NAppHostProtocol.TBucket.verify(message.Buckets[i]);
                    if (error)
                        return "Buckets." + error;
                }
            }
            return null;
        };

        /**
         * Creates a THistogram message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NAppHostProtocol.THistogram
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NAppHostProtocol.THistogram} THistogram
         */
        THistogram.fromObject = function fromObject(object) {
            if (object instanceof $root.NAppHostProtocol.THistogram)
                return object;
            var message = new $root.NAppHostProtocol.THistogram();
            if (object.Buckets) {
                if (!Array.isArray(object.Buckets))
                    throw TypeError(".NAppHostProtocol.THistogram.Buckets: array expected");
                message.Buckets = [];
                for (var i = 0; i < object.Buckets.length; ++i) {
                    if (typeof object.Buckets[i] !== "object")
                        throw TypeError(".NAppHostProtocol.THistogram.Buckets: object expected");
                    message.Buckets[i] = $root.NAppHostProtocol.TBucket.fromObject(object.Buckets[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a THistogram message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NAppHostProtocol.THistogram
         * @static
         * @param {NAppHostProtocol.THistogram} message THistogram
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        THistogram.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.Buckets = [];
            if (message.Buckets && message.Buckets.length) {
                object.Buckets = [];
                for (var j = 0; j < message.Buckets.length; ++j)
                    object.Buckets[j] = $root.NAppHostProtocol.TBucket.toObject(message.Buckets[j], options);
            }
            return object;
        };

        /**
         * Converts this THistogram to JSON.
         * @function toJSON
         * @memberof NAppHostProtocol.THistogram
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        THistogram.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return THistogram;
    })();

    NAppHostProtocol.TBackendStats = (function() {

        /**
         * Properties of a TBackendStats.
         * @memberof NAppHostProtocol
         * @interface ITBackendStats
         * @property {string|null} [Address] TBackendStats Address
         * @property {number|null} [Duration] TBackendStats Duration
         * @property {boolean|null} [Success] TBackendStats Success
         */

        /**
         * Constructs a new TBackendStats.
         * @memberof NAppHostProtocol
         * @classdesc Represents a TBackendStats.
         * @implements ITBackendStats
         * @constructor
         * @param {NAppHostProtocol.ITBackendStats=} [properties] Properties to set
         */
        function TBackendStats(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TBackendStats Address.
         * @member {string} Address
         * @memberof NAppHostProtocol.TBackendStats
         * @instance
         */
        TBackendStats.prototype.Address = "";

        /**
         * TBackendStats Duration.
         * @member {number} Duration
         * @memberof NAppHostProtocol.TBackendStats
         * @instance
         */
        TBackendStats.prototype.Duration = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * TBackendStats Success.
         * @member {boolean} Success
         * @memberof NAppHostProtocol.TBackendStats
         * @instance
         */
        TBackendStats.prototype.Success = false;

        /**
         * Creates a new TBackendStats instance using the specified properties.
         * @function create
         * @memberof NAppHostProtocol.TBackendStats
         * @static
         * @param {NAppHostProtocol.ITBackendStats=} [properties] Properties to set
         * @returns {NAppHostProtocol.TBackendStats} TBackendStats instance
         */
        TBackendStats.create = function create(properties) {
            return new TBackendStats(properties);
        };

        /**
         * Encodes the specified TBackendStats message. Does not implicitly {@link NAppHostProtocol.TBackendStats.verify|verify} messages.
         * @function encode
         * @memberof NAppHostProtocol.TBackendStats
         * @static
         * @param {NAppHostProtocol.ITBackendStats} message TBackendStats message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TBackendStats.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.Address != null && Object.hasOwnProperty.call(message, "Address"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.Address);
            if (message.Duration != null && Object.hasOwnProperty.call(message, "Duration"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint64(message.Duration);
            if (message.Success != null && Object.hasOwnProperty.call(message, "Success"))
                writer.uint32(/* id 3, wireType 0 =*/24).bool(message.Success);
            return writer;
        };

        /**
         * Encodes the specified TBackendStats message, length delimited. Does not implicitly {@link NAppHostProtocol.TBackendStats.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NAppHostProtocol.TBackendStats
         * @static
         * @param {NAppHostProtocol.ITBackendStats} message TBackendStats message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TBackendStats.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TBackendStats message from the specified reader or buffer.
         * @function decode
         * @memberof NAppHostProtocol.TBackendStats
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NAppHostProtocol.TBackendStats} TBackendStats
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TBackendStats.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAppHostProtocol.TBackendStats();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.Address = reader.string();
                    break;
                case 2:
                    message.Duration = reader.uint64();
                    break;
                case 3:
                    message.Success = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TBackendStats message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NAppHostProtocol.TBackendStats
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NAppHostProtocol.TBackendStats} TBackendStats
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TBackendStats.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TBackendStats message.
         * @function verify
         * @memberof NAppHostProtocol.TBackendStats
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TBackendStats.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.Address != null && message.hasOwnProperty("Address"))
                if (!$util.isString(message.Address))
                    return "Address: string expected";
            if (message.Duration != null && message.hasOwnProperty("Duration"))
                if (!$util.isInteger(message.Duration) && !(message.Duration && $util.isInteger(message.Duration.low) && $util.isInteger(message.Duration.high)))
                    return "Duration: integer|Long expected";
            if (message.Success != null && message.hasOwnProperty("Success"))
                if (typeof message.Success !== "boolean")
                    return "Success: boolean expected";
            return null;
        };

        /**
         * Creates a TBackendStats message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NAppHostProtocol.TBackendStats
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NAppHostProtocol.TBackendStats} TBackendStats
         */
        TBackendStats.fromObject = function fromObject(object) {
            if (object instanceof $root.NAppHostProtocol.TBackendStats)
                return object;
            var message = new $root.NAppHostProtocol.TBackendStats();
            if (object.Address != null)
                message.Address = String(object.Address);
            if (object.Duration != null)
                if ($util.Long)
                    (message.Duration = $util.Long.fromValue(object.Duration)).unsigned = true;
                else if (typeof object.Duration === "string")
                    message.Duration = parseInt(object.Duration, 10);
                else if (typeof object.Duration === "number")
                    message.Duration = object.Duration;
                else if (typeof object.Duration === "object")
                    message.Duration = new $util.LongBits(object.Duration.low >>> 0, object.Duration.high >>> 0).toNumber(true);
            if (object.Success != null)
                message.Success = Boolean(object.Success);
            return message;
        };

        /**
         * Creates a plain object from a TBackendStats message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NAppHostProtocol.TBackendStats
         * @static
         * @param {NAppHostProtocol.TBackendStats} message TBackendStats
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TBackendStats.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.Address = "";
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.Duration = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.Duration = options.longs === String ? "0" : 0;
                object.Success = false;
            }
            if (message.Address != null && message.hasOwnProperty("Address"))
                object.Address = message.Address;
            if (message.Duration != null && message.hasOwnProperty("Duration"))
                if (typeof message.Duration === "number")
                    object.Duration = options.longs === String ? String(message.Duration) : message.Duration;
                else
                    object.Duration = options.longs === String ? $util.Long.prototype.toString.call(message.Duration) : options.longs === Number ? new $util.LongBits(message.Duration.low >>> 0, message.Duration.high >>> 0).toNumber(true) : message.Duration;
            if (message.Success != null && message.hasOwnProperty("Success"))
                object.Success = message.Success;
            return object;
        };

        /**
         * Converts this TBackendStats to JSON.
         * @function toJSON
         * @memberof NAppHostProtocol.TBackendStats
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TBackendStats.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TBackendStats;
    })();

    NAppHostProtocol.THint = (function() {

        /**
         * Properties of a THint.
         * @memberof NAppHostProtocol
         * @interface ITHint
         * @property {string|null} [TargetNode] THint TargetNode
         * @property {number|null} [Value] THint Value
         * @property {string|null} [Origin] THint Origin
         */

        /**
         * Constructs a new THint.
         * @memberof NAppHostProtocol
         * @classdesc Represents a THint.
         * @implements ITHint
         * @constructor
         * @param {NAppHostProtocol.ITHint=} [properties] Properties to set
         */
        function THint(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * THint TargetNode.
         * @member {string} TargetNode
         * @memberof NAppHostProtocol.THint
         * @instance
         */
        THint.prototype.TargetNode = "";

        /**
         * THint Value.
         * @member {number} Value
         * @memberof NAppHostProtocol.THint
         * @instance
         */
        THint.prototype.Value = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * THint Origin.
         * @member {string} Origin
         * @memberof NAppHostProtocol.THint
         * @instance
         */
        THint.prototype.Origin = "";

        /**
         * Creates a new THint instance using the specified properties.
         * @function create
         * @memberof NAppHostProtocol.THint
         * @static
         * @param {NAppHostProtocol.ITHint=} [properties] Properties to set
         * @returns {NAppHostProtocol.THint} THint instance
         */
        THint.create = function create(properties) {
            return new THint(properties);
        };

        /**
         * Encodes the specified THint message. Does not implicitly {@link NAppHostProtocol.THint.verify|verify} messages.
         * @function encode
         * @memberof NAppHostProtocol.THint
         * @static
         * @param {NAppHostProtocol.ITHint} message THint message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        THint.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.TargetNode != null && Object.hasOwnProperty.call(message, "TargetNode"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.TargetNode);
            if (message.Value != null && Object.hasOwnProperty.call(message, "Value"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint64(message.Value);
            if (message.Origin != null && Object.hasOwnProperty.call(message, "Origin"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.Origin);
            return writer;
        };

        /**
         * Encodes the specified THint message, length delimited. Does not implicitly {@link NAppHostProtocol.THint.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NAppHostProtocol.THint
         * @static
         * @param {NAppHostProtocol.ITHint} message THint message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        THint.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a THint message from the specified reader or buffer.
         * @function decode
         * @memberof NAppHostProtocol.THint
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NAppHostProtocol.THint} THint
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        THint.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAppHostProtocol.THint();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.TargetNode = reader.string();
                    break;
                case 2:
                    message.Value = reader.uint64();
                    break;
                case 3:
                    message.Origin = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a THint message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NAppHostProtocol.THint
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NAppHostProtocol.THint} THint
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        THint.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a THint message.
         * @function verify
         * @memberof NAppHostProtocol.THint
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        THint.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.TargetNode != null && message.hasOwnProperty("TargetNode"))
                if (!$util.isString(message.TargetNode))
                    return "TargetNode: string expected";
            if (message.Value != null && message.hasOwnProperty("Value"))
                if (!$util.isInteger(message.Value) && !(message.Value && $util.isInteger(message.Value.low) && $util.isInteger(message.Value.high)))
                    return "Value: integer|Long expected";
            if (message.Origin != null && message.hasOwnProperty("Origin"))
                if (!$util.isString(message.Origin))
                    return "Origin: string expected";
            return null;
        };

        /**
         * Creates a THint message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NAppHostProtocol.THint
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NAppHostProtocol.THint} THint
         */
        THint.fromObject = function fromObject(object) {
            if (object instanceof $root.NAppHostProtocol.THint)
                return object;
            var message = new $root.NAppHostProtocol.THint();
            if (object.TargetNode != null)
                message.TargetNode = String(object.TargetNode);
            if (object.Value != null)
                if ($util.Long)
                    (message.Value = $util.Long.fromValue(object.Value)).unsigned = true;
                else if (typeof object.Value === "string")
                    message.Value = parseInt(object.Value, 10);
                else if (typeof object.Value === "number")
                    message.Value = object.Value;
                else if (typeof object.Value === "object")
                    message.Value = new $util.LongBits(object.Value.low >>> 0, object.Value.high >>> 0).toNumber(true);
            if (object.Origin != null)
                message.Origin = String(object.Origin);
            return message;
        };

        /**
         * Creates a plain object from a THint message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NAppHostProtocol.THint
         * @static
         * @param {NAppHostProtocol.THint} message THint
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        THint.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.TargetNode = "";
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.Value = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.Value = options.longs === String ? "0" : 0;
                object.Origin = "";
            }
            if (message.TargetNode != null && message.hasOwnProperty("TargetNode"))
                object.TargetNode = message.TargetNode;
            if (message.Value != null && message.hasOwnProperty("Value"))
                if (typeof message.Value === "number")
                    object.Value = options.longs === String ? String(message.Value) : message.Value;
                else
                    object.Value = options.longs === String ? $util.Long.prototype.toString.call(message.Value) : options.longs === Number ? new $util.LongBits(message.Value.low >>> 0, message.Value.high >>> 0).toNumber(true) : message.Value;
            if (message.Origin != null && message.hasOwnProperty("Origin"))
                object.Origin = message.Origin;
            return object;
        };

        /**
         * Converts this THint to JSON.
         * @function toJSON
         * @memberof NAppHostProtocol.THint
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        THint.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return THint;
    })();

    NAppHostProtocol.TServiceResponse = (function() {

        /**
         * Properties of a TServiceResponse.
         * @memberof NAppHostProtocol
         * @interface ITServiceResponse
         * @property {Array.<NAppHostProtocol.ITAnswer>|null} [Answers] TServiceResponse Answers
         * @property {Array.<NAppHostProtocol.ITHint>|null} [Hints] TServiceResponse Hints
         * @property {Array.<string>|null} [Flags] TServiceResponse Flags
         * @property {Array.<NAppHostProtocol.ITProtoEvent>|null} [ProtoLogEvents] TServiceResponse ProtoLogEvents
         * @property {Array.<Uint8Array>|null} [LogLines] TServiceResponse LogLines
         * @property {Uint8Array|null} [Exception] TServiceResponse Exception
         * @property {number|null} [RequestId] TServiceResponse RequestId
         * @property {number|null} [InitTime] TServiceResponse InitTime
         * @property {number|null} [FinTime] TServiceResponse FinTime
         * @property {number|null} [LogicTime] TServiceResponse LogicTime
         * @property {number|null} [DeserialTime] TServiceResponse DeserialTime
         * @property {number|null} [DecomprTime] TServiceResponse DecomprTime
         * @property {number|null} [ComprTime] TServiceResponse ComprTime
         * @property {number|null} [UncompressedSize] TServiceResponse UncompressedSize
         * @property {string|null} [FQDNHostName] TServiceResponse FQDNHostName
         * @property {number|null} [BackendTime] TServiceResponse BackendTime
         * @property {boolean|null} [ForceRetry] TServiceResponse ForceRetry
         * @property {number|null} [SerialTime] TServiceResponse SerialTime
         */

        /**
         * Constructs a new TServiceResponse.
         * @memberof NAppHostProtocol
         * @classdesc Represents a TServiceResponse.
         * @implements ITServiceResponse
         * @constructor
         * @param {NAppHostProtocol.ITServiceResponse=} [properties] Properties to set
         */
        function TServiceResponse(properties) {
            this.Answers = [];
            this.Hints = [];
            this.Flags = [];
            this.ProtoLogEvents = [];
            this.LogLines = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TServiceResponse Answers.
         * @member {Array.<NAppHostProtocol.ITAnswer>} Answers
         * @memberof NAppHostProtocol.TServiceResponse
         * @instance
         */
        TServiceResponse.prototype.Answers = $util.emptyArray;

        /**
         * TServiceResponse Hints.
         * @member {Array.<NAppHostProtocol.ITHint>} Hints
         * @memberof NAppHostProtocol.TServiceResponse
         * @instance
         */
        TServiceResponse.prototype.Hints = $util.emptyArray;

        /**
         * TServiceResponse Flags.
         * @member {Array.<string>} Flags
         * @memberof NAppHostProtocol.TServiceResponse
         * @instance
         */
        TServiceResponse.prototype.Flags = $util.emptyArray;

        /**
         * TServiceResponse ProtoLogEvents.
         * @member {Array.<NAppHostProtocol.ITProtoEvent>} ProtoLogEvents
         * @memberof NAppHostProtocol.TServiceResponse
         * @instance
         */
        TServiceResponse.prototype.ProtoLogEvents = $util.emptyArray;

        /**
         * TServiceResponse LogLines.
         * @member {Array.<Uint8Array>} LogLines
         * @memberof NAppHostProtocol.TServiceResponse
         * @instance
         */
        TServiceResponse.prototype.LogLines = $util.emptyArray;

        /**
         * TServiceResponse Exception.
         * @member {Uint8Array} Exception
         * @memberof NAppHostProtocol.TServiceResponse
         * @instance
         */
        TServiceResponse.prototype.Exception = $util.newBuffer([]);

        /**
         * TServiceResponse RequestId.
         * @member {number} RequestId
         * @memberof NAppHostProtocol.TServiceResponse
         * @instance
         */
        TServiceResponse.prototype.RequestId = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * TServiceResponse InitTime.
         * @member {number} InitTime
         * @memberof NAppHostProtocol.TServiceResponse
         * @instance
         */
        TServiceResponse.prototype.InitTime = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * TServiceResponse FinTime.
         * @member {number} FinTime
         * @memberof NAppHostProtocol.TServiceResponse
         * @instance
         */
        TServiceResponse.prototype.FinTime = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * TServiceResponse LogicTime.
         * @member {number} LogicTime
         * @memberof NAppHostProtocol.TServiceResponse
         * @instance
         */
        TServiceResponse.prototype.LogicTime = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * TServiceResponse DeserialTime.
         * @member {number} DeserialTime
         * @memberof NAppHostProtocol.TServiceResponse
         * @instance
         */
        TServiceResponse.prototype.DeserialTime = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * TServiceResponse DecomprTime.
         * @member {number} DecomprTime
         * @memberof NAppHostProtocol.TServiceResponse
         * @instance
         */
        TServiceResponse.prototype.DecomprTime = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * TServiceResponse ComprTime.
         * @member {number} ComprTime
         * @memberof NAppHostProtocol.TServiceResponse
         * @instance
         */
        TServiceResponse.prototype.ComprTime = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * TServiceResponse UncompressedSize.
         * @member {number} UncompressedSize
         * @memberof NAppHostProtocol.TServiceResponse
         * @instance
         */
        TServiceResponse.prototype.UncompressedSize = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * TServiceResponse FQDNHostName.
         * @member {string} FQDNHostName
         * @memberof NAppHostProtocol.TServiceResponse
         * @instance
         */
        TServiceResponse.prototype.FQDNHostName = "";

        /**
         * TServiceResponse BackendTime.
         * @member {number} BackendTime
         * @memberof NAppHostProtocol.TServiceResponse
         * @instance
         */
        TServiceResponse.prototype.BackendTime = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * TServiceResponse ForceRetry.
         * @member {boolean} ForceRetry
         * @memberof NAppHostProtocol.TServiceResponse
         * @instance
         */
        TServiceResponse.prototype.ForceRetry = false;

        /**
         * TServiceResponse SerialTime.
         * @member {number} SerialTime
         * @memberof NAppHostProtocol.TServiceResponse
         * @instance
         */
        TServiceResponse.prototype.SerialTime = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * Creates a new TServiceResponse instance using the specified properties.
         * @function create
         * @memberof NAppHostProtocol.TServiceResponse
         * @static
         * @param {NAppHostProtocol.ITServiceResponse=} [properties] Properties to set
         * @returns {NAppHostProtocol.TServiceResponse} TServiceResponse instance
         */
        TServiceResponse.create = function create(properties) {
            return new TServiceResponse(properties);
        };

        /**
         * Encodes the specified TServiceResponse message. Does not implicitly {@link NAppHostProtocol.TServiceResponse.verify|verify} messages.
         * @function encode
         * @memberof NAppHostProtocol.TServiceResponse
         * @static
         * @param {NAppHostProtocol.ITServiceResponse} message TServiceResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TServiceResponse.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.Answers != null && message.Answers.length)
                for (var i = 0; i < message.Answers.length; ++i)
                    $root.NAppHostProtocol.TAnswer.encode(message.Answers[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.Hints != null && message.Hints.length)
                for (var i = 0; i < message.Hints.length; ++i)
                    $root.NAppHostProtocol.THint.encode(message.Hints[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            if (message.Flags != null && message.Flags.length)
                for (var i = 0; i < message.Flags.length; ++i)
                    writer.uint32(/* id 4, wireType 2 =*/34).string(message.Flags[i]);
            if (message.LogLines != null && message.LogLines.length)
                for (var i = 0; i < message.LogLines.length; ++i)
                    writer.uint32(/* id 5, wireType 2 =*/42).bytes(message.LogLines[i]);
            if (message.Exception != null && Object.hasOwnProperty.call(message, "Exception"))
                writer.uint32(/* id 6, wireType 2 =*/50).bytes(message.Exception);
            if (message.RequestId != null && Object.hasOwnProperty.call(message, "RequestId"))
                writer.uint32(/* id 7, wireType 0 =*/56).uint64(message.RequestId);
            if (message.InitTime != null && Object.hasOwnProperty.call(message, "InitTime"))
                writer.uint32(/* id 9, wireType 0 =*/72).uint64(message.InitTime);
            if (message.FinTime != null && Object.hasOwnProperty.call(message, "FinTime"))
                writer.uint32(/* id 10, wireType 0 =*/80).uint64(message.FinTime);
            if (message.LogicTime != null && Object.hasOwnProperty.call(message, "LogicTime"))
                writer.uint32(/* id 11, wireType 0 =*/88).uint64(message.LogicTime);
            if (message.DeserialTime != null && Object.hasOwnProperty.call(message, "DeserialTime"))
                writer.uint32(/* id 12, wireType 0 =*/96).uint64(message.DeserialTime);
            if (message.DecomprTime != null && Object.hasOwnProperty.call(message, "DecomprTime"))
                writer.uint32(/* id 13, wireType 0 =*/104).uint64(message.DecomprTime);
            if (message.ComprTime != null && Object.hasOwnProperty.call(message, "ComprTime"))
                writer.uint32(/* id 14, wireType 0 =*/112).uint64(message.ComprTime);
            if (message.UncompressedSize != null && Object.hasOwnProperty.call(message, "UncompressedSize"))
                writer.uint32(/* id 15, wireType 0 =*/120).uint64(message.UncompressedSize);
            if (message.ProtoLogEvents != null && message.ProtoLogEvents.length)
                for (var i = 0; i < message.ProtoLogEvents.length; ++i)
                    $root.NAppHostProtocol.TProtoEvent.encode(message.ProtoLogEvents[i], writer.uint32(/* id 16, wireType 2 =*/130).fork()).ldelim();
            if (message.FQDNHostName != null && Object.hasOwnProperty.call(message, "FQDNHostName"))
                writer.uint32(/* id 17, wireType 2 =*/138).string(message.FQDNHostName);
            if (message.BackendTime != null && Object.hasOwnProperty.call(message, "BackendTime"))
                writer.uint32(/* id 19, wireType 0 =*/152).uint64(message.BackendTime);
            if (message.ForceRetry != null && Object.hasOwnProperty.call(message, "ForceRetry"))
                writer.uint32(/* id 20, wireType 0 =*/160).bool(message.ForceRetry);
            if (message.SerialTime != null && Object.hasOwnProperty.call(message, "SerialTime"))
                writer.uint32(/* id 31, wireType 0 =*/248).uint64(message.SerialTime);
            return writer;
        };

        /**
         * Encodes the specified TServiceResponse message, length delimited. Does not implicitly {@link NAppHostProtocol.TServiceResponse.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NAppHostProtocol.TServiceResponse
         * @static
         * @param {NAppHostProtocol.ITServiceResponse} message TServiceResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TServiceResponse.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TServiceResponse message from the specified reader or buffer.
         * @function decode
         * @memberof NAppHostProtocol.TServiceResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NAppHostProtocol.TServiceResponse} TServiceResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TServiceResponse.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAppHostProtocol.TServiceResponse();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    if (!(message.Answers && message.Answers.length))
                        message.Answers = [];
                    message.Answers.push($root.NAppHostProtocol.TAnswer.decode(reader, reader.uint32()));
                    break;
                case 3:
                    if (!(message.Hints && message.Hints.length))
                        message.Hints = [];
                    message.Hints.push($root.NAppHostProtocol.THint.decode(reader, reader.uint32()));
                    break;
                case 4:
                    if (!(message.Flags && message.Flags.length))
                        message.Flags = [];
                    message.Flags.push(reader.string());
                    break;
                case 16:
                    if (!(message.ProtoLogEvents && message.ProtoLogEvents.length))
                        message.ProtoLogEvents = [];
                    message.ProtoLogEvents.push($root.NAppHostProtocol.TProtoEvent.decode(reader, reader.uint32()));
                    break;
                case 5:
                    if (!(message.LogLines && message.LogLines.length))
                        message.LogLines = [];
                    message.LogLines.push(reader.bytes());
                    break;
                case 6:
                    message.Exception = reader.bytes();
                    break;
                case 7:
                    message.RequestId = reader.uint64();
                    break;
                case 9:
                    message.InitTime = reader.uint64();
                    break;
                case 10:
                    message.FinTime = reader.uint64();
                    break;
                case 11:
                    message.LogicTime = reader.uint64();
                    break;
                case 12:
                    message.DeserialTime = reader.uint64();
                    break;
                case 13:
                    message.DecomprTime = reader.uint64();
                    break;
                case 14:
                    message.ComprTime = reader.uint64();
                    break;
                case 15:
                    message.UncompressedSize = reader.uint64();
                    break;
                case 17:
                    message.FQDNHostName = reader.string();
                    break;
                case 19:
                    message.BackendTime = reader.uint64();
                    break;
                case 20:
                    message.ForceRetry = reader.bool();
                    break;
                case 31:
                    message.SerialTime = reader.uint64();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TServiceResponse message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NAppHostProtocol.TServiceResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NAppHostProtocol.TServiceResponse} TServiceResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TServiceResponse.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TServiceResponse message.
         * @function verify
         * @memberof NAppHostProtocol.TServiceResponse
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TServiceResponse.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.Answers != null && message.hasOwnProperty("Answers")) {
                if (!Array.isArray(message.Answers))
                    return "Answers: array expected";
                for (var i = 0; i < message.Answers.length; ++i) {
                    var error = $root.NAppHostProtocol.TAnswer.verify(message.Answers[i]);
                    if (error)
                        return "Answers." + error;
                }
            }
            if (message.Hints != null && message.hasOwnProperty("Hints")) {
                if (!Array.isArray(message.Hints))
                    return "Hints: array expected";
                for (var i = 0; i < message.Hints.length; ++i) {
                    var error = $root.NAppHostProtocol.THint.verify(message.Hints[i]);
                    if (error)
                        return "Hints." + error;
                }
            }
            if (message.Flags != null && message.hasOwnProperty("Flags")) {
                if (!Array.isArray(message.Flags))
                    return "Flags: array expected";
                for (var i = 0; i < message.Flags.length; ++i)
                    if (!$util.isString(message.Flags[i]))
                        return "Flags: string[] expected";
            }
            if (message.ProtoLogEvents != null && message.hasOwnProperty("ProtoLogEvents")) {
                if (!Array.isArray(message.ProtoLogEvents))
                    return "ProtoLogEvents: array expected";
                for (var i = 0; i < message.ProtoLogEvents.length; ++i) {
                    var error = $root.NAppHostProtocol.TProtoEvent.verify(message.ProtoLogEvents[i]);
                    if (error)
                        return "ProtoLogEvents." + error;
                }
            }
            if (message.LogLines != null && message.hasOwnProperty("LogLines")) {
                if (!Array.isArray(message.LogLines))
                    return "LogLines: array expected";
                for (var i = 0; i < message.LogLines.length; ++i)
                    if (!(message.LogLines[i] && typeof message.LogLines[i].length === "number" || $util.isString(message.LogLines[i])))
                        return "LogLines: buffer[] expected";
            }
            if (message.Exception != null && message.hasOwnProperty("Exception"))
                if (!(message.Exception && typeof message.Exception.length === "number" || $util.isString(message.Exception)))
                    return "Exception: buffer expected";
            if (message.RequestId != null && message.hasOwnProperty("RequestId"))
                if (!$util.isInteger(message.RequestId) && !(message.RequestId && $util.isInteger(message.RequestId.low) && $util.isInteger(message.RequestId.high)))
                    return "RequestId: integer|Long expected";
            if (message.InitTime != null && message.hasOwnProperty("InitTime"))
                if (!$util.isInteger(message.InitTime) && !(message.InitTime && $util.isInteger(message.InitTime.low) && $util.isInteger(message.InitTime.high)))
                    return "InitTime: integer|Long expected";
            if (message.FinTime != null && message.hasOwnProperty("FinTime"))
                if (!$util.isInteger(message.FinTime) && !(message.FinTime && $util.isInteger(message.FinTime.low) && $util.isInteger(message.FinTime.high)))
                    return "FinTime: integer|Long expected";
            if (message.LogicTime != null && message.hasOwnProperty("LogicTime"))
                if (!$util.isInteger(message.LogicTime) && !(message.LogicTime && $util.isInteger(message.LogicTime.low) && $util.isInteger(message.LogicTime.high)))
                    return "LogicTime: integer|Long expected";
            if (message.DeserialTime != null && message.hasOwnProperty("DeserialTime"))
                if (!$util.isInteger(message.DeserialTime) && !(message.DeserialTime && $util.isInteger(message.DeserialTime.low) && $util.isInteger(message.DeserialTime.high)))
                    return "DeserialTime: integer|Long expected";
            if (message.DecomprTime != null && message.hasOwnProperty("DecomprTime"))
                if (!$util.isInteger(message.DecomprTime) && !(message.DecomprTime && $util.isInteger(message.DecomprTime.low) && $util.isInteger(message.DecomprTime.high)))
                    return "DecomprTime: integer|Long expected";
            if (message.ComprTime != null && message.hasOwnProperty("ComprTime"))
                if (!$util.isInteger(message.ComprTime) && !(message.ComprTime && $util.isInteger(message.ComprTime.low) && $util.isInteger(message.ComprTime.high)))
                    return "ComprTime: integer|Long expected";
            if (message.UncompressedSize != null && message.hasOwnProperty("UncompressedSize"))
                if (!$util.isInteger(message.UncompressedSize) && !(message.UncompressedSize && $util.isInteger(message.UncompressedSize.low) && $util.isInteger(message.UncompressedSize.high)))
                    return "UncompressedSize: integer|Long expected";
            if (message.FQDNHostName != null && message.hasOwnProperty("FQDNHostName"))
                if (!$util.isString(message.FQDNHostName))
                    return "FQDNHostName: string expected";
            if (message.BackendTime != null && message.hasOwnProperty("BackendTime"))
                if (!$util.isInteger(message.BackendTime) && !(message.BackendTime && $util.isInteger(message.BackendTime.low) && $util.isInteger(message.BackendTime.high)))
                    return "BackendTime: integer|Long expected";
            if (message.ForceRetry != null && message.hasOwnProperty("ForceRetry"))
                if (typeof message.ForceRetry !== "boolean")
                    return "ForceRetry: boolean expected";
            if (message.SerialTime != null && message.hasOwnProperty("SerialTime"))
                if (!$util.isInteger(message.SerialTime) && !(message.SerialTime && $util.isInteger(message.SerialTime.low) && $util.isInteger(message.SerialTime.high)))
                    return "SerialTime: integer|Long expected";
            return null;
        };

        /**
         * Creates a TServiceResponse message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NAppHostProtocol.TServiceResponse
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NAppHostProtocol.TServiceResponse} TServiceResponse
         */
        TServiceResponse.fromObject = function fromObject(object) {
            if (object instanceof $root.NAppHostProtocol.TServiceResponse)
                return object;
            var message = new $root.NAppHostProtocol.TServiceResponse();
            if (object.Answers) {
                if (!Array.isArray(object.Answers))
                    throw TypeError(".NAppHostProtocol.TServiceResponse.Answers: array expected");
                message.Answers = [];
                for (var i = 0; i < object.Answers.length; ++i) {
                    if (typeof object.Answers[i] !== "object")
                        throw TypeError(".NAppHostProtocol.TServiceResponse.Answers: object expected");
                    message.Answers[i] = $root.NAppHostProtocol.TAnswer.fromObject(object.Answers[i]);
                }
            }
            if (object.Hints) {
                if (!Array.isArray(object.Hints))
                    throw TypeError(".NAppHostProtocol.TServiceResponse.Hints: array expected");
                message.Hints = [];
                for (var i = 0; i < object.Hints.length; ++i) {
                    if (typeof object.Hints[i] !== "object")
                        throw TypeError(".NAppHostProtocol.TServiceResponse.Hints: object expected");
                    message.Hints[i] = $root.NAppHostProtocol.THint.fromObject(object.Hints[i]);
                }
            }
            if (object.Flags) {
                if (!Array.isArray(object.Flags))
                    throw TypeError(".NAppHostProtocol.TServiceResponse.Flags: array expected");
                message.Flags = [];
                for (var i = 0; i < object.Flags.length; ++i)
                    message.Flags[i] = String(object.Flags[i]);
            }
            if (object.ProtoLogEvents) {
                if (!Array.isArray(object.ProtoLogEvents))
                    throw TypeError(".NAppHostProtocol.TServiceResponse.ProtoLogEvents: array expected");
                message.ProtoLogEvents = [];
                for (var i = 0; i < object.ProtoLogEvents.length; ++i) {
                    if (typeof object.ProtoLogEvents[i] !== "object")
                        throw TypeError(".NAppHostProtocol.TServiceResponse.ProtoLogEvents: object expected");
                    message.ProtoLogEvents[i] = $root.NAppHostProtocol.TProtoEvent.fromObject(object.ProtoLogEvents[i]);
                }
            }
            if (object.LogLines) {
                if (!Array.isArray(object.LogLines))
                    throw TypeError(".NAppHostProtocol.TServiceResponse.LogLines: array expected");
                message.LogLines = [];
                for (var i = 0; i < object.LogLines.length; ++i)
                    if (typeof object.LogLines[i] === "string")
                        $util.base64.decode(object.LogLines[i], message.LogLines[i] = $util.newBuffer($util.base64.length(object.LogLines[i])), 0);
                    else if (object.LogLines[i].length)
                        message.LogLines[i] = object.LogLines[i];
            }
            if (object.Exception != null)
                if (typeof object.Exception === "string")
                    $util.base64.decode(object.Exception, message.Exception = $util.newBuffer($util.base64.length(object.Exception)), 0);
                else if (object.Exception.length)
                    message.Exception = object.Exception;
            if (object.RequestId != null)
                if ($util.Long)
                    (message.RequestId = $util.Long.fromValue(object.RequestId)).unsigned = true;
                else if (typeof object.RequestId === "string")
                    message.RequestId = parseInt(object.RequestId, 10);
                else if (typeof object.RequestId === "number")
                    message.RequestId = object.RequestId;
                else if (typeof object.RequestId === "object")
                    message.RequestId = new $util.LongBits(object.RequestId.low >>> 0, object.RequestId.high >>> 0).toNumber(true);
            if (object.InitTime != null)
                if ($util.Long)
                    (message.InitTime = $util.Long.fromValue(object.InitTime)).unsigned = true;
                else if (typeof object.InitTime === "string")
                    message.InitTime = parseInt(object.InitTime, 10);
                else if (typeof object.InitTime === "number")
                    message.InitTime = object.InitTime;
                else if (typeof object.InitTime === "object")
                    message.InitTime = new $util.LongBits(object.InitTime.low >>> 0, object.InitTime.high >>> 0).toNumber(true);
            if (object.FinTime != null)
                if ($util.Long)
                    (message.FinTime = $util.Long.fromValue(object.FinTime)).unsigned = true;
                else if (typeof object.FinTime === "string")
                    message.FinTime = parseInt(object.FinTime, 10);
                else if (typeof object.FinTime === "number")
                    message.FinTime = object.FinTime;
                else if (typeof object.FinTime === "object")
                    message.FinTime = new $util.LongBits(object.FinTime.low >>> 0, object.FinTime.high >>> 0).toNumber(true);
            if (object.LogicTime != null)
                if ($util.Long)
                    (message.LogicTime = $util.Long.fromValue(object.LogicTime)).unsigned = true;
                else if (typeof object.LogicTime === "string")
                    message.LogicTime = parseInt(object.LogicTime, 10);
                else if (typeof object.LogicTime === "number")
                    message.LogicTime = object.LogicTime;
                else if (typeof object.LogicTime === "object")
                    message.LogicTime = new $util.LongBits(object.LogicTime.low >>> 0, object.LogicTime.high >>> 0).toNumber(true);
            if (object.DeserialTime != null)
                if ($util.Long)
                    (message.DeserialTime = $util.Long.fromValue(object.DeserialTime)).unsigned = true;
                else if (typeof object.DeserialTime === "string")
                    message.DeserialTime = parseInt(object.DeserialTime, 10);
                else if (typeof object.DeserialTime === "number")
                    message.DeserialTime = object.DeserialTime;
                else if (typeof object.DeserialTime === "object")
                    message.DeserialTime = new $util.LongBits(object.DeserialTime.low >>> 0, object.DeserialTime.high >>> 0).toNumber(true);
            if (object.DecomprTime != null)
                if ($util.Long)
                    (message.DecomprTime = $util.Long.fromValue(object.DecomprTime)).unsigned = true;
                else if (typeof object.DecomprTime === "string")
                    message.DecomprTime = parseInt(object.DecomprTime, 10);
                else if (typeof object.DecomprTime === "number")
                    message.DecomprTime = object.DecomprTime;
                else if (typeof object.DecomprTime === "object")
                    message.DecomprTime = new $util.LongBits(object.DecomprTime.low >>> 0, object.DecomprTime.high >>> 0).toNumber(true);
            if (object.ComprTime != null)
                if ($util.Long)
                    (message.ComprTime = $util.Long.fromValue(object.ComprTime)).unsigned = true;
                else if (typeof object.ComprTime === "string")
                    message.ComprTime = parseInt(object.ComprTime, 10);
                else if (typeof object.ComprTime === "number")
                    message.ComprTime = object.ComprTime;
                else if (typeof object.ComprTime === "object")
                    message.ComprTime = new $util.LongBits(object.ComprTime.low >>> 0, object.ComprTime.high >>> 0).toNumber(true);
            if (object.UncompressedSize != null)
                if ($util.Long)
                    (message.UncompressedSize = $util.Long.fromValue(object.UncompressedSize)).unsigned = true;
                else if (typeof object.UncompressedSize === "string")
                    message.UncompressedSize = parseInt(object.UncompressedSize, 10);
                else if (typeof object.UncompressedSize === "number")
                    message.UncompressedSize = object.UncompressedSize;
                else if (typeof object.UncompressedSize === "object")
                    message.UncompressedSize = new $util.LongBits(object.UncompressedSize.low >>> 0, object.UncompressedSize.high >>> 0).toNumber(true);
            if (object.FQDNHostName != null)
                message.FQDNHostName = String(object.FQDNHostName);
            if (object.BackendTime != null)
                if ($util.Long)
                    (message.BackendTime = $util.Long.fromValue(object.BackendTime)).unsigned = true;
                else if (typeof object.BackendTime === "string")
                    message.BackendTime = parseInt(object.BackendTime, 10);
                else if (typeof object.BackendTime === "number")
                    message.BackendTime = object.BackendTime;
                else if (typeof object.BackendTime === "object")
                    message.BackendTime = new $util.LongBits(object.BackendTime.low >>> 0, object.BackendTime.high >>> 0).toNumber(true);
            if (object.ForceRetry != null)
                message.ForceRetry = Boolean(object.ForceRetry);
            if (object.SerialTime != null)
                if ($util.Long)
                    (message.SerialTime = $util.Long.fromValue(object.SerialTime)).unsigned = true;
                else if (typeof object.SerialTime === "string")
                    message.SerialTime = parseInt(object.SerialTime, 10);
                else if (typeof object.SerialTime === "number")
                    message.SerialTime = object.SerialTime;
                else if (typeof object.SerialTime === "object")
                    message.SerialTime = new $util.LongBits(object.SerialTime.low >>> 0, object.SerialTime.high >>> 0).toNumber(true);
            return message;
        };

        /**
         * Creates a plain object from a TServiceResponse message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NAppHostProtocol.TServiceResponse
         * @static
         * @param {NAppHostProtocol.TServiceResponse} message TServiceResponse
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TServiceResponse.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults) {
                object.Answers = [];
                object.Hints = [];
                object.Flags = [];
                object.LogLines = [];
                object.ProtoLogEvents = [];
            }
            if (options.defaults) {
                if (options.bytes === String)
                    object.Exception = "";
                else {
                    object.Exception = [];
                    if (options.bytes !== Array)
                        object.Exception = $util.newBuffer(object.Exception);
                }
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.RequestId = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.RequestId = options.longs === String ? "0" : 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.InitTime = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.InitTime = options.longs === String ? "0" : 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.FinTime = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.FinTime = options.longs === String ? "0" : 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.LogicTime = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.LogicTime = options.longs === String ? "0" : 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.DeserialTime = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.DeserialTime = options.longs === String ? "0" : 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.DecomprTime = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.DecomprTime = options.longs === String ? "0" : 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.ComprTime = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.ComprTime = options.longs === String ? "0" : 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.UncompressedSize = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.UncompressedSize = options.longs === String ? "0" : 0;
                object.FQDNHostName = "";
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.BackendTime = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.BackendTime = options.longs === String ? "0" : 0;
                object.ForceRetry = false;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.SerialTime = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.SerialTime = options.longs === String ? "0" : 0;
            }
            if (message.Answers && message.Answers.length) {
                object.Answers = [];
                for (var j = 0; j < message.Answers.length; ++j)
                    object.Answers[j] = $root.NAppHostProtocol.TAnswer.toObject(message.Answers[j], options);
            }
            if (message.Hints && message.Hints.length) {
                object.Hints = [];
                for (var j = 0; j < message.Hints.length; ++j)
                    object.Hints[j] = $root.NAppHostProtocol.THint.toObject(message.Hints[j], options);
            }
            if (message.Flags && message.Flags.length) {
                object.Flags = [];
                for (var j = 0; j < message.Flags.length; ++j)
                    object.Flags[j] = message.Flags[j];
            }
            if (message.LogLines && message.LogLines.length) {
                object.LogLines = [];
                for (var j = 0; j < message.LogLines.length; ++j)
                    object.LogLines[j] = options.bytes === String ? $util.base64.encode(message.LogLines[j], 0, message.LogLines[j].length) : options.bytes === Array ? Array.prototype.slice.call(message.LogLines[j]) : message.LogLines[j];
            }
            if (message.Exception != null && message.hasOwnProperty("Exception"))
                object.Exception = options.bytes === String ? $util.base64.encode(message.Exception, 0, message.Exception.length) : options.bytes === Array ? Array.prototype.slice.call(message.Exception) : message.Exception;
            if (message.RequestId != null && message.hasOwnProperty("RequestId"))
                if (typeof message.RequestId === "number")
                    object.RequestId = options.longs === String ? String(message.RequestId) : message.RequestId;
                else
                    object.RequestId = options.longs === String ? $util.Long.prototype.toString.call(message.RequestId) : options.longs === Number ? new $util.LongBits(message.RequestId.low >>> 0, message.RequestId.high >>> 0).toNumber(true) : message.RequestId;
            if (message.InitTime != null && message.hasOwnProperty("InitTime"))
                if (typeof message.InitTime === "number")
                    object.InitTime = options.longs === String ? String(message.InitTime) : message.InitTime;
                else
                    object.InitTime = options.longs === String ? $util.Long.prototype.toString.call(message.InitTime) : options.longs === Number ? new $util.LongBits(message.InitTime.low >>> 0, message.InitTime.high >>> 0).toNumber(true) : message.InitTime;
            if (message.FinTime != null && message.hasOwnProperty("FinTime"))
                if (typeof message.FinTime === "number")
                    object.FinTime = options.longs === String ? String(message.FinTime) : message.FinTime;
                else
                    object.FinTime = options.longs === String ? $util.Long.prototype.toString.call(message.FinTime) : options.longs === Number ? new $util.LongBits(message.FinTime.low >>> 0, message.FinTime.high >>> 0).toNumber(true) : message.FinTime;
            if (message.LogicTime != null && message.hasOwnProperty("LogicTime"))
                if (typeof message.LogicTime === "number")
                    object.LogicTime = options.longs === String ? String(message.LogicTime) : message.LogicTime;
                else
                    object.LogicTime = options.longs === String ? $util.Long.prototype.toString.call(message.LogicTime) : options.longs === Number ? new $util.LongBits(message.LogicTime.low >>> 0, message.LogicTime.high >>> 0).toNumber(true) : message.LogicTime;
            if (message.DeserialTime != null && message.hasOwnProperty("DeserialTime"))
                if (typeof message.DeserialTime === "number")
                    object.DeserialTime = options.longs === String ? String(message.DeserialTime) : message.DeserialTime;
                else
                    object.DeserialTime = options.longs === String ? $util.Long.prototype.toString.call(message.DeserialTime) : options.longs === Number ? new $util.LongBits(message.DeserialTime.low >>> 0, message.DeserialTime.high >>> 0).toNumber(true) : message.DeserialTime;
            if (message.DecomprTime != null && message.hasOwnProperty("DecomprTime"))
                if (typeof message.DecomprTime === "number")
                    object.DecomprTime = options.longs === String ? String(message.DecomprTime) : message.DecomprTime;
                else
                    object.DecomprTime = options.longs === String ? $util.Long.prototype.toString.call(message.DecomprTime) : options.longs === Number ? new $util.LongBits(message.DecomprTime.low >>> 0, message.DecomprTime.high >>> 0).toNumber(true) : message.DecomprTime;
            if (message.ComprTime != null && message.hasOwnProperty("ComprTime"))
                if (typeof message.ComprTime === "number")
                    object.ComprTime = options.longs === String ? String(message.ComprTime) : message.ComprTime;
                else
                    object.ComprTime = options.longs === String ? $util.Long.prototype.toString.call(message.ComprTime) : options.longs === Number ? new $util.LongBits(message.ComprTime.low >>> 0, message.ComprTime.high >>> 0).toNumber(true) : message.ComprTime;
            if (message.UncompressedSize != null && message.hasOwnProperty("UncompressedSize"))
                if (typeof message.UncompressedSize === "number")
                    object.UncompressedSize = options.longs === String ? String(message.UncompressedSize) : message.UncompressedSize;
                else
                    object.UncompressedSize = options.longs === String ? $util.Long.prototype.toString.call(message.UncompressedSize) : options.longs === Number ? new $util.LongBits(message.UncompressedSize.low >>> 0, message.UncompressedSize.high >>> 0).toNumber(true) : message.UncompressedSize;
            if (message.ProtoLogEvents && message.ProtoLogEvents.length) {
                object.ProtoLogEvents = [];
                for (var j = 0; j < message.ProtoLogEvents.length; ++j)
                    object.ProtoLogEvents[j] = $root.NAppHostProtocol.TProtoEvent.toObject(message.ProtoLogEvents[j], options);
            }
            if (message.FQDNHostName != null && message.hasOwnProperty("FQDNHostName"))
                object.FQDNHostName = message.FQDNHostName;
            if (message.BackendTime != null && message.hasOwnProperty("BackendTime"))
                if (typeof message.BackendTime === "number")
                    object.BackendTime = options.longs === String ? String(message.BackendTime) : message.BackendTime;
                else
                    object.BackendTime = options.longs === String ? $util.Long.prototype.toString.call(message.BackendTime) : options.longs === Number ? new $util.LongBits(message.BackendTime.low >>> 0, message.BackendTime.high >>> 0).toNumber(true) : message.BackendTime;
            if (message.ForceRetry != null && message.hasOwnProperty("ForceRetry"))
                object.ForceRetry = message.ForceRetry;
            if (message.SerialTime != null && message.hasOwnProperty("SerialTime"))
                if (typeof message.SerialTime === "number")
                    object.SerialTime = options.longs === String ? String(message.SerialTime) : message.SerialTime;
                else
                    object.SerialTime = options.longs === String ? $util.Long.prototype.toString.call(message.SerialTime) : options.longs === Number ? new $util.LongBits(message.SerialTime.low >>> 0, message.SerialTime.high >>> 0).toNumber(true) : message.SerialTime;
            return object;
        };

        /**
         * Converts this TServiceResponse to JSON.
         * @function toJSON
         * @memberof NAppHostProtocol.TServiceResponse
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TServiceResponse.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TServiceResponse;
    })();

    NAppHostProtocol.TProtoEvent = (function() {

        /**
         * Properties of a TProtoEvent.
         * @memberof NAppHostProtocol
         * @interface ITProtoEvent
         * @property {number|null} [Timestamp] TProtoEvent Timestamp
         * @property {number|null} [ClassId] TProtoEvent ClassId
         * @property {Array.<string>|null} [SubSourcesPath] TProtoEvent SubSourcesPath
         * @property {google.protobuf.IAny|null} [Event] TProtoEvent Event
         */

        /**
         * Constructs a new TProtoEvent.
         * @memberof NAppHostProtocol
         * @classdesc Represents a TProtoEvent.
         * @implements ITProtoEvent
         * @constructor
         * @param {NAppHostProtocol.ITProtoEvent=} [properties] Properties to set
         */
        function TProtoEvent(properties) {
            this.SubSourcesPath = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TProtoEvent Timestamp.
         * @member {number} Timestamp
         * @memberof NAppHostProtocol.TProtoEvent
         * @instance
         */
        TProtoEvent.prototype.Timestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * TProtoEvent ClassId.
         * @member {number} ClassId
         * @memberof NAppHostProtocol.TProtoEvent
         * @instance
         */
        TProtoEvent.prototype.ClassId = 0;

        /**
         * TProtoEvent SubSourcesPath.
         * @member {Array.<string>} SubSourcesPath
         * @memberof NAppHostProtocol.TProtoEvent
         * @instance
         */
        TProtoEvent.prototype.SubSourcesPath = $util.emptyArray;

        /**
         * TProtoEvent Event.
         * @member {google.protobuf.IAny|null|undefined} Event
         * @memberof NAppHostProtocol.TProtoEvent
         * @instance
         */
        TProtoEvent.prototype.Event = null;

        /**
         * Creates a new TProtoEvent instance using the specified properties.
         * @function create
         * @memberof NAppHostProtocol.TProtoEvent
         * @static
         * @param {NAppHostProtocol.ITProtoEvent=} [properties] Properties to set
         * @returns {NAppHostProtocol.TProtoEvent} TProtoEvent instance
         */
        TProtoEvent.create = function create(properties) {
            return new TProtoEvent(properties);
        };

        /**
         * Encodes the specified TProtoEvent message. Does not implicitly {@link NAppHostProtocol.TProtoEvent.verify|verify} messages.
         * @function encode
         * @memberof NAppHostProtocol.TProtoEvent
         * @static
         * @param {NAppHostProtocol.ITProtoEvent} message TProtoEvent message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TProtoEvent.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.Timestamp != null && Object.hasOwnProperty.call(message, "Timestamp"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint64(message.Timestamp);
            if (message.ClassId != null && Object.hasOwnProperty.call(message, "ClassId"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.ClassId);
            if (message.SubSourcesPath != null && message.SubSourcesPath.length)
                for (var i = 0; i < message.SubSourcesPath.length; ++i)
                    writer.uint32(/* id 3, wireType 2 =*/26).string(message.SubSourcesPath[i]);
            if (message.Event != null && Object.hasOwnProperty.call(message, "Event"))
                $root.google.protobuf.Any.encode(message.Event, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified TProtoEvent message, length delimited. Does not implicitly {@link NAppHostProtocol.TProtoEvent.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NAppHostProtocol.TProtoEvent
         * @static
         * @param {NAppHostProtocol.ITProtoEvent} message TProtoEvent message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TProtoEvent.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TProtoEvent message from the specified reader or buffer.
         * @function decode
         * @memberof NAppHostProtocol.TProtoEvent
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NAppHostProtocol.TProtoEvent} TProtoEvent
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TProtoEvent.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAppHostProtocol.TProtoEvent();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.Timestamp = reader.uint64();
                    break;
                case 2:
                    message.ClassId = reader.int32();
                    break;
                case 3:
                    if (!(message.SubSourcesPath && message.SubSourcesPath.length))
                        message.SubSourcesPath = [];
                    message.SubSourcesPath.push(reader.string());
                    break;
                case 4:
                    message.Event = $root.google.protobuf.Any.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TProtoEvent message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NAppHostProtocol.TProtoEvent
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NAppHostProtocol.TProtoEvent} TProtoEvent
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TProtoEvent.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TProtoEvent message.
         * @function verify
         * @memberof NAppHostProtocol.TProtoEvent
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TProtoEvent.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.Timestamp != null && message.hasOwnProperty("Timestamp"))
                if (!$util.isInteger(message.Timestamp) && !(message.Timestamp && $util.isInteger(message.Timestamp.low) && $util.isInteger(message.Timestamp.high)))
                    return "Timestamp: integer|Long expected";
            if (message.ClassId != null && message.hasOwnProperty("ClassId"))
                if (!$util.isInteger(message.ClassId))
                    return "ClassId: integer expected";
            if (message.SubSourcesPath != null && message.hasOwnProperty("SubSourcesPath")) {
                if (!Array.isArray(message.SubSourcesPath))
                    return "SubSourcesPath: array expected";
                for (var i = 0; i < message.SubSourcesPath.length; ++i)
                    if (!$util.isString(message.SubSourcesPath[i]))
                        return "SubSourcesPath: string[] expected";
            }
            if (message.Event != null && message.hasOwnProperty("Event")) {
                var error = $root.google.protobuf.Any.verify(message.Event);
                if (error)
                    return "Event." + error;
            }
            return null;
        };

        /**
         * Creates a TProtoEvent message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NAppHostProtocol.TProtoEvent
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NAppHostProtocol.TProtoEvent} TProtoEvent
         */
        TProtoEvent.fromObject = function fromObject(object) {
            if (object instanceof $root.NAppHostProtocol.TProtoEvent)
                return object;
            var message = new $root.NAppHostProtocol.TProtoEvent();
            if (object.Timestamp != null)
                if ($util.Long)
                    (message.Timestamp = $util.Long.fromValue(object.Timestamp)).unsigned = true;
                else if (typeof object.Timestamp === "string")
                    message.Timestamp = parseInt(object.Timestamp, 10);
                else if (typeof object.Timestamp === "number")
                    message.Timestamp = object.Timestamp;
                else if (typeof object.Timestamp === "object")
                    message.Timestamp = new $util.LongBits(object.Timestamp.low >>> 0, object.Timestamp.high >>> 0).toNumber(true);
            if (object.ClassId != null)
                message.ClassId = object.ClassId | 0;
            if (object.SubSourcesPath) {
                if (!Array.isArray(object.SubSourcesPath))
                    throw TypeError(".NAppHostProtocol.TProtoEvent.SubSourcesPath: array expected");
                message.SubSourcesPath = [];
                for (var i = 0; i < object.SubSourcesPath.length; ++i)
                    message.SubSourcesPath[i] = String(object.SubSourcesPath[i]);
            }
            if (object.Event != null) {
                if (typeof object.Event !== "object")
                    throw TypeError(".NAppHostProtocol.TProtoEvent.Event: object expected");
                message.Event = $root.google.protobuf.Any.fromObject(object.Event);
            }
            return message;
        };

        /**
         * Creates a plain object from a TProtoEvent message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NAppHostProtocol.TProtoEvent
         * @static
         * @param {NAppHostProtocol.TProtoEvent} message TProtoEvent
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TProtoEvent.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.SubSourcesPath = [];
            if (options.defaults) {
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.Timestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.Timestamp = options.longs === String ? "0" : 0;
                object.ClassId = 0;
                object.Event = null;
            }
            if (message.Timestamp != null && message.hasOwnProperty("Timestamp"))
                if (typeof message.Timestamp === "number")
                    object.Timestamp = options.longs === String ? String(message.Timestamp) : message.Timestamp;
                else
                    object.Timestamp = options.longs === String ? $util.Long.prototype.toString.call(message.Timestamp) : options.longs === Number ? new $util.LongBits(message.Timestamp.low >>> 0, message.Timestamp.high >>> 0).toNumber(true) : message.Timestamp;
            if (message.ClassId != null && message.hasOwnProperty("ClassId"))
                object.ClassId = message.ClassId;
            if (message.SubSourcesPath && message.SubSourcesPath.length) {
                object.SubSourcesPath = [];
                for (var j = 0; j < message.SubSourcesPath.length; ++j)
                    object.SubSourcesPath[j] = message.SubSourcesPath[j];
            }
            if (message.Event != null && message.hasOwnProperty("Event"))
                object.Event = $root.google.protobuf.Any.toObject(message.Event, options);
            return object;
        };

        /**
         * Converts this TProtoEvent to JSON.
         * @function toJSON
         * @memberof NAppHostProtocol.TProtoEvent
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TProtoEvent.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TProtoEvent;
    })();

    NAppHostProtocol.TProtoEventLogDump = (function() {

        /**
         * Properties of a TProtoEventLogDump.
         * @memberof NAppHostProtocol
         * @interface ITProtoEventLogDump
         * @property {Array.<NAppHostProtocol.ITProtoEvent>|null} [LogEvent] TProtoEventLogDump LogEvent
         */

        /**
         * Constructs a new TProtoEventLogDump.
         * @memberof NAppHostProtocol
         * @classdesc Represents a TProtoEventLogDump.
         * @implements ITProtoEventLogDump
         * @constructor
         * @param {NAppHostProtocol.ITProtoEventLogDump=} [properties] Properties to set
         */
        function TProtoEventLogDump(properties) {
            this.LogEvent = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TProtoEventLogDump LogEvent.
         * @member {Array.<NAppHostProtocol.ITProtoEvent>} LogEvent
         * @memberof NAppHostProtocol.TProtoEventLogDump
         * @instance
         */
        TProtoEventLogDump.prototype.LogEvent = $util.emptyArray;

        /**
         * Creates a new TProtoEventLogDump instance using the specified properties.
         * @function create
         * @memberof NAppHostProtocol.TProtoEventLogDump
         * @static
         * @param {NAppHostProtocol.ITProtoEventLogDump=} [properties] Properties to set
         * @returns {NAppHostProtocol.TProtoEventLogDump} TProtoEventLogDump instance
         */
        TProtoEventLogDump.create = function create(properties) {
            return new TProtoEventLogDump(properties);
        };

        /**
         * Encodes the specified TProtoEventLogDump message. Does not implicitly {@link NAppHostProtocol.TProtoEventLogDump.verify|verify} messages.
         * @function encode
         * @memberof NAppHostProtocol.TProtoEventLogDump
         * @static
         * @param {NAppHostProtocol.ITProtoEventLogDump} message TProtoEventLogDump message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TProtoEventLogDump.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.LogEvent != null && message.LogEvent.length)
                for (var i = 0; i < message.LogEvent.length; ++i)
                    $root.NAppHostProtocol.TProtoEvent.encode(message.LogEvent[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified TProtoEventLogDump message, length delimited. Does not implicitly {@link NAppHostProtocol.TProtoEventLogDump.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NAppHostProtocol.TProtoEventLogDump
         * @static
         * @param {NAppHostProtocol.ITProtoEventLogDump} message TProtoEventLogDump message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TProtoEventLogDump.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TProtoEventLogDump message from the specified reader or buffer.
         * @function decode
         * @memberof NAppHostProtocol.TProtoEventLogDump
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NAppHostProtocol.TProtoEventLogDump} TProtoEventLogDump
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TProtoEventLogDump.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NAppHostProtocol.TProtoEventLogDump();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    if (!(message.LogEvent && message.LogEvent.length))
                        message.LogEvent = [];
                    message.LogEvent.push($root.NAppHostProtocol.TProtoEvent.decode(reader, reader.uint32()));
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TProtoEventLogDump message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NAppHostProtocol.TProtoEventLogDump
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NAppHostProtocol.TProtoEventLogDump} TProtoEventLogDump
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TProtoEventLogDump.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TProtoEventLogDump message.
         * @function verify
         * @memberof NAppHostProtocol.TProtoEventLogDump
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TProtoEventLogDump.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.LogEvent != null && message.hasOwnProperty("LogEvent")) {
                if (!Array.isArray(message.LogEvent))
                    return "LogEvent: array expected";
                for (var i = 0; i < message.LogEvent.length; ++i) {
                    var error = $root.NAppHostProtocol.TProtoEvent.verify(message.LogEvent[i]);
                    if (error)
                        return "LogEvent." + error;
                }
            }
            return null;
        };

        /**
         * Creates a TProtoEventLogDump message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NAppHostProtocol.TProtoEventLogDump
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NAppHostProtocol.TProtoEventLogDump} TProtoEventLogDump
         */
        TProtoEventLogDump.fromObject = function fromObject(object) {
            if (object instanceof $root.NAppHostProtocol.TProtoEventLogDump)
                return object;
            var message = new $root.NAppHostProtocol.TProtoEventLogDump();
            if (object.LogEvent) {
                if (!Array.isArray(object.LogEvent))
                    throw TypeError(".NAppHostProtocol.TProtoEventLogDump.LogEvent: array expected");
                message.LogEvent = [];
                for (var i = 0; i < object.LogEvent.length; ++i) {
                    if (typeof object.LogEvent[i] !== "object")
                        throw TypeError(".NAppHostProtocol.TProtoEventLogDump.LogEvent: object expected");
                    message.LogEvent[i] = $root.NAppHostProtocol.TProtoEvent.fromObject(object.LogEvent[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a TProtoEventLogDump message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NAppHostProtocol.TProtoEventLogDump
         * @static
         * @param {NAppHostProtocol.TProtoEventLogDump} message TProtoEventLogDump
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TProtoEventLogDump.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.LogEvent = [];
            if (message.LogEvent && message.LogEvent.length) {
                object.LogEvent = [];
                for (var j = 0; j < message.LogEvent.length; ++j)
                    object.LogEvent[j] = $root.NAppHostProtocol.TProtoEvent.toObject(message.LogEvent[j], options);
            }
            return object;
        };

        /**
         * Converts this TProtoEventLogDump to JSON.
         * @function toJSON
         * @memberof NAppHostProtocol.TProtoEventLogDump
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TProtoEventLogDump.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TProtoEventLogDump;
    })();

    return NAppHostProtocol;
})();

$root.google = (function() {

    /**
     * Namespace google.
     * @exports google
     * @namespace
     */
    var google = {};

    google.protobuf = (function() {

        /**
         * Namespace protobuf.
         * @memberof google
         * @namespace
         */
        var protobuf = {};

        protobuf.Any = (function() {

            /**
             * Properties of an Any.
             * @memberof google.protobuf
             * @interface IAny
             * @property {string|null} [type_url] Any type_url
             * @property {Uint8Array|null} [value] Any value
             */

            /**
             * Constructs a new Any.
             * @memberof google.protobuf
             * @classdesc Represents an Any.
             * @implements IAny
             * @constructor
             * @param {google.protobuf.IAny=} [properties] Properties to set
             */
            function Any(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * Any type_url.
             * @member {string} type_url
             * @memberof google.protobuf.Any
             * @instance
             */
            Any.prototype.type_url = "";

            /**
             * Any value.
             * @member {Uint8Array} value
             * @memberof google.protobuf.Any
             * @instance
             */
            Any.prototype.value = $util.newBuffer([]);

            /**
             * Creates a new Any instance using the specified properties.
             * @function create
             * @memberof google.protobuf.Any
             * @static
             * @param {google.protobuf.IAny=} [properties] Properties to set
             * @returns {google.protobuf.Any} Any instance
             */
            Any.create = function create(properties) {
                return new Any(properties);
            };

            /**
             * Encodes the specified Any message. Does not implicitly {@link google.protobuf.Any.verify|verify} messages.
             * @function encode
             * @memberof google.protobuf.Any
             * @static
             * @param {google.protobuf.IAny} message Any message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            Any.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.type_url != null && Object.hasOwnProperty.call(message, "type_url"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.type_url);
                if (message.value != null && Object.hasOwnProperty.call(message, "value"))
                    writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.value);
                return writer;
            };

            /**
             * Encodes the specified Any message, length delimited. Does not implicitly {@link google.protobuf.Any.verify|verify} messages.
             * @function encodeDelimited
             * @memberof google.protobuf.Any
             * @static
             * @param {google.protobuf.IAny} message Any message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            Any.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes an Any message from the specified reader or buffer.
             * @function decode
             * @memberof google.protobuf.Any
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {google.protobuf.Any} Any
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            Any.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.Any();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.type_url = reader.string();
                        break;
                    case 2:
                        message.value = reader.bytes();
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes an Any message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof google.protobuf.Any
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {google.protobuf.Any} Any
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            Any.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies an Any message.
             * @function verify
             * @memberof google.protobuf.Any
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            Any.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.type_url != null && message.hasOwnProperty("type_url"))
                    if (!$util.isString(message.type_url))
                        return "type_url: string expected";
                if (message.value != null && message.hasOwnProperty("value"))
                    if (!(message.value && typeof message.value.length === "number" || $util.isString(message.value)))
                        return "value: buffer expected";
                return null;
            };

            /**
             * Creates an Any message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof google.protobuf.Any
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {google.protobuf.Any} Any
             */
            Any.fromObject = function fromObject(object) {
                if (object instanceof $root.google.protobuf.Any)
                    return object;
                var message = new $root.google.protobuf.Any();
                if (object.type_url != null)
                    message.type_url = String(object.type_url);
                if (object.value != null)
                    if (typeof object.value === "string")
                        $util.base64.decode(object.value, message.value = $util.newBuffer($util.base64.length(object.value)), 0);
                    else if (object.value.length)
                        message.value = object.value;
                return message;
            };

            /**
             * Creates a plain object from an Any message. Also converts values to other types if specified.
             * @function toObject
             * @memberof google.protobuf.Any
             * @static
             * @param {google.protobuf.Any} message Any
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            Any.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.defaults) {
                    object.type_url = "";
                    if (options.bytes === String)
                        object.value = "";
                    else {
                        object.value = [];
                        if (options.bytes !== Array)
                            object.value = $util.newBuffer(object.value);
                    }
                }
                if (message.type_url != null && message.hasOwnProperty("type_url"))
                    object.type_url = message.type_url;
                if (message.value != null && message.hasOwnProperty("value"))
                    object.value = options.bytes === String ? $util.base64.encode(message.value, 0, message.value.length) : options.bytes === Array ? Array.prototype.slice.call(message.value) : message.value;
                return object;
            };

            /**
             * Converts this Any to JSON.
             * @function toJSON
             * @memberof google.protobuf.Any
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            Any.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return Any;
        })();

        protobuf.FileDescriptorSet = (function() {

            /**
             * Properties of a FileDescriptorSet.
             * @memberof google.protobuf
             * @interface IFileDescriptorSet
             * @property {Array.<google.protobuf.IFileDescriptorProto>|null} [file] FileDescriptorSet file
             */

            /**
             * Constructs a new FileDescriptorSet.
             * @memberof google.protobuf
             * @classdesc Represents a FileDescriptorSet.
             * @implements IFileDescriptorSet
             * @constructor
             * @param {google.protobuf.IFileDescriptorSet=} [properties] Properties to set
             */
            function FileDescriptorSet(properties) {
                this.file = [];
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * FileDescriptorSet file.
             * @member {Array.<google.protobuf.IFileDescriptorProto>} file
             * @memberof google.protobuf.FileDescriptorSet
             * @instance
             */
            FileDescriptorSet.prototype.file = $util.emptyArray;

            /**
             * Creates a new FileDescriptorSet instance using the specified properties.
             * @function create
             * @memberof google.protobuf.FileDescriptorSet
             * @static
             * @param {google.protobuf.IFileDescriptorSet=} [properties] Properties to set
             * @returns {google.protobuf.FileDescriptorSet} FileDescriptorSet instance
             */
            FileDescriptorSet.create = function create(properties) {
                return new FileDescriptorSet(properties);
            };

            /**
             * Encodes the specified FileDescriptorSet message. Does not implicitly {@link google.protobuf.FileDescriptorSet.verify|verify} messages.
             * @function encode
             * @memberof google.protobuf.FileDescriptorSet
             * @static
             * @param {google.protobuf.IFileDescriptorSet} message FileDescriptorSet message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            FileDescriptorSet.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.file != null && message.file.length)
                    for (var i = 0; i < message.file.length; ++i)
                        $root.google.protobuf.FileDescriptorProto.encode(message.file[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                return writer;
            };

            /**
             * Encodes the specified FileDescriptorSet message, length delimited. Does not implicitly {@link google.protobuf.FileDescriptorSet.verify|verify} messages.
             * @function encodeDelimited
             * @memberof google.protobuf.FileDescriptorSet
             * @static
             * @param {google.protobuf.IFileDescriptorSet} message FileDescriptorSet message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            FileDescriptorSet.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a FileDescriptorSet message from the specified reader or buffer.
             * @function decode
             * @memberof google.protobuf.FileDescriptorSet
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {google.protobuf.FileDescriptorSet} FileDescriptorSet
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            FileDescriptorSet.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.FileDescriptorSet();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        if (!(message.file && message.file.length))
                            message.file = [];
                        message.file.push($root.google.protobuf.FileDescriptorProto.decode(reader, reader.uint32()));
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a FileDescriptorSet message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof google.protobuf.FileDescriptorSet
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {google.protobuf.FileDescriptorSet} FileDescriptorSet
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            FileDescriptorSet.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a FileDescriptorSet message.
             * @function verify
             * @memberof google.protobuf.FileDescriptorSet
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            FileDescriptorSet.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.file != null && message.hasOwnProperty("file")) {
                    if (!Array.isArray(message.file))
                        return "file: array expected";
                    for (var i = 0; i < message.file.length; ++i) {
                        var error = $root.google.protobuf.FileDescriptorProto.verify(message.file[i]);
                        if (error)
                            return "file." + error;
                    }
                }
                return null;
            };

            /**
             * Creates a FileDescriptorSet message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof google.protobuf.FileDescriptorSet
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {google.protobuf.FileDescriptorSet} FileDescriptorSet
             */
            FileDescriptorSet.fromObject = function fromObject(object) {
                if (object instanceof $root.google.protobuf.FileDescriptorSet)
                    return object;
                var message = new $root.google.protobuf.FileDescriptorSet();
                if (object.file) {
                    if (!Array.isArray(object.file))
                        throw TypeError(".google.protobuf.FileDescriptorSet.file: array expected");
                    message.file = [];
                    for (var i = 0; i < object.file.length; ++i) {
                        if (typeof object.file[i] !== "object")
                            throw TypeError(".google.protobuf.FileDescriptorSet.file: object expected");
                        message.file[i] = $root.google.protobuf.FileDescriptorProto.fromObject(object.file[i]);
                    }
                }
                return message;
            };

            /**
             * Creates a plain object from a FileDescriptorSet message. Also converts values to other types if specified.
             * @function toObject
             * @memberof google.protobuf.FileDescriptorSet
             * @static
             * @param {google.protobuf.FileDescriptorSet} message FileDescriptorSet
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            FileDescriptorSet.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.arrays || options.defaults)
                    object.file = [];
                if (message.file && message.file.length) {
                    object.file = [];
                    for (var j = 0; j < message.file.length; ++j)
                        object.file[j] = $root.google.protobuf.FileDescriptorProto.toObject(message.file[j], options);
                }
                return object;
            };

            /**
             * Converts this FileDescriptorSet to JSON.
             * @function toJSON
             * @memberof google.protobuf.FileDescriptorSet
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            FileDescriptorSet.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return FileDescriptorSet;
        })();

        protobuf.FileDescriptorProto = (function() {

            /**
             * Properties of a FileDescriptorProto.
             * @memberof google.protobuf
             * @interface IFileDescriptorProto
             * @property {string|null} [name] FileDescriptorProto name
             * @property {string|null} ["package"] FileDescriptorProto package
             * @property {Array.<string>|null} [dependency] FileDescriptorProto dependency
             * @property {Array.<number>|null} [publicDependency] FileDescriptorProto publicDependency
             * @property {Array.<number>|null} [weakDependency] FileDescriptorProto weakDependency
             * @property {Array.<google.protobuf.IDescriptorProto>|null} [messageType] FileDescriptorProto messageType
             * @property {Array.<google.protobuf.IEnumDescriptorProto>|null} [enumType] FileDescriptorProto enumType
             * @property {Array.<google.protobuf.IServiceDescriptorProto>|null} [service] FileDescriptorProto service
             * @property {Array.<google.protobuf.IFieldDescriptorProto>|null} [extension] FileDescriptorProto extension
             * @property {google.protobuf.IFileOptions|null} [options] FileDescriptorProto options
             * @property {google.protobuf.ISourceCodeInfo|null} [sourceCodeInfo] FileDescriptorProto sourceCodeInfo
             * @property {string|null} [syntax] FileDescriptorProto syntax
             */

            /**
             * Constructs a new FileDescriptorProto.
             * @memberof google.protobuf
             * @classdesc Represents a FileDescriptorProto.
             * @implements IFileDescriptorProto
             * @constructor
             * @param {google.protobuf.IFileDescriptorProto=} [properties] Properties to set
             */
            function FileDescriptorProto(properties) {
                this.dependency = [];
                this.publicDependency = [];
                this.weakDependency = [];
                this.messageType = [];
                this.enumType = [];
                this.service = [];
                this.extension = [];
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * FileDescriptorProto name.
             * @member {string} name
             * @memberof google.protobuf.FileDescriptorProto
             * @instance
             */
            FileDescriptorProto.prototype.name = "";

            /**
             * FileDescriptorProto package.
             * @member {string} package
             * @memberof google.protobuf.FileDescriptorProto
             * @instance
             */
            FileDescriptorProto.prototype["package"] = "";

            /**
             * FileDescriptorProto dependency.
             * @member {Array.<string>} dependency
             * @memberof google.protobuf.FileDescriptorProto
             * @instance
             */
            FileDescriptorProto.prototype.dependency = $util.emptyArray;

            /**
             * FileDescriptorProto publicDependency.
             * @member {Array.<number>} publicDependency
             * @memberof google.protobuf.FileDescriptorProto
             * @instance
             */
            FileDescriptorProto.prototype.publicDependency = $util.emptyArray;

            /**
             * FileDescriptorProto weakDependency.
             * @member {Array.<number>} weakDependency
             * @memberof google.protobuf.FileDescriptorProto
             * @instance
             */
            FileDescriptorProto.prototype.weakDependency = $util.emptyArray;

            /**
             * FileDescriptorProto messageType.
             * @member {Array.<google.protobuf.IDescriptorProto>} messageType
             * @memberof google.protobuf.FileDescriptorProto
             * @instance
             */
            FileDescriptorProto.prototype.messageType = $util.emptyArray;

            /**
             * FileDescriptorProto enumType.
             * @member {Array.<google.protobuf.IEnumDescriptorProto>} enumType
             * @memberof google.protobuf.FileDescriptorProto
             * @instance
             */
            FileDescriptorProto.prototype.enumType = $util.emptyArray;

            /**
             * FileDescriptorProto service.
             * @member {Array.<google.protobuf.IServiceDescriptorProto>} service
             * @memberof google.protobuf.FileDescriptorProto
             * @instance
             */
            FileDescriptorProto.prototype.service = $util.emptyArray;

            /**
             * FileDescriptorProto extension.
             * @member {Array.<google.protobuf.IFieldDescriptorProto>} extension
             * @memberof google.protobuf.FileDescriptorProto
             * @instance
             */
            FileDescriptorProto.prototype.extension = $util.emptyArray;

            /**
             * FileDescriptorProto options.
             * @member {google.protobuf.IFileOptions|null|undefined} options
             * @memberof google.protobuf.FileDescriptorProto
             * @instance
             */
            FileDescriptorProto.prototype.options = null;

            /**
             * FileDescriptorProto sourceCodeInfo.
             * @member {google.protobuf.ISourceCodeInfo|null|undefined} sourceCodeInfo
             * @memberof google.protobuf.FileDescriptorProto
             * @instance
             */
            FileDescriptorProto.prototype.sourceCodeInfo = null;

            /**
             * FileDescriptorProto syntax.
             * @member {string} syntax
             * @memberof google.protobuf.FileDescriptorProto
             * @instance
             */
            FileDescriptorProto.prototype.syntax = "";

            /**
             * Creates a new FileDescriptorProto instance using the specified properties.
             * @function create
             * @memberof google.protobuf.FileDescriptorProto
             * @static
             * @param {google.protobuf.IFileDescriptorProto=} [properties] Properties to set
             * @returns {google.protobuf.FileDescriptorProto} FileDescriptorProto instance
             */
            FileDescriptorProto.create = function create(properties) {
                return new FileDescriptorProto(properties);
            };

            /**
             * Encodes the specified FileDescriptorProto message. Does not implicitly {@link google.protobuf.FileDescriptorProto.verify|verify} messages.
             * @function encode
             * @memberof google.protobuf.FileDescriptorProto
             * @static
             * @param {google.protobuf.IFileDescriptorProto} message FileDescriptorProto message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            FileDescriptorProto.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                if (message["package"] != null && Object.hasOwnProperty.call(message, "package"))
                    writer.uint32(/* id 2, wireType 2 =*/18).string(message["package"]);
                if (message.dependency != null && message.dependency.length)
                    for (var i = 0; i < message.dependency.length; ++i)
                        writer.uint32(/* id 3, wireType 2 =*/26).string(message.dependency[i]);
                if (message.messageType != null && message.messageType.length)
                    for (var i = 0; i < message.messageType.length; ++i)
                        $root.google.protobuf.DescriptorProto.encode(message.messageType[i], writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                if (message.enumType != null && message.enumType.length)
                    for (var i = 0; i < message.enumType.length; ++i)
                        $root.google.protobuf.EnumDescriptorProto.encode(message.enumType[i], writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                if (message.service != null && message.service.length)
                    for (var i = 0; i < message.service.length; ++i)
                        $root.google.protobuf.ServiceDescriptorProto.encode(message.service[i], writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                if (message.extension != null && message.extension.length)
                    for (var i = 0; i < message.extension.length; ++i)
                        $root.google.protobuf.FieldDescriptorProto.encode(message.extension[i], writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                if (message.options != null && Object.hasOwnProperty.call(message, "options"))
                    $root.google.protobuf.FileOptions.encode(message.options, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                if (message.sourceCodeInfo != null && Object.hasOwnProperty.call(message, "sourceCodeInfo"))
                    $root.google.protobuf.SourceCodeInfo.encode(message.sourceCodeInfo, writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
                if (message.publicDependency != null && message.publicDependency.length)
                    for (var i = 0; i < message.publicDependency.length; ++i)
                        writer.uint32(/* id 10, wireType 0 =*/80).int32(message.publicDependency[i]);
                if (message.weakDependency != null && message.weakDependency.length)
                    for (var i = 0; i < message.weakDependency.length; ++i)
                        writer.uint32(/* id 11, wireType 0 =*/88).int32(message.weakDependency[i]);
                if (message.syntax != null && Object.hasOwnProperty.call(message, "syntax"))
                    writer.uint32(/* id 12, wireType 2 =*/98).string(message.syntax);
                return writer;
            };

            /**
             * Encodes the specified FileDescriptorProto message, length delimited. Does not implicitly {@link google.protobuf.FileDescriptorProto.verify|verify} messages.
             * @function encodeDelimited
             * @memberof google.protobuf.FileDescriptorProto
             * @static
             * @param {google.protobuf.IFileDescriptorProto} message FileDescriptorProto message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            FileDescriptorProto.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a FileDescriptorProto message from the specified reader or buffer.
             * @function decode
             * @memberof google.protobuf.FileDescriptorProto
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {google.protobuf.FileDescriptorProto} FileDescriptorProto
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            FileDescriptorProto.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.FileDescriptorProto();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.name = reader.string();
                        break;
                    case 2:
                        message["package"] = reader.string();
                        break;
                    case 3:
                        if (!(message.dependency && message.dependency.length))
                            message.dependency = [];
                        message.dependency.push(reader.string());
                        break;
                    case 10:
                        if (!(message.publicDependency && message.publicDependency.length))
                            message.publicDependency = [];
                        if ((tag & 7) === 2) {
                            var end2 = reader.uint32() + reader.pos;
                            while (reader.pos < end2)
                                message.publicDependency.push(reader.int32());
                        } else
                            message.publicDependency.push(reader.int32());
                        break;
                    case 11:
                        if (!(message.weakDependency && message.weakDependency.length))
                            message.weakDependency = [];
                        if ((tag & 7) === 2) {
                            var end2 = reader.uint32() + reader.pos;
                            while (reader.pos < end2)
                                message.weakDependency.push(reader.int32());
                        } else
                            message.weakDependency.push(reader.int32());
                        break;
                    case 4:
                        if (!(message.messageType && message.messageType.length))
                            message.messageType = [];
                        message.messageType.push($root.google.protobuf.DescriptorProto.decode(reader, reader.uint32()));
                        break;
                    case 5:
                        if (!(message.enumType && message.enumType.length))
                            message.enumType = [];
                        message.enumType.push($root.google.protobuf.EnumDescriptorProto.decode(reader, reader.uint32()));
                        break;
                    case 6:
                        if (!(message.service && message.service.length))
                            message.service = [];
                        message.service.push($root.google.protobuf.ServiceDescriptorProto.decode(reader, reader.uint32()));
                        break;
                    case 7:
                        if (!(message.extension && message.extension.length))
                            message.extension = [];
                        message.extension.push($root.google.protobuf.FieldDescriptorProto.decode(reader, reader.uint32()));
                        break;
                    case 8:
                        message.options = $root.google.protobuf.FileOptions.decode(reader, reader.uint32());
                        break;
                    case 9:
                        message.sourceCodeInfo = $root.google.protobuf.SourceCodeInfo.decode(reader, reader.uint32());
                        break;
                    case 12:
                        message.syntax = reader.string();
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a FileDescriptorProto message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof google.protobuf.FileDescriptorProto
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {google.protobuf.FileDescriptorProto} FileDescriptorProto
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            FileDescriptorProto.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a FileDescriptorProto message.
             * @function verify
             * @memberof google.protobuf.FileDescriptorProto
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            FileDescriptorProto.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.name != null && message.hasOwnProperty("name"))
                    if (!$util.isString(message.name))
                        return "name: string expected";
                if (message["package"] != null && message.hasOwnProperty("package"))
                    if (!$util.isString(message["package"]))
                        return "package: string expected";
                if (message.dependency != null && message.hasOwnProperty("dependency")) {
                    if (!Array.isArray(message.dependency))
                        return "dependency: array expected";
                    for (var i = 0; i < message.dependency.length; ++i)
                        if (!$util.isString(message.dependency[i]))
                            return "dependency: string[] expected";
                }
                if (message.publicDependency != null && message.hasOwnProperty("publicDependency")) {
                    if (!Array.isArray(message.publicDependency))
                        return "publicDependency: array expected";
                    for (var i = 0; i < message.publicDependency.length; ++i)
                        if (!$util.isInteger(message.publicDependency[i]))
                            return "publicDependency: integer[] expected";
                }
                if (message.weakDependency != null && message.hasOwnProperty("weakDependency")) {
                    if (!Array.isArray(message.weakDependency))
                        return "weakDependency: array expected";
                    for (var i = 0; i < message.weakDependency.length; ++i)
                        if (!$util.isInteger(message.weakDependency[i]))
                            return "weakDependency: integer[] expected";
                }
                if (message.messageType != null && message.hasOwnProperty("messageType")) {
                    if (!Array.isArray(message.messageType))
                        return "messageType: array expected";
                    for (var i = 0; i < message.messageType.length; ++i) {
                        var error = $root.google.protobuf.DescriptorProto.verify(message.messageType[i]);
                        if (error)
                            return "messageType." + error;
                    }
                }
                if (message.enumType != null && message.hasOwnProperty("enumType")) {
                    if (!Array.isArray(message.enumType))
                        return "enumType: array expected";
                    for (var i = 0; i < message.enumType.length; ++i) {
                        var error = $root.google.protobuf.EnumDescriptorProto.verify(message.enumType[i]);
                        if (error)
                            return "enumType." + error;
                    }
                }
                if (message.service != null && message.hasOwnProperty("service")) {
                    if (!Array.isArray(message.service))
                        return "service: array expected";
                    for (var i = 0; i < message.service.length; ++i) {
                        var error = $root.google.protobuf.ServiceDescriptorProto.verify(message.service[i]);
                        if (error)
                            return "service." + error;
                    }
                }
                if (message.extension != null && message.hasOwnProperty("extension")) {
                    if (!Array.isArray(message.extension))
                        return "extension: array expected";
                    for (var i = 0; i < message.extension.length; ++i) {
                        var error = $root.google.protobuf.FieldDescriptorProto.verify(message.extension[i]);
                        if (error)
                            return "extension." + error;
                    }
                }
                if (message.options != null && message.hasOwnProperty("options")) {
                    var error = $root.google.protobuf.FileOptions.verify(message.options);
                    if (error)
                        return "options." + error;
                }
                if (message.sourceCodeInfo != null && message.hasOwnProperty("sourceCodeInfo")) {
                    var error = $root.google.protobuf.SourceCodeInfo.verify(message.sourceCodeInfo);
                    if (error)
                        return "sourceCodeInfo." + error;
                }
                if (message.syntax != null && message.hasOwnProperty("syntax"))
                    if (!$util.isString(message.syntax))
                        return "syntax: string expected";
                return null;
            };

            /**
             * Creates a FileDescriptorProto message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof google.protobuf.FileDescriptorProto
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {google.protobuf.FileDescriptorProto} FileDescriptorProto
             */
            FileDescriptorProto.fromObject = function fromObject(object) {
                if (object instanceof $root.google.protobuf.FileDescriptorProto)
                    return object;
                var message = new $root.google.protobuf.FileDescriptorProto();
                if (object.name != null)
                    message.name = String(object.name);
                if (object["package"] != null)
                    message["package"] = String(object["package"]);
                if (object.dependency) {
                    if (!Array.isArray(object.dependency))
                        throw TypeError(".google.protobuf.FileDescriptorProto.dependency: array expected");
                    message.dependency = [];
                    for (var i = 0; i < object.dependency.length; ++i)
                        message.dependency[i] = String(object.dependency[i]);
                }
                if (object.publicDependency) {
                    if (!Array.isArray(object.publicDependency))
                        throw TypeError(".google.protobuf.FileDescriptorProto.publicDependency: array expected");
                    message.publicDependency = [];
                    for (var i = 0; i < object.publicDependency.length; ++i)
                        message.publicDependency[i] = object.publicDependency[i] | 0;
                }
                if (object.weakDependency) {
                    if (!Array.isArray(object.weakDependency))
                        throw TypeError(".google.protobuf.FileDescriptorProto.weakDependency: array expected");
                    message.weakDependency = [];
                    for (var i = 0; i < object.weakDependency.length; ++i)
                        message.weakDependency[i] = object.weakDependency[i] | 0;
                }
                if (object.messageType) {
                    if (!Array.isArray(object.messageType))
                        throw TypeError(".google.protobuf.FileDescriptorProto.messageType: array expected");
                    message.messageType = [];
                    for (var i = 0; i < object.messageType.length; ++i) {
                        if (typeof object.messageType[i] !== "object")
                            throw TypeError(".google.protobuf.FileDescriptorProto.messageType: object expected");
                        message.messageType[i] = $root.google.protobuf.DescriptorProto.fromObject(object.messageType[i]);
                    }
                }
                if (object.enumType) {
                    if (!Array.isArray(object.enumType))
                        throw TypeError(".google.protobuf.FileDescriptorProto.enumType: array expected");
                    message.enumType = [];
                    for (var i = 0; i < object.enumType.length; ++i) {
                        if (typeof object.enumType[i] !== "object")
                            throw TypeError(".google.protobuf.FileDescriptorProto.enumType: object expected");
                        message.enumType[i] = $root.google.protobuf.EnumDescriptorProto.fromObject(object.enumType[i]);
                    }
                }
                if (object.service) {
                    if (!Array.isArray(object.service))
                        throw TypeError(".google.protobuf.FileDescriptorProto.service: array expected");
                    message.service = [];
                    for (var i = 0; i < object.service.length; ++i) {
                        if (typeof object.service[i] !== "object")
                            throw TypeError(".google.protobuf.FileDescriptorProto.service: object expected");
                        message.service[i] = $root.google.protobuf.ServiceDescriptorProto.fromObject(object.service[i]);
                    }
                }
                if (object.extension) {
                    if (!Array.isArray(object.extension))
                        throw TypeError(".google.protobuf.FileDescriptorProto.extension: array expected");
                    message.extension = [];
                    for (var i = 0; i < object.extension.length; ++i) {
                        if (typeof object.extension[i] !== "object")
                            throw TypeError(".google.protobuf.FileDescriptorProto.extension: object expected");
                        message.extension[i] = $root.google.protobuf.FieldDescriptorProto.fromObject(object.extension[i]);
                    }
                }
                if (object.options != null) {
                    if (typeof object.options !== "object")
                        throw TypeError(".google.protobuf.FileDescriptorProto.options: object expected");
                    message.options = $root.google.protobuf.FileOptions.fromObject(object.options);
                }
                if (object.sourceCodeInfo != null) {
                    if (typeof object.sourceCodeInfo !== "object")
                        throw TypeError(".google.protobuf.FileDescriptorProto.sourceCodeInfo: object expected");
                    message.sourceCodeInfo = $root.google.protobuf.SourceCodeInfo.fromObject(object.sourceCodeInfo);
                }
                if (object.syntax != null)
                    message.syntax = String(object.syntax);
                return message;
            };

            /**
             * Creates a plain object from a FileDescriptorProto message. Also converts values to other types if specified.
             * @function toObject
             * @memberof google.protobuf.FileDescriptorProto
             * @static
             * @param {google.protobuf.FileDescriptorProto} message FileDescriptorProto
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            FileDescriptorProto.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.arrays || options.defaults) {
                    object.dependency = [];
                    object.messageType = [];
                    object.enumType = [];
                    object.service = [];
                    object.extension = [];
                    object.publicDependency = [];
                    object.weakDependency = [];
                }
                if (options.defaults) {
                    object.name = "";
                    object["package"] = "";
                    object.options = null;
                    object.sourceCodeInfo = null;
                    object.syntax = "";
                }
                if (message.name != null && message.hasOwnProperty("name"))
                    object.name = message.name;
                if (message["package"] != null && message.hasOwnProperty("package"))
                    object["package"] = message["package"];
                if (message.dependency && message.dependency.length) {
                    object.dependency = [];
                    for (var j = 0; j < message.dependency.length; ++j)
                        object.dependency[j] = message.dependency[j];
                }
                if (message.messageType && message.messageType.length) {
                    object.messageType = [];
                    for (var j = 0; j < message.messageType.length; ++j)
                        object.messageType[j] = $root.google.protobuf.DescriptorProto.toObject(message.messageType[j], options);
                }
                if (message.enumType && message.enumType.length) {
                    object.enumType = [];
                    for (var j = 0; j < message.enumType.length; ++j)
                        object.enumType[j] = $root.google.protobuf.EnumDescriptorProto.toObject(message.enumType[j], options);
                }
                if (message.service && message.service.length) {
                    object.service = [];
                    for (var j = 0; j < message.service.length; ++j)
                        object.service[j] = $root.google.protobuf.ServiceDescriptorProto.toObject(message.service[j], options);
                }
                if (message.extension && message.extension.length) {
                    object.extension = [];
                    for (var j = 0; j < message.extension.length; ++j)
                        object.extension[j] = $root.google.protobuf.FieldDescriptorProto.toObject(message.extension[j], options);
                }
                if (message.options != null && message.hasOwnProperty("options"))
                    object.options = $root.google.protobuf.FileOptions.toObject(message.options, options);
                if (message.sourceCodeInfo != null && message.hasOwnProperty("sourceCodeInfo"))
                    object.sourceCodeInfo = $root.google.protobuf.SourceCodeInfo.toObject(message.sourceCodeInfo, options);
                if (message.publicDependency && message.publicDependency.length) {
                    object.publicDependency = [];
                    for (var j = 0; j < message.publicDependency.length; ++j)
                        object.publicDependency[j] = message.publicDependency[j];
                }
                if (message.weakDependency && message.weakDependency.length) {
                    object.weakDependency = [];
                    for (var j = 0; j < message.weakDependency.length; ++j)
                        object.weakDependency[j] = message.weakDependency[j];
                }
                if (message.syntax != null && message.hasOwnProperty("syntax"))
                    object.syntax = message.syntax;
                return object;
            };

            /**
             * Converts this FileDescriptorProto to JSON.
             * @function toJSON
             * @memberof google.protobuf.FileDescriptorProto
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            FileDescriptorProto.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return FileDescriptorProto;
        })();

        protobuf.DescriptorProto = (function() {

            /**
             * Properties of a DescriptorProto.
             * @memberof google.protobuf
             * @interface IDescriptorProto
             * @property {string|null} [name] DescriptorProto name
             * @property {Array.<google.protobuf.IFieldDescriptorProto>|null} [field] DescriptorProto field
             * @property {Array.<google.protobuf.IFieldDescriptorProto>|null} [extension] DescriptorProto extension
             * @property {Array.<google.protobuf.IDescriptorProto>|null} [nestedType] DescriptorProto nestedType
             * @property {Array.<google.protobuf.IEnumDescriptorProto>|null} [enumType] DescriptorProto enumType
             * @property {Array.<google.protobuf.DescriptorProto.IExtensionRange>|null} [extensionRange] DescriptorProto extensionRange
             * @property {Array.<google.protobuf.IOneofDescriptorProto>|null} [oneofDecl] DescriptorProto oneofDecl
             * @property {google.protobuf.IMessageOptions|null} [options] DescriptorProto options
             * @property {Array.<google.protobuf.DescriptorProto.IReservedRange>|null} [reservedRange] DescriptorProto reservedRange
             * @property {Array.<string>|null} [reservedName] DescriptorProto reservedName
             */

            /**
             * Constructs a new DescriptorProto.
             * @memberof google.protobuf
             * @classdesc Represents a DescriptorProto.
             * @implements IDescriptorProto
             * @constructor
             * @param {google.protobuf.IDescriptorProto=} [properties] Properties to set
             */
            function DescriptorProto(properties) {
                this.field = [];
                this.extension = [];
                this.nestedType = [];
                this.enumType = [];
                this.extensionRange = [];
                this.oneofDecl = [];
                this.reservedRange = [];
                this.reservedName = [];
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * DescriptorProto name.
             * @member {string} name
             * @memberof google.protobuf.DescriptorProto
             * @instance
             */
            DescriptorProto.prototype.name = "";

            /**
             * DescriptorProto field.
             * @member {Array.<google.protobuf.IFieldDescriptorProto>} field
             * @memberof google.protobuf.DescriptorProto
             * @instance
             */
            DescriptorProto.prototype.field = $util.emptyArray;

            /**
             * DescriptorProto extension.
             * @member {Array.<google.protobuf.IFieldDescriptorProto>} extension
             * @memberof google.protobuf.DescriptorProto
             * @instance
             */
            DescriptorProto.prototype.extension = $util.emptyArray;

            /**
             * DescriptorProto nestedType.
             * @member {Array.<google.protobuf.IDescriptorProto>} nestedType
             * @memberof google.protobuf.DescriptorProto
             * @instance
             */
            DescriptorProto.prototype.nestedType = $util.emptyArray;

            /**
             * DescriptorProto enumType.
             * @member {Array.<google.protobuf.IEnumDescriptorProto>} enumType
             * @memberof google.protobuf.DescriptorProto
             * @instance
             */
            DescriptorProto.prototype.enumType = $util.emptyArray;

            /**
             * DescriptorProto extensionRange.
             * @member {Array.<google.protobuf.DescriptorProto.IExtensionRange>} extensionRange
             * @memberof google.protobuf.DescriptorProto
             * @instance
             */
            DescriptorProto.prototype.extensionRange = $util.emptyArray;

            /**
             * DescriptorProto oneofDecl.
             * @member {Array.<google.protobuf.IOneofDescriptorProto>} oneofDecl
             * @memberof google.protobuf.DescriptorProto
             * @instance
             */
            DescriptorProto.prototype.oneofDecl = $util.emptyArray;

            /**
             * DescriptorProto options.
             * @member {google.protobuf.IMessageOptions|null|undefined} options
             * @memberof google.protobuf.DescriptorProto
             * @instance
             */
            DescriptorProto.prototype.options = null;

            /**
             * DescriptorProto reservedRange.
             * @member {Array.<google.protobuf.DescriptorProto.IReservedRange>} reservedRange
             * @memberof google.protobuf.DescriptorProto
             * @instance
             */
            DescriptorProto.prototype.reservedRange = $util.emptyArray;

            /**
             * DescriptorProto reservedName.
             * @member {Array.<string>} reservedName
             * @memberof google.protobuf.DescriptorProto
             * @instance
             */
            DescriptorProto.prototype.reservedName = $util.emptyArray;

            /**
             * Creates a new DescriptorProto instance using the specified properties.
             * @function create
             * @memberof google.protobuf.DescriptorProto
             * @static
             * @param {google.protobuf.IDescriptorProto=} [properties] Properties to set
             * @returns {google.protobuf.DescriptorProto} DescriptorProto instance
             */
            DescriptorProto.create = function create(properties) {
                return new DescriptorProto(properties);
            };

            /**
             * Encodes the specified DescriptorProto message. Does not implicitly {@link google.protobuf.DescriptorProto.verify|verify} messages.
             * @function encode
             * @memberof google.protobuf.DescriptorProto
             * @static
             * @param {google.protobuf.IDescriptorProto} message DescriptorProto message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            DescriptorProto.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                if (message.field != null && message.field.length)
                    for (var i = 0; i < message.field.length; ++i)
                        $root.google.protobuf.FieldDescriptorProto.encode(message.field[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                if (message.nestedType != null && message.nestedType.length)
                    for (var i = 0; i < message.nestedType.length; ++i)
                        $root.google.protobuf.DescriptorProto.encode(message.nestedType[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                if (message.enumType != null && message.enumType.length)
                    for (var i = 0; i < message.enumType.length; ++i)
                        $root.google.protobuf.EnumDescriptorProto.encode(message.enumType[i], writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                if (message.extensionRange != null && message.extensionRange.length)
                    for (var i = 0; i < message.extensionRange.length; ++i)
                        $root.google.protobuf.DescriptorProto.ExtensionRange.encode(message.extensionRange[i], writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                if (message.extension != null && message.extension.length)
                    for (var i = 0; i < message.extension.length; ++i)
                        $root.google.protobuf.FieldDescriptorProto.encode(message.extension[i], writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                if (message.options != null && Object.hasOwnProperty.call(message, "options"))
                    $root.google.protobuf.MessageOptions.encode(message.options, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                if (message.oneofDecl != null && message.oneofDecl.length)
                    for (var i = 0; i < message.oneofDecl.length; ++i)
                        $root.google.protobuf.OneofDescriptorProto.encode(message.oneofDecl[i], writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                if (message.reservedRange != null && message.reservedRange.length)
                    for (var i = 0; i < message.reservedRange.length; ++i)
                        $root.google.protobuf.DescriptorProto.ReservedRange.encode(message.reservedRange[i], writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
                if (message.reservedName != null && message.reservedName.length)
                    for (var i = 0; i < message.reservedName.length; ++i)
                        writer.uint32(/* id 10, wireType 2 =*/82).string(message.reservedName[i]);
                return writer;
            };

            /**
             * Encodes the specified DescriptorProto message, length delimited. Does not implicitly {@link google.protobuf.DescriptorProto.verify|verify} messages.
             * @function encodeDelimited
             * @memberof google.protobuf.DescriptorProto
             * @static
             * @param {google.protobuf.IDescriptorProto} message DescriptorProto message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            DescriptorProto.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a DescriptorProto message from the specified reader or buffer.
             * @function decode
             * @memberof google.protobuf.DescriptorProto
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {google.protobuf.DescriptorProto} DescriptorProto
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            DescriptorProto.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.DescriptorProto();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.name = reader.string();
                        break;
                    case 2:
                        if (!(message.field && message.field.length))
                            message.field = [];
                        message.field.push($root.google.protobuf.FieldDescriptorProto.decode(reader, reader.uint32()));
                        break;
                    case 6:
                        if (!(message.extension && message.extension.length))
                            message.extension = [];
                        message.extension.push($root.google.protobuf.FieldDescriptorProto.decode(reader, reader.uint32()));
                        break;
                    case 3:
                        if (!(message.nestedType && message.nestedType.length))
                            message.nestedType = [];
                        message.nestedType.push($root.google.protobuf.DescriptorProto.decode(reader, reader.uint32()));
                        break;
                    case 4:
                        if (!(message.enumType && message.enumType.length))
                            message.enumType = [];
                        message.enumType.push($root.google.protobuf.EnumDescriptorProto.decode(reader, reader.uint32()));
                        break;
                    case 5:
                        if (!(message.extensionRange && message.extensionRange.length))
                            message.extensionRange = [];
                        message.extensionRange.push($root.google.protobuf.DescriptorProto.ExtensionRange.decode(reader, reader.uint32()));
                        break;
                    case 8:
                        if (!(message.oneofDecl && message.oneofDecl.length))
                            message.oneofDecl = [];
                        message.oneofDecl.push($root.google.protobuf.OneofDescriptorProto.decode(reader, reader.uint32()));
                        break;
                    case 7:
                        message.options = $root.google.protobuf.MessageOptions.decode(reader, reader.uint32());
                        break;
                    case 9:
                        if (!(message.reservedRange && message.reservedRange.length))
                            message.reservedRange = [];
                        message.reservedRange.push($root.google.protobuf.DescriptorProto.ReservedRange.decode(reader, reader.uint32()));
                        break;
                    case 10:
                        if (!(message.reservedName && message.reservedName.length))
                            message.reservedName = [];
                        message.reservedName.push(reader.string());
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a DescriptorProto message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof google.protobuf.DescriptorProto
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {google.protobuf.DescriptorProto} DescriptorProto
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            DescriptorProto.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a DescriptorProto message.
             * @function verify
             * @memberof google.protobuf.DescriptorProto
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            DescriptorProto.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.name != null && message.hasOwnProperty("name"))
                    if (!$util.isString(message.name))
                        return "name: string expected";
                if (message.field != null && message.hasOwnProperty("field")) {
                    if (!Array.isArray(message.field))
                        return "field: array expected";
                    for (var i = 0; i < message.field.length; ++i) {
                        var error = $root.google.protobuf.FieldDescriptorProto.verify(message.field[i]);
                        if (error)
                            return "field." + error;
                    }
                }
                if (message.extension != null && message.hasOwnProperty("extension")) {
                    if (!Array.isArray(message.extension))
                        return "extension: array expected";
                    for (var i = 0; i < message.extension.length; ++i) {
                        var error = $root.google.protobuf.FieldDescriptorProto.verify(message.extension[i]);
                        if (error)
                            return "extension." + error;
                    }
                }
                if (message.nestedType != null && message.hasOwnProperty("nestedType")) {
                    if (!Array.isArray(message.nestedType))
                        return "nestedType: array expected";
                    for (var i = 0; i < message.nestedType.length; ++i) {
                        var error = $root.google.protobuf.DescriptorProto.verify(message.nestedType[i]);
                        if (error)
                            return "nestedType." + error;
                    }
                }
                if (message.enumType != null && message.hasOwnProperty("enumType")) {
                    if (!Array.isArray(message.enumType))
                        return "enumType: array expected";
                    for (var i = 0; i < message.enumType.length; ++i) {
                        var error = $root.google.protobuf.EnumDescriptorProto.verify(message.enumType[i]);
                        if (error)
                            return "enumType." + error;
                    }
                }
                if (message.extensionRange != null && message.hasOwnProperty("extensionRange")) {
                    if (!Array.isArray(message.extensionRange))
                        return "extensionRange: array expected";
                    for (var i = 0; i < message.extensionRange.length; ++i) {
                        var error = $root.google.protobuf.DescriptorProto.ExtensionRange.verify(message.extensionRange[i]);
                        if (error)
                            return "extensionRange." + error;
                    }
                }
                if (message.oneofDecl != null && message.hasOwnProperty("oneofDecl")) {
                    if (!Array.isArray(message.oneofDecl))
                        return "oneofDecl: array expected";
                    for (var i = 0; i < message.oneofDecl.length; ++i) {
                        var error = $root.google.protobuf.OneofDescriptorProto.verify(message.oneofDecl[i]);
                        if (error)
                            return "oneofDecl." + error;
                    }
                }
                if (message.options != null && message.hasOwnProperty("options")) {
                    var error = $root.google.protobuf.MessageOptions.verify(message.options);
                    if (error)
                        return "options." + error;
                }
                if (message.reservedRange != null && message.hasOwnProperty("reservedRange")) {
                    if (!Array.isArray(message.reservedRange))
                        return "reservedRange: array expected";
                    for (var i = 0; i < message.reservedRange.length; ++i) {
                        var error = $root.google.protobuf.DescriptorProto.ReservedRange.verify(message.reservedRange[i]);
                        if (error)
                            return "reservedRange." + error;
                    }
                }
                if (message.reservedName != null && message.hasOwnProperty("reservedName")) {
                    if (!Array.isArray(message.reservedName))
                        return "reservedName: array expected";
                    for (var i = 0; i < message.reservedName.length; ++i)
                        if (!$util.isString(message.reservedName[i]))
                            return "reservedName: string[] expected";
                }
                return null;
            };

            /**
             * Creates a DescriptorProto message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof google.protobuf.DescriptorProto
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {google.protobuf.DescriptorProto} DescriptorProto
             */
            DescriptorProto.fromObject = function fromObject(object) {
                if (object instanceof $root.google.protobuf.DescriptorProto)
                    return object;
                var message = new $root.google.protobuf.DescriptorProto();
                if (object.name != null)
                    message.name = String(object.name);
                if (object.field) {
                    if (!Array.isArray(object.field))
                        throw TypeError(".google.protobuf.DescriptorProto.field: array expected");
                    message.field = [];
                    for (var i = 0; i < object.field.length; ++i) {
                        if (typeof object.field[i] !== "object")
                            throw TypeError(".google.protobuf.DescriptorProto.field: object expected");
                        message.field[i] = $root.google.protobuf.FieldDescriptorProto.fromObject(object.field[i]);
                    }
                }
                if (object.extension) {
                    if (!Array.isArray(object.extension))
                        throw TypeError(".google.protobuf.DescriptorProto.extension: array expected");
                    message.extension = [];
                    for (var i = 0; i < object.extension.length; ++i) {
                        if (typeof object.extension[i] !== "object")
                            throw TypeError(".google.protobuf.DescriptorProto.extension: object expected");
                        message.extension[i] = $root.google.protobuf.FieldDescriptorProto.fromObject(object.extension[i]);
                    }
                }
                if (object.nestedType) {
                    if (!Array.isArray(object.nestedType))
                        throw TypeError(".google.protobuf.DescriptorProto.nestedType: array expected");
                    message.nestedType = [];
                    for (var i = 0; i < object.nestedType.length; ++i) {
                        if (typeof object.nestedType[i] !== "object")
                            throw TypeError(".google.protobuf.DescriptorProto.nestedType: object expected");
                        message.nestedType[i] = $root.google.protobuf.DescriptorProto.fromObject(object.nestedType[i]);
                    }
                }
                if (object.enumType) {
                    if (!Array.isArray(object.enumType))
                        throw TypeError(".google.protobuf.DescriptorProto.enumType: array expected");
                    message.enumType = [];
                    for (var i = 0; i < object.enumType.length; ++i) {
                        if (typeof object.enumType[i] !== "object")
                            throw TypeError(".google.protobuf.DescriptorProto.enumType: object expected");
                        message.enumType[i] = $root.google.protobuf.EnumDescriptorProto.fromObject(object.enumType[i]);
                    }
                }
                if (object.extensionRange) {
                    if (!Array.isArray(object.extensionRange))
                        throw TypeError(".google.protobuf.DescriptorProto.extensionRange: array expected");
                    message.extensionRange = [];
                    for (var i = 0; i < object.extensionRange.length; ++i) {
                        if (typeof object.extensionRange[i] !== "object")
                            throw TypeError(".google.protobuf.DescriptorProto.extensionRange: object expected");
                        message.extensionRange[i] = $root.google.protobuf.DescriptorProto.ExtensionRange.fromObject(object.extensionRange[i]);
                    }
                }
                if (object.oneofDecl) {
                    if (!Array.isArray(object.oneofDecl))
                        throw TypeError(".google.protobuf.DescriptorProto.oneofDecl: array expected");
                    message.oneofDecl = [];
                    for (var i = 0; i < object.oneofDecl.length; ++i) {
                        if (typeof object.oneofDecl[i] !== "object")
                            throw TypeError(".google.protobuf.DescriptorProto.oneofDecl: object expected");
                        message.oneofDecl[i] = $root.google.protobuf.OneofDescriptorProto.fromObject(object.oneofDecl[i]);
                    }
                }
                if (object.options != null) {
                    if (typeof object.options !== "object")
                        throw TypeError(".google.protobuf.DescriptorProto.options: object expected");
                    message.options = $root.google.protobuf.MessageOptions.fromObject(object.options);
                }
                if (object.reservedRange) {
                    if (!Array.isArray(object.reservedRange))
                        throw TypeError(".google.protobuf.DescriptorProto.reservedRange: array expected");
                    message.reservedRange = [];
                    for (var i = 0; i < object.reservedRange.length; ++i) {
                        if (typeof object.reservedRange[i] !== "object")
                            throw TypeError(".google.protobuf.DescriptorProto.reservedRange: object expected");
                        message.reservedRange[i] = $root.google.protobuf.DescriptorProto.ReservedRange.fromObject(object.reservedRange[i]);
                    }
                }
                if (object.reservedName) {
                    if (!Array.isArray(object.reservedName))
                        throw TypeError(".google.protobuf.DescriptorProto.reservedName: array expected");
                    message.reservedName = [];
                    for (var i = 0; i < object.reservedName.length; ++i)
                        message.reservedName[i] = String(object.reservedName[i]);
                }
                return message;
            };

            /**
             * Creates a plain object from a DescriptorProto message. Also converts values to other types if specified.
             * @function toObject
             * @memberof google.protobuf.DescriptorProto
             * @static
             * @param {google.protobuf.DescriptorProto} message DescriptorProto
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            DescriptorProto.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.arrays || options.defaults) {
                    object.field = [];
                    object.nestedType = [];
                    object.enumType = [];
                    object.extensionRange = [];
                    object.extension = [];
                    object.oneofDecl = [];
                    object.reservedRange = [];
                    object.reservedName = [];
                }
                if (options.defaults) {
                    object.name = "";
                    object.options = null;
                }
                if (message.name != null && message.hasOwnProperty("name"))
                    object.name = message.name;
                if (message.field && message.field.length) {
                    object.field = [];
                    for (var j = 0; j < message.field.length; ++j)
                        object.field[j] = $root.google.protobuf.FieldDescriptorProto.toObject(message.field[j], options);
                }
                if (message.nestedType && message.nestedType.length) {
                    object.nestedType = [];
                    for (var j = 0; j < message.nestedType.length; ++j)
                        object.nestedType[j] = $root.google.protobuf.DescriptorProto.toObject(message.nestedType[j], options);
                }
                if (message.enumType && message.enumType.length) {
                    object.enumType = [];
                    for (var j = 0; j < message.enumType.length; ++j)
                        object.enumType[j] = $root.google.protobuf.EnumDescriptorProto.toObject(message.enumType[j], options);
                }
                if (message.extensionRange && message.extensionRange.length) {
                    object.extensionRange = [];
                    for (var j = 0; j < message.extensionRange.length; ++j)
                        object.extensionRange[j] = $root.google.protobuf.DescriptorProto.ExtensionRange.toObject(message.extensionRange[j], options);
                }
                if (message.extension && message.extension.length) {
                    object.extension = [];
                    for (var j = 0; j < message.extension.length; ++j)
                        object.extension[j] = $root.google.protobuf.FieldDescriptorProto.toObject(message.extension[j], options);
                }
                if (message.options != null && message.hasOwnProperty("options"))
                    object.options = $root.google.protobuf.MessageOptions.toObject(message.options, options);
                if (message.oneofDecl && message.oneofDecl.length) {
                    object.oneofDecl = [];
                    for (var j = 0; j < message.oneofDecl.length; ++j)
                        object.oneofDecl[j] = $root.google.protobuf.OneofDescriptorProto.toObject(message.oneofDecl[j], options);
                }
                if (message.reservedRange && message.reservedRange.length) {
                    object.reservedRange = [];
                    for (var j = 0; j < message.reservedRange.length; ++j)
                        object.reservedRange[j] = $root.google.protobuf.DescriptorProto.ReservedRange.toObject(message.reservedRange[j], options);
                }
                if (message.reservedName && message.reservedName.length) {
                    object.reservedName = [];
                    for (var j = 0; j < message.reservedName.length; ++j)
                        object.reservedName[j] = message.reservedName[j];
                }
                return object;
            };

            /**
             * Converts this DescriptorProto to JSON.
             * @function toJSON
             * @memberof google.protobuf.DescriptorProto
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            DescriptorProto.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            DescriptorProto.ExtensionRange = (function() {

                /**
                 * Properties of an ExtensionRange.
                 * @memberof google.protobuf.DescriptorProto
                 * @interface IExtensionRange
                 * @property {number|null} [start] ExtensionRange start
                 * @property {number|null} [end] ExtensionRange end
                 */

                /**
                 * Constructs a new ExtensionRange.
                 * @memberof google.protobuf.DescriptorProto
                 * @classdesc Represents an ExtensionRange.
                 * @implements IExtensionRange
                 * @constructor
                 * @param {google.protobuf.DescriptorProto.IExtensionRange=} [properties] Properties to set
                 */
                function ExtensionRange(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * ExtensionRange start.
                 * @member {number} start
                 * @memberof google.protobuf.DescriptorProto.ExtensionRange
                 * @instance
                 */
                ExtensionRange.prototype.start = 0;

                /**
                 * ExtensionRange end.
                 * @member {number} end
                 * @memberof google.protobuf.DescriptorProto.ExtensionRange
                 * @instance
                 */
                ExtensionRange.prototype.end = 0;

                /**
                 * Creates a new ExtensionRange instance using the specified properties.
                 * @function create
                 * @memberof google.protobuf.DescriptorProto.ExtensionRange
                 * @static
                 * @param {google.protobuf.DescriptorProto.IExtensionRange=} [properties] Properties to set
                 * @returns {google.protobuf.DescriptorProto.ExtensionRange} ExtensionRange instance
                 */
                ExtensionRange.create = function create(properties) {
                    return new ExtensionRange(properties);
                };

                /**
                 * Encodes the specified ExtensionRange message. Does not implicitly {@link google.protobuf.DescriptorProto.ExtensionRange.verify|verify} messages.
                 * @function encode
                 * @memberof google.protobuf.DescriptorProto.ExtensionRange
                 * @static
                 * @param {google.protobuf.DescriptorProto.IExtensionRange} message ExtensionRange message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                ExtensionRange.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.start != null && Object.hasOwnProperty.call(message, "start"))
                        writer.uint32(/* id 1, wireType 0 =*/8).int32(message.start);
                    if (message.end != null && Object.hasOwnProperty.call(message, "end"))
                        writer.uint32(/* id 2, wireType 0 =*/16).int32(message.end);
                    return writer;
                };

                /**
                 * Encodes the specified ExtensionRange message, length delimited. Does not implicitly {@link google.protobuf.DescriptorProto.ExtensionRange.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof google.protobuf.DescriptorProto.ExtensionRange
                 * @static
                 * @param {google.protobuf.DescriptorProto.IExtensionRange} message ExtensionRange message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                ExtensionRange.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes an ExtensionRange message from the specified reader or buffer.
                 * @function decode
                 * @memberof google.protobuf.DescriptorProto.ExtensionRange
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {google.protobuf.DescriptorProto.ExtensionRange} ExtensionRange
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                ExtensionRange.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.DescriptorProto.ExtensionRange();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.start = reader.int32();
                            break;
                        case 2:
                            message.end = reader.int32();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes an ExtensionRange message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof google.protobuf.DescriptorProto.ExtensionRange
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {google.protobuf.DescriptorProto.ExtensionRange} ExtensionRange
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                ExtensionRange.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies an ExtensionRange message.
                 * @function verify
                 * @memberof google.protobuf.DescriptorProto.ExtensionRange
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                ExtensionRange.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.start != null && message.hasOwnProperty("start"))
                        if (!$util.isInteger(message.start))
                            return "start: integer expected";
                    if (message.end != null && message.hasOwnProperty("end"))
                        if (!$util.isInteger(message.end))
                            return "end: integer expected";
                    return null;
                };

                /**
                 * Creates an ExtensionRange message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof google.protobuf.DescriptorProto.ExtensionRange
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {google.protobuf.DescriptorProto.ExtensionRange} ExtensionRange
                 */
                ExtensionRange.fromObject = function fromObject(object) {
                    if (object instanceof $root.google.protobuf.DescriptorProto.ExtensionRange)
                        return object;
                    var message = new $root.google.protobuf.DescriptorProto.ExtensionRange();
                    if (object.start != null)
                        message.start = object.start | 0;
                    if (object.end != null)
                        message.end = object.end | 0;
                    return message;
                };

                /**
                 * Creates a plain object from an ExtensionRange message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof google.protobuf.DescriptorProto.ExtensionRange
                 * @static
                 * @param {google.protobuf.DescriptorProto.ExtensionRange} message ExtensionRange
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                ExtensionRange.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.defaults) {
                        object.start = 0;
                        object.end = 0;
                    }
                    if (message.start != null && message.hasOwnProperty("start"))
                        object.start = message.start;
                    if (message.end != null && message.hasOwnProperty("end"))
                        object.end = message.end;
                    return object;
                };

                /**
                 * Converts this ExtensionRange to JSON.
                 * @function toJSON
                 * @memberof google.protobuf.DescriptorProto.ExtensionRange
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                ExtensionRange.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                return ExtensionRange;
            })();

            DescriptorProto.ReservedRange = (function() {

                /**
                 * Properties of a ReservedRange.
                 * @memberof google.protobuf.DescriptorProto
                 * @interface IReservedRange
                 * @property {number|null} [start] ReservedRange start
                 * @property {number|null} [end] ReservedRange end
                 */

                /**
                 * Constructs a new ReservedRange.
                 * @memberof google.protobuf.DescriptorProto
                 * @classdesc Represents a ReservedRange.
                 * @implements IReservedRange
                 * @constructor
                 * @param {google.protobuf.DescriptorProto.IReservedRange=} [properties] Properties to set
                 */
                function ReservedRange(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * ReservedRange start.
                 * @member {number} start
                 * @memberof google.protobuf.DescriptorProto.ReservedRange
                 * @instance
                 */
                ReservedRange.prototype.start = 0;

                /**
                 * ReservedRange end.
                 * @member {number} end
                 * @memberof google.protobuf.DescriptorProto.ReservedRange
                 * @instance
                 */
                ReservedRange.prototype.end = 0;

                /**
                 * Creates a new ReservedRange instance using the specified properties.
                 * @function create
                 * @memberof google.protobuf.DescriptorProto.ReservedRange
                 * @static
                 * @param {google.protobuf.DescriptorProto.IReservedRange=} [properties] Properties to set
                 * @returns {google.protobuf.DescriptorProto.ReservedRange} ReservedRange instance
                 */
                ReservedRange.create = function create(properties) {
                    return new ReservedRange(properties);
                };

                /**
                 * Encodes the specified ReservedRange message. Does not implicitly {@link google.protobuf.DescriptorProto.ReservedRange.verify|verify} messages.
                 * @function encode
                 * @memberof google.protobuf.DescriptorProto.ReservedRange
                 * @static
                 * @param {google.protobuf.DescriptorProto.IReservedRange} message ReservedRange message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                ReservedRange.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.start != null && Object.hasOwnProperty.call(message, "start"))
                        writer.uint32(/* id 1, wireType 0 =*/8).int32(message.start);
                    if (message.end != null && Object.hasOwnProperty.call(message, "end"))
                        writer.uint32(/* id 2, wireType 0 =*/16).int32(message.end);
                    return writer;
                };

                /**
                 * Encodes the specified ReservedRange message, length delimited. Does not implicitly {@link google.protobuf.DescriptorProto.ReservedRange.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof google.protobuf.DescriptorProto.ReservedRange
                 * @static
                 * @param {google.protobuf.DescriptorProto.IReservedRange} message ReservedRange message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                ReservedRange.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a ReservedRange message from the specified reader or buffer.
                 * @function decode
                 * @memberof google.protobuf.DescriptorProto.ReservedRange
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {google.protobuf.DescriptorProto.ReservedRange} ReservedRange
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                ReservedRange.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.DescriptorProto.ReservedRange();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.start = reader.int32();
                            break;
                        case 2:
                            message.end = reader.int32();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a ReservedRange message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof google.protobuf.DescriptorProto.ReservedRange
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {google.protobuf.DescriptorProto.ReservedRange} ReservedRange
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                ReservedRange.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a ReservedRange message.
                 * @function verify
                 * @memberof google.protobuf.DescriptorProto.ReservedRange
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                ReservedRange.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.start != null && message.hasOwnProperty("start"))
                        if (!$util.isInteger(message.start))
                            return "start: integer expected";
                    if (message.end != null && message.hasOwnProperty("end"))
                        if (!$util.isInteger(message.end))
                            return "end: integer expected";
                    return null;
                };

                /**
                 * Creates a ReservedRange message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof google.protobuf.DescriptorProto.ReservedRange
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {google.protobuf.DescriptorProto.ReservedRange} ReservedRange
                 */
                ReservedRange.fromObject = function fromObject(object) {
                    if (object instanceof $root.google.protobuf.DescriptorProto.ReservedRange)
                        return object;
                    var message = new $root.google.protobuf.DescriptorProto.ReservedRange();
                    if (object.start != null)
                        message.start = object.start | 0;
                    if (object.end != null)
                        message.end = object.end | 0;
                    return message;
                };

                /**
                 * Creates a plain object from a ReservedRange message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof google.protobuf.DescriptorProto.ReservedRange
                 * @static
                 * @param {google.protobuf.DescriptorProto.ReservedRange} message ReservedRange
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                ReservedRange.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.defaults) {
                        object.start = 0;
                        object.end = 0;
                    }
                    if (message.start != null && message.hasOwnProperty("start"))
                        object.start = message.start;
                    if (message.end != null && message.hasOwnProperty("end"))
                        object.end = message.end;
                    return object;
                };

                /**
                 * Converts this ReservedRange to JSON.
                 * @function toJSON
                 * @memberof google.protobuf.DescriptorProto.ReservedRange
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                ReservedRange.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                return ReservedRange;
            })();

            return DescriptorProto;
        })();

        protobuf.FieldDescriptorProto = (function() {

            /**
             * Properties of a FieldDescriptorProto.
             * @memberof google.protobuf
             * @interface IFieldDescriptorProto
             * @property {string|null} [name] FieldDescriptorProto name
             * @property {number|null} [number] FieldDescriptorProto number
             * @property {google.protobuf.FieldDescriptorProto.Label|null} [label] FieldDescriptorProto label
             * @property {google.protobuf.FieldDescriptorProto.Type|null} [type] FieldDescriptorProto type
             * @property {string|null} [typeName] FieldDescriptorProto typeName
             * @property {string|null} [extendee] FieldDescriptorProto extendee
             * @property {string|null} [defaultValue] FieldDescriptorProto defaultValue
             * @property {number|null} [oneofIndex] FieldDescriptorProto oneofIndex
             * @property {string|null} [jsonName] FieldDescriptorProto jsonName
             * @property {google.protobuf.IFieldOptions|null} [options] FieldDescriptorProto options
             */

            /**
             * Constructs a new FieldDescriptorProto.
             * @memberof google.protobuf
             * @classdesc Represents a FieldDescriptorProto.
             * @implements IFieldDescriptorProto
             * @constructor
             * @param {google.protobuf.IFieldDescriptorProto=} [properties] Properties to set
             */
            function FieldDescriptorProto(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * FieldDescriptorProto name.
             * @member {string} name
             * @memberof google.protobuf.FieldDescriptorProto
             * @instance
             */
            FieldDescriptorProto.prototype.name = "";

            /**
             * FieldDescriptorProto number.
             * @member {number} number
             * @memberof google.protobuf.FieldDescriptorProto
             * @instance
             */
            FieldDescriptorProto.prototype.number = 0;

            /**
             * FieldDescriptorProto label.
             * @member {google.protobuf.FieldDescriptorProto.Label} label
             * @memberof google.protobuf.FieldDescriptorProto
             * @instance
             */
            FieldDescriptorProto.prototype.label = 1;

            /**
             * FieldDescriptorProto type.
             * @member {google.protobuf.FieldDescriptorProto.Type} type
             * @memberof google.protobuf.FieldDescriptorProto
             * @instance
             */
            FieldDescriptorProto.prototype.type = 1;

            /**
             * FieldDescriptorProto typeName.
             * @member {string} typeName
             * @memberof google.protobuf.FieldDescriptorProto
             * @instance
             */
            FieldDescriptorProto.prototype.typeName = "";

            /**
             * FieldDescriptorProto extendee.
             * @member {string} extendee
             * @memberof google.protobuf.FieldDescriptorProto
             * @instance
             */
            FieldDescriptorProto.prototype.extendee = "";

            /**
             * FieldDescriptorProto defaultValue.
             * @member {string} defaultValue
             * @memberof google.protobuf.FieldDescriptorProto
             * @instance
             */
            FieldDescriptorProto.prototype.defaultValue = "";

            /**
             * FieldDescriptorProto oneofIndex.
             * @member {number} oneofIndex
             * @memberof google.protobuf.FieldDescriptorProto
             * @instance
             */
            FieldDescriptorProto.prototype.oneofIndex = 0;

            /**
             * FieldDescriptorProto jsonName.
             * @member {string} jsonName
             * @memberof google.protobuf.FieldDescriptorProto
             * @instance
             */
            FieldDescriptorProto.prototype.jsonName = "";

            /**
             * FieldDescriptorProto options.
             * @member {google.protobuf.IFieldOptions|null|undefined} options
             * @memberof google.protobuf.FieldDescriptorProto
             * @instance
             */
            FieldDescriptorProto.prototype.options = null;

            /**
             * Creates a new FieldDescriptorProto instance using the specified properties.
             * @function create
             * @memberof google.protobuf.FieldDescriptorProto
             * @static
             * @param {google.protobuf.IFieldDescriptorProto=} [properties] Properties to set
             * @returns {google.protobuf.FieldDescriptorProto} FieldDescriptorProto instance
             */
            FieldDescriptorProto.create = function create(properties) {
                return new FieldDescriptorProto(properties);
            };

            /**
             * Encodes the specified FieldDescriptorProto message. Does not implicitly {@link google.protobuf.FieldDescriptorProto.verify|verify} messages.
             * @function encode
             * @memberof google.protobuf.FieldDescriptorProto
             * @static
             * @param {google.protobuf.IFieldDescriptorProto} message FieldDescriptorProto message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            FieldDescriptorProto.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                if (message.extendee != null && Object.hasOwnProperty.call(message, "extendee"))
                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.extendee);
                if (message.number != null && Object.hasOwnProperty.call(message, "number"))
                    writer.uint32(/* id 3, wireType 0 =*/24).int32(message.number);
                if (message.label != null && Object.hasOwnProperty.call(message, "label"))
                    writer.uint32(/* id 4, wireType 0 =*/32).int32(message.label);
                if (message.type != null && Object.hasOwnProperty.call(message, "type"))
                    writer.uint32(/* id 5, wireType 0 =*/40).int32(message.type);
                if (message.typeName != null && Object.hasOwnProperty.call(message, "typeName"))
                    writer.uint32(/* id 6, wireType 2 =*/50).string(message.typeName);
                if (message.defaultValue != null && Object.hasOwnProperty.call(message, "defaultValue"))
                    writer.uint32(/* id 7, wireType 2 =*/58).string(message.defaultValue);
                if (message.options != null && Object.hasOwnProperty.call(message, "options"))
                    $root.google.protobuf.FieldOptions.encode(message.options, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                if (message.oneofIndex != null && Object.hasOwnProperty.call(message, "oneofIndex"))
                    writer.uint32(/* id 9, wireType 0 =*/72).int32(message.oneofIndex);
                if (message.jsonName != null && Object.hasOwnProperty.call(message, "jsonName"))
                    writer.uint32(/* id 10, wireType 2 =*/82).string(message.jsonName);
                return writer;
            };

            /**
             * Encodes the specified FieldDescriptorProto message, length delimited. Does not implicitly {@link google.protobuf.FieldDescriptorProto.verify|verify} messages.
             * @function encodeDelimited
             * @memberof google.protobuf.FieldDescriptorProto
             * @static
             * @param {google.protobuf.IFieldDescriptorProto} message FieldDescriptorProto message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            FieldDescriptorProto.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a FieldDescriptorProto message from the specified reader or buffer.
             * @function decode
             * @memberof google.protobuf.FieldDescriptorProto
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {google.protobuf.FieldDescriptorProto} FieldDescriptorProto
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            FieldDescriptorProto.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.FieldDescriptorProto();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.name = reader.string();
                        break;
                    case 3:
                        message.number = reader.int32();
                        break;
                    case 4:
                        message.label = reader.int32();
                        break;
                    case 5:
                        message.type = reader.int32();
                        break;
                    case 6:
                        message.typeName = reader.string();
                        break;
                    case 2:
                        message.extendee = reader.string();
                        break;
                    case 7:
                        message.defaultValue = reader.string();
                        break;
                    case 9:
                        message.oneofIndex = reader.int32();
                        break;
                    case 10:
                        message.jsonName = reader.string();
                        break;
                    case 8:
                        message.options = $root.google.protobuf.FieldOptions.decode(reader, reader.uint32());
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a FieldDescriptorProto message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof google.protobuf.FieldDescriptorProto
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {google.protobuf.FieldDescriptorProto} FieldDescriptorProto
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            FieldDescriptorProto.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a FieldDescriptorProto message.
             * @function verify
             * @memberof google.protobuf.FieldDescriptorProto
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            FieldDescriptorProto.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.name != null && message.hasOwnProperty("name"))
                    if (!$util.isString(message.name))
                        return "name: string expected";
                if (message.number != null && message.hasOwnProperty("number"))
                    if (!$util.isInteger(message.number))
                        return "number: integer expected";
                if (message.label != null && message.hasOwnProperty("label"))
                    switch (message.label) {
                    default:
                        return "label: enum value expected";
                    case 1:
                    case 2:
                    case 3:
                        break;
                    }
                if (message.type != null && message.hasOwnProperty("type"))
                    switch (message.type) {
                    default:
                        return "type: enum value expected";
                    case 1:
                    case 2:
                    case 3:
                    case 4:
                    case 5:
                    case 6:
                    case 7:
                    case 8:
                    case 9:
                    case 10:
                    case 11:
                    case 12:
                    case 13:
                    case 14:
                    case 15:
                    case 16:
                    case 17:
                    case 18:
                        break;
                    }
                if (message.typeName != null && message.hasOwnProperty("typeName"))
                    if (!$util.isString(message.typeName))
                        return "typeName: string expected";
                if (message.extendee != null && message.hasOwnProperty("extendee"))
                    if (!$util.isString(message.extendee))
                        return "extendee: string expected";
                if (message.defaultValue != null && message.hasOwnProperty("defaultValue"))
                    if (!$util.isString(message.defaultValue))
                        return "defaultValue: string expected";
                if (message.oneofIndex != null && message.hasOwnProperty("oneofIndex"))
                    if (!$util.isInteger(message.oneofIndex))
                        return "oneofIndex: integer expected";
                if (message.jsonName != null && message.hasOwnProperty("jsonName"))
                    if (!$util.isString(message.jsonName))
                        return "jsonName: string expected";
                if (message.options != null && message.hasOwnProperty("options")) {
                    var error = $root.google.protobuf.FieldOptions.verify(message.options);
                    if (error)
                        return "options." + error;
                }
                return null;
            };

            /**
             * Creates a FieldDescriptorProto message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof google.protobuf.FieldDescriptorProto
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {google.protobuf.FieldDescriptorProto} FieldDescriptorProto
             */
            FieldDescriptorProto.fromObject = function fromObject(object) {
                if (object instanceof $root.google.protobuf.FieldDescriptorProto)
                    return object;
                var message = new $root.google.protobuf.FieldDescriptorProto();
                if (object.name != null)
                    message.name = String(object.name);
                if (object.number != null)
                    message.number = object.number | 0;
                switch (object.label) {
                case "LABEL_OPTIONAL":
                case 1:
                    message.label = 1;
                    break;
                case "LABEL_REQUIRED":
                case 2:
                    message.label = 2;
                    break;
                case "LABEL_REPEATED":
                case 3:
                    message.label = 3;
                    break;
                }
                switch (object.type) {
                case "TYPE_DOUBLE":
                case 1:
                    message.type = 1;
                    break;
                case "TYPE_FLOAT":
                case 2:
                    message.type = 2;
                    break;
                case "TYPE_INT64":
                case 3:
                    message.type = 3;
                    break;
                case "TYPE_UINT64":
                case 4:
                    message.type = 4;
                    break;
                case "TYPE_INT32":
                case 5:
                    message.type = 5;
                    break;
                case "TYPE_FIXED64":
                case 6:
                    message.type = 6;
                    break;
                case "TYPE_FIXED32":
                case 7:
                    message.type = 7;
                    break;
                case "TYPE_BOOL":
                case 8:
                    message.type = 8;
                    break;
                case "TYPE_STRING":
                case 9:
                    message.type = 9;
                    break;
                case "TYPE_GROUP":
                case 10:
                    message.type = 10;
                    break;
                case "TYPE_MESSAGE":
                case 11:
                    message.type = 11;
                    break;
                case "TYPE_BYTES":
                case 12:
                    message.type = 12;
                    break;
                case "TYPE_UINT32":
                case 13:
                    message.type = 13;
                    break;
                case "TYPE_ENUM":
                case 14:
                    message.type = 14;
                    break;
                case "TYPE_SFIXED32":
                case 15:
                    message.type = 15;
                    break;
                case "TYPE_SFIXED64":
                case 16:
                    message.type = 16;
                    break;
                case "TYPE_SINT32":
                case 17:
                    message.type = 17;
                    break;
                case "TYPE_SINT64":
                case 18:
                    message.type = 18;
                    break;
                }
                if (object.typeName != null)
                    message.typeName = String(object.typeName);
                if (object.extendee != null)
                    message.extendee = String(object.extendee);
                if (object.defaultValue != null)
                    message.defaultValue = String(object.defaultValue);
                if (object.oneofIndex != null)
                    message.oneofIndex = object.oneofIndex | 0;
                if (object.jsonName != null)
                    message.jsonName = String(object.jsonName);
                if (object.options != null) {
                    if (typeof object.options !== "object")
                        throw TypeError(".google.protobuf.FieldDescriptorProto.options: object expected");
                    message.options = $root.google.protobuf.FieldOptions.fromObject(object.options);
                }
                return message;
            };

            /**
             * Creates a plain object from a FieldDescriptorProto message. Also converts values to other types if specified.
             * @function toObject
             * @memberof google.protobuf.FieldDescriptorProto
             * @static
             * @param {google.protobuf.FieldDescriptorProto} message FieldDescriptorProto
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            FieldDescriptorProto.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.defaults) {
                    object.name = "";
                    object.extendee = "";
                    object.number = 0;
                    object.label = options.enums === String ? "LABEL_OPTIONAL" : 1;
                    object.type = options.enums === String ? "TYPE_DOUBLE" : 1;
                    object.typeName = "";
                    object.defaultValue = "";
                    object.options = null;
                    object.oneofIndex = 0;
                    object.jsonName = "";
                }
                if (message.name != null && message.hasOwnProperty("name"))
                    object.name = message.name;
                if (message.extendee != null && message.hasOwnProperty("extendee"))
                    object.extendee = message.extendee;
                if (message.number != null && message.hasOwnProperty("number"))
                    object.number = message.number;
                if (message.label != null && message.hasOwnProperty("label"))
                    object.label = options.enums === String ? $root.google.protobuf.FieldDescriptorProto.Label[message.label] : message.label;
                if (message.type != null && message.hasOwnProperty("type"))
                    object.type = options.enums === String ? $root.google.protobuf.FieldDescriptorProto.Type[message.type] : message.type;
                if (message.typeName != null && message.hasOwnProperty("typeName"))
                    object.typeName = message.typeName;
                if (message.defaultValue != null && message.hasOwnProperty("defaultValue"))
                    object.defaultValue = message.defaultValue;
                if (message.options != null && message.hasOwnProperty("options"))
                    object.options = $root.google.protobuf.FieldOptions.toObject(message.options, options);
                if (message.oneofIndex != null && message.hasOwnProperty("oneofIndex"))
                    object.oneofIndex = message.oneofIndex;
                if (message.jsonName != null && message.hasOwnProperty("jsonName"))
                    object.jsonName = message.jsonName;
                return object;
            };

            /**
             * Converts this FieldDescriptorProto to JSON.
             * @function toJSON
             * @memberof google.protobuf.FieldDescriptorProto
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            FieldDescriptorProto.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            /**
             * Type enum.
             * @name google.protobuf.FieldDescriptorProto.Type
             * @enum {number}
             * @property {number} TYPE_DOUBLE=1 TYPE_DOUBLE value
             * @property {number} TYPE_FLOAT=2 TYPE_FLOAT value
             * @property {number} TYPE_INT64=3 TYPE_INT64 value
             * @property {number} TYPE_UINT64=4 TYPE_UINT64 value
             * @property {number} TYPE_INT32=5 TYPE_INT32 value
             * @property {number} TYPE_FIXED64=6 TYPE_FIXED64 value
             * @property {number} TYPE_FIXED32=7 TYPE_FIXED32 value
             * @property {number} TYPE_BOOL=8 TYPE_BOOL value
             * @property {number} TYPE_STRING=9 TYPE_STRING value
             * @property {number} TYPE_GROUP=10 TYPE_GROUP value
             * @property {number} TYPE_MESSAGE=11 TYPE_MESSAGE value
             * @property {number} TYPE_BYTES=12 TYPE_BYTES value
             * @property {number} TYPE_UINT32=13 TYPE_UINT32 value
             * @property {number} TYPE_ENUM=14 TYPE_ENUM value
             * @property {number} TYPE_SFIXED32=15 TYPE_SFIXED32 value
             * @property {number} TYPE_SFIXED64=16 TYPE_SFIXED64 value
             * @property {number} TYPE_SINT32=17 TYPE_SINT32 value
             * @property {number} TYPE_SINT64=18 TYPE_SINT64 value
             */
            FieldDescriptorProto.Type = (function() {
                var valuesById = {}, values = Object.create(valuesById);
                values[valuesById[1] = "TYPE_DOUBLE"] = 1;
                values[valuesById[2] = "TYPE_FLOAT"] = 2;
                values[valuesById[3] = "TYPE_INT64"] = 3;
                values[valuesById[4] = "TYPE_UINT64"] = 4;
                values[valuesById[5] = "TYPE_INT32"] = 5;
                values[valuesById[6] = "TYPE_FIXED64"] = 6;
                values[valuesById[7] = "TYPE_FIXED32"] = 7;
                values[valuesById[8] = "TYPE_BOOL"] = 8;
                values[valuesById[9] = "TYPE_STRING"] = 9;
                values[valuesById[10] = "TYPE_GROUP"] = 10;
                values[valuesById[11] = "TYPE_MESSAGE"] = 11;
                values[valuesById[12] = "TYPE_BYTES"] = 12;
                values[valuesById[13] = "TYPE_UINT32"] = 13;
                values[valuesById[14] = "TYPE_ENUM"] = 14;
                values[valuesById[15] = "TYPE_SFIXED32"] = 15;
                values[valuesById[16] = "TYPE_SFIXED64"] = 16;
                values[valuesById[17] = "TYPE_SINT32"] = 17;
                values[valuesById[18] = "TYPE_SINT64"] = 18;
                return values;
            })();

            /**
             * Label enum.
             * @name google.protobuf.FieldDescriptorProto.Label
             * @enum {number}
             * @property {number} LABEL_OPTIONAL=1 LABEL_OPTIONAL value
             * @property {number} LABEL_REQUIRED=2 LABEL_REQUIRED value
             * @property {number} LABEL_REPEATED=3 LABEL_REPEATED value
             */
            FieldDescriptorProto.Label = (function() {
                var valuesById = {}, values = Object.create(valuesById);
                values[valuesById[1] = "LABEL_OPTIONAL"] = 1;
                values[valuesById[2] = "LABEL_REQUIRED"] = 2;
                values[valuesById[3] = "LABEL_REPEATED"] = 3;
                return values;
            })();

            return FieldDescriptorProto;
        })();

        protobuf.OneofDescriptorProto = (function() {

            /**
             * Properties of an OneofDescriptorProto.
             * @memberof google.protobuf
             * @interface IOneofDescriptorProto
             * @property {string|null} [name] OneofDescriptorProto name
             * @property {google.protobuf.IOneofOptions|null} [options] OneofDescriptorProto options
             */

            /**
             * Constructs a new OneofDescriptorProto.
             * @memberof google.protobuf
             * @classdesc Represents an OneofDescriptorProto.
             * @implements IOneofDescriptorProto
             * @constructor
             * @param {google.protobuf.IOneofDescriptorProto=} [properties] Properties to set
             */
            function OneofDescriptorProto(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * OneofDescriptorProto name.
             * @member {string} name
             * @memberof google.protobuf.OneofDescriptorProto
             * @instance
             */
            OneofDescriptorProto.prototype.name = "";

            /**
             * OneofDescriptorProto options.
             * @member {google.protobuf.IOneofOptions|null|undefined} options
             * @memberof google.protobuf.OneofDescriptorProto
             * @instance
             */
            OneofDescriptorProto.prototype.options = null;

            /**
             * Creates a new OneofDescriptorProto instance using the specified properties.
             * @function create
             * @memberof google.protobuf.OneofDescriptorProto
             * @static
             * @param {google.protobuf.IOneofDescriptorProto=} [properties] Properties to set
             * @returns {google.protobuf.OneofDescriptorProto} OneofDescriptorProto instance
             */
            OneofDescriptorProto.create = function create(properties) {
                return new OneofDescriptorProto(properties);
            };

            /**
             * Encodes the specified OneofDescriptorProto message. Does not implicitly {@link google.protobuf.OneofDescriptorProto.verify|verify} messages.
             * @function encode
             * @memberof google.protobuf.OneofDescriptorProto
             * @static
             * @param {google.protobuf.IOneofDescriptorProto} message OneofDescriptorProto message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            OneofDescriptorProto.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                if (message.options != null && Object.hasOwnProperty.call(message, "options"))
                    $root.google.protobuf.OneofOptions.encode(message.options, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                return writer;
            };

            /**
             * Encodes the specified OneofDescriptorProto message, length delimited. Does not implicitly {@link google.protobuf.OneofDescriptorProto.verify|verify} messages.
             * @function encodeDelimited
             * @memberof google.protobuf.OneofDescriptorProto
             * @static
             * @param {google.protobuf.IOneofDescriptorProto} message OneofDescriptorProto message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            OneofDescriptorProto.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes an OneofDescriptorProto message from the specified reader or buffer.
             * @function decode
             * @memberof google.protobuf.OneofDescriptorProto
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {google.protobuf.OneofDescriptorProto} OneofDescriptorProto
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            OneofDescriptorProto.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.OneofDescriptorProto();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.name = reader.string();
                        break;
                    case 2:
                        message.options = $root.google.protobuf.OneofOptions.decode(reader, reader.uint32());
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes an OneofDescriptorProto message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof google.protobuf.OneofDescriptorProto
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {google.protobuf.OneofDescriptorProto} OneofDescriptorProto
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            OneofDescriptorProto.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies an OneofDescriptorProto message.
             * @function verify
             * @memberof google.protobuf.OneofDescriptorProto
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            OneofDescriptorProto.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.name != null && message.hasOwnProperty("name"))
                    if (!$util.isString(message.name))
                        return "name: string expected";
                if (message.options != null && message.hasOwnProperty("options")) {
                    var error = $root.google.protobuf.OneofOptions.verify(message.options);
                    if (error)
                        return "options." + error;
                }
                return null;
            };

            /**
             * Creates an OneofDescriptorProto message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof google.protobuf.OneofDescriptorProto
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {google.protobuf.OneofDescriptorProto} OneofDescriptorProto
             */
            OneofDescriptorProto.fromObject = function fromObject(object) {
                if (object instanceof $root.google.protobuf.OneofDescriptorProto)
                    return object;
                var message = new $root.google.protobuf.OneofDescriptorProto();
                if (object.name != null)
                    message.name = String(object.name);
                if (object.options != null) {
                    if (typeof object.options !== "object")
                        throw TypeError(".google.protobuf.OneofDescriptorProto.options: object expected");
                    message.options = $root.google.protobuf.OneofOptions.fromObject(object.options);
                }
                return message;
            };

            /**
             * Creates a plain object from an OneofDescriptorProto message. Also converts values to other types if specified.
             * @function toObject
             * @memberof google.protobuf.OneofDescriptorProto
             * @static
             * @param {google.protobuf.OneofDescriptorProto} message OneofDescriptorProto
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            OneofDescriptorProto.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.defaults) {
                    object.name = "";
                    object.options = null;
                }
                if (message.name != null && message.hasOwnProperty("name"))
                    object.name = message.name;
                if (message.options != null && message.hasOwnProperty("options"))
                    object.options = $root.google.protobuf.OneofOptions.toObject(message.options, options);
                return object;
            };

            /**
             * Converts this OneofDescriptorProto to JSON.
             * @function toJSON
             * @memberof google.protobuf.OneofDescriptorProto
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            OneofDescriptorProto.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return OneofDescriptorProto;
        })();

        protobuf.EnumDescriptorProto = (function() {

            /**
             * Properties of an EnumDescriptorProto.
             * @memberof google.protobuf
             * @interface IEnumDescriptorProto
             * @property {string|null} [name] EnumDescriptorProto name
             * @property {Array.<google.protobuf.IEnumValueDescriptorProto>|null} [value] EnumDescriptorProto value
             * @property {google.protobuf.IEnumOptions|null} [options] EnumDescriptorProto options
             */

            /**
             * Constructs a new EnumDescriptorProto.
             * @memberof google.protobuf
             * @classdesc Represents an EnumDescriptorProto.
             * @implements IEnumDescriptorProto
             * @constructor
             * @param {google.protobuf.IEnumDescriptorProto=} [properties] Properties to set
             */
            function EnumDescriptorProto(properties) {
                this.value = [];
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * EnumDescriptorProto name.
             * @member {string} name
             * @memberof google.protobuf.EnumDescriptorProto
             * @instance
             */
            EnumDescriptorProto.prototype.name = "";

            /**
             * EnumDescriptorProto value.
             * @member {Array.<google.protobuf.IEnumValueDescriptorProto>} value
             * @memberof google.protobuf.EnumDescriptorProto
             * @instance
             */
            EnumDescriptorProto.prototype.value = $util.emptyArray;

            /**
             * EnumDescriptorProto options.
             * @member {google.protobuf.IEnumOptions|null|undefined} options
             * @memberof google.protobuf.EnumDescriptorProto
             * @instance
             */
            EnumDescriptorProto.prototype.options = null;

            /**
             * Creates a new EnumDescriptorProto instance using the specified properties.
             * @function create
             * @memberof google.protobuf.EnumDescriptorProto
             * @static
             * @param {google.protobuf.IEnumDescriptorProto=} [properties] Properties to set
             * @returns {google.protobuf.EnumDescriptorProto} EnumDescriptorProto instance
             */
            EnumDescriptorProto.create = function create(properties) {
                return new EnumDescriptorProto(properties);
            };

            /**
             * Encodes the specified EnumDescriptorProto message. Does not implicitly {@link google.protobuf.EnumDescriptorProto.verify|verify} messages.
             * @function encode
             * @memberof google.protobuf.EnumDescriptorProto
             * @static
             * @param {google.protobuf.IEnumDescriptorProto} message EnumDescriptorProto message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            EnumDescriptorProto.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                if (message.value != null && message.value.length)
                    for (var i = 0; i < message.value.length; ++i)
                        $root.google.protobuf.EnumValueDescriptorProto.encode(message.value[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                if (message.options != null && Object.hasOwnProperty.call(message, "options"))
                    $root.google.protobuf.EnumOptions.encode(message.options, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                return writer;
            };

            /**
             * Encodes the specified EnumDescriptorProto message, length delimited. Does not implicitly {@link google.protobuf.EnumDescriptorProto.verify|verify} messages.
             * @function encodeDelimited
             * @memberof google.protobuf.EnumDescriptorProto
             * @static
             * @param {google.protobuf.IEnumDescriptorProto} message EnumDescriptorProto message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            EnumDescriptorProto.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes an EnumDescriptorProto message from the specified reader or buffer.
             * @function decode
             * @memberof google.protobuf.EnumDescriptorProto
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {google.protobuf.EnumDescriptorProto} EnumDescriptorProto
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            EnumDescriptorProto.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.EnumDescriptorProto();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.name = reader.string();
                        break;
                    case 2:
                        if (!(message.value && message.value.length))
                            message.value = [];
                        message.value.push($root.google.protobuf.EnumValueDescriptorProto.decode(reader, reader.uint32()));
                        break;
                    case 3:
                        message.options = $root.google.protobuf.EnumOptions.decode(reader, reader.uint32());
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes an EnumDescriptorProto message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof google.protobuf.EnumDescriptorProto
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {google.protobuf.EnumDescriptorProto} EnumDescriptorProto
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            EnumDescriptorProto.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies an EnumDescriptorProto message.
             * @function verify
             * @memberof google.protobuf.EnumDescriptorProto
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            EnumDescriptorProto.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.name != null && message.hasOwnProperty("name"))
                    if (!$util.isString(message.name))
                        return "name: string expected";
                if (message.value != null && message.hasOwnProperty("value")) {
                    if (!Array.isArray(message.value))
                        return "value: array expected";
                    for (var i = 0; i < message.value.length; ++i) {
                        var error = $root.google.protobuf.EnumValueDescriptorProto.verify(message.value[i]);
                        if (error)
                            return "value." + error;
                    }
                }
                if (message.options != null && message.hasOwnProperty("options")) {
                    var error = $root.google.protobuf.EnumOptions.verify(message.options);
                    if (error)
                        return "options." + error;
                }
                return null;
            };

            /**
             * Creates an EnumDescriptorProto message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof google.protobuf.EnumDescriptorProto
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {google.protobuf.EnumDescriptorProto} EnumDescriptorProto
             */
            EnumDescriptorProto.fromObject = function fromObject(object) {
                if (object instanceof $root.google.protobuf.EnumDescriptorProto)
                    return object;
                var message = new $root.google.protobuf.EnumDescriptorProto();
                if (object.name != null)
                    message.name = String(object.name);
                if (object.value) {
                    if (!Array.isArray(object.value))
                        throw TypeError(".google.protobuf.EnumDescriptorProto.value: array expected");
                    message.value = [];
                    for (var i = 0; i < object.value.length; ++i) {
                        if (typeof object.value[i] !== "object")
                            throw TypeError(".google.protobuf.EnumDescriptorProto.value: object expected");
                        message.value[i] = $root.google.protobuf.EnumValueDescriptorProto.fromObject(object.value[i]);
                    }
                }
                if (object.options != null) {
                    if (typeof object.options !== "object")
                        throw TypeError(".google.protobuf.EnumDescriptorProto.options: object expected");
                    message.options = $root.google.protobuf.EnumOptions.fromObject(object.options);
                }
                return message;
            };

            /**
             * Creates a plain object from an EnumDescriptorProto message. Also converts values to other types if specified.
             * @function toObject
             * @memberof google.protobuf.EnumDescriptorProto
             * @static
             * @param {google.protobuf.EnumDescriptorProto} message EnumDescriptorProto
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            EnumDescriptorProto.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.arrays || options.defaults)
                    object.value = [];
                if (options.defaults) {
                    object.name = "";
                    object.options = null;
                }
                if (message.name != null && message.hasOwnProperty("name"))
                    object.name = message.name;
                if (message.value && message.value.length) {
                    object.value = [];
                    for (var j = 0; j < message.value.length; ++j)
                        object.value[j] = $root.google.protobuf.EnumValueDescriptorProto.toObject(message.value[j], options);
                }
                if (message.options != null && message.hasOwnProperty("options"))
                    object.options = $root.google.protobuf.EnumOptions.toObject(message.options, options);
                return object;
            };

            /**
             * Converts this EnumDescriptorProto to JSON.
             * @function toJSON
             * @memberof google.protobuf.EnumDescriptorProto
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            EnumDescriptorProto.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return EnumDescriptorProto;
        })();

        protobuf.EnumValueDescriptorProto = (function() {

            /**
             * Properties of an EnumValueDescriptorProto.
             * @memberof google.protobuf
             * @interface IEnumValueDescriptorProto
             * @property {string|null} [name] EnumValueDescriptorProto name
             * @property {number|null} [number] EnumValueDescriptorProto number
             * @property {google.protobuf.IEnumValueOptions|null} [options] EnumValueDescriptorProto options
             */

            /**
             * Constructs a new EnumValueDescriptorProto.
             * @memberof google.protobuf
             * @classdesc Represents an EnumValueDescriptorProto.
             * @implements IEnumValueDescriptorProto
             * @constructor
             * @param {google.protobuf.IEnumValueDescriptorProto=} [properties] Properties to set
             */
            function EnumValueDescriptorProto(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * EnumValueDescriptorProto name.
             * @member {string} name
             * @memberof google.protobuf.EnumValueDescriptorProto
             * @instance
             */
            EnumValueDescriptorProto.prototype.name = "";

            /**
             * EnumValueDescriptorProto number.
             * @member {number} number
             * @memberof google.protobuf.EnumValueDescriptorProto
             * @instance
             */
            EnumValueDescriptorProto.prototype.number = 0;

            /**
             * EnumValueDescriptorProto options.
             * @member {google.protobuf.IEnumValueOptions|null|undefined} options
             * @memberof google.protobuf.EnumValueDescriptorProto
             * @instance
             */
            EnumValueDescriptorProto.prototype.options = null;

            /**
             * Creates a new EnumValueDescriptorProto instance using the specified properties.
             * @function create
             * @memberof google.protobuf.EnumValueDescriptorProto
             * @static
             * @param {google.protobuf.IEnumValueDescriptorProto=} [properties] Properties to set
             * @returns {google.protobuf.EnumValueDescriptorProto} EnumValueDescriptorProto instance
             */
            EnumValueDescriptorProto.create = function create(properties) {
                return new EnumValueDescriptorProto(properties);
            };

            /**
             * Encodes the specified EnumValueDescriptorProto message. Does not implicitly {@link google.protobuf.EnumValueDescriptorProto.verify|verify} messages.
             * @function encode
             * @memberof google.protobuf.EnumValueDescriptorProto
             * @static
             * @param {google.protobuf.IEnumValueDescriptorProto} message EnumValueDescriptorProto message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            EnumValueDescriptorProto.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                if (message.number != null && Object.hasOwnProperty.call(message, "number"))
                    writer.uint32(/* id 2, wireType 0 =*/16).int32(message.number);
                if (message.options != null && Object.hasOwnProperty.call(message, "options"))
                    $root.google.protobuf.EnumValueOptions.encode(message.options, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                return writer;
            };

            /**
             * Encodes the specified EnumValueDescriptorProto message, length delimited. Does not implicitly {@link google.protobuf.EnumValueDescriptorProto.verify|verify} messages.
             * @function encodeDelimited
             * @memberof google.protobuf.EnumValueDescriptorProto
             * @static
             * @param {google.protobuf.IEnumValueDescriptorProto} message EnumValueDescriptorProto message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            EnumValueDescriptorProto.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes an EnumValueDescriptorProto message from the specified reader or buffer.
             * @function decode
             * @memberof google.protobuf.EnumValueDescriptorProto
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {google.protobuf.EnumValueDescriptorProto} EnumValueDescriptorProto
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            EnumValueDescriptorProto.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.EnumValueDescriptorProto();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.name = reader.string();
                        break;
                    case 2:
                        message.number = reader.int32();
                        break;
                    case 3:
                        message.options = $root.google.protobuf.EnumValueOptions.decode(reader, reader.uint32());
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes an EnumValueDescriptorProto message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof google.protobuf.EnumValueDescriptorProto
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {google.protobuf.EnumValueDescriptorProto} EnumValueDescriptorProto
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            EnumValueDescriptorProto.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies an EnumValueDescriptorProto message.
             * @function verify
             * @memberof google.protobuf.EnumValueDescriptorProto
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            EnumValueDescriptorProto.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.name != null && message.hasOwnProperty("name"))
                    if (!$util.isString(message.name))
                        return "name: string expected";
                if (message.number != null && message.hasOwnProperty("number"))
                    if (!$util.isInteger(message.number))
                        return "number: integer expected";
                if (message.options != null && message.hasOwnProperty("options")) {
                    var error = $root.google.protobuf.EnumValueOptions.verify(message.options);
                    if (error)
                        return "options." + error;
                }
                return null;
            };

            /**
             * Creates an EnumValueDescriptorProto message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof google.protobuf.EnumValueDescriptorProto
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {google.protobuf.EnumValueDescriptorProto} EnumValueDescriptorProto
             */
            EnumValueDescriptorProto.fromObject = function fromObject(object) {
                if (object instanceof $root.google.protobuf.EnumValueDescriptorProto)
                    return object;
                var message = new $root.google.protobuf.EnumValueDescriptorProto();
                if (object.name != null)
                    message.name = String(object.name);
                if (object.number != null)
                    message.number = object.number | 0;
                if (object.options != null) {
                    if (typeof object.options !== "object")
                        throw TypeError(".google.protobuf.EnumValueDescriptorProto.options: object expected");
                    message.options = $root.google.protobuf.EnumValueOptions.fromObject(object.options);
                }
                return message;
            };

            /**
             * Creates a plain object from an EnumValueDescriptorProto message. Also converts values to other types if specified.
             * @function toObject
             * @memberof google.protobuf.EnumValueDescriptorProto
             * @static
             * @param {google.protobuf.EnumValueDescriptorProto} message EnumValueDescriptorProto
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            EnumValueDescriptorProto.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.defaults) {
                    object.name = "";
                    object.number = 0;
                    object.options = null;
                }
                if (message.name != null && message.hasOwnProperty("name"))
                    object.name = message.name;
                if (message.number != null && message.hasOwnProperty("number"))
                    object.number = message.number;
                if (message.options != null && message.hasOwnProperty("options"))
                    object.options = $root.google.protobuf.EnumValueOptions.toObject(message.options, options);
                return object;
            };

            /**
             * Converts this EnumValueDescriptorProto to JSON.
             * @function toJSON
             * @memberof google.protobuf.EnumValueDescriptorProto
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            EnumValueDescriptorProto.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return EnumValueDescriptorProto;
        })();

        protobuf.ServiceDescriptorProto = (function() {

            /**
             * Properties of a ServiceDescriptorProto.
             * @memberof google.protobuf
             * @interface IServiceDescriptorProto
             * @property {string|null} [name] ServiceDescriptorProto name
             * @property {Array.<google.protobuf.IMethodDescriptorProto>|null} [method] ServiceDescriptorProto method
             * @property {google.protobuf.IServiceOptions|null} [options] ServiceDescriptorProto options
             */

            /**
             * Constructs a new ServiceDescriptorProto.
             * @memberof google.protobuf
             * @classdesc Represents a ServiceDescriptorProto.
             * @implements IServiceDescriptorProto
             * @constructor
             * @param {google.protobuf.IServiceDescriptorProto=} [properties] Properties to set
             */
            function ServiceDescriptorProto(properties) {
                this.method = [];
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * ServiceDescriptorProto name.
             * @member {string} name
             * @memberof google.protobuf.ServiceDescriptorProto
             * @instance
             */
            ServiceDescriptorProto.prototype.name = "";

            /**
             * ServiceDescriptorProto method.
             * @member {Array.<google.protobuf.IMethodDescriptorProto>} method
             * @memberof google.protobuf.ServiceDescriptorProto
             * @instance
             */
            ServiceDescriptorProto.prototype.method = $util.emptyArray;

            /**
             * ServiceDescriptorProto options.
             * @member {google.protobuf.IServiceOptions|null|undefined} options
             * @memberof google.protobuf.ServiceDescriptorProto
             * @instance
             */
            ServiceDescriptorProto.prototype.options = null;

            /**
             * Creates a new ServiceDescriptorProto instance using the specified properties.
             * @function create
             * @memberof google.protobuf.ServiceDescriptorProto
             * @static
             * @param {google.protobuf.IServiceDescriptorProto=} [properties] Properties to set
             * @returns {google.protobuf.ServiceDescriptorProto} ServiceDescriptorProto instance
             */
            ServiceDescriptorProto.create = function create(properties) {
                return new ServiceDescriptorProto(properties);
            };

            /**
             * Encodes the specified ServiceDescriptorProto message. Does not implicitly {@link google.protobuf.ServiceDescriptorProto.verify|verify} messages.
             * @function encode
             * @memberof google.protobuf.ServiceDescriptorProto
             * @static
             * @param {google.protobuf.IServiceDescriptorProto} message ServiceDescriptorProto message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            ServiceDescriptorProto.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                if (message.method != null && message.method.length)
                    for (var i = 0; i < message.method.length; ++i)
                        $root.google.protobuf.MethodDescriptorProto.encode(message.method[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                if (message.options != null && Object.hasOwnProperty.call(message, "options"))
                    $root.google.protobuf.ServiceOptions.encode(message.options, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                return writer;
            };

            /**
             * Encodes the specified ServiceDescriptorProto message, length delimited. Does not implicitly {@link google.protobuf.ServiceDescriptorProto.verify|verify} messages.
             * @function encodeDelimited
             * @memberof google.protobuf.ServiceDescriptorProto
             * @static
             * @param {google.protobuf.IServiceDescriptorProto} message ServiceDescriptorProto message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            ServiceDescriptorProto.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a ServiceDescriptorProto message from the specified reader or buffer.
             * @function decode
             * @memberof google.protobuf.ServiceDescriptorProto
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {google.protobuf.ServiceDescriptorProto} ServiceDescriptorProto
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            ServiceDescriptorProto.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.ServiceDescriptorProto();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.name = reader.string();
                        break;
                    case 2:
                        if (!(message.method && message.method.length))
                            message.method = [];
                        message.method.push($root.google.protobuf.MethodDescriptorProto.decode(reader, reader.uint32()));
                        break;
                    case 3:
                        message.options = $root.google.protobuf.ServiceOptions.decode(reader, reader.uint32());
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a ServiceDescriptorProto message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof google.protobuf.ServiceDescriptorProto
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {google.protobuf.ServiceDescriptorProto} ServiceDescriptorProto
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            ServiceDescriptorProto.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a ServiceDescriptorProto message.
             * @function verify
             * @memberof google.protobuf.ServiceDescriptorProto
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            ServiceDescriptorProto.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.name != null && message.hasOwnProperty("name"))
                    if (!$util.isString(message.name))
                        return "name: string expected";
                if (message.method != null && message.hasOwnProperty("method")) {
                    if (!Array.isArray(message.method))
                        return "method: array expected";
                    for (var i = 0; i < message.method.length; ++i) {
                        var error = $root.google.protobuf.MethodDescriptorProto.verify(message.method[i]);
                        if (error)
                            return "method." + error;
                    }
                }
                if (message.options != null && message.hasOwnProperty("options")) {
                    var error = $root.google.protobuf.ServiceOptions.verify(message.options);
                    if (error)
                        return "options." + error;
                }
                return null;
            };

            /**
             * Creates a ServiceDescriptorProto message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof google.protobuf.ServiceDescriptorProto
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {google.protobuf.ServiceDescriptorProto} ServiceDescriptorProto
             */
            ServiceDescriptorProto.fromObject = function fromObject(object) {
                if (object instanceof $root.google.protobuf.ServiceDescriptorProto)
                    return object;
                var message = new $root.google.protobuf.ServiceDescriptorProto();
                if (object.name != null)
                    message.name = String(object.name);
                if (object.method) {
                    if (!Array.isArray(object.method))
                        throw TypeError(".google.protobuf.ServiceDescriptorProto.method: array expected");
                    message.method = [];
                    for (var i = 0; i < object.method.length; ++i) {
                        if (typeof object.method[i] !== "object")
                            throw TypeError(".google.protobuf.ServiceDescriptorProto.method: object expected");
                        message.method[i] = $root.google.protobuf.MethodDescriptorProto.fromObject(object.method[i]);
                    }
                }
                if (object.options != null) {
                    if (typeof object.options !== "object")
                        throw TypeError(".google.protobuf.ServiceDescriptorProto.options: object expected");
                    message.options = $root.google.protobuf.ServiceOptions.fromObject(object.options);
                }
                return message;
            };

            /**
             * Creates a plain object from a ServiceDescriptorProto message. Also converts values to other types if specified.
             * @function toObject
             * @memberof google.protobuf.ServiceDescriptorProto
             * @static
             * @param {google.protobuf.ServiceDescriptorProto} message ServiceDescriptorProto
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            ServiceDescriptorProto.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.arrays || options.defaults)
                    object.method = [];
                if (options.defaults) {
                    object.name = "";
                    object.options = null;
                }
                if (message.name != null && message.hasOwnProperty("name"))
                    object.name = message.name;
                if (message.method && message.method.length) {
                    object.method = [];
                    for (var j = 0; j < message.method.length; ++j)
                        object.method[j] = $root.google.protobuf.MethodDescriptorProto.toObject(message.method[j], options);
                }
                if (message.options != null && message.hasOwnProperty("options"))
                    object.options = $root.google.protobuf.ServiceOptions.toObject(message.options, options);
                return object;
            };

            /**
             * Converts this ServiceDescriptorProto to JSON.
             * @function toJSON
             * @memberof google.protobuf.ServiceDescriptorProto
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            ServiceDescriptorProto.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return ServiceDescriptorProto;
        })();

        protobuf.MethodDescriptorProto = (function() {

            /**
             * Properties of a MethodDescriptorProto.
             * @memberof google.protobuf
             * @interface IMethodDescriptorProto
             * @property {string|null} [name] MethodDescriptorProto name
             * @property {string|null} [inputType] MethodDescriptorProto inputType
             * @property {string|null} [outputType] MethodDescriptorProto outputType
             * @property {google.protobuf.IMethodOptions|null} [options] MethodDescriptorProto options
             * @property {boolean|null} [clientStreaming] MethodDescriptorProto clientStreaming
             * @property {boolean|null} [serverStreaming] MethodDescriptorProto serverStreaming
             */

            /**
             * Constructs a new MethodDescriptorProto.
             * @memberof google.protobuf
             * @classdesc Represents a MethodDescriptorProto.
             * @implements IMethodDescriptorProto
             * @constructor
             * @param {google.protobuf.IMethodDescriptorProto=} [properties] Properties to set
             */
            function MethodDescriptorProto(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * MethodDescriptorProto name.
             * @member {string} name
             * @memberof google.protobuf.MethodDescriptorProto
             * @instance
             */
            MethodDescriptorProto.prototype.name = "";

            /**
             * MethodDescriptorProto inputType.
             * @member {string} inputType
             * @memberof google.protobuf.MethodDescriptorProto
             * @instance
             */
            MethodDescriptorProto.prototype.inputType = "";

            /**
             * MethodDescriptorProto outputType.
             * @member {string} outputType
             * @memberof google.protobuf.MethodDescriptorProto
             * @instance
             */
            MethodDescriptorProto.prototype.outputType = "";

            /**
             * MethodDescriptorProto options.
             * @member {google.protobuf.IMethodOptions|null|undefined} options
             * @memberof google.protobuf.MethodDescriptorProto
             * @instance
             */
            MethodDescriptorProto.prototype.options = null;

            /**
             * MethodDescriptorProto clientStreaming.
             * @member {boolean} clientStreaming
             * @memberof google.protobuf.MethodDescriptorProto
             * @instance
             */
            MethodDescriptorProto.prototype.clientStreaming = false;

            /**
             * MethodDescriptorProto serverStreaming.
             * @member {boolean} serverStreaming
             * @memberof google.protobuf.MethodDescriptorProto
             * @instance
             */
            MethodDescriptorProto.prototype.serverStreaming = false;

            /**
             * Creates a new MethodDescriptorProto instance using the specified properties.
             * @function create
             * @memberof google.protobuf.MethodDescriptorProto
             * @static
             * @param {google.protobuf.IMethodDescriptorProto=} [properties] Properties to set
             * @returns {google.protobuf.MethodDescriptorProto} MethodDescriptorProto instance
             */
            MethodDescriptorProto.create = function create(properties) {
                return new MethodDescriptorProto(properties);
            };

            /**
             * Encodes the specified MethodDescriptorProto message. Does not implicitly {@link google.protobuf.MethodDescriptorProto.verify|verify} messages.
             * @function encode
             * @memberof google.protobuf.MethodDescriptorProto
             * @static
             * @param {google.protobuf.IMethodDescriptorProto} message MethodDescriptorProto message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            MethodDescriptorProto.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                if (message.inputType != null && Object.hasOwnProperty.call(message, "inputType"))
                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.inputType);
                if (message.outputType != null && Object.hasOwnProperty.call(message, "outputType"))
                    writer.uint32(/* id 3, wireType 2 =*/26).string(message.outputType);
                if (message.options != null && Object.hasOwnProperty.call(message, "options"))
                    $root.google.protobuf.MethodOptions.encode(message.options, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                if (message.clientStreaming != null && Object.hasOwnProperty.call(message, "clientStreaming"))
                    writer.uint32(/* id 5, wireType 0 =*/40).bool(message.clientStreaming);
                if (message.serverStreaming != null && Object.hasOwnProperty.call(message, "serverStreaming"))
                    writer.uint32(/* id 6, wireType 0 =*/48).bool(message.serverStreaming);
                return writer;
            };

            /**
             * Encodes the specified MethodDescriptorProto message, length delimited. Does not implicitly {@link google.protobuf.MethodDescriptorProto.verify|verify} messages.
             * @function encodeDelimited
             * @memberof google.protobuf.MethodDescriptorProto
             * @static
             * @param {google.protobuf.IMethodDescriptorProto} message MethodDescriptorProto message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            MethodDescriptorProto.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a MethodDescriptorProto message from the specified reader or buffer.
             * @function decode
             * @memberof google.protobuf.MethodDescriptorProto
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {google.protobuf.MethodDescriptorProto} MethodDescriptorProto
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            MethodDescriptorProto.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.MethodDescriptorProto();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.name = reader.string();
                        break;
                    case 2:
                        message.inputType = reader.string();
                        break;
                    case 3:
                        message.outputType = reader.string();
                        break;
                    case 4:
                        message.options = $root.google.protobuf.MethodOptions.decode(reader, reader.uint32());
                        break;
                    case 5:
                        message.clientStreaming = reader.bool();
                        break;
                    case 6:
                        message.serverStreaming = reader.bool();
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a MethodDescriptorProto message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof google.protobuf.MethodDescriptorProto
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {google.protobuf.MethodDescriptorProto} MethodDescriptorProto
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            MethodDescriptorProto.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a MethodDescriptorProto message.
             * @function verify
             * @memberof google.protobuf.MethodDescriptorProto
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            MethodDescriptorProto.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.name != null && message.hasOwnProperty("name"))
                    if (!$util.isString(message.name))
                        return "name: string expected";
                if (message.inputType != null && message.hasOwnProperty("inputType"))
                    if (!$util.isString(message.inputType))
                        return "inputType: string expected";
                if (message.outputType != null && message.hasOwnProperty("outputType"))
                    if (!$util.isString(message.outputType))
                        return "outputType: string expected";
                if (message.options != null && message.hasOwnProperty("options")) {
                    var error = $root.google.protobuf.MethodOptions.verify(message.options);
                    if (error)
                        return "options." + error;
                }
                if (message.clientStreaming != null && message.hasOwnProperty("clientStreaming"))
                    if (typeof message.clientStreaming !== "boolean")
                        return "clientStreaming: boolean expected";
                if (message.serverStreaming != null && message.hasOwnProperty("serverStreaming"))
                    if (typeof message.serverStreaming !== "boolean")
                        return "serverStreaming: boolean expected";
                return null;
            };

            /**
             * Creates a MethodDescriptorProto message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof google.protobuf.MethodDescriptorProto
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {google.protobuf.MethodDescriptorProto} MethodDescriptorProto
             */
            MethodDescriptorProto.fromObject = function fromObject(object) {
                if (object instanceof $root.google.protobuf.MethodDescriptorProto)
                    return object;
                var message = new $root.google.protobuf.MethodDescriptorProto();
                if (object.name != null)
                    message.name = String(object.name);
                if (object.inputType != null)
                    message.inputType = String(object.inputType);
                if (object.outputType != null)
                    message.outputType = String(object.outputType);
                if (object.options != null) {
                    if (typeof object.options !== "object")
                        throw TypeError(".google.protobuf.MethodDescriptorProto.options: object expected");
                    message.options = $root.google.protobuf.MethodOptions.fromObject(object.options);
                }
                if (object.clientStreaming != null)
                    message.clientStreaming = Boolean(object.clientStreaming);
                if (object.serverStreaming != null)
                    message.serverStreaming = Boolean(object.serverStreaming);
                return message;
            };

            /**
             * Creates a plain object from a MethodDescriptorProto message. Also converts values to other types if specified.
             * @function toObject
             * @memberof google.protobuf.MethodDescriptorProto
             * @static
             * @param {google.protobuf.MethodDescriptorProto} message MethodDescriptorProto
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            MethodDescriptorProto.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.defaults) {
                    object.name = "";
                    object.inputType = "";
                    object.outputType = "";
                    object.options = null;
                    object.clientStreaming = false;
                    object.serverStreaming = false;
                }
                if (message.name != null && message.hasOwnProperty("name"))
                    object.name = message.name;
                if (message.inputType != null && message.hasOwnProperty("inputType"))
                    object.inputType = message.inputType;
                if (message.outputType != null && message.hasOwnProperty("outputType"))
                    object.outputType = message.outputType;
                if (message.options != null && message.hasOwnProperty("options"))
                    object.options = $root.google.protobuf.MethodOptions.toObject(message.options, options);
                if (message.clientStreaming != null && message.hasOwnProperty("clientStreaming"))
                    object.clientStreaming = message.clientStreaming;
                if (message.serverStreaming != null && message.hasOwnProperty("serverStreaming"))
                    object.serverStreaming = message.serverStreaming;
                return object;
            };

            /**
             * Converts this MethodDescriptorProto to JSON.
             * @function toJSON
             * @memberof google.protobuf.MethodDescriptorProto
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            MethodDescriptorProto.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return MethodDescriptorProto;
        })();

        protobuf.FileOptions = (function() {

            /**
             * Properties of a FileOptions.
             * @memberof google.protobuf
             * @interface IFileOptions
             * @property {string|null} [javaPackage] FileOptions javaPackage
             * @property {string|null} [javaOuterClassname] FileOptions javaOuterClassname
             * @property {boolean|null} [javaMultipleFiles] FileOptions javaMultipleFiles
             * @property {boolean|null} [javaGenerateEqualsAndHash] FileOptions javaGenerateEqualsAndHash
             * @property {boolean|null} [javaStringCheckUtf8] FileOptions javaStringCheckUtf8
             * @property {google.protobuf.FileOptions.OptimizeMode|null} [optimizeFor] FileOptions optimizeFor
             * @property {string|null} [goPackage] FileOptions goPackage
             * @property {boolean|null} [ccGenericServices] FileOptions ccGenericServices
             * @property {boolean|null} [javaGenericServices] FileOptions javaGenericServices
             * @property {boolean|null} [pyGenericServices] FileOptions pyGenericServices
             * @property {boolean|null} [deprecated] FileOptions deprecated
             * @property {boolean|null} [ccEnableArenas] FileOptions ccEnableArenas
             * @property {string|null} [objcClassPrefix] FileOptions objcClassPrefix
             * @property {string|null} [csharpNamespace] FileOptions csharpNamespace
             * @property {Array.<google.protobuf.IUninterpretedOption>|null} [uninterpretedOption] FileOptions uninterpretedOption
             */

            /**
             * Constructs a new FileOptions.
             * @memberof google.protobuf
             * @classdesc Represents a FileOptions.
             * @implements IFileOptions
             * @constructor
             * @param {google.protobuf.IFileOptions=} [properties] Properties to set
             */
            function FileOptions(properties) {
                this.uninterpretedOption = [];
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * FileOptions javaPackage.
             * @member {string} javaPackage
             * @memberof google.protobuf.FileOptions
             * @instance
             */
            FileOptions.prototype.javaPackage = "";

            /**
             * FileOptions javaOuterClassname.
             * @member {string} javaOuterClassname
             * @memberof google.protobuf.FileOptions
             * @instance
             */
            FileOptions.prototype.javaOuterClassname = "";

            /**
             * FileOptions javaMultipleFiles.
             * @member {boolean} javaMultipleFiles
             * @memberof google.protobuf.FileOptions
             * @instance
             */
            FileOptions.prototype.javaMultipleFiles = false;

            /**
             * FileOptions javaGenerateEqualsAndHash.
             * @member {boolean} javaGenerateEqualsAndHash
             * @memberof google.protobuf.FileOptions
             * @instance
             */
            FileOptions.prototype.javaGenerateEqualsAndHash = false;

            /**
             * FileOptions javaStringCheckUtf8.
             * @member {boolean} javaStringCheckUtf8
             * @memberof google.protobuf.FileOptions
             * @instance
             */
            FileOptions.prototype.javaStringCheckUtf8 = false;

            /**
             * FileOptions optimizeFor.
             * @member {google.protobuf.FileOptions.OptimizeMode} optimizeFor
             * @memberof google.protobuf.FileOptions
             * @instance
             */
            FileOptions.prototype.optimizeFor = 1;

            /**
             * FileOptions goPackage.
             * @member {string} goPackage
             * @memberof google.protobuf.FileOptions
             * @instance
             */
            FileOptions.prototype.goPackage = "";

            /**
             * FileOptions ccGenericServices.
             * @member {boolean} ccGenericServices
             * @memberof google.protobuf.FileOptions
             * @instance
             */
            FileOptions.prototype.ccGenericServices = false;

            /**
             * FileOptions javaGenericServices.
             * @member {boolean} javaGenericServices
             * @memberof google.protobuf.FileOptions
             * @instance
             */
            FileOptions.prototype.javaGenericServices = false;

            /**
             * FileOptions pyGenericServices.
             * @member {boolean} pyGenericServices
             * @memberof google.protobuf.FileOptions
             * @instance
             */
            FileOptions.prototype.pyGenericServices = false;

            /**
             * FileOptions deprecated.
             * @member {boolean} deprecated
             * @memberof google.protobuf.FileOptions
             * @instance
             */
            FileOptions.prototype.deprecated = false;

            /**
             * FileOptions ccEnableArenas.
             * @member {boolean} ccEnableArenas
             * @memberof google.protobuf.FileOptions
             * @instance
             */
            FileOptions.prototype.ccEnableArenas = false;

            /**
             * FileOptions objcClassPrefix.
             * @member {string} objcClassPrefix
             * @memberof google.protobuf.FileOptions
             * @instance
             */
            FileOptions.prototype.objcClassPrefix = "";

            /**
             * FileOptions csharpNamespace.
             * @member {string} csharpNamespace
             * @memberof google.protobuf.FileOptions
             * @instance
             */
            FileOptions.prototype.csharpNamespace = "";

            /**
             * FileOptions uninterpretedOption.
             * @member {Array.<google.protobuf.IUninterpretedOption>} uninterpretedOption
             * @memberof google.protobuf.FileOptions
             * @instance
             */
            FileOptions.prototype.uninterpretedOption = $util.emptyArray;

            /**
             * Creates a new FileOptions instance using the specified properties.
             * @function create
             * @memberof google.protobuf.FileOptions
             * @static
             * @param {google.protobuf.IFileOptions=} [properties] Properties to set
             * @returns {google.protobuf.FileOptions} FileOptions instance
             */
            FileOptions.create = function create(properties) {
                return new FileOptions(properties);
            };

            /**
             * Encodes the specified FileOptions message. Does not implicitly {@link google.protobuf.FileOptions.verify|verify} messages.
             * @function encode
             * @memberof google.protobuf.FileOptions
             * @static
             * @param {google.protobuf.IFileOptions} message FileOptions message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            FileOptions.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.javaPackage != null && Object.hasOwnProperty.call(message, "javaPackage"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.javaPackage);
                if (message.javaOuterClassname != null && Object.hasOwnProperty.call(message, "javaOuterClassname"))
                    writer.uint32(/* id 8, wireType 2 =*/66).string(message.javaOuterClassname);
                if (message.optimizeFor != null && Object.hasOwnProperty.call(message, "optimizeFor"))
                    writer.uint32(/* id 9, wireType 0 =*/72).int32(message.optimizeFor);
                if (message.javaMultipleFiles != null && Object.hasOwnProperty.call(message, "javaMultipleFiles"))
                    writer.uint32(/* id 10, wireType 0 =*/80).bool(message.javaMultipleFiles);
                if (message.goPackage != null && Object.hasOwnProperty.call(message, "goPackage"))
                    writer.uint32(/* id 11, wireType 2 =*/90).string(message.goPackage);
                if (message.ccGenericServices != null && Object.hasOwnProperty.call(message, "ccGenericServices"))
                    writer.uint32(/* id 16, wireType 0 =*/128).bool(message.ccGenericServices);
                if (message.javaGenericServices != null && Object.hasOwnProperty.call(message, "javaGenericServices"))
                    writer.uint32(/* id 17, wireType 0 =*/136).bool(message.javaGenericServices);
                if (message.pyGenericServices != null && Object.hasOwnProperty.call(message, "pyGenericServices"))
                    writer.uint32(/* id 18, wireType 0 =*/144).bool(message.pyGenericServices);
                if (message.javaGenerateEqualsAndHash != null && Object.hasOwnProperty.call(message, "javaGenerateEqualsAndHash"))
                    writer.uint32(/* id 20, wireType 0 =*/160).bool(message.javaGenerateEqualsAndHash);
                if (message.deprecated != null && Object.hasOwnProperty.call(message, "deprecated"))
                    writer.uint32(/* id 23, wireType 0 =*/184).bool(message.deprecated);
                if (message.javaStringCheckUtf8 != null && Object.hasOwnProperty.call(message, "javaStringCheckUtf8"))
                    writer.uint32(/* id 27, wireType 0 =*/216).bool(message.javaStringCheckUtf8);
                if (message.ccEnableArenas != null && Object.hasOwnProperty.call(message, "ccEnableArenas"))
                    writer.uint32(/* id 31, wireType 0 =*/248).bool(message.ccEnableArenas);
                if (message.objcClassPrefix != null && Object.hasOwnProperty.call(message, "objcClassPrefix"))
                    writer.uint32(/* id 36, wireType 2 =*/290).string(message.objcClassPrefix);
                if (message.csharpNamespace != null && Object.hasOwnProperty.call(message, "csharpNamespace"))
                    writer.uint32(/* id 37, wireType 2 =*/298).string(message.csharpNamespace);
                if (message.uninterpretedOption != null && message.uninterpretedOption.length)
                    for (var i = 0; i < message.uninterpretedOption.length; ++i)
                        $root.google.protobuf.UninterpretedOption.encode(message.uninterpretedOption[i], writer.uint32(/* id 999, wireType 2 =*/7994).fork()).ldelim();
                return writer;
            };

            /**
             * Encodes the specified FileOptions message, length delimited. Does not implicitly {@link google.protobuf.FileOptions.verify|verify} messages.
             * @function encodeDelimited
             * @memberof google.protobuf.FileOptions
             * @static
             * @param {google.protobuf.IFileOptions} message FileOptions message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            FileOptions.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a FileOptions message from the specified reader or buffer.
             * @function decode
             * @memberof google.protobuf.FileOptions
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {google.protobuf.FileOptions} FileOptions
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            FileOptions.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.FileOptions();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.javaPackage = reader.string();
                        break;
                    case 8:
                        message.javaOuterClassname = reader.string();
                        break;
                    case 10:
                        message.javaMultipleFiles = reader.bool();
                        break;
                    case 20:
                        message.javaGenerateEqualsAndHash = reader.bool();
                        break;
                    case 27:
                        message.javaStringCheckUtf8 = reader.bool();
                        break;
                    case 9:
                        message.optimizeFor = reader.int32();
                        break;
                    case 11:
                        message.goPackage = reader.string();
                        break;
                    case 16:
                        message.ccGenericServices = reader.bool();
                        break;
                    case 17:
                        message.javaGenericServices = reader.bool();
                        break;
                    case 18:
                        message.pyGenericServices = reader.bool();
                        break;
                    case 23:
                        message.deprecated = reader.bool();
                        break;
                    case 31:
                        message.ccEnableArenas = reader.bool();
                        break;
                    case 36:
                        message.objcClassPrefix = reader.string();
                        break;
                    case 37:
                        message.csharpNamespace = reader.string();
                        break;
                    case 999:
                        if (!(message.uninterpretedOption && message.uninterpretedOption.length))
                            message.uninterpretedOption = [];
                        message.uninterpretedOption.push($root.google.protobuf.UninterpretedOption.decode(reader, reader.uint32()));
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a FileOptions message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof google.protobuf.FileOptions
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {google.protobuf.FileOptions} FileOptions
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            FileOptions.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a FileOptions message.
             * @function verify
             * @memberof google.protobuf.FileOptions
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            FileOptions.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.javaPackage != null && message.hasOwnProperty("javaPackage"))
                    if (!$util.isString(message.javaPackage))
                        return "javaPackage: string expected";
                if (message.javaOuterClassname != null && message.hasOwnProperty("javaOuterClassname"))
                    if (!$util.isString(message.javaOuterClassname))
                        return "javaOuterClassname: string expected";
                if (message.javaMultipleFiles != null && message.hasOwnProperty("javaMultipleFiles"))
                    if (typeof message.javaMultipleFiles !== "boolean")
                        return "javaMultipleFiles: boolean expected";
                if (message.javaGenerateEqualsAndHash != null && message.hasOwnProperty("javaGenerateEqualsAndHash"))
                    if (typeof message.javaGenerateEqualsAndHash !== "boolean")
                        return "javaGenerateEqualsAndHash: boolean expected";
                if (message.javaStringCheckUtf8 != null && message.hasOwnProperty("javaStringCheckUtf8"))
                    if (typeof message.javaStringCheckUtf8 !== "boolean")
                        return "javaStringCheckUtf8: boolean expected";
                if (message.optimizeFor != null && message.hasOwnProperty("optimizeFor"))
                    switch (message.optimizeFor) {
                    default:
                        return "optimizeFor: enum value expected";
                    case 1:
                    case 2:
                    case 3:
                        break;
                    }
                if (message.goPackage != null && message.hasOwnProperty("goPackage"))
                    if (!$util.isString(message.goPackage))
                        return "goPackage: string expected";
                if (message.ccGenericServices != null && message.hasOwnProperty("ccGenericServices"))
                    if (typeof message.ccGenericServices !== "boolean")
                        return "ccGenericServices: boolean expected";
                if (message.javaGenericServices != null && message.hasOwnProperty("javaGenericServices"))
                    if (typeof message.javaGenericServices !== "boolean")
                        return "javaGenericServices: boolean expected";
                if (message.pyGenericServices != null && message.hasOwnProperty("pyGenericServices"))
                    if (typeof message.pyGenericServices !== "boolean")
                        return "pyGenericServices: boolean expected";
                if (message.deprecated != null && message.hasOwnProperty("deprecated"))
                    if (typeof message.deprecated !== "boolean")
                        return "deprecated: boolean expected";
                if (message.ccEnableArenas != null && message.hasOwnProperty("ccEnableArenas"))
                    if (typeof message.ccEnableArenas !== "boolean")
                        return "ccEnableArenas: boolean expected";
                if (message.objcClassPrefix != null && message.hasOwnProperty("objcClassPrefix"))
                    if (!$util.isString(message.objcClassPrefix))
                        return "objcClassPrefix: string expected";
                if (message.csharpNamespace != null && message.hasOwnProperty("csharpNamespace"))
                    if (!$util.isString(message.csharpNamespace))
                        return "csharpNamespace: string expected";
                if (message.uninterpretedOption != null && message.hasOwnProperty("uninterpretedOption")) {
                    if (!Array.isArray(message.uninterpretedOption))
                        return "uninterpretedOption: array expected";
                    for (var i = 0; i < message.uninterpretedOption.length; ++i) {
                        var error = $root.google.protobuf.UninterpretedOption.verify(message.uninterpretedOption[i]);
                        if (error)
                            return "uninterpretedOption." + error;
                    }
                }
                return null;
            };

            /**
             * Creates a FileOptions message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof google.protobuf.FileOptions
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {google.protobuf.FileOptions} FileOptions
             */
            FileOptions.fromObject = function fromObject(object) {
                if (object instanceof $root.google.protobuf.FileOptions)
                    return object;
                var message = new $root.google.protobuf.FileOptions();
                if (object.javaPackage != null)
                    message.javaPackage = String(object.javaPackage);
                if (object.javaOuterClassname != null)
                    message.javaOuterClassname = String(object.javaOuterClassname);
                if (object.javaMultipleFiles != null)
                    message.javaMultipleFiles = Boolean(object.javaMultipleFiles);
                if (object.javaGenerateEqualsAndHash != null)
                    message.javaGenerateEqualsAndHash = Boolean(object.javaGenerateEqualsAndHash);
                if (object.javaStringCheckUtf8 != null)
                    message.javaStringCheckUtf8 = Boolean(object.javaStringCheckUtf8);
                switch (object.optimizeFor) {
                case "SPEED":
                case 1:
                    message.optimizeFor = 1;
                    break;
                case "CODE_SIZE":
                case 2:
                    message.optimizeFor = 2;
                    break;
                case "LITE_RUNTIME":
                case 3:
                    message.optimizeFor = 3;
                    break;
                }
                if (object.goPackage != null)
                    message.goPackage = String(object.goPackage);
                if (object.ccGenericServices != null)
                    message.ccGenericServices = Boolean(object.ccGenericServices);
                if (object.javaGenericServices != null)
                    message.javaGenericServices = Boolean(object.javaGenericServices);
                if (object.pyGenericServices != null)
                    message.pyGenericServices = Boolean(object.pyGenericServices);
                if (object.deprecated != null)
                    message.deprecated = Boolean(object.deprecated);
                if (object.ccEnableArenas != null)
                    message.ccEnableArenas = Boolean(object.ccEnableArenas);
                if (object.objcClassPrefix != null)
                    message.objcClassPrefix = String(object.objcClassPrefix);
                if (object.csharpNamespace != null)
                    message.csharpNamespace = String(object.csharpNamespace);
                if (object.uninterpretedOption) {
                    if (!Array.isArray(object.uninterpretedOption))
                        throw TypeError(".google.protobuf.FileOptions.uninterpretedOption: array expected");
                    message.uninterpretedOption = [];
                    for (var i = 0; i < object.uninterpretedOption.length; ++i) {
                        if (typeof object.uninterpretedOption[i] !== "object")
                            throw TypeError(".google.protobuf.FileOptions.uninterpretedOption: object expected");
                        message.uninterpretedOption[i] = $root.google.protobuf.UninterpretedOption.fromObject(object.uninterpretedOption[i]);
                    }
                }
                return message;
            };

            /**
             * Creates a plain object from a FileOptions message. Also converts values to other types if specified.
             * @function toObject
             * @memberof google.protobuf.FileOptions
             * @static
             * @param {google.protobuf.FileOptions} message FileOptions
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            FileOptions.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.arrays || options.defaults)
                    object.uninterpretedOption = [];
                if (options.defaults) {
                    object.javaPackage = "";
                    object.javaOuterClassname = "";
                    object.optimizeFor = options.enums === String ? "SPEED" : 1;
                    object.javaMultipleFiles = false;
                    object.goPackage = "";
                    object.ccGenericServices = false;
                    object.javaGenericServices = false;
                    object.pyGenericServices = false;
                    object.javaGenerateEqualsAndHash = false;
                    object.deprecated = false;
                    object.javaStringCheckUtf8 = false;
                    object.ccEnableArenas = false;
                    object.objcClassPrefix = "";
                    object.csharpNamespace = "";
                }
                if (message.javaPackage != null && message.hasOwnProperty("javaPackage"))
                    object.javaPackage = message.javaPackage;
                if (message.javaOuterClassname != null && message.hasOwnProperty("javaOuterClassname"))
                    object.javaOuterClassname = message.javaOuterClassname;
                if (message.optimizeFor != null && message.hasOwnProperty("optimizeFor"))
                    object.optimizeFor = options.enums === String ? $root.google.protobuf.FileOptions.OptimizeMode[message.optimizeFor] : message.optimizeFor;
                if (message.javaMultipleFiles != null && message.hasOwnProperty("javaMultipleFiles"))
                    object.javaMultipleFiles = message.javaMultipleFiles;
                if (message.goPackage != null && message.hasOwnProperty("goPackage"))
                    object.goPackage = message.goPackage;
                if (message.ccGenericServices != null && message.hasOwnProperty("ccGenericServices"))
                    object.ccGenericServices = message.ccGenericServices;
                if (message.javaGenericServices != null && message.hasOwnProperty("javaGenericServices"))
                    object.javaGenericServices = message.javaGenericServices;
                if (message.pyGenericServices != null && message.hasOwnProperty("pyGenericServices"))
                    object.pyGenericServices = message.pyGenericServices;
                if (message.javaGenerateEqualsAndHash != null && message.hasOwnProperty("javaGenerateEqualsAndHash"))
                    object.javaGenerateEqualsAndHash = message.javaGenerateEqualsAndHash;
                if (message.deprecated != null && message.hasOwnProperty("deprecated"))
                    object.deprecated = message.deprecated;
                if (message.javaStringCheckUtf8 != null && message.hasOwnProperty("javaStringCheckUtf8"))
                    object.javaStringCheckUtf8 = message.javaStringCheckUtf8;
                if (message.ccEnableArenas != null && message.hasOwnProperty("ccEnableArenas"))
                    object.ccEnableArenas = message.ccEnableArenas;
                if (message.objcClassPrefix != null && message.hasOwnProperty("objcClassPrefix"))
                    object.objcClassPrefix = message.objcClassPrefix;
                if (message.csharpNamespace != null && message.hasOwnProperty("csharpNamespace"))
                    object.csharpNamespace = message.csharpNamespace;
                if (message.uninterpretedOption && message.uninterpretedOption.length) {
                    object.uninterpretedOption = [];
                    for (var j = 0; j < message.uninterpretedOption.length; ++j)
                        object.uninterpretedOption[j] = $root.google.protobuf.UninterpretedOption.toObject(message.uninterpretedOption[j], options);
                }
                return object;
            };

            /**
             * Converts this FileOptions to JSON.
             * @function toJSON
             * @memberof google.protobuf.FileOptions
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            FileOptions.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            /**
             * OptimizeMode enum.
             * @name google.protobuf.FileOptions.OptimizeMode
             * @enum {number}
             * @property {number} SPEED=1 SPEED value
             * @property {number} CODE_SIZE=2 CODE_SIZE value
             * @property {number} LITE_RUNTIME=3 LITE_RUNTIME value
             */
            FileOptions.OptimizeMode = (function() {
                var valuesById = {}, values = Object.create(valuesById);
                values[valuesById[1] = "SPEED"] = 1;
                values[valuesById[2] = "CODE_SIZE"] = 2;
                values[valuesById[3] = "LITE_RUNTIME"] = 3;
                return values;
            })();

            return FileOptions;
        })();

        protobuf.MessageOptions = (function() {

            /**
             * Properties of a MessageOptions.
             * @memberof google.protobuf
             * @interface IMessageOptions
             * @property {boolean|null} [messageSetWireFormat] MessageOptions messageSetWireFormat
             * @property {boolean|null} [noStandardDescriptorAccessor] MessageOptions noStandardDescriptorAccessor
             * @property {boolean|null} [deprecated] MessageOptions deprecated
             * @property {boolean|null} [mapEntry] MessageOptions mapEntry
             * @property {Array.<google.protobuf.IUninterpretedOption>|null} [uninterpretedOption] MessageOptions uninterpretedOption
             * @property {boolean|null} [".alwaysProto"] MessageOptions .alwaysProto
             * @property {string|null} [".apphostType"] MessageOptions .apphostType
             */

            /**
             * Constructs a new MessageOptions.
             * @memberof google.protobuf
             * @classdesc Represents a MessageOptions.
             * @implements IMessageOptions
             * @constructor
             * @param {google.protobuf.IMessageOptions=} [properties] Properties to set
             */
            function MessageOptions(properties) {
                this.uninterpretedOption = [];
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * MessageOptions messageSetWireFormat.
             * @member {boolean} messageSetWireFormat
             * @memberof google.protobuf.MessageOptions
             * @instance
             */
            MessageOptions.prototype.messageSetWireFormat = false;

            /**
             * MessageOptions noStandardDescriptorAccessor.
             * @member {boolean} noStandardDescriptorAccessor
             * @memberof google.protobuf.MessageOptions
             * @instance
             */
            MessageOptions.prototype.noStandardDescriptorAccessor = false;

            /**
             * MessageOptions deprecated.
             * @member {boolean} deprecated
             * @memberof google.protobuf.MessageOptions
             * @instance
             */
            MessageOptions.prototype.deprecated = false;

            /**
             * MessageOptions mapEntry.
             * @member {boolean} mapEntry
             * @memberof google.protobuf.MessageOptions
             * @instance
             */
            MessageOptions.prototype.mapEntry = false;

            /**
             * MessageOptions uninterpretedOption.
             * @member {Array.<google.protobuf.IUninterpretedOption>} uninterpretedOption
             * @memberof google.protobuf.MessageOptions
             * @instance
             */
            MessageOptions.prototype.uninterpretedOption = $util.emptyArray;

            /**
             * MessageOptions .alwaysProto.
             * @member {boolean} .alwaysProto
             * @memberof google.protobuf.MessageOptions
             * @instance
             */
            MessageOptions.prototype[".alwaysProto"] = false;

            /**
             * MessageOptions .apphostType.
             * @member {string} .apphostType
             * @memberof google.protobuf.MessageOptions
             * @instance
             */
            MessageOptions.prototype[".apphostType"] = "";

            /**
             * Creates a new MessageOptions instance using the specified properties.
             * @function create
             * @memberof google.protobuf.MessageOptions
             * @static
             * @param {google.protobuf.IMessageOptions=} [properties] Properties to set
             * @returns {google.protobuf.MessageOptions} MessageOptions instance
             */
            MessageOptions.create = function create(properties) {
                return new MessageOptions(properties);
            };

            /**
             * Encodes the specified MessageOptions message. Does not implicitly {@link google.protobuf.MessageOptions.verify|verify} messages.
             * @function encode
             * @memberof google.protobuf.MessageOptions
             * @static
             * @param {google.protobuf.IMessageOptions} message MessageOptions message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            MessageOptions.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.messageSetWireFormat != null && Object.hasOwnProperty.call(message, "messageSetWireFormat"))
                    writer.uint32(/* id 1, wireType 0 =*/8).bool(message.messageSetWireFormat);
                if (message.noStandardDescriptorAccessor != null && Object.hasOwnProperty.call(message, "noStandardDescriptorAccessor"))
                    writer.uint32(/* id 2, wireType 0 =*/16).bool(message.noStandardDescriptorAccessor);
                if (message.deprecated != null && Object.hasOwnProperty.call(message, "deprecated"))
                    writer.uint32(/* id 3, wireType 0 =*/24).bool(message.deprecated);
                if (message.mapEntry != null && Object.hasOwnProperty.call(message, "mapEntry"))
                    writer.uint32(/* id 7, wireType 0 =*/56).bool(message.mapEntry);
                if (message.uninterpretedOption != null && message.uninterpretedOption.length)
                    for (var i = 0; i < message.uninterpretedOption.length; ++i)
                        $root.google.protobuf.UninterpretedOption.encode(message.uninterpretedOption[i], writer.uint32(/* id 999, wireType 2 =*/7994).fork()).ldelim();
                if (message[".apphostType"] != null && Object.hasOwnProperty.call(message, ".apphostType"))
                    writer.uint32(/* id 17957, wireType 2 =*/143658).string(message[".apphostType"]);
                if (message[".alwaysProto"] != null && Object.hasOwnProperty.call(message, ".alwaysProto"))
                    writer.uint32(/* id 17958, wireType 0 =*/143664).bool(message[".alwaysProto"]);
                return writer;
            };

            /**
             * Encodes the specified MessageOptions message, length delimited. Does not implicitly {@link google.protobuf.MessageOptions.verify|verify} messages.
             * @function encodeDelimited
             * @memberof google.protobuf.MessageOptions
             * @static
             * @param {google.protobuf.IMessageOptions} message MessageOptions message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            MessageOptions.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a MessageOptions message from the specified reader or buffer.
             * @function decode
             * @memberof google.protobuf.MessageOptions
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {google.protobuf.MessageOptions} MessageOptions
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            MessageOptions.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.MessageOptions();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.messageSetWireFormat = reader.bool();
                        break;
                    case 2:
                        message.noStandardDescriptorAccessor = reader.bool();
                        break;
                    case 3:
                        message.deprecated = reader.bool();
                        break;
                    case 7:
                        message.mapEntry = reader.bool();
                        break;
                    case 999:
                        if (!(message.uninterpretedOption && message.uninterpretedOption.length))
                            message.uninterpretedOption = [];
                        message.uninterpretedOption.push($root.google.protobuf.UninterpretedOption.decode(reader, reader.uint32()));
                        break;
                    case 17958:
                        message[".alwaysProto"] = reader.bool();
                        break;
                    case 17957:
                        message[".apphostType"] = reader.string();
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a MessageOptions message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof google.protobuf.MessageOptions
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {google.protobuf.MessageOptions} MessageOptions
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            MessageOptions.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a MessageOptions message.
             * @function verify
             * @memberof google.protobuf.MessageOptions
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            MessageOptions.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.messageSetWireFormat != null && message.hasOwnProperty("messageSetWireFormat"))
                    if (typeof message.messageSetWireFormat !== "boolean")
                        return "messageSetWireFormat: boolean expected";
                if (message.noStandardDescriptorAccessor != null && message.hasOwnProperty("noStandardDescriptorAccessor"))
                    if (typeof message.noStandardDescriptorAccessor !== "boolean")
                        return "noStandardDescriptorAccessor: boolean expected";
                if (message.deprecated != null && message.hasOwnProperty("deprecated"))
                    if (typeof message.deprecated !== "boolean")
                        return "deprecated: boolean expected";
                if (message.mapEntry != null && message.hasOwnProperty("mapEntry"))
                    if (typeof message.mapEntry !== "boolean")
                        return "mapEntry: boolean expected";
                if (message.uninterpretedOption != null && message.hasOwnProperty("uninterpretedOption")) {
                    if (!Array.isArray(message.uninterpretedOption))
                        return "uninterpretedOption: array expected";
                    for (var i = 0; i < message.uninterpretedOption.length; ++i) {
                        var error = $root.google.protobuf.UninterpretedOption.verify(message.uninterpretedOption[i]);
                        if (error)
                            return "uninterpretedOption." + error;
                    }
                }
                if (message[".alwaysProto"] != null && message.hasOwnProperty(".alwaysProto"))
                    if (typeof message[".alwaysProto"] !== "boolean")
                        return ".alwaysProto: boolean expected";
                if (message[".apphostType"] != null && message.hasOwnProperty(".apphostType"))
                    if (!$util.isString(message[".apphostType"]))
                        return ".apphostType: string expected";
                return null;
            };

            /**
             * Creates a MessageOptions message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof google.protobuf.MessageOptions
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {google.protobuf.MessageOptions} MessageOptions
             */
            MessageOptions.fromObject = function fromObject(object) {
                if (object instanceof $root.google.protobuf.MessageOptions)
                    return object;
                var message = new $root.google.protobuf.MessageOptions();
                if (object.messageSetWireFormat != null)
                    message.messageSetWireFormat = Boolean(object.messageSetWireFormat);
                if (object.noStandardDescriptorAccessor != null)
                    message.noStandardDescriptorAccessor = Boolean(object.noStandardDescriptorAccessor);
                if (object.deprecated != null)
                    message.deprecated = Boolean(object.deprecated);
                if (object.mapEntry != null)
                    message.mapEntry = Boolean(object.mapEntry);
                if (object.uninterpretedOption) {
                    if (!Array.isArray(object.uninterpretedOption))
                        throw TypeError(".google.protobuf.MessageOptions.uninterpretedOption: array expected");
                    message.uninterpretedOption = [];
                    for (var i = 0; i < object.uninterpretedOption.length; ++i) {
                        if (typeof object.uninterpretedOption[i] !== "object")
                            throw TypeError(".google.protobuf.MessageOptions.uninterpretedOption: object expected");
                        message.uninterpretedOption[i] = $root.google.protobuf.UninterpretedOption.fromObject(object.uninterpretedOption[i]);
                    }
                }
                if (object[".alwaysProto"] != null)
                    message[".alwaysProto"] = Boolean(object[".alwaysProto"]);
                if (object[".apphostType"] != null)
                    message[".apphostType"] = String(object[".apphostType"]);
                return message;
            };

            /**
             * Creates a plain object from a MessageOptions message. Also converts values to other types if specified.
             * @function toObject
             * @memberof google.protobuf.MessageOptions
             * @static
             * @param {google.protobuf.MessageOptions} message MessageOptions
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            MessageOptions.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.arrays || options.defaults)
                    object.uninterpretedOption = [];
                if (options.defaults) {
                    object.messageSetWireFormat = false;
                    object.noStandardDescriptorAccessor = false;
                    object.deprecated = false;
                    object.mapEntry = false;
                    object[".apphostType"] = "";
                    object[".alwaysProto"] = false;
                }
                if (message.messageSetWireFormat != null && message.hasOwnProperty("messageSetWireFormat"))
                    object.messageSetWireFormat = message.messageSetWireFormat;
                if (message.noStandardDescriptorAccessor != null && message.hasOwnProperty("noStandardDescriptorAccessor"))
                    object.noStandardDescriptorAccessor = message.noStandardDescriptorAccessor;
                if (message.deprecated != null && message.hasOwnProperty("deprecated"))
                    object.deprecated = message.deprecated;
                if (message.mapEntry != null && message.hasOwnProperty("mapEntry"))
                    object.mapEntry = message.mapEntry;
                if (message.uninterpretedOption && message.uninterpretedOption.length) {
                    object.uninterpretedOption = [];
                    for (var j = 0; j < message.uninterpretedOption.length; ++j)
                        object.uninterpretedOption[j] = $root.google.protobuf.UninterpretedOption.toObject(message.uninterpretedOption[j], options);
                }
                if (message[".apphostType"] != null && message.hasOwnProperty(".apphostType"))
                    object[".apphostType"] = message[".apphostType"];
                if (message[".alwaysProto"] != null && message.hasOwnProperty(".alwaysProto"))
                    object[".alwaysProto"] = message[".alwaysProto"];
                return object;
            };

            /**
             * Converts this MessageOptions to JSON.
             * @function toJSON
             * @memberof google.protobuf.MessageOptions
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            MessageOptions.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return MessageOptions;
        })();

        protobuf.FieldOptions = (function() {

            /**
             * Properties of a FieldOptions.
             * @memberof google.protobuf
             * @interface IFieldOptions
             * @property {google.protobuf.FieldOptions.CType|null} [ctype] FieldOptions ctype
             * @property {boolean|null} [packed] FieldOptions packed
             * @property {google.protobuf.FieldOptions.JSType|null} [jstype] FieldOptions jstype
             * @property {boolean|null} [lazy] FieldOptions lazy
             * @property {boolean|null} [deprecated] FieldOptions deprecated
             * @property {boolean|null} [weak] FieldOptions weak
             * @property {Array.<google.protobuf.IUninterpretedOption>|null} [uninterpretedOption] FieldOptions uninterpretedOption
             * @property {string|null} [".typingApphostType"] FieldOptions .typingApphostType
             */

            /**
             * Constructs a new FieldOptions.
             * @memberof google.protobuf
             * @classdesc Represents a FieldOptions.
             * @implements IFieldOptions
             * @constructor
             * @param {google.protobuf.IFieldOptions=} [properties] Properties to set
             */
            function FieldOptions(properties) {
                this.uninterpretedOption = [];
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * FieldOptions ctype.
             * @member {google.protobuf.FieldOptions.CType} ctype
             * @memberof google.protobuf.FieldOptions
             * @instance
             */
            FieldOptions.prototype.ctype = 0;

            /**
             * FieldOptions packed.
             * @member {boolean} packed
             * @memberof google.protobuf.FieldOptions
             * @instance
             */
            FieldOptions.prototype.packed = false;

            /**
             * FieldOptions jstype.
             * @member {google.protobuf.FieldOptions.JSType} jstype
             * @memberof google.protobuf.FieldOptions
             * @instance
             */
            FieldOptions.prototype.jstype = 0;

            /**
             * FieldOptions lazy.
             * @member {boolean} lazy
             * @memberof google.protobuf.FieldOptions
             * @instance
             */
            FieldOptions.prototype.lazy = false;

            /**
             * FieldOptions deprecated.
             * @member {boolean} deprecated
             * @memberof google.protobuf.FieldOptions
             * @instance
             */
            FieldOptions.prototype.deprecated = false;

            /**
             * FieldOptions weak.
             * @member {boolean} weak
             * @memberof google.protobuf.FieldOptions
             * @instance
             */
            FieldOptions.prototype.weak = false;

            /**
             * FieldOptions uninterpretedOption.
             * @member {Array.<google.protobuf.IUninterpretedOption>} uninterpretedOption
             * @memberof google.protobuf.FieldOptions
             * @instance
             */
            FieldOptions.prototype.uninterpretedOption = $util.emptyArray;

            /**
             * FieldOptions .typingApphostType.
             * @member {string} .typingApphostType
             * @memberof google.protobuf.FieldOptions
             * @instance
             */
            FieldOptions.prototype[".typingApphostType"] = "";

            /**
             * Creates a new FieldOptions instance using the specified properties.
             * @function create
             * @memberof google.protobuf.FieldOptions
             * @static
             * @param {google.protobuf.IFieldOptions=} [properties] Properties to set
             * @returns {google.protobuf.FieldOptions} FieldOptions instance
             */
            FieldOptions.create = function create(properties) {
                return new FieldOptions(properties);
            };

            /**
             * Encodes the specified FieldOptions message. Does not implicitly {@link google.protobuf.FieldOptions.verify|verify} messages.
             * @function encode
             * @memberof google.protobuf.FieldOptions
             * @static
             * @param {google.protobuf.IFieldOptions} message FieldOptions message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            FieldOptions.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.ctype != null && Object.hasOwnProperty.call(message, "ctype"))
                    writer.uint32(/* id 1, wireType 0 =*/8).int32(message.ctype);
                if (message.packed != null && Object.hasOwnProperty.call(message, "packed"))
                    writer.uint32(/* id 2, wireType 0 =*/16).bool(message.packed);
                if (message.deprecated != null && Object.hasOwnProperty.call(message, "deprecated"))
                    writer.uint32(/* id 3, wireType 0 =*/24).bool(message.deprecated);
                if (message.lazy != null && Object.hasOwnProperty.call(message, "lazy"))
                    writer.uint32(/* id 5, wireType 0 =*/40).bool(message.lazy);
                if (message.jstype != null && Object.hasOwnProperty.call(message, "jstype"))
                    writer.uint32(/* id 6, wireType 0 =*/48).int32(message.jstype);
                if (message.weak != null && Object.hasOwnProperty.call(message, "weak"))
                    writer.uint32(/* id 10, wireType 0 =*/80).bool(message.weak);
                if (message.uninterpretedOption != null && message.uninterpretedOption.length)
                    for (var i = 0; i < message.uninterpretedOption.length; ++i)
                        $root.google.protobuf.UninterpretedOption.encode(message.uninterpretedOption[i], writer.uint32(/* id 999, wireType 2 =*/7994).fork()).ldelim();
                if (message[".typingApphostType"] != null && Object.hasOwnProperty.call(message, ".typingApphostType"))
                    writer.uint32(/* id 17959, wireType 2 =*/143674).string(message[".typingApphostType"]);
                return writer;
            };

            /**
             * Encodes the specified FieldOptions message, length delimited. Does not implicitly {@link google.protobuf.FieldOptions.verify|verify} messages.
             * @function encodeDelimited
             * @memberof google.protobuf.FieldOptions
             * @static
             * @param {google.protobuf.IFieldOptions} message FieldOptions message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            FieldOptions.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a FieldOptions message from the specified reader or buffer.
             * @function decode
             * @memberof google.protobuf.FieldOptions
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {google.protobuf.FieldOptions} FieldOptions
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            FieldOptions.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.FieldOptions();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.ctype = reader.int32();
                        break;
                    case 2:
                        message.packed = reader.bool();
                        break;
                    case 6:
                        message.jstype = reader.int32();
                        break;
                    case 5:
                        message.lazy = reader.bool();
                        break;
                    case 3:
                        message.deprecated = reader.bool();
                        break;
                    case 10:
                        message.weak = reader.bool();
                        break;
                    case 999:
                        if (!(message.uninterpretedOption && message.uninterpretedOption.length))
                            message.uninterpretedOption = [];
                        message.uninterpretedOption.push($root.google.protobuf.UninterpretedOption.decode(reader, reader.uint32()));
                        break;
                    case 17959:
                        message[".typingApphostType"] = reader.string();
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a FieldOptions message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof google.protobuf.FieldOptions
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {google.protobuf.FieldOptions} FieldOptions
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            FieldOptions.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a FieldOptions message.
             * @function verify
             * @memberof google.protobuf.FieldOptions
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            FieldOptions.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.ctype != null && message.hasOwnProperty("ctype"))
                    switch (message.ctype) {
                    default:
                        return "ctype: enum value expected";
                    case 0:
                    case 1:
                    case 2:
                        break;
                    }
                if (message.packed != null && message.hasOwnProperty("packed"))
                    if (typeof message.packed !== "boolean")
                        return "packed: boolean expected";
                if (message.jstype != null && message.hasOwnProperty("jstype"))
                    switch (message.jstype) {
                    default:
                        return "jstype: enum value expected";
                    case 0:
                    case 1:
                    case 2:
                        break;
                    }
                if (message.lazy != null && message.hasOwnProperty("lazy"))
                    if (typeof message.lazy !== "boolean")
                        return "lazy: boolean expected";
                if (message.deprecated != null && message.hasOwnProperty("deprecated"))
                    if (typeof message.deprecated !== "boolean")
                        return "deprecated: boolean expected";
                if (message.weak != null && message.hasOwnProperty("weak"))
                    if (typeof message.weak !== "boolean")
                        return "weak: boolean expected";
                if (message.uninterpretedOption != null && message.hasOwnProperty("uninterpretedOption")) {
                    if (!Array.isArray(message.uninterpretedOption))
                        return "uninterpretedOption: array expected";
                    for (var i = 0; i < message.uninterpretedOption.length; ++i) {
                        var error = $root.google.protobuf.UninterpretedOption.verify(message.uninterpretedOption[i]);
                        if (error)
                            return "uninterpretedOption." + error;
                    }
                }
                if (message[".typingApphostType"] != null && message.hasOwnProperty(".typingApphostType"))
                    if (!$util.isString(message[".typingApphostType"]))
                        return ".typingApphostType: string expected";
                return null;
            };

            /**
             * Creates a FieldOptions message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof google.protobuf.FieldOptions
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {google.protobuf.FieldOptions} FieldOptions
             */
            FieldOptions.fromObject = function fromObject(object) {
                if (object instanceof $root.google.protobuf.FieldOptions)
                    return object;
                var message = new $root.google.protobuf.FieldOptions();
                switch (object.ctype) {
                case "STRING":
                case 0:
                    message.ctype = 0;
                    break;
                case "CORD":
                case 1:
                    message.ctype = 1;
                    break;
                case "STRING_PIECE":
                case 2:
                    message.ctype = 2;
                    break;
                }
                if (object.packed != null)
                    message.packed = Boolean(object.packed);
                switch (object.jstype) {
                case "JS_NORMAL":
                case 0:
                    message.jstype = 0;
                    break;
                case "JS_STRING":
                case 1:
                    message.jstype = 1;
                    break;
                case "JS_NUMBER":
                case 2:
                    message.jstype = 2;
                    break;
                }
                if (object.lazy != null)
                    message.lazy = Boolean(object.lazy);
                if (object.deprecated != null)
                    message.deprecated = Boolean(object.deprecated);
                if (object.weak != null)
                    message.weak = Boolean(object.weak);
                if (object.uninterpretedOption) {
                    if (!Array.isArray(object.uninterpretedOption))
                        throw TypeError(".google.protobuf.FieldOptions.uninterpretedOption: array expected");
                    message.uninterpretedOption = [];
                    for (var i = 0; i < object.uninterpretedOption.length; ++i) {
                        if (typeof object.uninterpretedOption[i] !== "object")
                            throw TypeError(".google.protobuf.FieldOptions.uninterpretedOption: object expected");
                        message.uninterpretedOption[i] = $root.google.protobuf.UninterpretedOption.fromObject(object.uninterpretedOption[i]);
                    }
                }
                if (object[".typingApphostType"] != null)
                    message[".typingApphostType"] = String(object[".typingApphostType"]);
                return message;
            };

            /**
             * Creates a plain object from a FieldOptions message. Also converts values to other types if specified.
             * @function toObject
             * @memberof google.protobuf.FieldOptions
             * @static
             * @param {google.protobuf.FieldOptions} message FieldOptions
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            FieldOptions.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.arrays || options.defaults)
                    object.uninterpretedOption = [];
                if (options.defaults) {
                    object.ctype = options.enums === String ? "STRING" : 0;
                    object.packed = false;
                    object.deprecated = false;
                    object.lazy = false;
                    object.jstype = options.enums === String ? "JS_NORMAL" : 0;
                    object.weak = false;
                    object[".typingApphostType"] = "";
                }
                if (message.ctype != null && message.hasOwnProperty("ctype"))
                    object.ctype = options.enums === String ? $root.google.protobuf.FieldOptions.CType[message.ctype] : message.ctype;
                if (message.packed != null && message.hasOwnProperty("packed"))
                    object.packed = message.packed;
                if (message.deprecated != null && message.hasOwnProperty("deprecated"))
                    object.deprecated = message.deprecated;
                if (message.lazy != null && message.hasOwnProperty("lazy"))
                    object.lazy = message.lazy;
                if (message.jstype != null && message.hasOwnProperty("jstype"))
                    object.jstype = options.enums === String ? $root.google.protobuf.FieldOptions.JSType[message.jstype] : message.jstype;
                if (message.weak != null && message.hasOwnProperty("weak"))
                    object.weak = message.weak;
                if (message.uninterpretedOption && message.uninterpretedOption.length) {
                    object.uninterpretedOption = [];
                    for (var j = 0; j < message.uninterpretedOption.length; ++j)
                        object.uninterpretedOption[j] = $root.google.protobuf.UninterpretedOption.toObject(message.uninterpretedOption[j], options);
                }
                if (message[".typingApphostType"] != null && message.hasOwnProperty(".typingApphostType"))
                    object[".typingApphostType"] = message[".typingApphostType"];
                return object;
            };

            /**
             * Converts this FieldOptions to JSON.
             * @function toJSON
             * @memberof google.protobuf.FieldOptions
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            FieldOptions.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            /**
             * CType enum.
             * @name google.protobuf.FieldOptions.CType
             * @enum {number}
             * @property {number} STRING=0 STRING value
             * @property {number} CORD=1 CORD value
             * @property {number} STRING_PIECE=2 STRING_PIECE value
             */
            FieldOptions.CType = (function() {
                var valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "STRING"] = 0;
                values[valuesById[1] = "CORD"] = 1;
                values[valuesById[2] = "STRING_PIECE"] = 2;
                return values;
            })();

            /**
             * JSType enum.
             * @name google.protobuf.FieldOptions.JSType
             * @enum {number}
             * @property {number} JS_NORMAL=0 JS_NORMAL value
             * @property {number} JS_STRING=1 JS_STRING value
             * @property {number} JS_NUMBER=2 JS_NUMBER value
             */
            FieldOptions.JSType = (function() {
                var valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "JS_NORMAL"] = 0;
                values[valuesById[1] = "JS_STRING"] = 1;
                values[valuesById[2] = "JS_NUMBER"] = 2;
                return values;
            })();

            return FieldOptions;
        })();

        protobuf.OneofOptions = (function() {

            /**
             * Properties of an OneofOptions.
             * @memberof google.protobuf
             * @interface IOneofOptions
             * @property {Array.<google.protobuf.IUninterpretedOption>|null} [uninterpretedOption] OneofOptions uninterpretedOption
             */

            /**
             * Constructs a new OneofOptions.
             * @memberof google.protobuf
             * @classdesc Represents an OneofOptions.
             * @implements IOneofOptions
             * @constructor
             * @param {google.protobuf.IOneofOptions=} [properties] Properties to set
             */
            function OneofOptions(properties) {
                this.uninterpretedOption = [];
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * OneofOptions uninterpretedOption.
             * @member {Array.<google.protobuf.IUninterpretedOption>} uninterpretedOption
             * @memberof google.protobuf.OneofOptions
             * @instance
             */
            OneofOptions.prototype.uninterpretedOption = $util.emptyArray;

            /**
             * Creates a new OneofOptions instance using the specified properties.
             * @function create
             * @memberof google.protobuf.OneofOptions
             * @static
             * @param {google.protobuf.IOneofOptions=} [properties] Properties to set
             * @returns {google.protobuf.OneofOptions} OneofOptions instance
             */
            OneofOptions.create = function create(properties) {
                return new OneofOptions(properties);
            };

            /**
             * Encodes the specified OneofOptions message. Does not implicitly {@link google.protobuf.OneofOptions.verify|verify} messages.
             * @function encode
             * @memberof google.protobuf.OneofOptions
             * @static
             * @param {google.protobuf.IOneofOptions} message OneofOptions message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            OneofOptions.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.uninterpretedOption != null && message.uninterpretedOption.length)
                    for (var i = 0; i < message.uninterpretedOption.length; ++i)
                        $root.google.protobuf.UninterpretedOption.encode(message.uninterpretedOption[i], writer.uint32(/* id 999, wireType 2 =*/7994).fork()).ldelim();
                return writer;
            };

            /**
             * Encodes the specified OneofOptions message, length delimited. Does not implicitly {@link google.protobuf.OneofOptions.verify|verify} messages.
             * @function encodeDelimited
             * @memberof google.protobuf.OneofOptions
             * @static
             * @param {google.protobuf.IOneofOptions} message OneofOptions message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            OneofOptions.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes an OneofOptions message from the specified reader or buffer.
             * @function decode
             * @memberof google.protobuf.OneofOptions
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {google.protobuf.OneofOptions} OneofOptions
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            OneofOptions.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.OneofOptions();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 999:
                        if (!(message.uninterpretedOption && message.uninterpretedOption.length))
                            message.uninterpretedOption = [];
                        message.uninterpretedOption.push($root.google.protobuf.UninterpretedOption.decode(reader, reader.uint32()));
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes an OneofOptions message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof google.protobuf.OneofOptions
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {google.protobuf.OneofOptions} OneofOptions
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            OneofOptions.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies an OneofOptions message.
             * @function verify
             * @memberof google.protobuf.OneofOptions
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            OneofOptions.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.uninterpretedOption != null && message.hasOwnProperty("uninterpretedOption")) {
                    if (!Array.isArray(message.uninterpretedOption))
                        return "uninterpretedOption: array expected";
                    for (var i = 0; i < message.uninterpretedOption.length; ++i) {
                        var error = $root.google.protobuf.UninterpretedOption.verify(message.uninterpretedOption[i]);
                        if (error)
                            return "uninterpretedOption." + error;
                    }
                }
                return null;
            };

            /**
             * Creates an OneofOptions message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof google.protobuf.OneofOptions
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {google.protobuf.OneofOptions} OneofOptions
             */
            OneofOptions.fromObject = function fromObject(object) {
                if (object instanceof $root.google.protobuf.OneofOptions)
                    return object;
                var message = new $root.google.protobuf.OneofOptions();
                if (object.uninterpretedOption) {
                    if (!Array.isArray(object.uninterpretedOption))
                        throw TypeError(".google.protobuf.OneofOptions.uninterpretedOption: array expected");
                    message.uninterpretedOption = [];
                    for (var i = 0; i < object.uninterpretedOption.length; ++i) {
                        if (typeof object.uninterpretedOption[i] !== "object")
                            throw TypeError(".google.protobuf.OneofOptions.uninterpretedOption: object expected");
                        message.uninterpretedOption[i] = $root.google.protobuf.UninterpretedOption.fromObject(object.uninterpretedOption[i]);
                    }
                }
                return message;
            };

            /**
             * Creates a plain object from an OneofOptions message. Also converts values to other types if specified.
             * @function toObject
             * @memberof google.protobuf.OneofOptions
             * @static
             * @param {google.protobuf.OneofOptions} message OneofOptions
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            OneofOptions.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.arrays || options.defaults)
                    object.uninterpretedOption = [];
                if (message.uninterpretedOption && message.uninterpretedOption.length) {
                    object.uninterpretedOption = [];
                    for (var j = 0; j < message.uninterpretedOption.length; ++j)
                        object.uninterpretedOption[j] = $root.google.protobuf.UninterpretedOption.toObject(message.uninterpretedOption[j], options);
                }
                return object;
            };

            /**
             * Converts this OneofOptions to JSON.
             * @function toJSON
             * @memberof google.protobuf.OneofOptions
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            OneofOptions.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return OneofOptions;
        })();

        protobuf.EnumOptions = (function() {

            /**
             * Properties of an EnumOptions.
             * @memberof google.protobuf
             * @interface IEnumOptions
             * @property {boolean|null} [allowAlias] EnumOptions allowAlias
             * @property {boolean|null} [deprecated] EnumOptions deprecated
             * @property {Array.<google.protobuf.IUninterpretedOption>|null} [uninterpretedOption] EnumOptions uninterpretedOption
             */

            /**
             * Constructs a new EnumOptions.
             * @memberof google.protobuf
             * @classdesc Represents an EnumOptions.
             * @implements IEnumOptions
             * @constructor
             * @param {google.protobuf.IEnumOptions=} [properties] Properties to set
             */
            function EnumOptions(properties) {
                this.uninterpretedOption = [];
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * EnumOptions allowAlias.
             * @member {boolean} allowAlias
             * @memberof google.protobuf.EnumOptions
             * @instance
             */
            EnumOptions.prototype.allowAlias = false;

            /**
             * EnumOptions deprecated.
             * @member {boolean} deprecated
             * @memberof google.protobuf.EnumOptions
             * @instance
             */
            EnumOptions.prototype.deprecated = false;

            /**
             * EnumOptions uninterpretedOption.
             * @member {Array.<google.protobuf.IUninterpretedOption>} uninterpretedOption
             * @memberof google.protobuf.EnumOptions
             * @instance
             */
            EnumOptions.prototype.uninterpretedOption = $util.emptyArray;

            /**
             * Creates a new EnumOptions instance using the specified properties.
             * @function create
             * @memberof google.protobuf.EnumOptions
             * @static
             * @param {google.protobuf.IEnumOptions=} [properties] Properties to set
             * @returns {google.protobuf.EnumOptions} EnumOptions instance
             */
            EnumOptions.create = function create(properties) {
                return new EnumOptions(properties);
            };

            /**
             * Encodes the specified EnumOptions message. Does not implicitly {@link google.protobuf.EnumOptions.verify|verify} messages.
             * @function encode
             * @memberof google.protobuf.EnumOptions
             * @static
             * @param {google.protobuf.IEnumOptions} message EnumOptions message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            EnumOptions.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.allowAlias != null && Object.hasOwnProperty.call(message, "allowAlias"))
                    writer.uint32(/* id 2, wireType 0 =*/16).bool(message.allowAlias);
                if (message.deprecated != null && Object.hasOwnProperty.call(message, "deprecated"))
                    writer.uint32(/* id 3, wireType 0 =*/24).bool(message.deprecated);
                if (message.uninterpretedOption != null && message.uninterpretedOption.length)
                    for (var i = 0; i < message.uninterpretedOption.length; ++i)
                        $root.google.protobuf.UninterpretedOption.encode(message.uninterpretedOption[i], writer.uint32(/* id 999, wireType 2 =*/7994).fork()).ldelim();
                return writer;
            };

            /**
             * Encodes the specified EnumOptions message, length delimited. Does not implicitly {@link google.protobuf.EnumOptions.verify|verify} messages.
             * @function encodeDelimited
             * @memberof google.protobuf.EnumOptions
             * @static
             * @param {google.protobuf.IEnumOptions} message EnumOptions message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            EnumOptions.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes an EnumOptions message from the specified reader or buffer.
             * @function decode
             * @memberof google.protobuf.EnumOptions
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {google.protobuf.EnumOptions} EnumOptions
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            EnumOptions.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.EnumOptions();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 2:
                        message.allowAlias = reader.bool();
                        break;
                    case 3:
                        message.deprecated = reader.bool();
                        break;
                    case 999:
                        if (!(message.uninterpretedOption && message.uninterpretedOption.length))
                            message.uninterpretedOption = [];
                        message.uninterpretedOption.push($root.google.protobuf.UninterpretedOption.decode(reader, reader.uint32()));
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes an EnumOptions message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof google.protobuf.EnumOptions
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {google.protobuf.EnumOptions} EnumOptions
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            EnumOptions.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies an EnumOptions message.
             * @function verify
             * @memberof google.protobuf.EnumOptions
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            EnumOptions.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.allowAlias != null && message.hasOwnProperty("allowAlias"))
                    if (typeof message.allowAlias !== "boolean")
                        return "allowAlias: boolean expected";
                if (message.deprecated != null && message.hasOwnProperty("deprecated"))
                    if (typeof message.deprecated !== "boolean")
                        return "deprecated: boolean expected";
                if (message.uninterpretedOption != null && message.hasOwnProperty("uninterpretedOption")) {
                    if (!Array.isArray(message.uninterpretedOption))
                        return "uninterpretedOption: array expected";
                    for (var i = 0; i < message.uninterpretedOption.length; ++i) {
                        var error = $root.google.protobuf.UninterpretedOption.verify(message.uninterpretedOption[i]);
                        if (error)
                            return "uninterpretedOption." + error;
                    }
                }
                return null;
            };

            /**
             * Creates an EnumOptions message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof google.protobuf.EnumOptions
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {google.protobuf.EnumOptions} EnumOptions
             */
            EnumOptions.fromObject = function fromObject(object) {
                if (object instanceof $root.google.protobuf.EnumOptions)
                    return object;
                var message = new $root.google.protobuf.EnumOptions();
                if (object.allowAlias != null)
                    message.allowAlias = Boolean(object.allowAlias);
                if (object.deprecated != null)
                    message.deprecated = Boolean(object.deprecated);
                if (object.uninterpretedOption) {
                    if (!Array.isArray(object.uninterpretedOption))
                        throw TypeError(".google.protobuf.EnumOptions.uninterpretedOption: array expected");
                    message.uninterpretedOption = [];
                    for (var i = 0; i < object.uninterpretedOption.length; ++i) {
                        if (typeof object.uninterpretedOption[i] !== "object")
                            throw TypeError(".google.protobuf.EnumOptions.uninterpretedOption: object expected");
                        message.uninterpretedOption[i] = $root.google.protobuf.UninterpretedOption.fromObject(object.uninterpretedOption[i]);
                    }
                }
                return message;
            };

            /**
             * Creates a plain object from an EnumOptions message. Also converts values to other types if specified.
             * @function toObject
             * @memberof google.protobuf.EnumOptions
             * @static
             * @param {google.protobuf.EnumOptions} message EnumOptions
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            EnumOptions.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.arrays || options.defaults)
                    object.uninterpretedOption = [];
                if (options.defaults) {
                    object.allowAlias = false;
                    object.deprecated = false;
                }
                if (message.allowAlias != null && message.hasOwnProperty("allowAlias"))
                    object.allowAlias = message.allowAlias;
                if (message.deprecated != null && message.hasOwnProperty("deprecated"))
                    object.deprecated = message.deprecated;
                if (message.uninterpretedOption && message.uninterpretedOption.length) {
                    object.uninterpretedOption = [];
                    for (var j = 0; j < message.uninterpretedOption.length; ++j)
                        object.uninterpretedOption[j] = $root.google.protobuf.UninterpretedOption.toObject(message.uninterpretedOption[j], options);
                }
                return object;
            };

            /**
             * Converts this EnumOptions to JSON.
             * @function toJSON
             * @memberof google.protobuf.EnumOptions
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            EnumOptions.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return EnumOptions;
        })();

        protobuf.EnumValueOptions = (function() {

            /**
             * Properties of an EnumValueOptions.
             * @memberof google.protobuf
             * @interface IEnumValueOptions
             * @property {boolean|null} [deprecated] EnumValueOptions deprecated
             * @property {Array.<google.protobuf.IUninterpretedOption>|null} [uninterpretedOption] EnumValueOptions uninterpretedOption
             */

            /**
             * Constructs a new EnumValueOptions.
             * @memberof google.protobuf
             * @classdesc Represents an EnumValueOptions.
             * @implements IEnumValueOptions
             * @constructor
             * @param {google.protobuf.IEnumValueOptions=} [properties] Properties to set
             */
            function EnumValueOptions(properties) {
                this.uninterpretedOption = [];
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * EnumValueOptions deprecated.
             * @member {boolean} deprecated
             * @memberof google.protobuf.EnumValueOptions
             * @instance
             */
            EnumValueOptions.prototype.deprecated = false;

            /**
             * EnumValueOptions uninterpretedOption.
             * @member {Array.<google.protobuf.IUninterpretedOption>} uninterpretedOption
             * @memberof google.protobuf.EnumValueOptions
             * @instance
             */
            EnumValueOptions.prototype.uninterpretedOption = $util.emptyArray;

            /**
             * Creates a new EnumValueOptions instance using the specified properties.
             * @function create
             * @memberof google.protobuf.EnumValueOptions
             * @static
             * @param {google.protobuf.IEnumValueOptions=} [properties] Properties to set
             * @returns {google.protobuf.EnumValueOptions} EnumValueOptions instance
             */
            EnumValueOptions.create = function create(properties) {
                return new EnumValueOptions(properties);
            };

            /**
             * Encodes the specified EnumValueOptions message. Does not implicitly {@link google.protobuf.EnumValueOptions.verify|verify} messages.
             * @function encode
             * @memberof google.protobuf.EnumValueOptions
             * @static
             * @param {google.protobuf.IEnumValueOptions} message EnumValueOptions message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            EnumValueOptions.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.deprecated != null && Object.hasOwnProperty.call(message, "deprecated"))
                    writer.uint32(/* id 1, wireType 0 =*/8).bool(message.deprecated);
                if (message.uninterpretedOption != null && message.uninterpretedOption.length)
                    for (var i = 0; i < message.uninterpretedOption.length; ++i)
                        $root.google.protobuf.UninterpretedOption.encode(message.uninterpretedOption[i], writer.uint32(/* id 999, wireType 2 =*/7994).fork()).ldelim();
                return writer;
            };

            /**
             * Encodes the specified EnumValueOptions message, length delimited. Does not implicitly {@link google.protobuf.EnumValueOptions.verify|verify} messages.
             * @function encodeDelimited
             * @memberof google.protobuf.EnumValueOptions
             * @static
             * @param {google.protobuf.IEnumValueOptions} message EnumValueOptions message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            EnumValueOptions.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes an EnumValueOptions message from the specified reader or buffer.
             * @function decode
             * @memberof google.protobuf.EnumValueOptions
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {google.protobuf.EnumValueOptions} EnumValueOptions
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            EnumValueOptions.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.EnumValueOptions();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.deprecated = reader.bool();
                        break;
                    case 999:
                        if (!(message.uninterpretedOption && message.uninterpretedOption.length))
                            message.uninterpretedOption = [];
                        message.uninterpretedOption.push($root.google.protobuf.UninterpretedOption.decode(reader, reader.uint32()));
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes an EnumValueOptions message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof google.protobuf.EnumValueOptions
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {google.protobuf.EnumValueOptions} EnumValueOptions
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            EnumValueOptions.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies an EnumValueOptions message.
             * @function verify
             * @memberof google.protobuf.EnumValueOptions
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            EnumValueOptions.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.deprecated != null && message.hasOwnProperty("deprecated"))
                    if (typeof message.deprecated !== "boolean")
                        return "deprecated: boolean expected";
                if (message.uninterpretedOption != null && message.hasOwnProperty("uninterpretedOption")) {
                    if (!Array.isArray(message.uninterpretedOption))
                        return "uninterpretedOption: array expected";
                    for (var i = 0; i < message.uninterpretedOption.length; ++i) {
                        var error = $root.google.protobuf.UninterpretedOption.verify(message.uninterpretedOption[i]);
                        if (error)
                            return "uninterpretedOption." + error;
                    }
                }
                return null;
            };

            /**
             * Creates an EnumValueOptions message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof google.protobuf.EnumValueOptions
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {google.protobuf.EnumValueOptions} EnumValueOptions
             */
            EnumValueOptions.fromObject = function fromObject(object) {
                if (object instanceof $root.google.protobuf.EnumValueOptions)
                    return object;
                var message = new $root.google.protobuf.EnumValueOptions();
                if (object.deprecated != null)
                    message.deprecated = Boolean(object.deprecated);
                if (object.uninterpretedOption) {
                    if (!Array.isArray(object.uninterpretedOption))
                        throw TypeError(".google.protobuf.EnumValueOptions.uninterpretedOption: array expected");
                    message.uninterpretedOption = [];
                    for (var i = 0; i < object.uninterpretedOption.length; ++i) {
                        if (typeof object.uninterpretedOption[i] !== "object")
                            throw TypeError(".google.protobuf.EnumValueOptions.uninterpretedOption: object expected");
                        message.uninterpretedOption[i] = $root.google.protobuf.UninterpretedOption.fromObject(object.uninterpretedOption[i]);
                    }
                }
                return message;
            };

            /**
             * Creates a plain object from an EnumValueOptions message. Also converts values to other types if specified.
             * @function toObject
             * @memberof google.protobuf.EnumValueOptions
             * @static
             * @param {google.protobuf.EnumValueOptions} message EnumValueOptions
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            EnumValueOptions.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.arrays || options.defaults)
                    object.uninterpretedOption = [];
                if (options.defaults)
                    object.deprecated = false;
                if (message.deprecated != null && message.hasOwnProperty("deprecated"))
                    object.deprecated = message.deprecated;
                if (message.uninterpretedOption && message.uninterpretedOption.length) {
                    object.uninterpretedOption = [];
                    for (var j = 0; j < message.uninterpretedOption.length; ++j)
                        object.uninterpretedOption[j] = $root.google.protobuf.UninterpretedOption.toObject(message.uninterpretedOption[j], options);
                }
                return object;
            };

            /**
             * Converts this EnumValueOptions to JSON.
             * @function toJSON
             * @memberof google.protobuf.EnumValueOptions
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            EnumValueOptions.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return EnumValueOptions;
        })();

        protobuf.ServiceOptions = (function() {

            /**
             * Properties of a ServiceOptions.
             * @memberof google.protobuf
             * @interface IServiceOptions
             * @property {boolean|null} [deprecated] ServiceOptions deprecated
             * @property {Array.<google.protobuf.IUninterpretedOption>|null} [uninterpretedOption] ServiceOptions uninterpretedOption
             */

            /**
             * Constructs a new ServiceOptions.
             * @memberof google.protobuf
             * @classdesc Represents a ServiceOptions.
             * @implements IServiceOptions
             * @constructor
             * @param {google.protobuf.IServiceOptions=} [properties] Properties to set
             */
            function ServiceOptions(properties) {
                this.uninterpretedOption = [];
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * ServiceOptions deprecated.
             * @member {boolean} deprecated
             * @memberof google.protobuf.ServiceOptions
             * @instance
             */
            ServiceOptions.prototype.deprecated = false;

            /**
             * ServiceOptions uninterpretedOption.
             * @member {Array.<google.protobuf.IUninterpretedOption>} uninterpretedOption
             * @memberof google.protobuf.ServiceOptions
             * @instance
             */
            ServiceOptions.prototype.uninterpretedOption = $util.emptyArray;

            /**
             * Creates a new ServiceOptions instance using the specified properties.
             * @function create
             * @memberof google.protobuf.ServiceOptions
             * @static
             * @param {google.protobuf.IServiceOptions=} [properties] Properties to set
             * @returns {google.protobuf.ServiceOptions} ServiceOptions instance
             */
            ServiceOptions.create = function create(properties) {
                return new ServiceOptions(properties);
            };

            /**
             * Encodes the specified ServiceOptions message. Does not implicitly {@link google.protobuf.ServiceOptions.verify|verify} messages.
             * @function encode
             * @memberof google.protobuf.ServiceOptions
             * @static
             * @param {google.protobuf.IServiceOptions} message ServiceOptions message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            ServiceOptions.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.deprecated != null && Object.hasOwnProperty.call(message, "deprecated"))
                    writer.uint32(/* id 33, wireType 0 =*/264).bool(message.deprecated);
                if (message.uninterpretedOption != null && message.uninterpretedOption.length)
                    for (var i = 0; i < message.uninterpretedOption.length; ++i)
                        $root.google.protobuf.UninterpretedOption.encode(message.uninterpretedOption[i], writer.uint32(/* id 999, wireType 2 =*/7994).fork()).ldelim();
                return writer;
            };

            /**
             * Encodes the specified ServiceOptions message, length delimited. Does not implicitly {@link google.protobuf.ServiceOptions.verify|verify} messages.
             * @function encodeDelimited
             * @memberof google.protobuf.ServiceOptions
             * @static
             * @param {google.protobuf.IServiceOptions} message ServiceOptions message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            ServiceOptions.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a ServiceOptions message from the specified reader or buffer.
             * @function decode
             * @memberof google.protobuf.ServiceOptions
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {google.protobuf.ServiceOptions} ServiceOptions
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            ServiceOptions.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.ServiceOptions();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 33:
                        message.deprecated = reader.bool();
                        break;
                    case 999:
                        if (!(message.uninterpretedOption && message.uninterpretedOption.length))
                            message.uninterpretedOption = [];
                        message.uninterpretedOption.push($root.google.protobuf.UninterpretedOption.decode(reader, reader.uint32()));
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a ServiceOptions message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof google.protobuf.ServiceOptions
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {google.protobuf.ServiceOptions} ServiceOptions
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            ServiceOptions.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a ServiceOptions message.
             * @function verify
             * @memberof google.protobuf.ServiceOptions
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            ServiceOptions.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.deprecated != null && message.hasOwnProperty("deprecated"))
                    if (typeof message.deprecated !== "boolean")
                        return "deprecated: boolean expected";
                if (message.uninterpretedOption != null && message.hasOwnProperty("uninterpretedOption")) {
                    if (!Array.isArray(message.uninterpretedOption))
                        return "uninterpretedOption: array expected";
                    for (var i = 0; i < message.uninterpretedOption.length; ++i) {
                        var error = $root.google.protobuf.UninterpretedOption.verify(message.uninterpretedOption[i]);
                        if (error)
                            return "uninterpretedOption." + error;
                    }
                }
                return null;
            };

            /**
             * Creates a ServiceOptions message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof google.protobuf.ServiceOptions
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {google.protobuf.ServiceOptions} ServiceOptions
             */
            ServiceOptions.fromObject = function fromObject(object) {
                if (object instanceof $root.google.protobuf.ServiceOptions)
                    return object;
                var message = new $root.google.protobuf.ServiceOptions();
                if (object.deprecated != null)
                    message.deprecated = Boolean(object.deprecated);
                if (object.uninterpretedOption) {
                    if (!Array.isArray(object.uninterpretedOption))
                        throw TypeError(".google.protobuf.ServiceOptions.uninterpretedOption: array expected");
                    message.uninterpretedOption = [];
                    for (var i = 0; i < object.uninterpretedOption.length; ++i) {
                        if (typeof object.uninterpretedOption[i] !== "object")
                            throw TypeError(".google.protobuf.ServiceOptions.uninterpretedOption: object expected");
                        message.uninterpretedOption[i] = $root.google.protobuf.UninterpretedOption.fromObject(object.uninterpretedOption[i]);
                    }
                }
                return message;
            };

            /**
             * Creates a plain object from a ServiceOptions message. Also converts values to other types if specified.
             * @function toObject
             * @memberof google.protobuf.ServiceOptions
             * @static
             * @param {google.protobuf.ServiceOptions} message ServiceOptions
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            ServiceOptions.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.arrays || options.defaults)
                    object.uninterpretedOption = [];
                if (options.defaults)
                    object.deprecated = false;
                if (message.deprecated != null && message.hasOwnProperty("deprecated"))
                    object.deprecated = message.deprecated;
                if (message.uninterpretedOption && message.uninterpretedOption.length) {
                    object.uninterpretedOption = [];
                    for (var j = 0; j < message.uninterpretedOption.length; ++j)
                        object.uninterpretedOption[j] = $root.google.protobuf.UninterpretedOption.toObject(message.uninterpretedOption[j], options);
                }
                return object;
            };

            /**
             * Converts this ServiceOptions to JSON.
             * @function toJSON
             * @memberof google.protobuf.ServiceOptions
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            ServiceOptions.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return ServiceOptions;
        })();

        protobuf.MethodOptions = (function() {

            /**
             * Properties of a MethodOptions.
             * @memberof google.protobuf
             * @interface IMethodOptions
             * @property {boolean|null} [deprecated] MethodOptions deprecated
             * @property {Array.<google.protobuf.IUninterpretedOption>|null} [uninterpretedOption] MethodOptions uninterpretedOption
             * @property {string|null} [".path"] MethodOptions .path
             */

            /**
             * Constructs a new MethodOptions.
             * @memberof google.protobuf
             * @classdesc Represents a MethodOptions.
             * @implements IMethodOptions
             * @constructor
             * @param {google.protobuf.IMethodOptions=} [properties] Properties to set
             */
            function MethodOptions(properties) {
                this.uninterpretedOption = [];
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * MethodOptions deprecated.
             * @member {boolean} deprecated
             * @memberof google.protobuf.MethodOptions
             * @instance
             */
            MethodOptions.prototype.deprecated = false;

            /**
             * MethodOptions uninterpretedOption.
             * @member {Array.<google.protobuf.IUninterpretedOption>} uninterpretedOption
             * @memberof google.protobuf.MethodOptions
             * @instance
             */
            MethodOptions.prototype.uninterpretedOption = $util.emptyArray;

            /**
             * MethodOptions .path.
             * @member {string} .path
             * @memberof google.protobuf.MethodOptions
             * @instance
             */
            MethodOptions.prototype[".path"] = "";

            /**
             * Creates a new MethodOptions instance using the specified properties.
             * @function create
             * @memberof google.protobuf.MethodOptions
             * @static
             * @param {google.protobuf.IMethodOptions=} [properties] Properties to set
             * @returns {google.protobuf.MethodOptions} MethodOptions instance
             */
            MethodOptions.create = function create(properties) {
                return new MethodOptions(properties);
            };

            /**
             * Encodes the specified MethodOptions message. Does not implicitly {@link google.protobuf.MethodOptions.verify|verify} messages.
             * @function encode
             * @memberof google.protobuf.MethodOptions
             * @static
             * @param {google.protobuf.IMethodOptions} message MethodOptions message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            MethodOptions.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.deprecated != null && Object.hasOwnProperty.call(message, "deprecated"))
                    writer.uint32(/* id 33, wireType 0 =*/264).bool(message.deprecated);
                if (message.uninterpretedOption != null && message.uninterpretedOption.length)
                    for (var i = 0; i < message.uninterpretedOption.length; ++i)
                        $root.google.protobuf.UninterpretedOption.encode(message.uninterpretedOption[i], writer.uint32(/* id 999, wireType 2 =*/7994).fork()).ldelim();
                if (message[".path"] != null && Object.hasOwnProperty.call(message, ".path"))
                    writer.uint32(/* id 17960, wireType 2 =*/143682).string(message[".path"]);
                return writer;
            };

            /**
             * Encodes the specified MethodOptions message, length delimited. Does not implicitly {@link google.protobuf.MethodOptions.verify|verify} messages.
             * @function encodeDelimited
             * @memberof google.protobuf.MethodOptions
             * @static
             * @param {google.protobuf.IMethodOptions} message MethodOptions message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            MethodOptions.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a MethodOptions message from the specified reader or buffer.
             * @function decode
             * @memberof google.protobuf.MethodOptions
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {google.protobuf.MethodOptions} MethodOptions
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            MethodOptions.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.MethodOptions();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 33:
                        message.deprecated = reader.bool();
                        break;
                    case 999:
                        if (!(message.uninterpretedOption && message.uninterpretedOption.length))
                            message.uninterpretedOption = [];
                        message.uninterpretedOption.push($root.google.protobuf.UninterpretedOption.decode(reader, reader.uint32()));
                        break;
                    case 17960:
                        message[".path"] = reader.string();
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a MethodOptions message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof google.protobuf.MethodOptions
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {google.protobuf.MethodOptions} MethodOptions
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            MethodOptions.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a MethodOptions message.
             * @function verify
             * @memberof google.protobuf.MethodOptions
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            MethodOptions.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.deprecated != null && message.hasOwnProperty("deprecated"))
                    if (typeof message.deprecated !== "boolean")
                        return "deprecated: boolean expected";
                if (message.uninterpretedOption != null && message.hasOwnProperty("uninterpretedOption")) {
                    if (!Array.isArray(message.uninterpretedOption))
                        return "uninterpretedOption: array expected";
                    for (var i = 0; i < message.uninterpretedOption.length; ++i) {
                        var error = $root.google.protobuf.UninterpretedOption.verify(message.uninterpretedOption[i]);
                        if (error)
                            return "uninterpretedOption." + error;
                    }
                }
                if (message[".path"] != null && message.hasOwnProperty(".path"))
                    if (!$util.isString(message[".path"]))
                        return ".path: string expected";
                return null;
            };

            /**
             * Creates a MethodOptions message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof google.protobuf.MethodOptions
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {google.protobuf.MethodOptions} MethodOptions
             */
            MethodOptions.fromObject = function fromObject(object) {
                if (object instanceof $root.google.protobuf.MethodOptions)
                    return object;
                var message = new $root.google.protobuf.MethodOptions();
                if (object.deprecated != null)
                    message.deprecated = Boolean(object.deprecated);
                if (object.uninterpretedOption) {
                    if (!Array.isArray(object.uninterpretedOption))
                        throw TypeError(".google.protobuf.MethodOptions.uninterpretedOption: array expected");
                    message.uninterpretedOption = [];
                    for (var i = 0; i < object.uninterpretedOption.length; ++i) {
                        if (typeof object.uninterpretedOption[i] !== "object")
                            throw TypeError(".google.protobuf.MethodOptions.uninterpretedOption: object expected");
                        message.uninterpretedOption[i] = $root.google.protobuf.UninterpretedOption.fromObject(object.uninterpretedOption[i]);
                    }
                }
                if (object[".path"] != null)
                    message[".path"] = String(object[".path"]);
                return message;
            };

            /**
             * Creates a plain object from a MethodOptions message. Also converts values to other types if specified.
             * @function toObject
             * @memberof google.protobuf.MethodOptions
             * @static
             * @param {google.protobuf.MethodOptions} message MethodOptions
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            MethodOptions.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.arrays || options.defaults)
                    object.uninterpretedOption = [];
                if (options.defaults) {
                    object.deprecated = false;
                    object[".path"] = "";
                }
                if (message.deprecated != null && message.hasOwnProperty("deprecated"))
                    object.deprecated = message.deprecated;
                if (message.uninterpretedOption && message.uninterpretedOption.length) {
                    object.uninterpretedOption = [];
                    for (var j = 0; j < message.uninterpretedOption.length; ++j)
                        object.uninterpretedOption[j] = $root.google.protobuf.UninterpretedOption.toObject(message.uninterpretedOption[j], options);
                }
                if (message[".path"] != null && message.hasOwnProperty(".path"))
                    object[".path"] = message[".path"];
                return object;
            };

            /**
             * Converts this MethodOptions to JSON.
             * @function toJSON
             * @memberof google.protobuf.MethodOptions
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            MethodOptions.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return MethodOptions;
        })();

        protobuf.UninterpretedOption = (function() {

            /**
             * Properties of an UninterpretedOption.
             * @memberof google.protobuf
             * @interface IUninterpretedOption
             * @property {Array.<google.protobuf.UninterpretedOption.INamePart>|null} [name] UninterpretedOption name
             * @property {string|null} [identifierValue] UninterpretedOption identifierValue
             * @property {number|null} [positiveIntValue] UninterpretedOption positiveIntValue
             * @property {number|null} [negativeIntValue] UninterpretedOption negativeIntValue
             * @property {number|null} [doubleValue] UninterpretedOption doubleValue
             * @property {Uint8Array|null} [stringValue] UninterpretedOption stringValue
             * @property {string|null} [aggregateValue] UninterpretedOption aggregateValue
             */

            /**
             * Constructs a new UninterpretedOption.
             * @memberof google.protobuf
             * @classdesc Represents an UninterpretedOption.
             * @implements IUninterpretedOption
             * @constructor
             * @param {google.protobuf.IUninterpretedOption=} [properties] Properties to set
             */
            function UninterpretedOption(properties) {
                this.name = [];
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * UninterpretedOption name.
             * @member {Array.<google.protobuf.UninterpretedOption.INamePart>} name
             * @memberof google.protobuf.UninterpretedOption
             * @instance
             */
            UninterpretedOption.prototype.name = $util.emptyArray;

            /**
             * UninterpretedOption identifierValue.
             * @member {string} identifierValue
             * @memberof google.protobuf.UninterpretedOption
             * @instance
             */
            UninterpretedOption.prototype.identifierValue = "";

            /**
             * UninterpretedOption positiveIntValue.
             * @member {number} positiveIntValue
             * @memberof google.protobuf.UninterpretedOption
             * @instance
             */
            UninterpretedOption.prototype.positiveIntValue = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

            /**
             * UninterpretedOption negativeIntValue.
             * @member {number} negativeIntValue
             * @memberof google.protobuf.UninterpretedOption
             * @instance
             */
            UninterpretedOption.prototype.negativeIntValue = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

            /**
             * UninterpretedOption doubleValue.
             * @member {number} doubleValue
             * @memberof google.protobuf.UninterpretedOption
             * @instance
             */
            UninterpretedOption.prototype.doubleValue = 0;

            /**
             * UninterpretedOption stringValue.
             * @member {Uint8Array} stringValue
             * @memberof google.protobuf.UninterpretedOption
             * @instance
             */
            UninterpretedOption.prototype.stringValue = $util.newBuffer([]);

            /**
             * UninterpretedOption aggregateValue.
             * @member {string} aggregateValue
             * @memberof google.protobuf.UninterpretedOption
             * @instance
             */
            UninterpretedOption.prototype.aggregateValue = "";

            /**
             * Creates a new UninterpretedOption instance using the specified properties.
             * @function create
             * @memberof google.protobuf.UninterpretedOption
             * @static
             * @param {google.protobuf.IUninterpretedOption=} [properties] Properties to set
             * @returns {google.protobuf.UninterpretedOption} UninterpretedOption instance
             */
            UninterpretedOption.create = function create(properties) {
                return new UninterpretedOption(properties);
            };

            /**
             * Encodes the specified UninterpretedOption message. Does not implicitly {@link google.protobuf.UninterpretedOption.verify|verify} messages.
             * @function encode
             * @memberof google.protobuf.UninterpretedOption
             * @static
             * @param {google.protobuf.IUninterpretedOption} message UninterpretedOption message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            UninterpretedOption.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.name != null && message.name.length)
                    for (var i = 0; i < message.name.length; ++i)
                        $root.google.protobuf.UninterpretedOption.NamePart.encode(message.name[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                if (message.identifierValue != null && Object.hasOwnProperty.call(message, "identifierValue"))
                    writer.uint32(/* id 3, wireType 2 =*/26).string(message.identifierValue);
                if (message.positiveIntValue != null && Object.hasOwnProperty.call(message, "positiveIntValue"))
                    writer.uint32(/* id 4, wireType 0 =*/32).uint64(message.positiveIntValue);
                if (message.negativeIntValue != null && Object.hasOwnProperty.call(message, "negativeIntValue"))
                    writer.uint32(/* id 5, wireType 0 =*/40).int64(message.negativeIntValue);
                if (message.doubleValue != null && Object.hasOwnProperty.call(message, "doubleValue"))
                    writer.uint32(/* id 6, wireType 1 =*/49).double(message.doubleValue);
                if (message.stringValue != null && Object.hasOwnProperty.call(message, "stringValue"))
                    writer.uint32(/* id 7, wireType 2 =*/58).bytes(message.stringValue);
                if (message.aggregateValue != null && Object.hasOwnProperty.call(message, "aggregateValue"))
                    writer.uint32(/* id 8, wireType 2 =*/66).string(message.aggregateValue);
                return writer;
            };

            /**
             * Encodes the specified UninterpretedOption message, length delimited. Does not implicitly {@link google.protobuf.UninterpretedOption.verify|verify} messages.
             * @function encodeDelimited
             * @memberof google.protobuf.UninterpretedOption
             * @static
             * @param {google.protobuf.IUninterpretedOption} message UninterpretedOption message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            UninterpretedOption.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes an UninterpretedOption message from the specified reader or buffer.
             * @function decode
             * @memberof google.protobuf.UninterpretedOption
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {google.protobuf.UninterpretedOption} UninterpretedOption
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            UninterpretedOption.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.UninterpretedOption();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 2:
                        if (!(message.name && message.name.length))
                            message.name = [];
                        message.name.push($root.google.protobuf.UninterpretedOption.NamePart.decode(reader, reader.uint32()));
                        break;
                    case 3:
                        message.identifierValue = reader.string();
                        break;
                    case 4:
                        message.positiveIntValue = reader.uint64();
                        break;
                    case 5:
                        message.negativeIntValue = reader.int64();
                        break;
                    case 6:
                        message.doubleValue = reader.double();
                        break;
                    case 7:
                        message.stringValue = reader.bytes();
                        break;
                    case 8:
                        message.aggregateValue = reader.string();
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes an UninterpretedOption message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof google.protobuf.UninterpretedOption
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {google.protobuf.UninterpretedOption} UninterpretedOption
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            UninterpretedOption.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies an UninterpretedOption message.
             * @function verify
             * @memberof google.protobuf.UninterpretedOption
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            UninterpretedOption.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.name != null && message.hasOwnProperty("name")) {
                    if (!Array.isArray(message.name))
                        return "name: array expected";
                    for (var i = 0; i < message.name.length; ++i) {
                        var error = $root.google.protobuf.UninterpretedOption.NamePart.verify(message.name[i]);
                        if (error)
                            return "name." + error;
                    }
                }
                if (message.identifierValue != null && message.hasOwnProperty("identifierValue"))
                    if (!$util.isString(message.identifierValue))
                        return "identifierValue: string expected";
                if (message.positiveIntValue != null && message.hasOwnProperty("positiveIntValue"))
                    if (!$util.isInteger(message.positiveIntValue) && !(message.positiveIntValue && $util.isInteger(message.positiveIntValue.low) && $util.isInteger(message.positiveIntValue.high)))
                        return "positiveIntValue: integer|Long expected";
                if (message.negativeIntValue != null && message.hasOwnProperty("negativeIntValue"))
                    if (!$util.isInteger(message.negativeIntValue) && !(message.negativeIntValue && $util.isInteger(message.negativeIntValue.low) && $util.isInteger(message.negativeIntValue.high)))
                        return "negativeIntValue: integer|Long expected";
                if (message.doubleValue != null && message.hasOwnProperty("doubleValue"))
                    if (typeof message.doubleValue !== "number")
                        return "doubleValue: number expected";
                if (message.stringValue != null && message.hasOwnProperty("stringValue"))
                    if (!(message.stringValue && typeof message.stringValue.length === "number" || $util.isString(message.stringValue)))
                        return "stringValue: buffer expected";
                if (message.aggregateValue != null && message.hasOwnProperty("aggregateValue"))
                    if (!$util.isString(message.aggregateValue))
                        return "aggregateValue: string expected";
                return null;
            };

            /**
             * Creates an UninterpretedOption message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof google.protobuf.UninterpretedOption
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {google.protobuf.UninterpretedOption} UninterpretedOption
             */
            UninterpretedOption.fromObject = function fromObject(object) {
                if (object instanceof $root.google.protobuf.UninterpretedOption)
                    return object;
                var message = new $root.google.protobuf.UninterpretedOption();
                if (object.name) {
                    if (!Array.isArray(object.name))
                        throw TypeError(".google.protobuf.UninterpretedOption.name: array expected");
                    message.name = [];
                    for (var i = 0; i < object.name.length; ++i) {
                        if (typeof object.name[i] !== "object")
                            throw TypeError(".google.protobuf.UninterpretedOption.name: object expected");
                        message.name[i] = $root.google.protobuf.UninterpretedOption.NamePart.fromObject(object.name[i]);
                    }
                }
                if (object.identifierValue != null)
                    message.identifierValue = String(object.identifierValue);
                if (object.positiveIntValue != null)
                    if ($util.Long)
                        (message.positiveIntValue = $util.Long.fromValue(object.positiveIntValue)).unsigned = true;
                    else if (typeof object.positiveIntValue === "string")
                        message.positiveIntValue = parseInt(object.positiveIntValue, 10);
                    else if (typeof object.positiveIntValue === "number")
                        message.positiveIntValue = object.positiveIntValue;
                    else if (typeof object.positiveIntValue === "object")
                        message.positiveIntValue = new $util.LongBits(object.positiveIntValue.low >>> 0, object.positiveIntValue.high >>> 0).toNumber(true);
                if (object.negativeIntValue != null)
                    if ($util.Long)
                        (message.negativeIntValue = $util.Long.fromValue(object.negativeIntValue)).unsigned = false;
                    else if (typeof object.negativeIntValue === "string")
                        message.negativeIntValue = parseInt(object.negativeIntValue, 10);
                    else if (typeof object.negativeIntValue === "number")
                        message.negativeIntValue = object.negativeIntValue;
                    else if (typeof object.negativeIntValue === "object")
                        message.negativeIntValue = new $util.LongBits(object.negativeIntValue.low >>> 0, object.negativeIntValue.high >>> 0).toNumber();
                if (object.doubleValue != null)
                    message.doubleValue = Number(object.doubleValue);
                if (object.stringValue != null)
                    if (typeof object.stringValue === "string")
                        $util.base64.decode(object.stringValue, message.stringValue = $util.newBuffer($util.base64.length(object.stringValue)), 0);
                    else if (object.stringValue.length)
                        message.stringValue = object.stringValue;
                if (object.aggregateValue != null)
                    message.aggregateValue = String(object.aggregateValue);
                return message;
            };

            /**
             * Creates a plain object from an UninterpretedOption message. Also converts values to other types if specified.
             * @function toObject
             * @memberof google.protobuf.UninterpretedOption
             * @static
             * @param {google.protobuf.UninterpretedOption} message UninterpretedOption
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            UninterpretedOption.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.arrays || options.defaults)
                    object.name = [];
                if (options.defaults) {
                    object.identifierValue = "";
                    if ($util.Long) {
                        var long = new $util.Long(0, 0, true);
                        object.positiveIntValue = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                    } else
                        object.positiveIntValue = options.longs === String ? "0" : 0;
                    if ($util.Long) {
                        var long = new $util.Long(0, 0, false);
                        object.negativeIntValue = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                    } else
                        object.negativeIntValue = options.longs === String ? "0" : 0;
                    object.doubleValue = 0;
                    if (options.bytes === String)
                        object.stringValue = "";
                    else {
                        object.stringValue = [];
                        if (options.bytes !== Array)
                            object.stringValue = $util.newBuffer(object.stringValue);
                    }
                    object.aggregateValue = "";
                }
                if (message.name && message.name.length) {
                    object.name = [];
                    for (var j = 0; j < message.name.length; ++j)
                        object.name[j] = $root.google.protobuf.UninterpretedOption.NamePart.toObject(message.name[j], options);
                }
                if (message.identifierValue != null && message.hasOwnProperty("identifierValue"))
                    object.identifierValue = message.identifierValue;
                if (message.positiveIntValue != null && message.hasOwnProperty("positiveIntValue"))
                    if (typeof message.positiveIntValue === "number")
                        object.positiveIntValue = options.longs === String ? String(message.positiveIntValue) : message.positiveIntValue;
                    else
                        object.positiveIntValue = options.longs === String ? $util.Long.prototype.toString.call(message.positiveIntValue) : options.longs === Number ? new $util.LongBits(message.positiveIntValue.low >>> 0, message.positiveIntValue.high >>> 0).toNumber(true) : message.positiveIntValue;
                if (message.negativeIntValue != null && message.hasOwnProperty("negativeIntValue"))
                    if (typeof message.negativeIntValue === "number")
                        object.negativeIntValue = options.longs === String ? String(message.negativeIntValue) : message.negativeIntValue;
                    else
                        object.negativeIntValue = options.longs === String ? $util.Long.prototype.toString.call(message.negativeIntValue) : options.longs === Number ? new $util.LongBits(message.negativeIntValue.low >>> 0, message.negativeIntValue.high >>> 0).toNumber() : message.negativeIntValue;
                if (message.doubleValue != null && message.hasOwnProperty("doubleValue"))
                    object.doubleValue = options.json && !isFinite(message.doubleValue) ? String(message.doubleValue) : message.doubleValue;
                if (message.stringValue != null && message.hasOwnProperty("stringValue"))
                    object.stringValue = options.bytes === String ? $util.base64.encode(message.stringValue, 0, message.stringValue.length) : options.bytes === Array ? Array.prototype.slice.call(message.stringValue) : message.stringValue;
                if (message.aggregateValue != null && message.hasOwnProperty("aggregateValue"))
                    object.aggregateValue = message.aggregateValue;
                return object;
            };

            /**
             * Converts this UninterpretedOption to JSON.
             * @function toJSON
             * @memberof google.protobuf.UninterpretedOption
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            UninterpretedOption.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            UninterpretedOption.NamePart = (function() {

                /**
                 * Properties of a NamePart.
                 * @memberof google.protobuf.UninterpretedOption
                 * @interface INamePart
                 * @property {string} namePart NamePart namePart
                 * @property {boolean} isExtension NamePart isExtension
                 */

                /**
                 * Constructs a new NamePart.
                 * @memberof google.protobuf.UninterpretedOption
                 * @classdesc Represents a NamePart.
                 * @implements INamePart
                 * @constructor
                 * @param {google.protobuf.UninterpretedOption.INamePart=} [properties] Properties to set
                 */
                function NamePart(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * NamePart namePart.
                 * @member {string} namePart
                 * @memberof google.protobuf.UninterpretedOption.NamePart
                 * @instance
                 */
                NamePart.prototype.namePart = "";

                /**
                 * NamePart isExtension.
                 * @member {boolean} isExtension
                 * @memberof google.protobuf.UninterpretedOption.NamePart
                 * @instance
                 */
                NamePart.prototype.isExtension = false;

                /**
                 * Creates a new NamePart instance using the specified properties.
                 * @function create
                 * @memberof google.protobuf.UninterpretedOption.NamePart
                 * @static
                 * @param {google.protobuf.UninterpretedOption.INamePart=} [properties] Properties to set
                 * @returns {google.protobuf.UninterpretedOption.NamePart} NamePart instance
                 */
                NamePart.create = function create(properties) {
                    return new NamePart(properties);
                };

                /**
                 * Encodes the specified NamePart message. Does not implicitly {@link google.protobuf.UninterpretedOption.NamePart.verify|verify} messages.
                 * @function encode
                 * @memberof google.protobuf.UninterpretedOption.NamePart
                 * @static
                 * @param {google.protobuf.UninterpretedOption.INamePart} message NamePart message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                NamePart.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.namePart);
                    writer.uint32(/* id 2, wireType 0 =*/16).bool(message.isExtension);
                    return writer;
                };

                /**
                 * Encodes the specified NamePart message, length delimited. Does not implicitly {@link google.protobuf.UninterpretedOption.NamePart.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof google.protobuf.UninterpretedOption.NamePart
                 * @static
                 * @param {google.protobuf.UninterpretedOption.INamePart} message NamePart message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                NamePart.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a NamePart message from the specified reader or buffer.
                 * @function decode
                 * @memberof google.protobuf.UninterpretedOption.NamePart
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {google.protobuf.UninterpretedOption.NamePart} NamePart
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                NamePart.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.UninterpretedOption.NamePart();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.namePart = reader.string();
                            break;
                        case 2:
                            message.isExtension = reader.bool();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    if (!message.hasOwnProperty("namePart"))
                        throw $util.ProtocolError("missing required 'namePart'", { instance: message });
                    if (!message.hasOwnProperty("isExtension"))
                        throw $util.ProtocolError("missing required 'isExtension'", { instance: message });
                    return message;
                };

                /**
                 * Decodes a NamePart message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof google.protobuf.UninterpretedOption.NamePart
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {google.protobuf.UninterpretedOption.NamePart} NamePart
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                NamePart.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a NamePart message.
                 * @function verify
                 * @memberof google.protobuf.UninterpretedOption.NamePart
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                NamePart.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (!$util.isString(message.namePart))
                        return "namePart: string expected";
                    if (typeof message.isExtension !== "boolean")
                        return "isExtension: boolean expected";
                    return null;
                };

                /**
                 * Creates a NamePart message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof google.protobuf.UninterpretedOption.NamePart
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {google.protobuf.UninterpretedOption.NamePart} NamePart
                 */
                NamePart.fromObject = function fromObject(object) {
                    if (object instanceof $root.google.protobuf.UninterpretedOption.NamePart)
                        return object;
                    var message = new $root.google.protobuf.UninterpretedOption.NamePart();
                    if (object.namePart != null)
                        message.namePart = String(object.namePart);
                    if (object.isExtension != null)
                        message.isExtension = Boolean(object.isExtension);
                    return message;
                };

                /**
                 * Creates a plain object from a NamePart message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof google.protobuf.UninterpretedOption.NamePart
                 * @static
                 * @param {google.protobuf.UninterpretedOption.NamePart} message NamePart
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                NamePart.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.defaults) {
                        object.namePart = "";
                        object.isExtension = false;
                    }
                    if (message.namePart != null && message.hasOwnProperty("namePart"))
                        object.namePart = message.namePart;
                    if (message.isExtension != null && message.hasOwnProperty("isExtension"))
                        object.isExtension = message.isExtension;
                    return object;
                };

                /**
                 * Converts this NamePart to JSON.
                 * @function toJSON
                 * @memberof google.protobuf.UninterpretedOption.NamePart
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                NamePart.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                return NamePart;
            })();

            return UninterpretedOption;
        })();

        protobuf.SourceCodeInfo = (function() {

            /**
             * Properties of a SourceCodeInfo.
             * @memberof google.protobuf
             * @interface ISourceCodeInfo
             * @property {Array.<google.protobuf.SourceCodeInfo.ILocation>|null} [location] SourceCodeInfo location
             */

            /**
             * Constructs a new SourceCodeInfo.
             * @memberof google.protobuf
             * @classdesc Represents a SourceCodeInfo.
             * @implements ISourceCodeInfo
             * @constructor
             * @param {google.protobuf.ISourceCodeInfo=} [properties] Properties to set
             */
            function SourceCodeInfo(properties) {
                this.location = [];
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * SourceCodeInfo location.
             * @member {Array.<google.protobuf.SourceCodeInfo.ILocation>} location
             * @memberof google.protobuf.SourceCodeInfo
             * @instance
             */
            SourceCodeInfo.prototype.location = $util.emptyArray;

            /**
             * Creates a new SourceCodeInfo instance using the specified properties.
             * @function create
             * @memberof google.protobuf.SourceCodeInfo
             * @static
             * @param {google.protobuf.ISourceCodeInfo=} [properties] Properties to set
             * @returns {google.protobuf.SourceCodeInfo} SourceCodeInfo instance
             */
            SourceCodeInfo.create = function create(properties) {
                return new SourceCodeInfo(properties);
            };

            /**
             * Encodes the specified SourceCodeInfo message. Does not implicitly {@link google.protobuf.SourceCodeInfo.verify|verify} messages.
             * @function encode
             * @memberof google.protobuf.SourceCodeInfo
             * @static
             * @param {google.protobuf.ISourceCodeInfo} message SourceCodeInfo message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            SourceCodeInfo.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.location != null && message.location.length)
                    for (var i = 0; i < message.location.length; ++i)
                        $root.google.protobuf.SourceCodeInfo.Location.encode(message.location[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                return writer;
            };

            /**
             * Encodes the specified SourceCodeInfo message, length delimited. Does not implicitly {@link google.protobuf.SourceCodeInfo.verify|verify} messages.
             * @function encodeDelimited
             * @memberof google.protobuf.SourceCodeInfo
             * @static
             * @param {google.protobuf.ISourceCodeInfo} message SourceCodeInfo message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            SourceCodeInfo.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a SourceCodeInfo message from the specified reader or buffer.
             * @function decode
             * @memberof google.protobuf.SourceCodeInfo
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {google.protobuf.SourceCodeInfo} SourceCodeInfo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            SourceCodeInfo.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.SourceCodeInfo();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        if (!(message.location && message.location.length))
                            message.location = [];
                        message.location.push($root.google.protobuf.SourceCodeInfo.Location.decode(reader, reader.uint32()));
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a SourceCodeInfo message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof google.protobuf.SourceCodeInfo
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {google.protobuf.SourceCodeInfo} SourceCodeInfo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            SourceCodeInfo.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a SourceCodeInfo message.
             * @function verify
             * @memberof google.protobuf.SourceCodeInfo
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            SourceCodeInfo.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.location != null && message.hasOwnProperty("location")) {
                    if (!Array.isArray(message.location))
                        return "location: array expected";
                    for (var i = 0; i < message.location.length; ++i) {
                        var error = $root.google.protobuf.SourceCodeInfo.Location.verify(message.location[i]);
                        if (error)
                            return "location." + error;
                    }
                }
                return null;
            };

            /**
             * Creates a SourceCodeInfo message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof google.protobuf.SourceCodeInfo
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {google.protobuf.SourceCodeInfo} SourceCodeInfo
             */
            SourceCodeInfo.fromObject = function fromObject(object) {
                if (object instanceof $root.google.protobuf.SourceCodeInfo)
                    return object;
                var message = new $root.google.protobuf.SourceCodeInfo();
                if (object.location) {
                    if (!Array.isArray(object.location))
                        throw TypeError(".google.protobuf.SourceCodeInfo.location: array expected");
                    message.location = [];
                    for (var i = 0; i < object.location.length; ++i) {
                        if (typeof object.location[i] !== "object")
                            throw TypeError(".google.protobuf.SourceCodeInfo.location: object expected");
                        message.location[i] = $root.google.protobuf.SourceCodeInfo.Location.fromObject(object.location[i]);
                    }
                }
                return message;
            };

            /**
             * Creates a plain object from a SourceCodeInfo message. Also converts values to other types if specified.
             * @function toObject
             * @memberof google.protobuf.SourceCodeInfo
             * @static
             * @param {google.protobuf.SourceCodeInfo} message SourceCodeInfo
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            SourceCodeInfo.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.arrays || options.defaults)
                    object.location = [];
                if (message.location && message.location.length) {
                    object.location = [];
                    for (var j = 0; j < message.location.length; ++j)
                        object.location[j] = $root.google.protobuf.SourceCodeInfo.Location.toObject(message.location[j], options);
                }
                return object;
            };

            /**
             * Converts this SourceCodeInfo to JSON.
             * @function toJSON
             * @memberof google.protobuf.SourceCodeInfo
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            SourceCodeInfo.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            SourceCodeInfo.Location = (function() {

                /**
                 * Properties of a Location.
                 * @memberof google.protobuf.SourceCodeInfo
                 * @interface ILocation
                 * @property {Array.<number>|null} [path] Location path
                 * @property {Array.<number>|null} [span] Location span
                 * @property {string|null} [leadingComments] Location leadingComments
                 * @property {string|null} [trailingComments] Location trailingComments
                 * @property {Array.<string>|null} [leadingDetachedComments] Location leadingDetachedComments
                 */

                /**
                 * Constructs a new Location.
                 * @memberof google.protobuf.SourceCodeInfo
                 * @classdesc Represents a Location.
                 * @implements ILocation
                 * @constructor
                 * @param {google.protobuf.SourceCodeInfo.ILocation=} [properties] Properties to set
                 */
                function Location(properties) {
                    this.path = [];
                    this.span = [];
                    this.leadingDetachedComments = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * Location path.
                 * @member {Array.<number>} path
                 * @memberof google.protobuf.SourceCodeInfo.Location
                 * @instance
                 */
                Location.prototype.path = $util.emptyArray;

                /**
                 * Location span.
                 * @member {Array.<number>} span
                 * @memberof google.protobuf.SourceCodeInfo.Location
                 * @instance
                 */
                Location.prototype.span = $util.emptyArray;

                /**
                 * Location leadingComments.
                 * @member {string} leadingComments
                 * @memberof google.protobuf.SourceCodeInfo.Location
                 * @instance
                 */
                Location.prototype.leadingComments = "";

                /**
                 * Location trailingComments.
                 * @member {string} trailingComments
                 * @memberof google.protobuf.SourceCodeInfo.Location
                 * @instance
                 */
                Location.prototype.trailingComments = "";

                /**
                 * Location leadingDetachedComments.
                 * @member {Array.<string>} leadingDetachedComments
                 * @memberof google.protobuf.SourceCodeInfo.Location
                 * @instance
                 */
                Location.prototype.leadingDetachedComments = $util.emptyArray;

                /**
                 * Creates a new Location instance using the specified properties.
                 * @function create
                 * @memberof google.protobuf.SourceCodeInfo.Location
                 * @static
                 * @param {google.protobuf.SourceCodeInfo.ILocation=} [properties] Properties to set
                 * @returns {google.protobuf.SourceCodeInfo.Location} Location instance
                 */
                Location.create = function create(properties) {
                    return new Location(properties);
                };

                /**
                 * Encodes the specified Location message. Does not implicitly {@link google.protobuf.SourceCodeInfo.Location.verify|verify} messages.
                 * @function encode
                 * @memberof google.protobuf.SourceCodeInfo.Location
                 * @static
                 * @param {google.protobuf.SourceCodeInfo.ILocation} message Location message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Location.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.path != null && message.path.length) {
                        writer.uint32(/* id 1, wireType 2 =*/10).fork();
                        for (var i = 0; i < message.path.length; ++i)
                            writer.int32(message.path[i]);
                        writer.ldelim();
                    }
                    if (message.span != null && message.span.length) {
                        writer.uint32(/* id 2, wireType 2 =*/18).fork();
                        for (var i = 0; i < message.span.length; ++i)
                            writer.int32(message.span[i]);
                        writer.ldelim();
                    }
                    if (message.leadingComments != null && Object.hasOwnProperty.call(message, "leadingComments"))
                        writer.uint32(/* id 3, wireType 2 =*/26).string(message.leadingComments);
                    if (message.trailingComments != null && Object.hasOwnProperty.call(message, "trailingComments"))
                        writer.uint32(/* id 4, wireType 2 =*/34).string(message.trailingComments);
                    if (message.leadingDetachedComments != null && message.leadingDetachedComments.length)
                        for (var i = 0; i < message.leadingDetachedComments.length; ++i)
                            writer.uint32(/* id 6, wireType 2 =*/50).string(message.leadingDetachedComments[i]);
                    return writer;
                };

                /**
                 * Encodes the specified Location message, length delimited. Does not implicitly {@link google.protobuf.SourceCodeInfo.Location.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof google.protobuf.SourceCodeInfo.Location
                 * @static
                 * @param {google.protobuf.SourceCodeInfo.ILocation} message Location message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Location.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a Location message from the specified reader or buffer.
                 * @function decode
                 * @memberof google.protobuf.SourceCodeInfo.Location
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {google.protobuf.SourceCodeInfo.Location} Location
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Location.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.SourceCodeInfo.Location();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            if (!(message.path && message.path.length))
                                message.path = [];
                            if ((tag & 7) === 2) {
                                var end2 = reader.uint32() + reader.pos;
                                while (reader.pos < end2)
                                    message.path.push(reader.int32());
                            } else
                                message.path.push(reader.int32());
                            break;
                        case 2:
                            if (!(message.span && message.span.length))
                                message.span = [];
                            if ((tag & 7) === 2) {
                                var end2 = reader.uint32() + reader.pos;
                                while (reader.pos < end2)
                                    message.span.push(reader.int32());
                            } else
                                message.span.push(reader.int32());
                            break;
                        case 3:
                            message.leadingComments = reader.string();
                            break;
                        case 4:
                            message.trailingComments = reader.string();
                            break;
                        case 6:
                            if (!(message.leadingDetachedComments && message.leadingDetachedComments.length))
                                message.leadingDetachedComments = [];
                            message.leadingDetachedComments.push(reader.string());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a Location message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof google.protobuf.SourceCodeInfo.Location
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {google.protobuf.SourceCodeInfo.Location} Location
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Location.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a Location message.
                 * @function verify
                 * @memberof google.protobuf.SourceCodeInfo.Location
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                Location.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.path != null && message.hasOwnProperty("path")) {
                        if (!Array.isArray(message.path))
                            return "path: array expected";
                        for (var i = 0; i < message.path.length; ++i)
                            if (!$util.isInteger(message.path[i]))
                                return "path: integer[] expected";
                    }
                    if (message.span != null && message.hasOwnProperty("span")) {
                        if (!Array.isArray(message.span))
                            return "span: array expected";
                        for (var i = 0; i < message.span.length; ++i)
                            if (!$util.isInteger(message.span[i]))
                                return "span: integer[] expected";
                    }
                    if (message.leadingComments != null && message.hasOwnProperty("leadingComments"))
                        if (!$util.isString(message.leadingComments))
                            return "leadingComments: string expected";
                    if (message.trailingComments != null && message.hasOwnProperty("trailingComments"))
                        if (!$util.isString(message.trailingComments))
                            return "trailingComments: string expected";
                    if (message.leadingDetachedComments != null && message.hasOwnProperty("leadingDetachedComments")) {
                        if (!Array.isArray(message.leadingDetachedComments))
                            return "leadingDetachedComments: array expected";
                        for (var i = 0; i < message.leadingDetachedComments.length; ++i)
                            if (!$util.isString(message.leadingDetachedComments[i]))
                                return "leadingDetachedComments: string[] expected";
                    }
                    return null;
                };

                /**
                 * Creates a Location message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof google.protobuf.SourceCodeInfo.Location
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {google.protobuf.SourceCodeInfo.Location} Location
                 */
                Location.fromObject = function fromObject(object) {
                    if (object instanceof $root.google.protobuf.SourceCodeInfo.Location)
                        return object;
                    var message = new $root.google.protobuf.SourceCodeInfo.Location();
                    if (object.path) {
                        if (!Array.isArray(object.path))
                            throw TypeError(".google.protobuf.SourceCodeInfo.Location.path: array expected");
                        message.path = [];
                        for (var i = 0; i < object.path.length; ++i)
                            message.path[i] = object.path[i] | 0;
                    }
                    if (object.span) {
                        if (!Array.isArray(object.span))
                            throw TypeError(".google.protobuf.SourceCodeInfo.Location.span: array expected");
                        message.span = [];
                        for (var i = 0; i < object.span.length; ++i)
                            message.span[i] = object.span[i] | 0;
                    }
                    if (object.leadingComments != null)
                        message.leadingComments = String(object.leadingComments);
                    if (object.trailingComments != null)
                        message.trailingComments = String(object.trailingComments);
                    if (object.leadingDetachedComments) {
                        if (!Array.isArray(object.leadingDetachedComments))
                            throw TypeError(".google.protobuf.SourceCodeInfo.Location.leadingDetachedComments: array expected");
                        message.leadingDetachedComments = [];
                        for (var i = 0; i < object.leadingDetachedComments.length; ++i)
                            message.leadingDetachedComments[i] = String(object.leadingDetachedComments[i]);
                    }
                    return message;
                };

                /**
                 * Creates a plain object from a Location message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof google.protobuf.SourceCodeInfo.Location
                 * @static
                 * @param {google.protobuf.SourceCodeInfo.Location} message Location
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                Location.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.arrays || options.defaults) {
                        object.path = [];
                        object.span = [];
                        object.leadingDetachedComments = [];
                    }
                    if (options.defaults) {
                        object.leadingComments = "";
                        object.trailingComments = "";
                    }
                    if (message.path && message.path.length) {
                        object.path = [];
                        for (var j = 0; j < message.path.length; ++j)
                            object.path[j] = message.path[j];
                    }
                    if (message.span && message.span.length) {
                        object.span = [];
                        for (var j = 0; j < message.span.length; ++j)
                            object.span[j] = message.span[j];
                    }
                    if (message.leadingComments != null && message.hasOwnProperty("leadingComments"))
                        object.leadingComments = message.leadingComments;
                    if (message.trailingComments != null && message.hasOwnProperty("trailingComments"))
                        object.trailingComments = message.trailingComments;
                    if (message.leadingDetachedComments && message.leadingDetachedComments.length) {
                        object.leadingDetachedComments = [];
                        for (var j = 0; j < message.leadingDetachedComments.length; ++j)
                            object.leadingDetachedComments[j] = message.leadingDetachedComments[j];
                    }
                    return object;
                };

                /**
                 * Converts this Location to JSON.
                 * @function toJSON
                 * @memberof google.protobuf.SourceCodeInfo.Location
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                Location.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                return Location;
            })();

            return SourceCodeInfo;
        })();

        protobuf.GeneratedCodeInfo = (function() {

            /**
             * Properties of a GeneratedCodeInfo.
             * @memberof google.protobuf
             * @interface IGeneratedCodeInfo
             * @property {Array.<google.protobuf.GeneratedCodeInfo.IAnnotation>|null} [annotation] GeneratedCodeInfo annotation
             */

            /**
             * Constructs a new GeneratedCodeInfo.
             * @memberof google.protobuf
             * @classdesc Represents a GeneratedCodeInfo.
             * @implements IGeneratedCodeInfo
             * @constructor
             * @param {google.protobuf.IGeneratedCodeInfo=} [properties] Properties to set
             */
            function GeneratedCodeInfo(properties) {
                this.annotation = [];
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * GeneratedCodeInfo annotation.
             * @member {Array.<google.protobuf.GeneratedCodeInfo.IAnnotation>} annotation
             * @memberof google.protobuf.GeneratedCodeInfo
             * @instance
             */
            GeneratedCodeInfo.prototype.annotation = $util.emptyArray;

            /**
             * Creates a new GeneratedCodeInfo instance using the specified properties.
             * @function create
             * @memberof google.protobuf.GeneratedCodeInfo
             * @static
             * @param {google.protobuf.IGeneratedCodeInfo=} [properties] Properties to set
             * @returns {google.protobuf.GeneratedCodeInfo} GeneratedCodeInfo instance
             */
            GeneratedCodeInfo.create = function create(properties) {
                return new GeneratedCodeInfo(properties);
            };

            /**
             * Encodes the specified GeneratedCodeInfo message. Does not implicitly {@link google.protobuf.GeneratedCodeInfo.verify|verify} messages.
             * @function encode
             * @memberof google.protobuf.GeneratedCodeInfo
             * @static
             * @param {google.protobuf.IGeneratedCodeInfo} message GeneratedCodeInfo message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            GeneratedCodeInfo.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.annotation != null && message.annotation.length)
                    for (var i = 0; i < message.annotation.length; ++i)
                        $root.google.protobuf.GeneratedCodeInfo.Annotation.encode(message.annotation[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                return writer;
            };

            /**
             * Encodes the specified GeneratedCodeInfo message, length delimited. Does not implicitly {@link google.protobuf.GeneratedCodeInfo.verify|verify} messages.
             * @function encodeDelimited
             * @memberof google.protobuf.GeneratedCodeInfo
             * @static
             * @param {google.protobuf.IGeneratedCodeInfo} message GeneratedCodeInfo message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            GeneratedCodeInfo.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a GeneratedCodeInfo message from the specified reader or buffer.
             * @function decode
             * @memberof google.protobuf.GeneratedCodeInfo
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {google.protobuf.GeneratedCodeInfo} GeneratedCodeInfo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            GeneratedCodeInfo.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.GeneratedCodeInfo();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        if (!(message.annotation && message.annotation.length))
                            message.annotation = [];
                        message.annotation.push($root.google.protobuf.GeneratedCodeInfo.Annotation.decode(reader, reader.uint32()));
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a GeneratedCodeInfo message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof google.protobuf.GeneratedCodeInfo
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {google.protobuf.GeneratedCodeInfo} GeneratedCodeInfo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            GeneratedCodeInfo.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a GeneratedCodeInfo message.
             * @function verify
             * @memberof google.protobuf.GeneratedCodeInfo
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            GeneratedCodeInfo.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.annotation != null && message.hasOwnProperty("annotation")) {
                    if (!Array.isArray(message.annotation))
                        return "annotation: array expected";
                    for (var i = 0; i < message.annotation.length; ++i) {
                        var error = $root.google.protobuf.GeneratedCodeInfo.Annotation.verify(message.annotation[i]);
                        if (error)
                            return "annotation." + error;
                    }
                }
                return null;
            };

            /**
             * Creates a GeneratedCodeInfo message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof google.protobuf.GeneratedCodeInfo
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {google.protobuf.GeneratedCodeInfo} GeneratedCodeInfo
             */
            GeneratedCodeInfo.fromObject = function fromObject(object) {
                if (object instanceof $root.google.protobuf.GeneratedCodeInfo)
                    return object;
                var message = new $root.google.protobuf.GeneratedCodeInfo();
                if (object.annotation) {
                    if (!Array.isArray(object.annotation))
                        throw TypeError(".google.protobuf.GeneratedCodeInfo.annotation: array expected");
                    message.annotation = [];
                    for (var i = 0; i < object.annotation.length; ++i) {
                        if (typeof object.annotation[i] !== "object")
                            throw TypeError(".google.protobuf.GeneratedCodeInfo.annotation: object expected");
                        message.annotation[i] = $root.google.protobuf.GeneratedCodeInfo.Annotation.fromObject(object.annotation[i]);
                    }
                }
                return message;
            };

            /**
             * Creates a plain object from a GeneratedCodeInfo message. Also converts values to other types if specified.
             * @function toObject
             * @memberof google.protobuf.GeneratedCodeInfo
             * @static
             * @param {google.protobuf.GeneratedCodeInfo} message GeneratedCodeInfo
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            GeneratedCodeInfo.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.arrays || options.defaults)
                    object.annotation = [];
                if (message.annotation && message.annotation.length) {
                    object.annotation = [];
                    for (var j = 0; j < message.annotation.length; ++j)
                        object.annotation[j] = $root.google.protobuf.GeneratedCodeInfo.Annotation.toObject(message.annotation[j], options);
                }
                return object;
            };

            /**
             * Converts this GeneratedCodeInfo to JSON.
             * @function toJSON
             * @memberof google.protobuf.GeneratedCodeInfo
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            GeneratedCodeInfo.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            GeneratedCodeInfo.Annotation = (function() {

                /**
                 * Properties of an Annotation.
                 * @memberof google.protobuf.GeneratedCodeInfo
                 * @interface IAnnotation
                 * @property {Array.<number>|null} [path] Annotation path
                 * @property {string|null} [sourceFile] Annotation sourceFile
                 * @property {number|null} [begin] Annotation begin
                 * @property {number|null} [end] Annotation end
                 */

                /**
                 * Constructs a new Annotation.
                 * @memberof google.protobuf.GeneratedCodeInfo
                 * @classdesc Represents an Annotation.
                 * @implements IAnnotation
                 * @constructor
                 * @param {google.protobuf.GeneratedCodeInfo.IAnnotation=} [properties] Properties to set
                 */
                function Annotation(properties) {
                    this.path = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * Annotation path.
                 * @member {Array.<number>} path
                 * @memberof google.protobuf.GeneratedCodeInfo.Annotation
                 * @instance
                 */
                Annotation.prototype.path = $util.emptyArray;

                /**
                 * Annotation sourceFile.
                 * @member {string} sourceFile
                 * @memberof google.protobuf.GeneratedCodeInfo.Annotation
                 * @instance
                 */
                Annotation.prototype.sourceFile = "";

                /**
                 * Annotation begin.
                 * @member {number} begin
                 * @memberof google.protobuf.GeneratedCodeInfo.Annotation
                 * @instance
                 */
                Annotation.prototype.begin = 0;

                /**
                 * Annotation end.
                 * @member {number} end
                 * @memberof google.protobuf.GeneratedCodeInfo.Annotation
                 * @instance
                 */
                Annotation.prototype.end = 0;

                /**
                 * Creates a new Annotation instance using the specified properties.
                 * @function create
                 * @memberof google.protobuf.GeneratedCodeInfo.Annotation
                 * @static
                 * @param {google.protobuf.GeneratedCodeInfo.IAnnotation=} [properties] Properties to set
                 * @returns {google.protobuf.GeneratedCodeInfo.Annotation} Annotation instance
                 */
                Annotation.create = function create(properties) {
                    return new Annotation(properties);
                };

                /**
                 * Encodes the specified Annotation message. Does not implicitly {@link google.protobuf.GeneratedCodeInfo.Annotation.verify|verify} messages.
                 * @function encode
                 * @memberof google.protobuf.GeneratedCodeInfo.Annotation
                 * @static
                 * @param {google.protobuf.GeneratedCodeInfo.IAnnotation} message Annotation message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Annotation.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.path != null && message.path.length) {
                        writer.uint32(/* id 1, wireType 2 =*/10).fork();
                        for (var i = 0; i < message.path.length; ++i)
                            writer.int32(message.path[i]);
                        writer.ldelim();
                    }
                    if (message.sourceFile != null && Object.hasOwnProperty.call(message, "sourceFile"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.sourceFile);
                    if (message.begin != null && Object.hasOwnProperty.call(message, "begin"))
                        writer.uint32(/* id 3, wireType 0 =*/24).int32(message.begin);
                    if (message.end != null && Object.hasOwnProperty.call(message, "end"))
                        writer.uint32(/* id 4, wireType 0 =*/32).int32(message.end);
                    return writer;
                };

                /**
                 * Encodes the specified Annotation message, length delimited. Does not implicitly {@link google.protobuf.GeneratedCodeInfo.Annotation.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof google.protobuf.GeneratedCodeInfo.Annotation
                 * @static
                 * @param {google.protobuf.GeneratedCodeInfo.IAnnotation} message Annotation message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Annotation.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes an Annotation message from the specified reader or buffer.
                 * @function decode
                 * @memberof google.protobuf.GeneratedCodeInfo.Annotation
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {google.protobuf.GeneratedCodeInfo.Annotation} Annotation
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Annotation.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.GeneratedCodeInfo.Annotation();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            if (!(message.path && message.path.length))
                                message.path = [];
                            if ((tag & 7) === 2) {
                                var end2 = reader.uint32() + reader.pos;
                                while (reader.pos < end2)
                                    message.path.push(reader.int32());
                            } else
                                message.path.push(reader.int32());
                            break;
                        case 2:
                            message.sourceFile = reader.string();
                            break;
                        case 3:
                            message.begin = reader.int32();
                            break;
                        case 4:
                            message.end = reader.int32();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes an Annotation message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof google.protobuf.GeneratedCodeInfo.Annotation
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {google.protobuf.GeneratedCodeInfo.Annotation} Annotation
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Annotation.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies an Annotation message.
                 * @function verify
                 * @memberof google.protobuf.GeneratedCodeInfo.Annotation
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                Annotation.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.path != null && message.hasOwnProperty("path")) {
                        if (!Array.isArray(message.path))
                            return "path: array expected";
                        for (var i = 0; i < message.path.length; ++i)
                            if (!$util.isInteger(message.path[i]))
                                return "path: integer[] expected";
                    }
                    if (message.sourceFile != null && message.hasOwnProperty("sourceFile"))
                        if (!$util.isString(message.sourceFile))
                            return "sourceFile: string expected";
                    if (message.begin != null && message.hasOwnProperty("begin"))
                        if (!$util.isInteger(message.begin))
                            return "begin: integer expected";
                    if (message.end != null && message.hasOwnProperty("end"))
                        if (!$util.isInteger(message.end))
                            return "end: integer expected";
                    return null;
                };

                /**
                 * Creates an Annotation message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof google.protobuf.GeneratedCodeInfo.Annotation
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {google.protobuf.GeneratedCodeInfo.Annotation} Annotation
                 */
                Annotation.fromObject = function fromObject(object) {
                    if (object instanceof $root.google.protobuf.GeneratedCodeInfo.Annotation)
                        return object;
                    var message = new $root.google.protobuf.GeneratedCodeInfo.Annotation();
                    if (object.path) {
                        if (!Array.isArray(object.path))
                            throw TypeError(".google.protobuf.GeneratedCodeInfo.Annotation.path: array expected");
                        message.path = [];
                        for (var i = 0; i < object.path.length; ++i)
                            message.path[i] = object.path[i] | 0;
                    }
                    if (object.sourceFile != null)
                        message.sourceFile = String(object.sourceFile);
                    if (object.begin != null)
                        message.begin = object.begin | 0;
                    if (object.end != null)
                        message.end = object.end | 0;
                    return message;
                };

                /**
                 * Creates a plain object from an Annotation message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof google.protobuf.GeneratedCodeInfo.Annotation
                 * @static
                 * @param {google.protobuf.GeneratedCodeInfo.Annotation} message Annotation
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                Annotation.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.arrays || options.defaults)
                        object.path = [];
                    if (options.defaults) {
                        object.sourceFile = "";
                        object.begin = 0;
                        object.end = 0;
                    }
                    if (message.path && message.path.length) {
                        object.path = [];
                        for (var j = 0; j < message.path.length; ++j)
                            object.path[j] = message.path[j];
                    }
                    if (message.sourceFile != null && message.hasOwnProperty("sourceFile"))
                        object.sourceFile = message.sourceFile;
                    if (message.begin != null && message.hasOwnProperty("begin"))
                        object.begin = message.begin;
                    if (message.end != null && message.hasOwnProperty("end"))
                        object.end = message.end;
                    return object;
                };

                /**
                 * Converts this Annotation to JSON.
                 * @function toJSON
                 * @memberof google.protobuf.GeneratedCodeInfo.Annotation
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                Annotation.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                return Annotation;
            })();

            return GeneratedCodeInfo;
        })();

        return protobuf;
    })();

    return google;
})();

$root.NAppHost = (function() {

    /**
     * Namespace NAppHost.
     * @exports NAppHost
     * @namespace
     */
    var NAppHost = {};

    /**
     * ESerializationFormat enum.
     * @name NAppHost.ESerializationFormat
     * @enum {number}
     * @property {number} DEFAULT=0 DEFAULT value
     * @property {number} JSON=1 JSON value
     * @property {number} YSON=2 YSON value
     */
    NAppHost.ESerializationFormat = (function() {
        var valuesById = {}, values = Object.create(valuesById);
        values[valuesById[0] = "DEFAULT"] = 0;
        values[valuesById[1] = "JSON"] = 1;
        values[valuesById[2] = "YSON"] = 2;
        return values;
    })();

    return NAppHost;
})();

$root.userselector = (function() {

    /**
     * Namespace userselector.
     * @exports userselector
     * @namespace
     */
    var userselector = {};

    userselector.User = (function() {

        /**
         * Properties of a User.
         * @memberof userselector
         * @interface IUser
         * @property {number|null} [userId] User userId
         * @property {userselector.User.AuthenticationType|null} [authenticationType] User authenticationType
         */

        /**
         * Constructs a new User.
         * @memberof userselector
         * @classdesc Represents a User.
         * @implements IUser
         * @constructor
         * @param {userselector.IUser=} [properties] Properties to set
         */
        function User(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * User userId.
         * @member {number} userId
         * @memberof userselector.User
         * @instance
         */
        User.prototype.userId = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * User authenticationType.
         * @member {userselector.User.AuthenticationType} authenticationType
         * @memberof userselector.User
         * @instance
         */
        User.prototype.authenticationType = 0;

        /**
         * Creates a new User instance using the specified properties.
         * @function create
         * @memberof userselector.User
         * @static
         * @param {userselector.IUser=} [properties] Properties to set
         * @returns {userselector.User} User instance
         */
        User.create = function create(properties) {
            return new User(properties);
        };

        /**
         * Encodes the specified User message. Does not implicitly {@link userselector.User.verify|verify} messages.
         * @function encode
         * @memberof userselector.User
         * @static
         * @param {userselector.IUser} message User message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        User.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.userId != null && Object.hasOwnProperty.call(message, "userId"))
                writer.uint32(/* id 1, wireType 0 =*/8).int64(message.userId);
            if (message.authenticationType != null && Object.hasOwnProperty.call(message, "authenticationType"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.authenticationType);
            return writer;
        };

        /**
         * Encodes the specified User message, length delimited. Does not implicitly {@link userselector.User.verify|verify} messages.
         * @function encodeDelimited
         * @memberof userselector.User
         * @static
         * @param {userselector.IUser} message User message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        User.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a User message from the specified reader or buffer.
         * @function decode
         * @memberof userselector.User
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {userselector.User} User
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        User.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.userselector.User();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.userId = reader.int64();
                    break;
                case 2:
                    message.authenticationType = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a User message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof userselector.User
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {userselector.User} User
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        User.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a User message.
         * @function verify
         * @memberof userselector.User
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        User.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.userId != null && message.hasOwnProperty("userId"))
                if (!$util.isInteger(message.userId) && !(message.userId && $util.isInteger(message.userId.low) && $util.isInteger(message.userId.high)))
                    return "userId: integer|Long expected";
            if (message.authenticationType != null && message.hasOwnProperty("authenticationType"))
                switch (message.authenticationType) {
                default:
                    return "authenticationType: enum value expected";
                case 0:
                case 1:
                    break;
                }
            return null;
        };

        /**
         * Creates a User message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof userselector.User
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {userselector.User} User
         */
        User.fromObject = function fromObject(object) {
            if (object instanceof $root.userselector.User)
                return object;
            var message = new $root.userselector.User();
            if (object.userId != null)
                if ($util.Long)
                    (message.userId = $util.Long.fromValue(object.userId)).unsigned = false;
                else if (typeof object.userId === "string")
                    message.userId = parseInt(object.userId, 10);
                else if (typeof object.userId === "number")
                    message.userId = object.userId;
                else if (typeof object.userId === "object")
                    message.userId = new $util.LongBits(object.userId.low >>> 0, object.userId.high >>> 0).toNumber();
            switch (object.authenticationType) {
            case "YaStaffUser":
            case 0:
                message.authenticationType = 0;
                break;
            case "YaService":
            case 1:
                message.authenticationType = 1;
                break;
            }
            return message;
        };

        /**
         * Creates a plain object from a User message. Also converts values to other types if specified.
         * @function toObject
         * @memberof userselector.User
         * @static
         * @param {userselector.User} message User
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        User.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.userId = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.userId = options.longs === String ? "0" : 0;
                object.authenticationType = options.enums === String ? "YaStaffUser" : 0;
            }
            if (message.userId != null && message.hasOwnProperty("userId"))
                if (typeof message.userId === "number")
                    object.userId = options.longs === String ? String(message.userId) : message.userId;
                else
                    object.userId = options.longs === String ? $util.Long.prototype.toString.call(message.userId) : options.longs === Number ? new $util.LongBits(message.userId.low >>> 0, message.userId.high >>> 0).toNumber() : message.userId;
            if (message.authenticationType != null && message.hasOwnProperty("authenticationType"))
                object.authenticationType = options.enums === String ? $root.userselector.User.AuthenticationType[message.authenticationType] : message.authenticationType;
            return object;
        };

        /**
         * Converts this User to JSON.
         * @function toJSON
         * @memberof userselector.User
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        User.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * AuthenticationType enum.
         * @name userselector.User.AuthenticationType
         * @enum {number}
         * @property {number} YaStaffUser=0 YaStaffUser value
         * @property {number} YaService=1 YaService value
         */
        User.AuthenticationType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "YaStaffUser"] = 0;
            values[valuesById[1] = "YaService"] = 1;
            return values;
        })();

        return User;
    })();

    userselector.Organization = (function() {

        /**
         * Properties of an Organization.
         * @memberof userselector
         * @interface IOrganization
         * @property {number|null} [OrganizationId] Organization OrganizationId
         * @property {number|null} [PoolId] Organization PoolId
         */

        /**
         * Constructs a new Organization.
         * @memberof userselector
         * @classdesc Represents an Organization.
         * @implements IOrganization
         * @constructor
         * @param {userselector.IOrganization=} [properties] Properties to set
         */
        function Organization(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Organization OrganizationId.
         * @member {number} OrganizationId
         * @memberof userselector.Organization
         * @instance
         */
        Organization.prototype.OrganizationId = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * Organization PoolId.
         * @member {number} PoolId
         * @memberof userselector.Organization
         * @instance
         */
        Organization.prototype.PoolId = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * Creates a new Organization instance using the specified properties.
         * @function create
         * @memberof userselector.Organization
         * @static
         * @param {userselector.IOrganization=} [properties] Properties to set
         * @returns {userselector.Organization} Organization instance
         */
        Organization.create = function create(properties) {
            return new Organization(properties);
        };

        /**
         * Encodes the specified Organization message. Does not implicitly {@link userselector.Organization.verify|verify} messages.
         * @function encode
         * @memberof userselector.Organization
         * @static
         * @param {userselector.IOrganization} message Organization message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Organization.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.OrganizationId != null && Object.hasOwnProperty.call(message, "OrganizationId"))
                writer.uint32(/* id 1, wireType 0 =*/8).int64(message.OrganizationId);
            if (message.PoolId != null && Object.hasOwnProperty.call(message, "PoolId"))
                writer.uint32(/* id 2, wireType 0 =*/16).int64(message.PoolId);
            return writer;
        };

        /**
         * Encodes the specified Organization message, length delimited. Does not implicitly {@link userselector.Organization.verify|verify} messages.
         * @function encodeDelimited
         * @memberof userselector.Organization
         * @static
         * @param {userselector.IOrganization} message Organization message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Organization.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an Organization message from the specified reader or buffer.
         * @function decode
         * @memberof userselector.Organization
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {userselector.Organization} Organization
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Organization.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.userselector.Organization();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.OrganizationId = reader.int64();
                    break;
                case 2:
                    message.PoolId = reader.int64();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an Organization message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof userselector.Organization
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {userselector.Organization} Organization
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Organization.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an Organization message.
         * @function verify
         * @memberof userselector.Organization
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Organization.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.OrganizationId != null && message.hasOwnProperty("OrganizationId"))
                if (!$util.isInteger(message.OrganizationId) && !(message.OrganizationId && $util.isInteger(message.OrganizationId.low) && $util.isInteger(message.OrganizationId.high)))
                    return "OrganizationId: integer|Long expected";
            if (message.PoolId != null && message.hasOwnProperty("PoolId"))
                if (!$util.isInteger(message.PoolId) && !(message.PoolId && $util.isInteger(message.PoolId.low) && $util.isInteger(message.PoolId.high)))
                    return "PoolId: integer|Long expected";
            return null;
        };

        /**
         * Creates an Organization message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof userselector.Organization
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {userselector.Organization} Organization
         */
        Organization.fromObject = function fromObject(object) {
            if (object instanceof $root.userselector.Organization)
                return object;
            var message = new $root.userselector.Organization();
            if (object.OrganizationId != null)
                if ($util.Long)
                    (message.OrganizationId = $util.Long.fromValue(object.OrganizationId)).unsigned = false;
                else if (typeof object.OrganizationId === "string")
                    message.OrganizationId = parseInt(object.OrganizationId, 10);
                else if (typeof object.OrganizationId === "number")
                    message.OrganizationId = object.OrganizationId;
                else if (typeof object.OrganizationId === "object")
                    message.OrganizationId = new $util.LongBits(object.OrganizationId.low >>> 0, object.OrganizationId.high >>> 0).toNumber();
            if (object.PoolId != null)
                if ($util.Long)
                    (message.PoolId = $util.Long.fromValue(object.PoolId)).unsigned = false;
                else if (typeof object.PoolId === "string")
                    message.PoolId = parseInt(object.PoolId, 10);
                else if (typeof object.PoolId === "number")
                    message.PoolId = object.PoolId;
                else if (typeof object.PoolId === "object")
                    message.PoolId = new $util.LongBits(object.PoolId.low >>> 0, object.PoolId.high >>> 0).toNumber();
            return message;
        };

        /**
         * Creates a plain object from an Organization message. Also converts values to other types if specified.
         * @function toObject
         * @memberof userselector.Organization
         * @static
         * @param {userselector.Organization} message Organization
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Organization.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.OrganizationId = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.OrganizationId = options.longs === String ? "0" : 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.PoolId = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.PoolId = options.longs === String ? "0" : 0;
            }
            if (message.OrganizationId != null && message.hasOwnProperty("OrganizationId"))
                if (typeof message.OrganizationId === "number")
                    object.OrganizationId = options.longs === String ? String(message.OrganizationId) : message.OrganizationId;
                else
                    object.OrganizationId = options.longs === String ? $util.Long.prototype.toString.call(message.OrganizationId) : options.longs === Number ? new $util.LongBits(message.OrganizationId.low >>> 0, message.OrganizationId.high >>> 0).toNumber() : message.OrganizationId;
            if (message.PoolId != null && message.hasOwnProperty("PoolId"))
                if (typeof message.PoolId === "number")
                    object.PoolId = options.longs === String ? String(message.PoolId) : message.PoolId;
                else
                    object.PoolId = options.longs === String ? $util.Long.prototype.toString.call(message.PoolId) : options.longs === Number ? new $util.LongBits(message.PoolId.low >>> 0, message.PoolId.high >>> 0).toNumber() : message.PoolId;
            return object;
        };

        /**
         * Converts this Organization to JSON.
         * @function toJSON
         * @memberof userselector.Organization
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Organization.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return Organization;
    })();

    userselector.Delegation = (function() {

        /**
         * Properties of a Delegation.
         * @memberof userselector
         * @interface IDelegation
         */

        /**
         * Constructs a new Delegation.
         * @memberof userselector
         * @classdesc Represents a Delegation.
         * @implements IDelegation
         * @constructor
         * @param {userselector.IDelegation=} [properties] Properties to set
         */
        function Delegation(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Creates a new Delegation instance using the specified properties.
         * @function create
         * @memberof userselector.Delegation
         * @static
         * @param {userselector.IDelegation=} [properties] Properties to set
         * @returns {userselector.Delegation} Delegation instance
         */
        Delegation.create = function create(properties) {
            return new Delegation(properties);
        };

        /**
         * Encodes the specified Delegation message. Does not implicitly {@link userselector.Delegation.verify|verify} messages.
         * @function encode
         * @memberof userselector.Delegation
         * @static
         * @param {userselector.IDelegation} message Delegation message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Delegation.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            return writer;
        };

        /**
         * Encodes the specified Delegation message, length delimited. Does not implicitly {@link userselector.Delegation.verify|verify} messages.
         * @function encodeDelimited
         * @memberof userselector.Delegation
         * @static
         * @param {userselector.IDelegation} message Delegation message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Delegation.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a Delegation message from the specified reader or buffer.
         * @function decode
         * @memberof userselector.Delegation
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {userselector.Delegation} Delegation
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Delegation.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.userselector.Delegation();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a Delegation message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof userselector.Delegation
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {userselector.Delegation} Delegation
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Delegation.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a Delegation message.
         * @function verify
         * @memberof userselector.Delegation
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Delegation.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            return null;
        };

        /**
         * Creates a Delegation message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof userselector.Delegation
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {userselector.Delegation} Delegation
         */
        Delegation.fromObject = function fromObject(object) {
            if (object instanceof $root.userselector.Delegation)
                return object;
            return new $root.userselector.Delegation();
        };

        /**
         * Creates a plain object from a Delegation message. Also converts values to other types if specified.
         * @function toObject
         * @memberof userselector.Delegation
         * @static
         * @param {userselector.Delegation} message Delegation
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Delegation.toObject = function toObject() {
            return {};
        };

        /**
         * Converts this Delegation to JSON.
         * @function toJSON
         * @memberof userselector.Delegation
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Delegation.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return Delegation;
    })();

    userselector.YandexUser = (function() {

        /**
         * Properties of a YandexUser.
         * @memberof userselector
         * @interface IYandexUser
         * @property {number|null} [uId] YandexUser uId
         */

        /**
         * Constructs a new YandexUser.
         * @memberof userselector
         * @classdesc Represents a YandexUser.
         * @implements IYandexUser
         * @constructor
         * @param {userselector.IYandexUser=} [properties] Properties to set
         */
        function YandexUser(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * YandexUser uId.
         * @member {number} uId
         * @memberof userselector.YandexUser
         * @instance
         */
        YandexUser.prototype.uId = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * Creates a new YandexUser instance using the specified properties.
         * @function create
         * @memberof userselector.YandexUser
         * @static
         * @param {userselector.IYandexUser=} [properties] Properties to set
         * @returns {userselector.YandexUser} YandexUser instance
         */
        YandexUser.create = function create(properties) {
            return new YandexUser(properties);
        };

        /**
         * Encodes the specified YandexUser message. Does not implicitly {@link userselector.YandexUser.verify|verify} messages.
         * @function encode
         * @memberof userselector.YandexUser
         * @static
         * @param {userselector.IYandexUser} message YandexUser message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        YandexUser.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.uId != null && Object.hasOwnProperty.call(message, "uId"))
                writer.uint32(/* id 1, wireType 0 =*/8).int64(message.uId);
            return writer;
        };

        /**
         * Encodes the specified YandexUser message, length delimited. Does not implicitly {@link userselector.YandexUser.verify|verify} messages.
         * @function encodeDelimited
         * @memberof userselector.YandexUser
         * @static
         * @param {userselector.IYandexUser} message YandexUser message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        YandexUser.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a YandexUser message from the specified reader or buffer.
         * @function decode
         * @memberof userselector.YandexUser
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {userselector.YandexUser} YandexUser
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        YandexUser.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.userselector.YandexUser();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.uId = reader.int64();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a YandexUser message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof userselector.YandexUser
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {userselector.YandexUser} YandexUser
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        YandexUser.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a YandexUser message.
         * @function verify
         * @memberof userselector.YandexUser
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        YandexUser.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.uId != null && message.hasOwnProperty("uId"))
                if (!$util.isInteger(message.uId) && !(message.uId && $util.isInteger(message.uId.low) && $util.isInteger(message.uId.high)))
                    return "uId: integer|Long expected";
            return null;
        };

        /**
         * Creates a YandexUser message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof userselector.YandexUser
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {userselector.YandexUser} YandexUser
         */
        YandexUser.fromObject = function fromObject(object) {
            if (object instanceof $root.userselector.YandexUser)
                return object;
            var message = new $root.userselector.YandexUser();
            if (object.uId != null)
                if ($util.Long)
                    (message.uId = $util.Long.fromValue(object.uId)).unsigned = false;
                else if (typeof object.uId === "string")
                    message.uId = parseInt(object.uId, 10);
                else if (typeof object.uId === "number")
                    message.uId = object.uId;
                else if (typeof object.uId === "object")
                    message.uId = new $util.LongBits(object.uId.low >>> 0, object.uId.high >>> 0).toNumber();
            return message;
        };

        /**
         * Creates a plain object from a YandexUser message. Also converts values to other types if specified.
         * @function toObject
         * @memberof userselector.YandexUser
         * @static
         * @param {userselector.YandexUser} message YandexUser
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        YandexUser.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.uId = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.uId = options.longs === String ? "0" : 0;
            if (message.uId != null && message.hasOwnProperty("uId"))
                if (typeof message.uId === "number")
                    object.uId = options.longs === String ? String(message.uId) : message.uId;
                else
                    object.uId = options.longs === String ? $util.Long.prototype.toString.call(message.uId) : options.longs === Number ? new $util.LongBits(message.uId.low >>> 0, message.uId.high >>> 0).toNumber() : message.uId;
            return object;
        };

        /**
         * Converts this YandexUser to JSON.
         * @function toJSON
         * @memberof userselector.YandexUser
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        YandexUser.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return YandexUser;
    })();

    userselector.YandexService = (function() {

        /**
         * Properties of a YandexService.
         * @memberof userselector
         * @interface IYandexService
         * @property {number|null} [tvmId] YandexService tvmId
         */

        /**
         * Constructs a new YandexService.
         * @memberof userselector
         * @classdesc Represents a YandexService.
         * @implements IYandexService
         * @constructor
         * @param {userselector.IYandexService=} [properties] Properties to set
         */
        function YandexService(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * YandexService tvmId.
         * @member {number} tvmId
         * @memberof userselector.YandexService
         * @instance
         */
        YandexService.prototype.tvmId = 0;

        /**
         * Creates a new YandexService instance using the specified properties.
         * @function create
         * @memberof userselector.YandexService
         * @static
         * @param {userselector.IYandexService=} [properties] Properties to set
         * @returns {userselector.YandexService} YandexService instance
         */
        YandexService.create = function create(properties) {
            return new YandexService(properties);
        };

        /**
         * Encodes the specified YandexService message. Does not implicitly {@link userselector.YandexService.verify|verify} messages.
         * @function encode
         * @memberof userselector.YandexService
         * @static
         * @param {userselector.IYandexService} message YandexService message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        YandexService.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.tvmId != null && Object.hasOwnProperty.call(message, "tvmId"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.tvmId);
            return writer;
        };

        /**
         * Encodes the specified YandexService message, length delimited. Does not implicitly {@link userselector.YandexService.verify|verify} messages.
         * @function encodeDelimited
         * @memberof userselector.YandexService
         * @static
         * @param {userselector.IYandexService} message YandexService message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        YandexService.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a YandexService message from the specified reader or buffer.
         * @function decode
         * @memberof userselector.YandexService
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {userselector.YandexService} YandexService
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        YandexService.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.userselector.YandexService();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.tvmId = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a YandexService message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof userselector.YandexService
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {userselector.YandexService} YandexService
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        YandexService.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a YandexService message.
         * @function verify
         * @memberof userselector.YandexService
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        YandexService.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.tvmId != null && message.hasOwnProperty("tvmId"))
                if (!$util.isInteger(message.tvmId))
                    return "tvmId: integer expected";
            return null;
        };

        /**
         * Creates a YandexService message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof userselector.YandexService
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {userselector.YandexService} YandexService
         */
        YandexService.fromObject = function fromObject(object) {
            if (object instanceof $root.userselector.YandexService)
                return object;
            var message = new $root.userselector.YandexService();
            if (object.tvmId != null)
                message.tvmId = object.tvmId | 0;
            return message;
        };

        /**
         * Creates a plain object from a YandexService message. Also converts values to other types if specified.
         * @function toObject
         * @memberof userselector.YandexService
         * @static
         * @param {userselector.YandexService} message YandexService
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        YandexService.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.tvmId = 0;
            if (message.tvmId != null && message.hasOwnProperty("tvmId"))
                object.tvmId = message.tvmId;
            return object;
        };

        /**
         * Converts this YandexService to JSON.
         * @function toJSON
         * @memberof userselector.YandexService
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        YandexService.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return YandexService;
    })();

    return userselector;
})();

$root.NBlackbox = (function() {

    /**
     * Namespace NBlackbox.
     * @exports NBlackbox
     * @namespace
     */
    var NBlackbox = {};

    NBlackbox.TUser = (function() {

        /**
         * Properties of a TUser.
         * @memberof NBlackbox
         * @interface ITUser
         * @property {string|null} [Login] TUser Login
         * @property {string|null} [Uid] TUser Uid
         */

        /**
         * Constructs a new TUser.
         * @memberof NBlackbox
         * @classdesc Represents a TUser.
         * @implements ITUser
         * @constructor
         * @param {NBlackbox.ITUser=} [properties] Properties to set
         */
        function TUser(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TUser Login.
         * @member {string} Login
         * @memberof NBlackbox.TUser
         * @instance
         */
        TUser.prototype.Login = "";

        /**
         * TUser Uid.
         * @member {string} Uid
         * @memberof NBlackbox.TUser
         * @instance
         */
        TUser.prototype.Uid = "";

        /**
         * Creates a new TUser instance using the specified properties.
         * @function create
         * @memberof NBlackbox.TUser
         * @static
         * @param {NBlackbox.ITUser=} [properties] Properties to set
         * @returns {NBlackbox.TUser} TUser instance
         */
        TUser.create = function create(properties) {
            return new TUser(properties);
        };

        /**
         * Encodes the specified TUser message. Does not implicitly {@link NBlackbox.TUser.verify|verify} messages.
         * @function encode
         * @memberof NBlackbox.TUser
         * @static
         * @param {NBlackbox.ITUser} message TUser message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TUser.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.Login != null && Object.hasOwnProperty.call(message, "Login"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.Login);
            if (message.Uid != null && Object.hasOwnProperty.call(message, "Uid"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.Uid);
            return writer;
        };

        /**
         * Encodes the specified TUser message, length delimited. Does not implicitly {@link NBlackbox.TUser.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NBlackbox.TUser
         * @static
         * @param {NBlackbox.ITUser} message TUser message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TUser.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TUser message from the specified reader or buffer.
         * @function decode
         * @memberof NBlackbox.TUser
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NBlackbox.TUser} TUser
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TUser.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.NBlackbox.TUser();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.Login = reader.string();
                    break;
                case 2:
                    message.Uid = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TUser message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NBlackbox.TUser
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NBlackbox.TUser} TUser
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TUser.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TUser message.
         * @function verify
         * @memberof NBlackbox.TUser
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TUser.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.Login != null && message.hasOwnProperty("Login"))
                if (!$util.isString(message.Login))
                    return "Login: string expected";
            if (message.Uid != null && message.hasOwnProperty("Uid"))
                if (!$util.isString(message.Uid))
                    return "Uid: string expected";
            return null;
        };

        /**
         * Creates a TUser message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NBlackbox.TUser
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NBlackbox.TUser} TUser
         */
        TUser.fromObject = function fromObject(object) {
            if (object instanceof $root.NBlackbox.TUser)
                return object;
            var message = new $root.NBlackbox.TUser();
            if (object.Login != null)
                message.Login = String(object.Login);
            if (object.Uid != null)
                message.Uid = String(object.Uid);
            return message;
        };

        /**
         * Creates a plain object from a TUser message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NBlackbox.TUser
         * @static
         * @param {NBlackbox.TUser} message TUser
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TUser.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.Login = "";
                object.Uid = "";
            }
            if (message.Login != null && message.hasOwnProperty("Login"))
                object.Login = message.Login;
            if (message.Uid != null && message.hasOwnProperty("Uid"))
                object.Uid = message.Uid;
            return object;
        };

        /**
         * Converts this TUser to JSON.
         * @function toJSON
         * @memberof NBlackbox.TUser
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TUser.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TUser;
    })();

    return NBlackbox;
})();

$root.usermanager = (function() {

    /**
     * Namespace usermanager.
     * @exports usermanager
     * @namespace
     */
    var usermanager = {};

    usermanager.User = (function() {

        /**
         * Properties of a User.
         * @memberof usermanager
         * @interface IUser
         * @property {number|null} [userId] User userId
         * @property {usermanager.IUserData|null} [data] User data
         */

        /**
         * Constructs a new User.
         * @memberof usermanager
         * @classdesc Represents a User.
         * @implements IUser
         * @constructor
         * @param {usermanager.IUser=} [properties] Properties to set
         */
        function User(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * User userId.
         * @member {number} userId
         * @memberof usermanager.User
         * @instance
         */
        User.prototype.userId = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * User data.
         * @member {usermanager.IUserData|null|undefined} data
         * @memberof usermanager.User
         * @instance
         */
        User.prototype.data = null;

        /**
         * Creates a new User instance using the specified properties.
         * @function create
         * @memberof usermanager.User
         * @static
         * @param {usermanager.IUser=} [properties] Properties to set
         * @returns {usermanager.User} User instance
         */
        User.create = function create(properties) {
            return new User(properties);
        };

        /**
         * Encodes the specified User message. Does not implicitly {@link usermanager.User.verify|verify} messages.
         * @function encode
         * @memberof usermanager.User
         * @static
         * @param {usermanager.IUser} message User message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        User.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.userId != null && Object.hasOwnProperty.call(message, "userId"))
                writer.uint32(/* id 1, wireType 0 =*/8).int64(message.userId);
            if (message.data != null && Object.hasOwnProperty.call(message, "data"))
                $root.usermanager.UserData.encode(message.data, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified User message, length delimited. Does not implicitly {@link usermanager.User.verify|verify} messages.
         * @function encodeDelimited
         * @memberof usermanager.User
         * @static
         * @param {usermanager.IUser} message User message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        User.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a User message from the specified reader or buffer.
         * @function decode
         * @memberof usermanager.User
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {usermanager.User} User
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        User.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.usermanager.User();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.userId = reader.int64();
                    break;
                case 2:
                    message.data = $root.usermanager.UserData.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a User message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof usermanager.User
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {usermanager.User} User
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        User.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a User message.
         * @function verify
         * @memberof usermanager.User
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        User.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.userId != null && message.hasOwnProperty("userId"))
                if (!$util.isInteger(message.userId) && !(message.userId && $util.isInteger(message.userId.low) && $util.isInteger(message.userId.high)))
                    return "userId: integer|Long expected";
            if (message.data != null && message.hasOwnProperty("data")) {
                var error = $root.usermanager.UserData.verify(message.data);
                if (error)
                    return "data." + error;
            }
            return null;
        };

        /**
         * Creates a User message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof usermanager.User
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {usermanager.User} User
         */
        User.fromObject = function fromObject(object) {
            if (object instanceof $root.usermanager.User)
                return object;
            var message = new $root.usermanager.User();
            if (object.userId != null)
                if ($util.Long)
                    (message.userId = $util.Long.fromValue(object.userId)).unsigned = false;
                else if (typeof object.userId === "string")
                    message.userId = parseInt(object.userId, 10);
                else if (typeof object.userId === "number")
                    message.userId = object.userId;
                else if (typeof object.userId === "object")
                    message.userId = new $util.LongBits(object.userId.low >>> 0, object.userId.high >>> 0).toNumber();
            if (object.data != null) {
                if (typeof object.data !== "object")
                    throw TypeError(".usermanager.User.data: object expected");
                message.data = $root.usermanager.UserData.fromObject(object.data);
            }
            return message;
        };

        /**
         * Creates a plain object from a User message. Also converts values to other types if specified.
         * @function toObject
         * @memberof usermanager.User
         * @static
         * @param {usermanager.User} message User
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        User.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.userId = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.userId = options.longs === String ? "0" : 0;
                object.data = null;
            }
            if (message.userId != null && message.hasOwnProperty("userId"))
                if (typeof message.userId === "number")
                    object.userId = options.longs === String ? String(message.userId) : message.userId;
                else
                    object.userId = options.longs === String ? $util.Long.prototype.toString.call(message.userId) : options.longs === Number ? new $util.LongBits(message.userId.low >>> 0, message.userId.high >>> 0).toNumber() : message.userId;
            if (message.data != null && message.hasOwnProperty("data"))
                object.data = $root.usermanager.UserData.toObject(message.data, options);
            return object;
        };

        /**
         * Converts this User to JSON.
         * @function toJSON
         * @memberof usermanager.User
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        User.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return User;
    })();

    usermanager.UserData = (function() {

        /**
         * Properties of a UserData.
         * @memberof usermanager
         * @interface IUserData
         * @property {string|null} [firstName] UserData firstName
         * @property {string|null} [secondName] UserData secondName
         */

        /**
         * Constructs a new UserData.
         * @memberof usermanager
         * @classdesc Represents a UserData.
         * @implements IUserData
         * @constructor
         * @param {usermanager.IUserData=} [properties] Properties to set
         */
        function UserData(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * UserData firstName.
         * @member {string} firstName
         * @memberof usermanager.UserData
         * @instance
         */
        UserData.prototype.firstName = "";

        /**
         * UserData secondName.
         * @member {string} secondName
         * @memberof usermanager.UserData
         * @instance
         */
        UserData.prototype.secondName = "";

        /**
         * Creates a new UserData instance using the specified properties.
         * @function create
         * @memberof usermanager.UserData
         * @static
         * @param {usermanager.IUserData=} [properties] Properties to set
         * @returns {usermanager.UserData} UserData instance
         */
        UserData.create = function create(properties) {
            return new UserData(properties);
        };

        /**
         * Encodes the specified UserData message. Does not implicitly {@link usermanager.UserData.verify|verify} messages.
         * @function encode
         * @memberof usermanager.UserData
         * @static
         * @param {usermanager.IUserData} message UserData message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        UserData.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.firstName != null && Object.hasOwnProperty.call(message, "firstName"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.firstName);
            if (message.secondName != null && Object.hasOwnProperty.call(message, "secondName"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.secondName);
            return writer;
        };

        /**
         * Encodes the specified UserData message, length delimited. Does not implicitly {@link usermanager.UserData.verify|verify} messages.
         * @function encodeDelimited
         * @memberof usermanager.UserData
         * @static
         * @param {usermanager.IUserData} message UserData message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        UserData.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a UserData message from the specified reader or buffer.
         * @function decode
         * @memberof usermanager.UserData
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {usermanager.UserData} UserData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        UserData.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.usermanager.UserData();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.firstName = reader.string();
                    break;
                case 2:
                    message.secondName = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a UserData message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof usermanager.UserData
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {usermanager.UserData} UserData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        UserData.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a UserData message.
         * @function verify
         * @memberof usermanager.UserData
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        UserData.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.firstName != null && message.hasOwnProperty("firstName"))
                if (!$util.isString(message.firstName))
                    return "firstName: string expected";
            if (message.secondName != null && message.hasOwnProperty("secondName"))
                if (!$util.isString(message.secondName))
                    return "secondName: string expected";
            return null;
        };

        /**
         * Creates a UserData message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof usermanager.UserData
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {usermanager.UserData} UserData
         */
        UserData.fromObject = function fromObject(object) {
            if (object instanceof $root.usermanager.UserData)
                return object;
            var message = new $root.usermanager.UserData();
            if (object.firstName != null)
                message.firstName = String(object.firstName);
            if (object.secondName != null)
                message.secondName = String(object.secondName);
            return message;
        };

        /**
         * Creates a plain object from a UserData message. Also converts values to other types if specified.
         * @function toObject
         * @memberof usermanager.UserData
         * @static
         * @param {usermanager.UserData} message UserData
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        UserData.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.firstName = "";
                object.secondName = "";
            }
            if (message.firstName != null && message.hasOwnProperty("firstName"))
                object.firstName = message.firstName;
            if (message.secondName != null && message.hasOwnProperty("secondName"))
                object.secondName = message.secondName;
            return object;
        };

        /**
         * Converts this UserData to JSON.
         * @function toJSON
         * @memberof usermanager.UserData
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        UserData.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return UserData;
    })();

    usermanager.UpdateUserData = (function() {

        /**
         * Properties of an UpdateUserData.
         * @memberof usermanager
         * @interface IUpdateUserData
         * @property {string|null} [newFirstName] UpdateUserData newFirstName
         * @property {string|null} [newSecondName] UpdateUserData newSecondName
         */

        /**
         * Constructs a new UpdateUserData.
         * @memberof usermanager
         * @classdesc Represents an UpdateUserData.
         * @implements IUpdateUserData
         * @constructor
         * @param {usermanager.IUpdateUserData=} [properties] Properties to set
         */
        function UpdateUserData(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * UpdateUserData newFirstName.
         * @member {string|null|undefined} newFirstName
         * @memberof usermanager.UpdateUserData
         * @instance
         */
        UpdateUserData.prototype.newFirstName = null;

        /**
         * UpdateUserData newSecondName.
         * @member {string|null|undefined} newSecondName
         * @memberof usermanager.UpdateUserData
         * @instance
         */
        UpdateUserData.prototype.newSecondName = null;

        // OneOf field names bound to virtual getters and setters
        var $oneOfFields;

        /**
         * UpdateUserData _newFirstName.
         * @member {"newFirstName"|undefined} _newFirstName
         * @memberof usermanager.UpdateUserData
         * @instance
         */
        Object.defineProperty(UpdateUserData.prototype, "_newFirstName", {
            get: $util.oneOfGetter($oneOfFields = ["newFirstName"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * UpdateUserData _newSecondName.
         * @member {"newSecondName"|undefined} _newSecondName
         * @memberof usermanager.UpdateUserData
         * @instance
         */
        Object.defineProperty(UpdateUserData.prototype, "_newSecondName", {
            get: $util.oneOfGetter($oneOfFields = ["newSecondName"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new UpdateUserData instance using the specified properties.
         * @function create
         * @memberof usermanager.UpdateUserData
         * @static
         * @param {usermanager.IUpdateUserData=} [properties] Properties to set
         * @returns {usermanager.UpdateUserData} UpdateUserData instance
         */
        UpdateUserData.create = function create(properties) {
            return new UpdateUserData(properties);
        };

        /**
         * Encodes the specified UpdateUserData message. Does not implicitly {@link usermanager.UpdateUserData.verify|verify} messages.
         * @function encode
         * @memberof usermanager.UpdateUserData
         * @static
         * @param {usermanager.IUpdateUserData} message UpdateUserData message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        UpdateUserData.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.newFirstName != null && Object.hasOwnProperty.call(message, "newFirstName"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.newFirstName);
            if (message.newSecondName != null && Object.hasOwnProperty.call(message, "newSecondName"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.newSecondName);
            return writer;
        };

        /**
         * Encodes the specified UpdateUserData message, length delimited. Does not implicitly {@link usermanager.UpdateUserData.verify|verify} messages.
         * @function encodeDelimited
         * @memberof usermanager.UpdateUserData
         * @static
         * @param {usermanager.IUpdateUserData} message UpdateUserData message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        UpdateUserData.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an UpdateUserData message from the specified reader or buffer.
         * @function decode
         * @memberof usermanager.UpdateUserData
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {usermanager.UpdateUserData} UpdateUserData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        UpdateUserData.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.usermanager.UpdateUserData();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.newFirstName = reader.string();
                    break;
                case 2:
                    message.newSecondName = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an UpdateUserData message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof usermanager.UpdateUserData
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {usermanager.UpdateUserData} UpdateUserData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        UpdateUserData.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an UpdateUserData message.
         * @function verify
         * @memberof usermanager.UpdateUserData
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        UpdateUserData.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            var properties = {};
            if (message.newFirstName != null && message.hasOwnProperty("newFirstName")) {
                properties._newFirstName = 1;
                if (!$util.isString(message.newFirstName))
                    return "newFirstName: string expected";
            }
            if (message.newSecondName != null && message.hasOwnProperty("newSecondName")) {
                properties._newSecondName = 1;
                if (!$util.isString(message.newSecondName))
                    return "newSecondName: string expected";
            }
            return null;
        };

        /**
         * Creates an UpdateUserData message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof usermanager.UpdateUserData
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {usermanager.UpdateUserData} UpdateUserData
         */
        UpdateUserData.fromObject = function fromObject(object) {
            if (object instanceof $root.usermanager.UpdateUserData)
                return object;
            var message = new $root.usermanager.UpdateUserData();
            if (object.newFirstName != null)
                message.newFirstName = String(object.newFirstName);
            if (object.newSecondName != null)
                message.newSecondName = String(object.newSecondName);
            return message;
        };

        /**
         * Creates a plain object from an UpdateUserData message. Also converts values to other types if specified.
         * @function toObject
         * @memberof usermanager.UpdateUserData
         * @static
         * @param {usermanager.UpdateUserData} message UpdateUserData
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        UpdateUserData.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (message.newFirstName != null && message.hasOwnProperty("newFirstName")) {
                object.newFirstName = message.newFirstName;
                if (options.oneofs)
                    object._newFirstName = "newFirstName";
            }
            if (message.newSecondName != null && message.hasOwnProperty("newSecondName")) {
                object.newSecondName = message.newSecondName;
                if (options.oneofs)
                    object._newSecondName = "newSecondName";
            }
            return object;
        };

        /**
         * Converts this UpdateUserData to JSON.
         * @function toJSON
         * @memberof usermanager.UpdateUserData
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        UpdateUserData.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return UpdateUserData;
    })();

    usermanager.YandexUser = (function() {

        /**
         * Properties of a YandexUser.
         * @memberof usermanager
         * @interface IYandexUser
         * @property {number|null} [yandexUserId] YandexUser yandexUserId
         * @property {number|null} [userId] YandexUser userId
         * @property {number|null} [uid] YandexUser uid
         * @property {string|null} [login] YandexUser login
         */

        /**
         * Constructs a new YandexUser.
         * @memberof usermanager
         * @classdesc Represents a YandexUser.
         * @implements IYandexUser
         * @constructor
         * @param {usermanager.IYandexUser=} [properties] Properties to set
         */
        function YandexUser(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * YandexUser yandexUserId.
         * @member {number} yandexUserId
         * @memberof usermanager.YandexUser
         * @instance
         */
        YandexUser.prototype.yandexUserId = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * YandexUser userId.
         * @member {number} userId
         * @memberof usermanager.YandexUser
         * @instance
         */
        YandexUser.prototype.userId = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * YandexUser uid.
         * @member {number} uid
         * @memberof usermanager.YandexUser
         * @instance
         */
        YandexUser.prototype.uid = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * YandexUser login.
         * @member {string} login
         * @memberof usermanager.YandexUser
         * @instance
         */
        YandexUser.prototype.login = "";

        /**
         * Creates a new YandexUser instance using the specified properties.
         * @function create
         * @memberof usermanager.YandexUser
         * @static
         * @param {usermanager.IYandexUser=} [properties] Properties to set
         * @returns {usermanager.YandexUser} YandexUser instance
         */
        YandexUser.create = function create(properties) {
            return new YandexUser(properties);
        };

        /**
         * Encodes the specified YandexUser message. Does not implicitly {@link usermanager.YandexUser.verify|verify} messages.
         * @function encode
         * @memberof usermanager.YandexUser
         * @static
         * @param {usermanager.IYandexUser} message YandexUser message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        YandexUser.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.yandexUserId != null && Object.hasOwnProperty.call(message, "yandexUserId"))
                writer.uint32(/* id 1, wireType 0 =*/8).int64(message.yandexUserId);
            if (message.userId != null && Object.hasOwnProperty.call(message, "userId"))
                writer.uint32(/* id 2, wireType 0 =*/16).int64(message.userId);
            if (message.uid != null && Object.hasOwnProperty.call(message, "uid"))
                writer.uint32(/* id 3, wireType 0 =*/24).int64(message.uid);
            if (message.login != null && Object.hasOwnProperty.call(message, "login"))
                writer.uint32(/* id 4, wireType 2 =*/34).string(message.login);
            return writer;
        };

        /**
         * Encodes the specified YandexUser message, length delimited. Does not implicitly {@link usermanager.YandexUser.verify|verify} messages.
         * @function encodeDelimited
         * @memberof usermanager.YandexUser
         * @static
         * @param {usermanager.IYandexUser} message YandexUser message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        YandexUser.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a YandexUser message from the specified reader or buffer.
         * @function decode
         * @memberof usermanager.YandexUser
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {usermanager.YandexUser} YandexUser
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        YandexUser.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.usermanager.YandexUser();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.yandexUserId = reader.int64();
                    break;
                case 2:
                    message.userId = reader.int64();
                    break;
                case 3:
                    message.uid = reader.int64();
                    break;
                case 4:
                    message.login = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a YandexUser message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof usermanager.YandexUser
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {usermanager.YandexUser} YandexUser
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        YandexUser.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a YandexUser message.
         * @function verify
         * @memberof usermanager.YandexUser
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        YandexUser.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.yandexUserId != null && message.hasOwnProperty("yandexUserId"))
                if (!$util.isInteger(message.yandexUserId) && !(message.yandexUserId && $util.isInteger(message.yandexUserId.low) && $util.isInteger(message.yandexUserId.high)))
                    return "yandexUserId: integer|Long expected";
            if (message.userId != null && message.hasOwnProperty("userId"))
                if (!$util.isInteger(message.userId) && !(message.userId && $util.isInteger(message.userId.low) && $util.isInteger(message.userId.high)))
                    return "userId: integer|Long expected";
            if (message.uid != null && message.hasOwnProperty("uid"))
                if (!$util.isInteger(message.uid) && !(message.uid && $util.isInteger(message.uid.low) && $util.isInteger(message.uid.high)))
                    return "uid: integer|Long expected";
            if (message.login != null && message.hasOwnProperty("login"))
                if (!$util.isString(message.login))
                    return "login: string expected";
            return null;
        };

        /**
         * Creates a YandexUser message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof usermanager.YandexUser
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {usermanager.YandexUser} YandexUser
         */
        YandexUser.fromObject = function fromObject(object) {
            if (object instanceof $root.usermanager.YandexUser)
                return object;
            var message = new $root.usermanager.YandexUser();
            if (object.yandexUserId != null)
                if ($util.Long)
                    (message.yandexUserId = $util.Long.fromValue(object.yandexUserId)).unsigned = false;
                else if (typeof object.yandexUserId === "string")
                    message.yandexUserId = parseInt(object.yandexUserId, 10);
                else if (typeof object.yandexUserId === "number")
                    message.yandexUserId = object.yandexUserId;
                else if (typeof object.yandexUserId === "object")
                    message.yandexUserId = new $util.LongBits(object.yandexUserId.low >>> 0, object.yandexUserId.high >>> 0).toNumber();
            if (object.userId != null)
                if ($util.Long)
                    (message.userId = $util.Long.fromValue(object.userId)).unsigned = false;
                else if (typeof object.userId === "string")
                    message.userId = parseInt(object.userId, 10);
                else if (typeof object.userId === "number")
                    message.userId = object.userId;
                else if (typeof object.userId === "object")
                    message.userId = new $util.LongBits(object.userId.low >>> 0, object.userId.high >>> 0).toNumber();
            if (object.uid != null)
                if ($util.Long)
                    (message.uid = $util.Long.fromValue(object.uid)).unsigned = false;
                else if (typeof object.uid === "string")
                    message.uid = parseInt(object.uid, 10);
                else if (typeof object.uid === "number")
                    message.uid = object.uid;
                else if (typeof object.uid === "object")
                    message.uid = new $util.LongBits(object.uid.low >>> 0, object.uid.high >>> 0).toNumber();
            if (object.login != null)
                message.login = String(object.login);
            return message;
        };

        /**
         * Creates a plain object from a YandexUser message. Also converts values to other types if specified.
         * @function toObject
         * @memberof usermanager.YandexUser
         * @static
         * @param {usermanager.YandexUser} message YandexUser
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        YandexUser.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.yandexUserId = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.yandexUserId = options.longs === String ? "0" : 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.userId = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.userId = options.longs === String ? "0" : 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.uid = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.uid = options.longs === String ? "0" : 0;
                object.login = "";
            }
            if (message.yandexUserId != null && message.hasOwnProperty("yandexUserId"))
                if (typeof message.yandexUserId === "number")
                    object.yandexUserId = options.longs === String ? String(message.yandexUserId) : message.yandexUserId;
                else
                    object.yandexUserId = options.longs === String ? $util.Long.prototype.toString.call(message.yandexUserId) : options.longs === Number ? new $util.LongBits(message.yandexUserId.low >>> 0, message.yandexUserId.high >>> 0).toNumber() : message.yandexUserId;
            if (message.userId != null && message.hasOwnProperty("userId"))
                if (typeof message.userId === "number")
                    object.userId = options.longs === String ? String(message.userId) : message.userId;
                else
                    object.userId = options.longs === String ? $util.Long.prototype.toString.call(message.userId) : options.longs === Number ? new $util.LongBits(message.userId.low >>> 0, message.userId.high >>> 0).toNumber() : message.userId;
            if (message.uid != null && message.hasOwnProperty("uid"))
                if (typeof message.uid === "number")
                    object.uid = options.longs === String ? String(message.uid) : message.uid;
                else
                    object.uid = options.longs === String ? $util.Long.prototype.toString.call(message.uid) : options.longs === Number ? new $util.LongBits(message.uid.low >>> 0, message.uid.high >>> 0).toNumber() : message.uid;
            if (message.login != null && message.hasOwnProperty("login"))
                object.login = message.login;
            return object;
        };

        /**
         * Converts this YandexUser to JSON.
         * @function toJSON
         * @memberof usermanager.YandexUser
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        YandexUser.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return YandexUser;
    })();

    usermanager.YandexUserData = (function() {

        /**
         * Properties of a YandexUserData.
         * @memberof usermanager
         * @interface IYandexUserData
         * @property {number|null} [userId] YandexUserData userId
         * @property {number|null} [uid] YandexUserData uid
         * @property {string|null} [login] YandexUserData login
         */

        /**
         * Constructs a new YandexUserData.
         * @memberof usermanager
         * @classdesc Represents a YandexUserData.
         * @implements IYandexUserData
         * @constructor
         * @param {usermanager.IYandexUserData=} [properties] Properties to set
         */
        function YandexUserData(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * YandexUserData userId.
         * @member {number} userId
         * @memberof usermanager.YandexUserData
         * @instance
         */
        YandexUserData.prototype.userId = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * YandexUserData uid.
         * @member {number} uid
         * @memberof usermanager.YandexUserData
         * @instance
         */
        YandexUserData.prototype.uid = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * YandexUserData login.
         * @member {string} login
         * @memberof usermanager.YandexUserData
         * @instance
         */
        YandexUserData.prototype.login = "";

        /**
         * Creates a new YandexUserData instance using the specified properties.
         * @function create
         * @memberof usermanager.YandexUserData
         * @static
         * @param {usermanager.IYandexUserData=} [properties] Properties to set
         * @returns {usermanager.YandexUserData} YandexUserData instance
         */
        YandexUserData.create = function create(properties) {
            return new YandexUserData(properties);
        };

        /**
         * Encodes the specified YandexUserData message. Does not implicitly {@link usermanager.YandexUserData.verify|verify} messages.
         * @function encode
         * @memberof usermanager.YandexUserData
         * @static
         * @param {usermanager.IYandexUserData} message YandexUserData message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        YandexUserData.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.userId != null && Object.hasOwnProperty.call(message, "userId"))
                writer.uint32(/* id 1, wireType 0 =*/8).int64(message.userId);
            if (message.uid != null && Object.hasOwnProperty.call(message, "uid"))
                writer.uint32(/* id 2, wireType 0 =*/16).int64(message.uid);
            if (message.login != null && Object.hasOwnProperty.call(message, "login"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.login);
            return writer;
        };

        /**
         * Encodes the specified YandexUserData message, length delimited. Does not implicitly {@link usermanager.YandexUserData.verify|verify} messages.
         * @function encodeDelimited
         * @memberof usermanager.YandexUserData
         * @static
         * @param {usermanager.IYandexUserData} message YandexUserData message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        YandexUserData.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a YandexUserData message from the specified reader or buffer.
         * @function decode
         * @memberof usermanager.YandexUserData
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {usermanager.YandexUserData} YandexUserData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        YandexUserData.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.usermanager.YandexUserData();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.userId = reader.int64();
                    break;
                case 2:
                    message.uid = reader.int64();
                    break;
                case 3:
                    message.login = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a YandexUserData message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof usermanager.YandexUserData
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {usermanager.YandexUserData} YandexUserData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        YandexUserData.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a YandexUserData message.
         * @function verify
         * @memberof usermanager.YandexUserData
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        YandexUserData.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.userId != null && message.hasOwnProperty("userId"))
                if (!$util.isInteger(message.userId) && !(message.userId && $util.isInteger(message.userId.low) && $util.isInteger(message.userId.high)))
                    return "userId: integer|Long expected";
            if (message.uid != null && message.hasOwnProperty("uid"))
                if (!$util.isInteger(message.uid) && !(message.uid && $util.isInteger(message.uid.low) && $util.isInteger(message.uid.high)))
                    return "uid: integer|Long expected";
            if (message.login != null && message.hasOwnProperty("login"))
                if (!$util.isString(message.login))
                    return "login: string expected";
            return null;
        };

        /**
         * Creates a YandexUserData message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof usermanager.YandexUserData
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {usermanager.YandexUserData} YandexUserData
         */
        YandexUserData.fromObject = function fromObject(object) {
            if (object instanceof $root.usermanager.YandexUserData)
                return object;
            var message = new $root.usermanager.YandexUserData();
            if (object.userId != null)
                if ($util.Long)
                    (message.userId = $util.Long.fromValue(object.userId)).unsigned = false;
                else if (typeof object.userId === "string")
                    message.userId = parseInt(object.userId, 10);
                else if (typeof object.userId === "number")
                    message.userId = object.userId;
                else if (typeof object.userId === "object")
                    message.userId = new $util.LongBits(object.userId.low >>> 0, object.userId.high >>> 0).toNumber();
            if (object.uid != null)
                if ($util.Long)
                    (message.uid = $util.Long.fromValue(object.uid)).unsigned = false;
                else if (typeof object.uid === "string")
                    message.uid = parseInt(object.uid, 10);
                else if (typeof object.uid === "number")
                    message.uid = object.uid;
                else if (typeof object.uid === "object")
                    message.uid = new $util.LongBits(object.uid.low >>> 0, object.uid.high >>> 0).toNumber();
            if (object.login != null)
                message.login = String(object.login);
            return message;
        };

        /**
         * Creates a plain object from a YandexUserData message. Also converts values to other types if specified.
         * @function toObject
         * @memberof usermanager.YandexUserData
         * @static
         * @param {usermanager.YandexUserData} message YandexUserData
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        YandexUserData.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.userId = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.userId = options.longs === String ? "0" : 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.uid = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.uid = options.longs === String ? "0" : 0;
                object.login = "";
            }
            if (message.userId != null && message.hasOwnProperty("userId"))
                if (typeof message.userId === "number")
                    object.userId = options.longs === String ? String(message.userId) : message.userId;
                else
                    object.userId = options.longs === String ? $util.Long.prototype.toString.call(message.userId) : options.longs === Number ? new $util.LongBits(message.userId.low >>> 0, message.userId.high >>> 0).toNumber() : message.userId;
            if (message.uid != null && message.hasOwnProperty("uid"))
                if (typeof message.uid === "number")
                    object.uid = options.longs === String ? String(message.uid) : message.uid;
                else
                    object.uid = options.longs === String ? $util.Long.prototype.toString.call(message.uid) : options.longs === Number ? new $util.LongBits(message.uid.low >>> 0, message.uid.high >>> 0).toNumber() : message.uid;
            if (message.login != null && message.hasOwnProperty("login"))
                object.login = message.login;
            return object;
        };

        /**
         * Converts this YandexUserData to JSON.
         * @function toJSON
         * @memberof usermanager.YandexUserData
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        YandexUserData.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return YandexUserData;
    })();

    usermanager.UpdateYandexUserData = (function() {

        /**
         * Properties of an UpdateYandexUserData.
         * @memberof usermanager
         * @interface IUpdateYandexUserData
         * @property {number|null} [newUserId] UpdateYandexUserData newUserId
         * @property {number|null} [newUid] UpdateYandexUserData newUid
         * @property {string|null} [newLogin] UpdateYandexUserData newLogin
         */

        /**
         * Constructs a new UpdateYandexUserData.
         * @memberof usermanager
         * @classdesc Represents an UpdateYandexUserData.
         * @implements IUpdateYandexUserData
         * @constructor
         * @param {usermanager.IUpdateYandexUserData=} [properties] Properties to set
         */
        function UpdateYandexUserData(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * UpdateYandexUserData newUserId.
         * @member {number|null|undefined} newUserId
         * @memberof usermanager.UpdateYandexUserData
         * @instance
         */
        UpdateYandexUserData.prototype.newUserId = null;

        /**
         * UpdateYandexUserData newUid.
         * @member {number|null|undefined} newUid
         * @memberof usermanager.UpdateYandexUserData
         * @instance
         */
        UpdateYandexUserData.prototype.newUid = null;

        /**
         * UpdateYandexUserData newLogin.
         * @member {string|null|undefined} newLogin
         * @memberof usermanager.UpdateYandexUserData
         * @instance
         */
        UpdateYandexUserData.prototype.newLogin = null;

        // OneOf field names bound to virtual getters and setters
        var $oneOfFields;

        /**
         * UpdateYandexUserData updateUserId.
         * @member {"newUserId"|undefined} updateUserId
         * @memberof usermanager.UpdateYandexUserData
         * @instance
         */
        Object.defineProperty(UpdateYandexUserData.prototype, "updateUserId", {
            get: $util.oneOfGetter($oneOfFields = ["newUserId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * UpdateYandexUserData updateUid.
         * @member {"newUid"|undefined} updateUid
         * @memberof usermanager.UpdateYandexUserData
         * @instance
         */
        Object.defineProperty(UpdateYandexUserData.prototype, "updateUid", {
            get: $util.oneOfGetter($oneOfFields = ["newUid"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * UpdateYandexUserData _newLogin.
         * @member {"newLogin"|undefined} _newLogin
         * @memberof usermanager.UpdateYandexUserData
         * @instance
         */
        Object.defineProperty(UpdateYandexUserData.prototype, "_newLogin", {
            get: $util.oneOfGetter($oneOfFields = ["newLogin"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new UpdateYandexUserData instance using the specified properties.
         * @function create
         * @memberof usermanager.UpdateYandexUserData
         * @static
         * @param {usermanager.IUpdateYandexUserData=} [properties] Properties to set
         * @returns {usermanager.UpdateYandexUserData} UpdateYandexUserData instance
         */
        UpdateYandexUserData.create = function create(properties) {
            return new UpdateYandexUserData(properties);
        };

        /**
         * Encodes the specified UpdateYandexUserData message. Does not implicitly {@link usermanager.UpdateYandexUserData.verify|verify} messages.
         * @function encode
         * @memberof usermanager.UpdateYandexUserData
         * @static
         * @param {usermanager.IUpdateYandexUserData} message UpdateYandexUserData message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        UpdateYandexUserData.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.newUserId != null && Object.hasOwnProperty.call(message, "newUserId"))
                writer.uint32(/* id 1, wireType 0 =*/8).int64(message.newUserId);
            if (message.newUid != null && Object.hasOwnProperty.call(message, "newUid"))
                writer.uint32(/* id 2, wireType 0 =*/16).int64(message.newUid);
            if (message.newLogin != null && Object.hasOwnProperty.call(message, "newLogin"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.newLogin);
            return writer;
        };

        /**
         * Encodes the specified UpdateYandexUserData message, length delimited. Does not implicitly {@link usermanager.UpdateYandexUserData.verify|verify} messages.
         * @function encodeDelimited
         * @memberof usermanager.UpdateYandexUserData
         * @static
         * @param {usermanager.IUpdateYandexUserData} message UpdateYandexUserData message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        UpdateYandexUserData.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an UpdateYandexUserData message from the specified reader or buffer.
         * @function decode
         * @memberof usermanager.UpdateYandexUserData
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {usermanager.UpdateYandexUserData} UpdateYandexUserData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        UpdateYandexUserData.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.usermanager.UpdateYandexUserData();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.newUserId = reader.int64();
                    break;
                case 2:
                    message.newUid = reader.int64();
                    break;
                case 3:
                    message.newLogin = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an UpdateYandexUserData message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof usermanager.UpdateYandexUserData
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {usermanager.UpdateYandexUserData} UpdateYandexUserData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        UpdateYandexUserData.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an UpdateYandexUserData message.
         * @function verify
         * @memberof usermanager.UpdateYandexUserData
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        UpdateYandexUserData.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            var properties = {};
            if (message.newUserId != null && message.hasOwnProperty("newUserId")) {
                properties.updateUserId = 1;
                if (!$util.isInteger(message.newUserId) && !(message.newUserId && $util.isInteger(message.newUserId.low) && $util.isInteger(message.newUserId.high)))
                    return "newUserId: integer|Long expected";
            }
            if (message.newUid != null && message.hasOwnProperty("newUid")) {
                properties.updateUid = 1;
                if (!$util.isInteger(message.newUid) && !(message.newUid && $util.isInteger(message.newUid.low) && $util.isInteger(message.newUid.high)))
                    return "newUid: integer|Long expected";
            }
            if (message.newLogin != null && message.hasOwnProperty("newLogin")) {
                properties._newLogin = 1;
                if (!$util.isString(message.newLogin))
                    return "newLogin: string expected";
            }
            return null;
        };

        /**
         * Creates an UpdateYandexUserData message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof usermanager.UpdateYandexUserData
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {usermanager.UpdateYandexUserData} UpdateYandexUserData
         */
        UpdateYandexUserData.fromObject = function fromObject(object) {
            if (object instanceof $root.usermanager.UpdateYandexUserData)
                return object;
            var message = new $root.usermanager.UpdateYandexUserData();
            if (object.newUserId != null)
                if ($util.Long)
                    (message.newUserId = $util.Long.fromValue(object.newUserId)).unsigned = false;
                else if (typeof object.newUserId === "string")
                    message.newUserId = parseInt(object.newUserId, 10);
                else if (typeof object.newUserId === "number")
                    message.newUserId = object.newUserId;
                else if (typeof object.newUserId === "object")
                    message.newUserId = new $util.LongBits(object.newUserId.low >>> 0, object.newUserId.high >>> 0).toNumber();
            if (object.newUid != null)
                if ($util.Long)
                    (message.newUid = $util.Long.fromValue(object.newUid)).unsigned = false;
                else if (typeof object.newUid === "string")
                    message.newUid = parseInt(object.newUid, 10);
                else if (typeof object.newUid === "number")
                    message.newUid = object.newUid;
                else if (typeof object.newUid === "object")
                    message.newUid = new $util.LongBits(object.newUid.low >>> 0, object.newUid.high >>> 0).toNumber();
            if (object.newLogin != null)
                message.newLogin = String(object.newLogin);
            return message;
        };

        /**
         * Creates a plain object from an UpdateYandexUserData message. Also converts values to other types if specified.
         * @function toObject
         * @memberof usermanager.UpdateYandexUserData
         * @static
         * @param {usermanager.UpdateYandexUserData} message UpdateYandexUserData
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        UpdateYandexUserData.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (message.newUserId != null && message.hasOwnProperty("newUserId")) {
                if (typeof message.newUserId === "number")
                    object.newUserId = options.longs === String ? String(message.newUserId) : message.newUserId;
                else
                    object.newUserId = options.longs === String ? $util.Long.prototype.toString.call(message.newUserId) : options.longs === Number ? new $util.LongBits(message.newUserId.low >>> 0, message.newUserId.high >>> 0).toNumber() : message.newUserId;
                if (options.oneofs)
                    object.updateUserId = "newUserId";
            }
            if (message.newUid != null && message.hasOwnProperty("newUid")) {
                if (typeof message.newUid === "number")
                    object.newUid = options.longs === String ? String(message.newUid) : message.newUid;
                else
                    object.newUid = options.longs === String ? $util.Long.prototype.toString.call(message.newUid) : options.longs === Number ? new $util.LongBits(message.newUid.low >>> 0, message.newUid.high >>> 0).toNumber() : message.newUid;
                if (options.oneofs)
                    object.updateUid = "newUid";
            }
            if (message.newLogin != null && message.hasOwnProperty("newLogin")) {
                object.newLogin = message.newLogin;
                if (options.oneofs)
                    object._newLogin = "newLogin";
            }
            return object;
        };

        /**
         * Converts this UpdateYandexUserData to JSON.
         * @function toJSON
         * @memberof usermanager.UpdateYandexUserData
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        UpdateYandexUserData.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return UpdateYandexUserData;
    })();

    usermanager.UserResponse = (function() {

        /**
         * Properties of a UserResponse.
         * @memberof usermanager
         * @interface IUserResponse
         * @property {usermanager.IUser|null} [user] UserResponse user
         */

        /**
         * Constructs a new UserResponse.
         * @memberof usermanager
         * @classdesc Represents a UserResponse.
         * @implements IUserResponse
         * @constructor
         * @param {usermanager.IUserResponse=} [properties] Properties to set
         */
        function UserResponse(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * UserResponse user.
         * @member {usermanager.IUser|null|undefined} user
         * @memberof usermanager.UserResponse
         * @instance
         */
        UserResponse.prototype.user = null;

        /**
         * Creates a new UserResponse instance using the specified properties.
         * @function create
         * @memberof usermanager.UserResponse
         * @static
         * @param {usermanager.IUserResponse=} [properties] Properties to set
         * @returns {usermanager.UserResponse} UserResponse instance
         */
        UserResponse.create = function create(properties) {
            return new UserResponse(properties);
        };

        /**
         * Encodes the specified UserResponse message. Does not implicitly {@link usermanager.UserResponse.verify|verify} messages.
         * @function encode
         * @memberof usermanager.UserResponse
         * @static
         * @param {usermanager.IUserResponse} message UserResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        UserResponse.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.user != null && Object.hasOwnProperty.call(message, "user"))
                $root.usermanager.User.encode(message.user, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified UserResponse message, length delimited. Does not implicitly {@link usermanager.UserResponse.verify|verify} messages.
         * @function encodeDelimited
         * @memberof usermanager.UserResponse
         * @static
         * @param {usermanager.IUserResponse} message UserResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        UserResponse.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a UserResponse message from the specified reader or buffer.
         * @function decode
         * @memberof usermanager.UserResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {usermanager.UserResponse} UserResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        UserResponse.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.usermanager.UserResponse();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.user = $root.usermanager.User.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a UserResponse message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof usermanager.UserResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {usermanager.UserResponse} UserResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        UserResponse.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a UserResponse message.
         * @function verify
         * @memberof usermanager.UserResponse
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        UserResponse.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.user != null && message.hasOwnProperty("user")) {
                var error = $root.usermanager.User.verify(message.user);
                if (error)
                    return "user." + error;
            }
            return null;
        };

        /**
         * Creates a UserResponse message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof usermanager.UserResponse
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {usermanager.UserResponse} UserResponse
         */
        UserResponse.fromObject = function fromObject(object) {
            if (object instanceof $root.usermanager.UserResponse)
                return object;
            var message = new $root.usermanager.UserResponse();
            if (object.user != null) {
                if (typeof object.user !== "object")
                    throw TypeError(".usermanager.UserResponse.user: object expected");
                message.user = $root.usermanager.User.fromObject(object.user);
            }
            return message;
        };

        /**
         * Creates a plain object from a UserResponse message. Also converts values to other types if specified.
         * @function toObject
         * @memberof usermanager.UserResponse
         * @static
         * @param {usermanager.UserResponse} message UserResponse
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        UserResponse.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.user = null;
            if (message.user != null && message.hasOwnProperty("user"))
                object.user = $root.usermanager.User.toObject(message.user, options);
            return object;
        };

        /**
         * Converts this UserResponse to JSON.
         * @function toJSON
         * @memberof usermanager.UserResponse
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        UserResponse.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return UserResponse;
    })();

    usermanager.UsersResponse = (function() {

        /**
         * Properties of a UsersResponse.
         * @memberof usermanager
         * @interface IUsersResponse
         * @property {Array.<usermanager.IUser>|null} [users] UsersResponse users
         */

        /**
         * Constructs a new UsersResponse.
         * @memberof usermanager
         * @classdesc Represents a UsersResponse.
         * @implements IUsersResponse
         * @constructor
         * @param {usermanager.IUsersResponse=} [properties] Properties to set
         */
        function UsersResponse(properties) {
            this.users = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * UsersResponse users.
         * @member {Array.<usermanager.IUser>} users
         * @memberof usermanager.UsersResponse
         * @instance
         */
        UsersResponse.prototype.users = $util.emptyArray;

        /**
         * Creates a new UsersResponse instance using the specified properties.
         * @function create
         * @memberof usermanager.UsersResponse
         * @static
         * @param {usermanager.IUsersResponse=} [properties] Properties to set
         * @returns {usermanager.UsersResponse} UsersResponse instance
         */
        UsersResponse.create = function create(properties) {
            return new UsersResponse(properties);
        };

        /**
         * Encodes the specified UsersResponse message. Does not implicitly {@link usermanager.UsersResponse.verify|verify} messages.
         * @function encode
         * @memberof usermanager.UsersResponse
         * @static
         * @param {usermanager.IUsersResponse} message UsersResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        UsersResponse.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.users != null && message.users.length)
                for (var i = 0; i < message.users.length; ++i)
                    $root.usermanager.User.encode(message.users[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified UsersResponse message, length delimited. Does not implicitly {@link usermanager.UsersResponse.verify|verify} messages.
         * @function encodeDelimited
         * @memberof usermanager.UsersResponse
         * @static
         * @param {usermanager.IUsersResponse} message UsersResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        UsersResponse.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a UsersResponse message from the specified reader or buffer.
         * @function decode
         * @memberof usermanager.UsersResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {usermanager.UsersResponse} UsersResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        UsersResponse.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.usermanager.UsersResponse();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    if (!(message.users && message.users.length))
                        message.users = [];
                    message.users.push($root.usermanager.User.decode(reader, reader.uint32()));
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a UsersResponse message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof usermanager.UsersResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {usermanager.UsersResponse} UsersResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        UsersResponse.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a UsersResponse message.
         * @function verify
         * @memberof usermanager.UsersResponse
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        UsersResponse.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.users != null && message.hasOwnProperty("users")) {
                if (!Array.isArray(message.users))
                    return "users: array expected";
                for (var i = 0; i < message.users.length; ++i) {
                    var error = $root.usermanager.User.verify(message.users[i]);
                    if (error)
                        return "users." + error;
                }
            }
            return null;
        };

        /**
         * Creates a UsersResponse message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof usermanager.UsersResponse
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {usermanager.UsersResponse} UsersResponse
         */
        UsersResponse.fromObject = function fromObject(object) {
            if (object instanceof $root.usermanager.UsersResponse)
                return object;
            var message = new $root.usermanager.UsersResponse();
            if (object.users) {
                if (!Array.isArray(object.users))
                    throw TypeError(".usermanager.UsersResponse.users: array expected");
                message.users = [];
                for (var i = 0; i < object.users.length; ++i) {
                    if (typeof object.users[i] !== "object")
                        throw TypeError(".usermanager.UsersResponse.users: object expected");
                    message.users[i] = $root.usermanager.User.fromObject(object.users[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a UsersResponse message. Also converts values to other types if specified.
         * @function toObject
         * @memberof usermanager.UsersResponse
         * @static
         * @param {usermanager.UsersResponse} message UsersResponse
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        UsersResponse.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.users = [];
            if (message.users && message.users.length) {
                object.users = [];
                for (var j = 0; j < message.users.length; ++j)
                    object.users[j] = $root.usermanager.User.toObject(message.users[j], options);
            }
            return object;
        };

        /**
         * Converts this UsersResponse to JSON.
         * @function toJSON
         * @memberof usermanager.UsersResponse
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        UsersResponse.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return UsersResponse;
    })();

    usermanager.OrganizationUsersResponse = (function() {

        /**
         * Properties of an OrganizationUsersResponse.
         * @memberof usermanager
         * @interface IOrganizationUsersResponse
         * @property {Array.<number>|null} [usersId] OrganizationUsersResponse usersId
         */

        /**
         * Constructs a new OrganizationUsersResponse.
         * @memberof usermanager
         * @classdesc Represents an OrganizationUsersResponse.
         * @implements IOrganizationUsersResponse
         * @constructor
         * @param {usermanager.IOrganizationUsersResponse=} [properties] Properties to set
         */
        function OrganizationUsersResponse(properties) {
            this.usersId = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * OrganizationUsersResponse usersId.
         * @member {Array.<number>} usersId
         * @memberof usermanager.OrganizationUsersResponse
         * @instance
         */
        OrganizationUsersResponse.prototype.usersId = $util.emptyArray;

        /**
         * Creates a new OrganizationUsersResponse instance using the specified properties.
         * @function create
         * @memberof usermanager.OrganizationUsersResponse
         * @static
         * @param {usermanager.IOrganizationUsersResponse=} [properties] Properties to set
         * @returns {usermanager.OrganizationUsersResponse} OrganizationUsersResponse instance
         */
        OrganizationUsersResponse.create = function create(properties) {
            return new OrganizationUsersResponse(properties);
        };

        /**
         * Encodes the specified OrganizationUsersResponse message. Does not implicitly {@link usermanager.OrganizationUsersResponse.verify|verify} messages.
         * @function encode
         * @memberof usermanager.OrganizationUsersResponse
         * @static
         * @param {usermanager.IOrganizationUsersResponse} message OrganizationUsersResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        OrganizationUsersResponse.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.usersId != null && message.usersId.length) {
                writer.uint32(/* id 1, wireType 2 =*/10).fork();
                for (var i = 0; i < message.usersId.length; ++i)
                    writer.int64(message.usersId[i]);
                writer.ldelim();
            }
            return writer;
        };

        /**
         * Encodes the specified OrganizationUsersResponse message, length delimited. Does not implicitly {@link usermanager.OrganizationUsersResponse.verify|verify} messages.
         * @function encodeDelimited
         * @memberof usermanager.OrganizationUsersResponse
         * @static
         * @param {usermanager.IOrganizationUsersResponse} message OrganizationUsersResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        OrganizationUsersResponse.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an OrganizationUsersResponse message from the specified reader or buffer.
         * @function decode
         * @memberof usermanager.OrganizationUsersResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {usermanager.OrganizationUsersResponse} OrganizationUsersResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        OrganizationUsersResponse.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.usermanager.OrganizationUsersResponse();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    if (!(message.usersId && message.usersId.length))
                        message.usersId = [];
                    if ((tag & 7) === 2) {
                        var end2 = reader.uint32() + reader.pos;
                        while (reader.pos < end2)
                            message.usersId.push(reader.int64());
                    } else
                        message.usersId.push(reader.int64());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an OrganizationUsersResponse message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof usermanager.OrganizationUsersResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {usermanager.OrganizationUsersResponse} OrganizationUsersResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        OrganizationUsersResponse.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an OrganizationUsersResponse message.
         * @function verify
         * @memberof usermanager.OrganizationUsersResponse
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        OrganizationUsersResponse.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.usersId != null && message.hasOwnProperty("usersId")) {
                if (!Array.isArray(message.usersId))
                    return "usersId: array expected";
                for (var i = 0; i < message.usersId.length; ++i)
                    if (!$util.isInteger(message.usersId[i]) && !(message.usersId[i] && $util.isInteger(message.usersId[i].low) && $util.isInteger(message.usersId[i].high)))
                        return "usersId: integer|Long[] expected";
            }
            return null;
        };

        /**
         * Creates an OrganizationUsersResponse message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof usermanager.OrganizationUsersResponse
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {usermanager.OrganizationUsersResponse} OrganizationUsersResponse
         */
        OrganizationUsersResponse.fromObject = function fromObject(object) {
            if (object instanceof $root.usermanager.OrganizationUsersResponse)
                return object;
            var message = new $root.usermanager.OrganizationUsersResponse();
            if (object.usersId) {
                if (!Array.isArray(object.usersId))
                    throw TypeError(".usermanager.OrganizationUsersResponse.usersId: array expected");
                message.usersId = [];
                for (var i = 0; i < object.usersId.length; ++i)
                    if ($util.Long)
                        (message.usersId[i] = $util.Long.fromValue(object.usersId[i])).unsigned = false;
                    else if (typeof object.usersId[i] === "string")
                        message.usersId[i] = parseInt(object.usersId[i], 10);
                    else if (typeof object.usersId[i] === "number")
                        message.usersId[i] = object.usersId[i];
                    else if (typeof object.usersId[i] === "object")
                        message.usersId[i] = new $util.LongBits(object.usersId[i].low >>> 0, object.usersId[i].high >>> 0).toNumber();
            }
            return message;
        };

        /**
         * Creates a plain object from an OrganizationUsersResponse message. Also converts values to other types if specified.
         * @function toObject
         * @memberof usermanager.OrganizationUsersResponse
         * @static
         * @param {usermanager.OrganizationUsersResponse} message OrganizationUsersResponse
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        OrganizationUsersResponse.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.usersId = [];
            if (message.usersId && message.usersId.length) {
                object.usersId = [];
                for (var j = 0; j < message.usersId.length; ++j)
                    if (typeof message.usersId[j] === "number")
                        object.usersId[j] = options.longs === String ? String(message.usersId[j]) : message.usersId[j];
                    else
                        object.usersId[j] = options.longs === String ? $util.Long.prototype.toString.call(message.usersId[j]) : options.longs === Number ? new $util.LongBits(message.usersId[j].low >>> 0, message.usersId[j].high >>> 0).toNumber() : message.usersId[j];
            }
            return object;
        };

        /**
         * Converts this OrganizationUsersResponse to JSON.
         * @function toJSON
         * @memberof usermanager.OrganizationUsersResponse
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        OrganizationUsersResponse.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return OrganizationUsersResponse;
    })();

    return usermanager;
})();

$root.organizationmanager = (function() {

    /**
     * Namespace organizationmanager.
     * @exports organizationmanager
     * @namespace
     */
    var organizationmanager = {};

    organizationmanager.Organization = (function() {

        /**
         * Properties of an Organization.
         * @memberof organizationmanager
         * @interface IOrganization
         * @property {organizationmanager.IOrganizationId|null} [id] Organization id
         * @property {organizationmanager.IOrganizationData|null} [data] Organization data
         */

        /**
         * Constructs a new Organization.
         * @memberof organizationmanager
         * @classdesc Represents an Organization.
         * @implements IOrganization
         * @constructor
         * @param {organizationmanager.IOrganization=} [properties] Properties to set
         */
        function Organization(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Organization id.
         * @member {organizationmanager.IOrganizationId|null|undefined} id
         * @memberof organizationmanager.Organization
         * @instance
         */
        Organization.prototype.id = null;

        /**
         * Organization data.
         * @member {organizationmanager.IOrganizationData|null|undefined} data
         * @memberof organizationmanager.Organization
         * @instance
         */
        Organization.prototype.data = null;

        /**
         * Creates a new Organization instance using the specified properties.
         * @function create
         * @memberof organizationmanager.Organization
         * @static
         * @param {organizationmanager.IOrganization=} [properties] Properties to set
         * @returns {organizationmanager.Organization} Organization instance
         */
        Organization.create = function create(properties) {
            return new Organization(properties);
        };

        /**
         * Encodes the specified Organization message. Does not implicitly {@link organizationmanager.Organization.verify|verify} messages.
         * @function encode
         * @memberof organizationmanager.Organization
         * @static
         * @param {organizationmanager.IOrganization} message Organization message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Organization.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.id != null && Object.hasOwnProperty.call(message, "id"))
                $root.organizationmanager.OrganizationId.encode(message.id, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.data != null && Object.hasOwnProperty.call(message, "data"))
                $root.organizationmanager.OrganizationData.encode(message.data, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified Organization message, length delimited. Does not implicitly {@link organizationmanager.Organization.verify|verify} messages.
         * @function encodeDelimited
         * @memberof organizationmanager.Organization
         * @static
         * @param {organizationmanager.IOrganization} message Organization message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Organization.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an Organization message from the specified reader or buffer.
         * @function decode
         * @memberof organizationmanager.Organization
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {organizationmanager.Organization} Organization
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Organization.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.organizationmanager.Organization();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.id = $root.organizationmanager.OrganizationId.decode(reader, reader.uint32());
                    break;
                case 2:
                    message.data = $root.organizationmanager.OrganizationData.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an Organization message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof organizationmanager.Organization
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {organizationmanager.Organization} Organization
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Organization.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an Organization message.
         * @function verify
         * @memberof organizationmanager.Organization
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Organization.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.id != null && message.hasOwnProperty("id")) {
                var error = $root.organizationmanager.OrganizationId.verify(message.id);
                if (error)
                    return "id." + error;
            }
            if (message.data != null && message.hasOwnProperty("data")) {
                var error = $root.organizationmanager.OrganizationData.verify(message.data);
                if (error)
                    return "data." + error;
            }
            return null;
        };

        /**
         * Creates an Organization message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof organizationmanager.Organization
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {organizationmanager.Organization} Organization
         */
        Organization.fromObject = function fromObject(object) {
            if (object instanceof $root.organizationmanager.Organization)
                return object;
            var message = new $root.organizationmanager.Organization();
            if (object.id != null) {
                if (typeof object.id !== "object")
                    throw TypeError(".organizationmanager.Organization.id: object expected");
                message.id = $root.organizationmanager.OrganizationId.fromObject(object.id);
            }
            if (object.data != null) {
                if (typeof object.data !== "object")
                    throw TypeError(".organizationmanager.Organization.data: object expected");
                message.data = $root.organizationmanager.OrganizationData.fromObject(object.data);
            }
            return message;
        };

        /**
         * Creates a plain object from an Organization message. Also converts values to other types if specified.
         * @function toObject
         * @memberof organizationmanager.Organization
         * @static
         * @param {organizationmanager.Organization} message Organization
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Organization.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.id = null;
                object.data = null;
            }
            if (message.id != null && message.hasOwnProperty("id"))
                object.id = $root.organizationmanager.OrganizationId.toObject(message.id, options);
            if (message.data != null && message.hasOwnProperty("data"))
                object.data = $root.organizationmanager.OrganizationData.toObject(message.data, options);
            return object;
        };

        /**
         * Converts this Organization to JSON.
         * @function toJSON
         * @memberof organizationmanager.Organization
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Organization.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return Organization;
    })();

    organizationmanager.OrganizationId = (function() {

        /**
         * Properties of an OrganizationId.
         * @memberof organizationmanager
         * @interface IOrganizationId
         * @property {number|null} [value] OrganizationId value
         */

        /**
         * Constructs a new OrganizationId.
         * @memberof organizationmanager
         * @classdesc Represents an OrganizationId.
         * @implements IOrganizationId
         * @constructor
         * @param {organizationmanager.IOrganizationId=} [properties] Properties to set
         */
        function OrganizationId(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * OrganizationId value.
         * @member {number} value
         * @memberof organizationmanager.OrganizationId
         * @instance
         */
        OrganizationId.prototype.value = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * Creates a new OrganizationId instance using the specified properties.
         * @function create
         * @memberof organizationmanager.OrganizationId
         * @static
         * @param {organizationmanager.IOrganizationId=} [properties] Properties to set
         * @returns {organizationmanager.OrganizationId} OrganizationId instance
         */
        OrganizationId.create = function create(properties) {
            return new OrganizationId(properties);
        };

        /**
         * Encodes the specified OrganizationId message. Does not implicitly {@link organizationmanager.OrganizationId.verify|verify} messages.
         * @function encode
         * @memberof organizationmanager.OrganizationId
         * @static
         * @param {organizationmanager.IOrganizationId} message OrganizationId message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        OrganizationId.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.value != null && Object.hasOwnProperty.call(message, "value"))
                writer.uint32(/* id 1, wireType 0 =*/8).int64(message.value);
            return writer;
        };

        /**
         * Encodes the specified OrganizationId message, length delimited. Does not implicitly {@link organizationmanager.OrganizationId.verify|verify} messages.
         * @function encodeDelimited
         * @memberof organizationmanager.OrganizationId
         * @static
         * @param {organizationmanager.IOrganizationId} message OrganizationId message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        OrganizationId.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an OrganizationId message from the specified reader or buffer.
         * @function decode
         * @memberof organizationmanager.OrganizationId
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {organizationmanager.OrganizationId} OrganizationId
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        OrganizationId.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.organizationmanager.OrganizationId();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.value = reader.int64();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an OrganizationId message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof organizationmanager.OrganizationId
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {organizationmanager.OrganizationId} OrganizationId
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        OrganizationId.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an OrganizationId message.
         * @function verify
         * @memberof organizationmanager.OrganizationId
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        OrganizationId.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.value != null && message.hasOwnProperty("value"))
                if (!$util.isInteger(message.value) && !(message.value && $util.isInteger(message.value.low) && $util.isInteger(message.value.high)))
                    return "value: integer|Long expected";
            return null;
        };

        /**
         * Creates an OrganizationId message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof organizationmanager.OrganizationId
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {organizationmanager.OrganizationId} OrganizationId
         */
        OrganizationId.fromObject = function fromObject(object) {
            if (object instanceof $root.organizationmanager.OrganizationId)
                return object;
            var message = new $root.organizationmanager.OrganizationId();
            if (object.value != null)
                if ($util.Long)
                    (message.value = $util.Long.fromValue(object.value)).unsigned = false;
                else if (typeof object.value === "string")
                    message.value = parseInt(object.value, 10);
                else if (typeof object.value === "number")
                    message.value = object.value;
                else if (typeof object.value === "object")
                    message.value = new $util.LongBits(object.value.low >>> 0, object.value.high >>> 0).toNumber();
            return message;
        };

        /**
         * Creates a plain object from an OrganizationId message. Also converts values to other types if specified.
         * @function toObject
         * @memberof organizationmanager.OrganizationId
         * @static
         * @param {organizationmanager.OrganizationId} message OrganizationId
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        OrganizationId.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.value = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.value = options.longs === String ? "0" : 0;
            if (message.value != null && message.hasOwnProperty("value"))
                if (typeof message.value === "number")
                    object.value = options.longs === String ? String(message.value) : message.value;
                else
                    object.value = options.longs === String ? $util.Long.prototype.toString.call(message.value) : options.longs === Number ? new $util.LongBits(message.value.low >>> 0, message.value.high >>> 0).toNumber() : message.value;
            return object;
        };

        /**
         * Converts this OrganizationId to JSON.
         * @function toJSON
         * @memberof organizationmanager.OrganizationId
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        OrganizationId.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return OrganizationId;
    })();

    organizationmanager.OrganizationData = (function() {

        /**
         * Properties of an OrganizationData.
         * @memberof organizationmanager
         * @interface IOrganizationData
         * @property {number|null} [pool] OrganizationData pool
         * @property {string|null} [slug] OrganizationData slug
         * @property {string|null} [name] OrganizationData name
         */

        /**
         * Constructs a new OrganizationData.
         * @memberof organizationmanager
         * @classdesc Represents an OrganizationData.
         * @implements IOrganizationData
         * @constructor
         * @param {organizationmanager.IOrganizationData=} [properties] Properties to set
         */
        function OrganizationData(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * OrganizationData pool.
         * @member {number} pool
         * @memberof organizationmanager.OrganizationData
         * @instance
         */
        OrganizationData.prototype.pool = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * OrganizationData slug.
         * @member {string} slug
         * @memberof organizationmanager.OrganizationData
         * @instance
         */
        OrganizationData.prototype.slug = "";

        /**
         * OrganizationData name.
         * @member {string} name
         * @memberof organizationmanager.OrganizationData
         * @instance
         */
        OrganizationData.prototype.name = "";

        /**
         * Creates a new OrganizationData instance using the specified properties.
         * @function create
         * @memberof organizationmanager.OrganizationData
         * @static
         * @param {organizationmanager.IOrganizationData=} [properties] Properties to set
         * @returns {organizationmanager.OrganizationData} OrganizationData instance
         */
        OrganizationData.create = function create(properties) {
            return new OrganizationData(properties);
        };

        /**
         * Encodes the specified OrganizationData message. Does not implicitly {@link organizationmanager.OrganizationData.verify|verify} messages.
         * @function encode
         * @memberof organizationmanager.OrganizationData
         * @static
         * @param {organizationmanager.IOrganizationData} message OrganizationData message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        OrganizationData.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.pool != null && Object.hasOwnProperty.call(message, "pool"))
                writer.uint32(/* id 1, wireType 0 =*/8).int64(message.pool);
            if (message.slug != null && Object.hasOwnProperty.call(message, "slug"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.slug);
            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.name);
            return writer;
        };

        /**
         * Encodes the specified OrganizationData message, length delimited. Does not implicitly {@link organizationmanager.OrganizationData.verify|verify} messages.
         * @function encodeDelimited
         * @memberof organizationmanager.OrganizationData
         * @static
         * @param {organizationmanager.IOrganizationData} message OrganizationData message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        OrganizationData.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an OrganizationData message from the specified reader or buffer.
         * @function decode
         * @memberof organizationmanager.OrganizationData
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {organizationmanager.OrganizationData} OrganizationData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        OrganizationData.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.organizationmanager.OrganizationData();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.pool = reader.int64();
                    break;
                case 2:
                    message.slug = reader.string();
                    break;
                case 3:
                    message.name = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an OrganizationData message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof organizationmanager.OrganizationData
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {organizationmanager.OrganizationData} OrganizationData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        OrganizationData.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an OrganizationData message.
         * @function verify
         * @memberof organizationmanager.OrganizationData
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        OrganizationData.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.pool != null && message.hasOwnProperty("pool"))
                if (!$util.isInteger(message.pool) && !(message.pool && $util.isInteger(message.pool.low) && $util.isInteger(message.pool.high)))
                    return "pool: integer|Long expected";
            if (message.slug != null && message.hasOwnProperty("slug"))
                if (!$util.isString(message.slug))
                    return "slug: string expected";
            if (message.name != null && message.hasOwnProperty("name"))
                if (!$util.isString(message.name))
                    return "name: string expected";
            return null;
        };

        /**
         * Creates an OrganizationData message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof organizationmanager.OrganizationData
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {organizationmanager.OrganizationData} OrganizationData
         */
        OrganizationData.fromObject = function fromObject(object) {
            if (object instanceof $root.organizationmanager.OrganizationData)
                return object;
            var message = new $root.organizationmanager.OrganizationData();
            if (object.pool != null)
                if ($util.Long)
                    (message.pool = $util.Long.fromValue(object.pool)).unsigned = false;
                else if (typeof object.pool === "string")
                    message.pool = parseInt(object.pool, 10);
                else if (typeof object.pool === "number")
                    message.pool = object.pool;
                else if (typeof object.pool === "object")
                    message.pool = new $util.LongBits(object.pool.low >>> 0, object.pool.high >>> 0).toNumber();
            if (object.slug != null)
                message.slug = String(object.slug);
            if (object.name != null)
                message.name = String(object.name);
            return message;
        };

        /**
         * Creates a plain object from an OrganizationData message. Also converts values to other types if specified.
         * @function toObject
         * @memberof organizationmanager.OrganizationData
         * @static
         * @param {organizationmanager.OrganizationData} message OrganizationData
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        OrganizationData.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.pool = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.pool = options.longs === String ? "0" : 0;
                object.slug = "";
                object.name = "";
            }
            if (message.pool != null && message.hasOwnProperty("pool"))
                if (typeof message.pool === "number")
                    object.pool = options.longs === String ? String(message.pool) : message.pool;
                else
                    object.pool = options.longs === String ? $util.Long.prototype.toString.call(message.pool) : options.longs === Number ? new $util.LongBits(message.pool.low >>> 0, message.pool.high >>> 0).toNumber() : message.pool;
            if (message.slug != null && message.hasOwnProperty("slug"))
                object.slug = message.slug;
            if (message.name != null && message.hasOwnProperty("name"))
                object.name = message.name;
            return object;
        };

        /**
         * Converts this OrganizationData to JSON.
         * @function toJSON
         * @memberof organizationmanager.OrganizationData
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        OrganizationData.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return OrganizationData;
    })();

    organizationmanager.UpdateOrganizationData = (function() {

        /**
         * Properties of an UpdateOrganizationData.
         * @memberof organizationmanager
         * @interface IUpdateOrganizationData
         * @property {number|null} [newPool] UpdateOrganizationData newPool
         * @property {string|null} [newSlug] UpdateOrganizationData newSlug
         * @property {string|null} [newName] UpdateOrganizationData newName
         */

        /**
         * Constructs a new UpdateOrganizationData.
         * @memberof organizationmanager
         * @classdesc Represents an UpdateOrganizationData.
         * @implements IUpdateOrganizationData
         * @constructor
         * @param {organizationmanager.IUpdateOrganizationData=} [properties] Properties to set
         */
        function UpdateOrganizationData(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * UpdateOrganizationData newPool.
         * @member {number|null|undefined} newPool
         * @memberof organizationmanager.UpdateOrganizationData
         * @instance
         */
        UpdateOrganizationData.prototype.newPool = null;

        /**
         * UpdateOrganizationData newSlug.
         * @member {string|null|undefined} newSlug
         * @memberof organizationmanager.UpdateOrganizationData
         * @instance
         */
        UpdateOrganizationData.prototype.newSlug = null;

        /**
         * UpdateOrganizationData newName.
         * @member {string|null|undefined} newName
         * @memberof organizationmanager.UpdateOrganizationData
         * @instance
         */
        UpdateOrganizationData.prototype.newName = null;

        // OneOf field names bound to virtual getters and setters
        var $oneOfFields;

        /**
         * UpdateOrganizationData updatePool.
         * @member {"newPool"|undefined} updatePool
         * @memberof organizationmanager.UpdateOrganizationData
         * @instance
         */
        Object.defineProperty(UpdateOrganizationData.prototype, "updatePool", {
            get: $util.oneOfGetter($oneOfFields = ["newPool"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * UpdateOrganizationData _newSlug.
         * @member {"newSlug"|undefined} _newSlug
         * @memberof organizationmanager.UpdateOrganizationData
         * @instance
         */
        Object.defineProperty(UpdateOrganizationData.prototype, "_newSlug", {
            get: $util.oneOfGetter($oneOfFields = ["newSlug"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * UpdateOrganizationData _newName.
         * @member {"newName"|undefined} _newName
         * @memberof organizationmanager.UpdateOrganizationData
         * @instance
         */
        Object.defineProperty(UpdateOrganizationData.prototype, "_newName", {
            get: $util.oneOfGetter($oneOfFields = ["newName"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new UpdateOrganizationData instance using the specified properties.
         * @function create
         * @memberof organizationmanager.UpdateOrganizationData
         * @static
         * @param {organizationmanager.IUpdateOrganizationData=} [properties] Properties to set
         * @returns {organizationmanager.UpdateOrganizationData} UpdateOrganizationData instance
         */
        UpdateOrganizationData.create = function create(properties) {
            return new UpdateOrganizationData(properties);
        };

        /**
         * Encodes the specified UpdateOrganizationData message. Does not implicitly {@link organizationmanager.UpdateOrganizationData.verify|verify} messages.
         * @function encode
         * @memberof organizationmanager.UpdateOrganizationData
         * @static
         * @param {organizationmanager.IUpdateOrganizationData} message UpdateOrganizationData message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        UpdateOrganizationData.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.newPool != null && Object.hasOwnProperty.call(message, "newPool"))
                writer.uint32(/* id 1, wireType 0 =*/8).int64(message.newPool);
            if (message.newSlug != null && Object.hasOwnProperty.call(message, "newSlug"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.newSlug);
            if (message.newName != null && Object.hasOwnProperty.call(message, "newName"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.newName);
            return writer;
        };

        /**
         * Encodes the specified UpdateOrganizationData message, length delimited. Does not implicitly {@link organizationmanager.UpdateOrganizationData.verify|verify} messages.
         * @function encodeDelimited
         * @memberof organizationmanager.UpdateOrganizationData
         * @static
         * @param {organizationmanager.IUpdateOrganizationData} message UpdateOrganizationData message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        UpdateOrganizationData.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an UpdateOrganizationData message from the specified reader or buffer.
         * @function decode
         * @memberof organizationmanager.UpdateOrganizationData
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {organizationmanager.UpdateOrganizationData} UpdateOrganizationData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        UpdateOrganizationData.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.organizationmanager.UpdateOrganizationData();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.newPool = reader.int64();
                    break;
                case 2:
                    message.newSlug = reader.string();
                    break;
                case 3:
                    message.newName = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an UpdateOrganizationData message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof organizationmanager.UpdateOrganizationData
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {organizationmanager.UpdateOrganizationData} UpdateOrganizationData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        UpdateOrganizationData.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an UpdateOrganizationData message.
         * @function verify
         * @memberof organizationmanager.UpdateOrganizationData
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        UpdateOrganizationData.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            var properties = {};
            if (message.newPool != null && message.hasOwnProperty("newPool")) {
                properties.updatePool = 1;
                if (!$util.isInteger(message.newPool) && !(message.newPool && $util.isInteger(message.newPool.low) && $util.isInteger(message.newPool.high)))
                    return "newPool: integer|Long expected";
            }
            if (message.newSlug != null && message.hasOwnProperty("newSlug")) {
                properties._newSlug = 1;
                if (!$util.isString(message.newSlug))
                    return "newSlug: string expected";
            }
            if (message.newName != null && message.hasOwnProperty("newName")) {
                properties._newName = 1;
                if (!$util.isString(message.newName))
                    return "newName: string expected";
            }
            return null;
        };

        /**
         * Creates an UpdateOrganizationData message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof organizationmanager.UpdateOrganizationData
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {organizationmanager.UpdateOrganizationData} UpdateOrganizationData
         */
        UpdateOrganizationData.fromObject = function fromObject(object) {
            if (object instanceof $root.organizationmanager.UpdateOrganizationData)
                return object;
            var message = new $root.organizationmanager.UpdateOrganizationData();
            if (object.newPool != null)
                if ($util.Long)
                    (message.newPool = $util.Long.fromValue(object.newPool)).unsigned = false;
                else if (typeof object.newPool === "string")
                    message.newPool = parseInt(object.newPool, 10);
                else if (typeof object.newPool === "number")
                    message.newPool = object.newPool;
                else if (typeof object.newPool === "object")
                    message.newPool = new $util.LongBits(object.newPool.low >>> 0, object.newPool.high >>> 0).toNumber();
            if (object.newSlug != null)
                message.newSlug = String(object.newSlug);
            if (object.newName != null)
                message.newName = String(object.newName);
            return message;
        };

        /**
         * Creates a plain object from an UpdateOrganizationData message. Also converts values to other types if specified.
         * @function toObject
         * @memberof organizationmanager.UpdateOrganizationData
         * @static
         * @param {organizationmanager.UpdateOrganizationData} message UpdateOrganizationData
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        UpdateOrganizationData.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (message.newPool != null && message.hasOwnProperty("newPool")) {
                if (typeof message.newPool === "number")
                    object.newPool = options.longs === String ? String(message.newPool) : message.newPool;
                else
                    object.newPool = options.longs === String ? $util.Long.prototype.toString.call(message.newPool) : options.longs === Number ? new $util.LongBits(message.newPool.low >>> 0, message.newPool.high >>> 0).toNumber() : message.newPool;
                if (options.oneofs)
                    object.updatePool = "newPool";
            }
            if (message.newSlug != null && message.hasOwnProperty("newSlug")) {
                object.newSlug = message.newSlug;
                if (options.oneofs)
                    object._newSlug = "newSlug";
            }
            if (message.newName != null && message.hasOwnProperty("newName")) {
                object.newName = message.newName;
                if (options.oneofs)
                    object._newName = "newName";
            }
            return object;
        };

        /**
         * Converts this UpdateOrganizationData to JSON.
         * @function toJSON
         * @memberof organizationmanager.UpdateOrganizationData
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        UpdateOrganizationData.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return UpdateOrganizationData;
    })();

    organizationmanager.OrganizationResponse = (function() {

        /**
         * Properties of an OrganizationResponse.
         * @memberof organizationmanager
         * @interface IOrganizationResponse
         * @property {organizationmanager.IOrganization|null} [organization] OrganizationResponse organization
         */

        /**
         * Constructs a new OrganizationResponse.
         * @memberof organizationmanager
         * @classdesc Represents an OrganizationResponse.
         * @implements IOrganizationResponse
         * @constructor
         * @param {organizationmanager.IOrganizationResponse=} [properties] Properties to set
         */
        function OrganizationResponse(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * OrganizationResponse organization.
         * @member {organizationmanager.IOrganization|null|undefined} organization
         * @memberof organizationmanager.OrganizationResponse
         * @instance
         */
        OrganizationResponse.prototype.organization = null;

        /**
         * Creates a new OrganizationResponse instance using the specified properties.
         * @function create
         * @memberof organizationmanager.OrganizationResponse
         * @static
         * @param {organizationmanager.IOrganizationResponse=} [properties] Properties to set
         * @returns {organizationmanager.OrganizationResponse} OrganizationResponse instance
         */
        OrganizationResponse.create = function create(properties) {
            return new OrganizationResponse(properties);
        };

        /**
         * Encodes the specified OrganizationResponse message. Does not implicitly {@link organizationmanager.OrganizationResponse.verify|verify} messages.
         * @function encode
         * @memberof organizationmanager.OrganizationResponse
         * @static
         * @param {organizationmanager.IOrganizationResponse} message OrganizationResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        OrganizationResponse.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.organization != null && Object.hasOwnProperty.call(message, "organization"))
                $root.organizationmanager.Organization.encode(message.organization, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified OrganizationResponse message, length delimited. Does not implicitly {@link organizationmanager.OrganizationResponse.verify|verify} messages.
         * @function encodeDelimited
         * @memberof organizationmanager.OrganizationResponse
         * @static
         * @param {organizationmanager.IOrganizationResponse} message OrganizationResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        OrganizationResponse.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an OrganizationResponse message from the specified reader or buffer.
         * @function decode
         * @memberof organizationmanager.OrganizationResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {organizationmanager.OrganizationResponse} OrganizationResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        OrganizationResponse.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.organizationmanager.OrganizationResponse();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.organization = $root.organizationmanager.Organization.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an OrganizationResponse message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof organizationmanager.OrganizationResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {organizationmanager.OrganizationResponse} OrganizationResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        OrganizationResponse.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an OrganizationResponse message.
         * @function verify
         * @memberof organizationmanager.OrganizationResponse
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        OrganizationResponse.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.organization != null && message.hasOwnProperty("organization")) {
                var error = $root.organizationmanager.Organization.verify(message.organization);
                if (error)
                    return "organization." + error;
            }
            return null;
        };

        /**
         * Creates an OrganizationResponse message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof organizationmanager.OrganizationResponse
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {organizationmanager.OrganizationResponse} OrganizationResponse
         */
        OrganizationResponse.fromObject = function fromObject(object) {
            if (object instanceof $root.organizationmanager.OrganizationResponse)
                return object;
            var message = new $root.organizationmanager.OrganizationResponse();
            if (object.organization != null) {
                if (typeof object.organization !== "object")
                    throw TypeError(".organizationmanager.OrganizationResponse.organization: object expected");
                message.organization = $root.organizationmanager.Organization.fromObject(object.organization);
            }
            return message;
        };

        /**
         * Creates a plain object from an OrganizationResponse message. Also converts values to other types if specified.
         * @function toObject
         * @memberof organizationmanager.OrganizationResponse
         * @static
         * @param {organizationmanager.OrganizationResponse} message OrganizationResponse
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        OrganizationResponse.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.organization = null;
            if (message.organization != null && message.hasOwnProperty("organization"))
                object.organization = $root.organizationmanager.Organization.toObject(message.organization, options);
            return object;
        };

        /**
         * Converts this OrganizationResponse to JSON.
         * @function toJSON
         * @memberof organizationmanager.OrganizationResponse
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        OrganizationResponse.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return OrganizationResponse;
    })();

    organizationmanager.OrganizationsResponse = (function() {

        /**
         * Properties of an OrganizationsResponse.
         * @memberof organizationmanager
         * @interface IOrganizationsResponse
         * @property {Array.<organizationmanager.IOrganization>|null} [organizations] OrganizationsResponse organizations
         */

        /**
         * Constructs a new OrganizationsResponse.
         * @memberof organizationmanager
         * @classdesc Represents an OrganizationsResponse.
         * @implements IOrganizationsResponse
         * @constructor
         * @param {organizationmanager.IOrganizationsResponse=} [properties] Properties to set
         */
        function OrganizationsResponse(properties) {
            this.organizations = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * OrganizationsResponse organizations.
         * @member {Array.<organizationmanager.IOrganization>} organizations
         * @memberof organizationmanager.OrganizationsResponse
         * @instance
         */
        OrganizationsResponse.prototype.organizations = $util.emptyArray;

        /**
         * Creates a new OrganizationsResponse instance using the specified properties.
         * @function create
         * @memberof organizationmanager.OrganizationsResponse
         * @static
         * @param {organizationmanager.IOrganizationsResponse=} [properties] Properties to set
         * @returns {organizationmanager.OrganizationsResponse} OrganizationsResponse instance
         */
        OrganizationsResponse.create = function create(properties) {
            return new OrganizationsResponse(properties);
        };

        /**
         * Encodes the specified OrganizationsResponse message. Does not implicitly {@link organizationmanager.OrganizationsResponse.verify|verify} messages.
         * @function encode
         * @memberof organizationmanager.OrganizationsResponse
         * @static
         * @param {organizationmanager.IOrganizationsResponse} message OrganizationsResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        OrganizationsResponse.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.organizations != null && message.organizations.length)
                for (var i = 0; i < message.organizations.length; ++i)
                    $root.organizationmanager.Organization.encode(message.organizations[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified OrganizationsResponse message, length delimited. Does not implicitly {@link organizationmanager.OrganizationsResponse.verify|verify} messages.
         * @function encodeDelimited
         * @memberof organizationmanager.OrganizationsResponse
         * @static
         * @param {organizationmanager.IOrganizationsResponse} message OrganizationsResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        OrganizationsResponse.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an OrganizationsResponse message from the specified reader or buffer.
         * @function decode
         * @memberof organizationmanager.OrganizationsResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {organizationmanager.OrganizationsResponse} OrganizationsResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        OrganizationsResponse.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.organizationmanager.OrganizationsResponse();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    if (!(message.organizations && message.organizations.length))
                        message.organizations = [];
                    message.organizations.push($root.organizationmanager.Organization.decode(reader, reader.uint32()));
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an OrganizationsResponse message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof organizationmanager.OrganizationsResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {organizationmanager.OrganizationsResponse} OrganizationsResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        OrganizationsResponse.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an OrganizationsResponse message.
         * @function verify
         * @memberof organizationmanager.OrganizationsResponse
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        OrganizationsResponse.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.organizations != null && message.hasOwnProperty("organizations")) {
                if (!Array.isArray(message.organizations))
                    return "organizations: array expected";
                for (var i = 0; i < message.organizations.length; ++i) {
                    var error = $root.organizationmanager.Organization.verify(message.organizations[i]);
                    if (error)
                        return "organizations." + error;
                }
            }
            return null;
        };

        /**
         * Creates an OrganizationsResponse message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof organizationmanager.OrganizationsResponse
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {organizationmanager.OrganizationsResponse} OrganizationsResponse
         */
        OrganizationsResponse.fromObject = function fromObject(object) {
            if (object instanceof $root.organizationmanager.OrganizationsResponse)
                return object;
            var message = new $root.organizationmanager.OrganizationsResponse();
            if (object.organizations) {
                if (!Array.isArray(object.organizations))
                    throw TypeError(".organizationmanager.OrganizationsResponse.organizations: array expected");
                message.organizations = [];
                for (var i = 0; i < object.organizations.length; ++i) {
                    if (typeof object.organizations[i] !== "object")
                        throw TypeError(".organizationmanager.OrganizationsResponse.organizations: object expected");
                    message.organizations[i] = $root.organizationmanager.Organization.fromObject(object.organizations[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from an OrganizationsResponse message. Also converts values to other types if specified.
         * @function toObject
         * @memberof organizationmanager.OrganizationsResponse
         * @static
         * @param {organizationmanager.OrganizationsResponse} message OrganizationsResponse
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        OrganizationsResponse.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.organizations = [];
            if (message.organizations && message.organizations.length) {
                object.organizations = [];
                for (var j = 0; j < message.organizations.length; ++j)
                    object.organizations[j] = $root.organizationmanager.Organization.toObject(message.organizations[j], options);
            }
            return object;
        };

        /**
         * Converts this OrganizationsResponse to JSON.
         * @function toJSON
         * @memberof organizationmanager.OrganizationsResponse
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        OrganizationsResponse.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return OrganizationsResponse;
    })();

    return organizationmanager;
})();

$root.departmentmanager = (function() {

    /**
     * Namespace departmentmanager.
     * @exports departmentmanager
     * @namespace
     */
    var departmentmanager = {};

    departmentmanager.Department = (function() {

        /**
         * Properties of a Department.
         * @memberof departmentmanager
         * @interface IDepartment
         * @property {string|null} [id] Department id
         * @property {departmentmanager.IDepartmentData|null} [data] Department data
         */

        /**
         * Constructs a new Department.
         * @memberof departmentmanager
         * @classdesc Represents a Department.
         * @implements IDepartment
         * @constructor
         * @param {departmentmanager.IDepartment=} [properties] Properties to set
         */
        function Department(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Department id.
         * @member {string} id
         * @memberof departmentmanager.Department
         * @instance
         */
        Department.prototype.id = "";

        /**
         * Department data.
         * @member {departmentmanager.IDepartmentData|null|undefined} data
         * @memberof departmentmanager.Department
         * @instance
         */
        Department.prototype.data = null;

        /**
         * Creates a new Department instance using the specified properties.
         * @function create
         * @memberof departmentmanager.Department
         * @static
         * @param {departmentmanager.IDepartment=} [properties] Properties to set
         * @returns {departmentmanager.Department} Department instance
         */
        Department.create = function create(properties) {
            return new Department(properties);
        };

        /**
         * Encodes the specified Department message. Does not implicitly {@link departmentmanager.Department.verify|verify} messages.
         * @function encode
         * @memberof departmentmanager.Department
         * @static
         * @param {departmentmanager.IDepartment} message Department message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Department.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.id != null && Object.hasOwnProperty.call(message, "id"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.id);
            if (message.data != null && Object.hasOwnProperty.call(message, "data"))
                $root.departmentmanager.DepartmentData.encode(message.data, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified Department message, length delimited. Does not implicitly {@link departmentmanager.Department.verify|verify} messages.
         * @function encodeDelimited
         * @memberof departmentmanager.Department
         * @static
         * @param {departmentmanager.IDepartment} message Department message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Department.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a Department message from the specified reader or buffer.
         * @function decode
         * @memberof departmentmanager.Department
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {departmentmanager.Department} Department
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Department.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.departmentmanager.Department();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.id = reader.string();
                    break;
                case 2:
                    message.data = $root.departmentmanager.DepartmentData.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a Department message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof departmentmanager.Department
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {departmentmanager.Department} Department
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Department.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a Department message.
         * @function verify
         * @memberof departmentmanager.Department
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Department.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.id != null && message.hasOwnProperty("id"))
                if (!$util.isString(message.id))
                    return "id: string expected";
            if (message.data != null && message.hasOwnProperty("data")) {
                var error = $root.departmentmanager.DepartmentData.verify(message.data);
                if (error)
                    return "data." + error;
            }
            return null;
        };

        /**
         * Creates a Department message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof departmentmanager.Department
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {departmentmanager.Department} Department
         */
        Department.fromObject = function fromObject(object) {
            if (object instanceof $root.departmentmanager.Department)
                return object;
            var message = new $root.departmentmanager.Department();
            if (object.id != null)
                message.id = String(object.id);
            if (object.data != null) {
                if (typeof object.data !== "object")
                    throw TypeError(".departmentmanager.Department.data: object expected");
                message.data = $root.departmentmanager.DepartmentData.fromObject(object.data);
            }
            return message;
        };

        /**
         * Creates a plain object from a Department message. Also converts values to other types if specified.
         * @function toObject
         * @memberof departmentmanager.Department
         * @static
         * @param {departmentmanager.Department} message Department
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Department.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.id = "";
                object.data = null;
            }
            if (message.id != null && message.hasOwnProperty("id"))
                object.id = message.id;
            if (message.data != null && message.hasOwnProperty("data"))
                object.data = $root.departmentmanager.DepartmentData.toObject(message.data, options);
            return object;
        };

        /**
         * Converts this Department to JSON.
         * @function toJSON
         * @memberof departmentmanager.Department
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Department.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return Department;
    })();

    departmentmanager.DepartmentData = (function() {

        /**
         * Properties of a DepartmentData.
         * @memberof departmentmanager
         * @interface IDepartmentData
         * @property {number|null} [organizationId] DepartmentData organizationId
         * @property {string|null} [parentDepartmentId] DepartmentData parentDepartmentId
         * @property {Array.<departmentmanager.IDepartmentName>|null} [names] DepartmentData names
         */

        /**
         * Constructs a new DepartmentData.
         * @memberof departmentmanager
         * @classdesc Represents a DepartmentData.
         * @implements IDepartmentData
         * @constructor
         * @param {departmentmanager.IDepartmentData=} [properties] Properties to set
         */
        function DepartmentData(properties) {
            this.names = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * DepartmentData organizationId.
         * @member {number} organizationId
         * @memberof departmentmanager.DepartmentData
         * @instance
         */
        DepartmentData.prototype.organizationId = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * DepartmentData parentDepartmentId.
         * @member {string} parentDepartmentId
         * @memberof departmentmanager.DepartmentData
         * @instance
         */
        DepartmentData.prototype.parentDepartmentId = "";

        /**
         * DepartmentData names.
         * @member {Array.<departmentmanager.IDepartmentName>} names
         * @memberof departmentmanager.DepartmentData
         * @instance
         */
        DepartmentData.prototype.names = $util.emptyArray;

        /**
         * Creates a new DepartmentData instance using the specified properties.
         * @function create
         * @memberof departmentmanager.DepartmentData
         * @static
         * @param {departmentmanager.IDepartmentData=} [properties] Properties to set
         * @returns {departmentmanager.DepartmentData} DepartmentData instance
         */
        DepartmentData.create = function create(properties) {
            return new DepartmentData(properties);
        };

        /**
         * Encodes the specified DepartmentData message. Does not implicitly {@link departmentmanager.DepartmentData.verify|verify} messages.
         * @function encode
         * @memberof departmentmanager.DepartmentData
         * @static
         * @param {departmentmanager.IDepartmentData} message DepartmentData message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DepartmentData.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.organizationId != null && Object.hasOwnProperty.call(message, "organizationId"))
                writer.uint32(/* id 1, wireType 0 =*/8).int64(message.organizationId);
            if (message.parentDepartmentId != null && Object.hasOwnProperty.call(message, "parentDepartmentId"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.parentDepartmentId);
            if (message.names != null && message.names.length)
                for (var i = 0; i < message.names.length; ++i)
                    $root.departmentmanager.DepartmentName.encode(message.names[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified DepartmentData message, length delimited. Does not implicitly {@link departmentmanager.DepartmentData.verify|verify} messages.
         * @function encodeDelimited
         * @memberof departmentmanager.DepartmentData
         * @static
         * @param {departmentmanager.IDepartmentData} message DepartmentData message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DepartmentData.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DepartmentData message from the specified reader or buffer.
         * @function decode
         * @memberof departmentmanager.DepartmentData
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {departmentmanager.DepartmentData} DepartmentData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DepartmentData.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.departmentmanager.DepartmentData();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.organizationId = reader.int64();
                    break;
                case 2:
                    message.parentDepartmentId = reader.string();
                    break;
                case 3:
                    if (!(message.names && message.names.length))
                        message.names = [];
                    message.names.push($root.departmentmanager.DepartmentName.decode(reader, reader.uint32()));
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DepartmentData message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof departmentmanager.DepartmentData
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {departmentmanager.DepartmentData} DepartmentData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DepartmentData.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DepartmentData message.
         * @function verify
         * @memberof departmentmanager.DepartmentData
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DepartmentData.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.organizationId != null && message.hasOwnProperty("organizationId"))
                if (!$util.isInteger(message.organizationId) && !(message.organizationId && $util.isInteger(message.organizationId.low) && $util.isInteger(message.organizationId.high)))
                    return "organizationId: integer|Long expected";
            if (message.parentDepartmentId != null && message.hasOwnProperty("parentDepartmentId"))
                if (!$util.isString(message.parentDepartmentId))
                    return "parentDepartmentId: string expected";
            if (message.names != null && message.hasOwnProperty("names")) {
                if (!Array.isArray(message.names))
                    return "names: array expected";
                for (var i = 0; i < message.names.length; ++i) {
                    var error = $root.departmentmanager.DepartmentName.verify(message.names[i]);
                    if (error)
                        return "names." + error;
                }
            }
            return null;
        };

        /**
         * Creates a DepartmentData message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof departmentmanager.DepartmentData
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {departmentmanager.DepartmentData} DepartmentData
         */
        DepartmentData.fromObject = function fromObject(object) {
            if (object instanceof $root.departmentmanager.DepartmentData)
                return object;
            var message = new $root.departmentmanager.DepartmentData();
            if (object.organizationId != null)
                if ($util.Long)
                    (message.organizationId = $util.Long.fromValue(object.organizationId)).unsigned = false;
                else if (typeof object.organizationId === "string")
                    message.organizationId = parseInt(object.organizationId, 10);
                else if (typeof object.organizationId === "number")
                    message.organizationId = object.organizationId;
                else if (typeof object.organizationId === "object")
                    message.organizationId = new $util.LongBits(object.organizationId.low >>> 0, object.organizationId.high >>> 0).toNumber();
            if (object.parentDepartmentId != null)
                message.parentDepartmentId = String(object.parentDepartmentId);
            if (object.names) {
                if (!Array.isArray(object.names))
                    throw TypeError(".departmentmanager.DepartmentData.names: array expected");
                message.names = [];
                for (var i = 0; i < object.names.length; ++i) {
                    if (typeof object.names[i] !== "object")
                        throw TypeError(".departmentmanager.DepartmentData.names: object expected");
                    message.names[i] = $root.departmentmanager.DepartmentName.fromObject(object.names[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a DepartmentData message. Also converts values to other types if specified.
         * @function toObject
         * @memberof departmentmanager.DepartmentData
         * @static
         * @param {departmentmanager.DepartmentData} message DepartmentData
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DepartmentData.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.names = [];
            if (options.defaults) {
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.organizationId = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.organizationId = options.longs === String ? "0" : 0;
                object.parentDepartmentId = "";
            }
            if (message.organizationId != null && message.hasOwnProperty("organizationId"))
                if (typeof message.organizationId === "number")
                    object.organizationId = options.longs === String ? String(message.organizationId) : message.organizationId;
                else
                    object.organizationId = options.longs === String ? $util.Long.prototype.toString.call(message.organizationId) : options.longs === Number ? new $util.LongBits(message.organizationId.low >>> 0, message.organizationId.high >>> 0).toNumber() : message.organizationId;
            if (message.parentDepartmentId != null && message.hasOwnProperty("parentDepartmentId"))
                object.parentDepartmentId = message.parentDepartmentId;
            if (message.names && message.names.length) {
                object.names = [];
                for (var j = 0; j < message.names.length; ++j)
                    object.names[j] = $root.departmentmanager.DepartmentName.toObject(message.names[j], options);
            }
            return object;
        };

        /**
         * Converts this DepartmentData to JSON.
         * @function toJSON
         * @memberof departmentmanager.DepartmentData
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DepartmentData.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return DepartmentData;
    })();

    departmentmanager.UpdateDepartmentData = (function() {

        /**
         * Properties of an UpdateDepartmentData.
         * @memberof departmentmanager
         * @interface IUpdateDepartmentData
         * @property {number|null} [newOrganizationId] UpdateDepartmentData newOrganizationId
         * @property {string|null} [newParentDepartmentId] UpdateDepartmentData newParentDepartmentId
         * @property {Array.<departmentmanager.IDepartmentName>|null} [newNames] UpdateDepartmentData newNames
         */

        /**
         * Constructs a new UpdateDepartmentData.
         * @memberof departmentmanager
         * @classdesc Represents an UpdateDepartmentData.
         * @implements IUpdateDepartmentData
         * @constructor
         * @param {departmentmanager.IUpdateDepartmentData=} [properties] Properties to set
         */
        function UpdateDepartmentData(properties) {
            this.newNames = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * UpdateDepartmentData newOrganizationId.
         * @member {number|null|undefined} newOrganizationId
         * @memberof departmentmanager.UpdateDepartmentData
         * @instance
         */
        UpdateDepartmentData.prototype.newOrganizationId = null;

        /**
         * UpdateDepartmentData newParentDepartmentId.
         * @member {string|null|undefined} newParentDepartmentId
         * @memberof departmentmanager.UpdateDepartmentData
         * @instance
         */
        UpdateDepartmentData.prototype.newParentDepartmentId = null;

        /**
         * UpdateDepartmentData newNames.
         * @member {Array.<departmentmanager.IDepartmentName>} newNames
         * @memberof departmentmanager.UpdateDepartmentData
         * @instance
         */
        UpdateDepartmentData.prototype.newNames = $util.emptyArray;

        // OneOf field names bound to virtual getters and setters
        var $oneOfFields;

        /**
         * UpdateDepartmentData updateOrganizationId.
         * @member {"newOrganizationId"|undefined} updateOrganizationId
         * @memberof departmentmanager.UpdateDepartmentData
         * @instance
         */
        Object.defineProperty(UpdateDepartmentData.prototype, "updateOrganizationId", {
            get: $util.oneOfGetter($oneOfFields = ["newOrganizationId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * UpdateDepartmentData _newParentDepartmentId.
         * @member {"newParentDepartmentId"|undefined} _newParentDepartmentId
         * @memberof departmentmanager.UpdateDepartmentData
         * @instance
         */
        Object.defineProperty(UpdateDepartmentData.prototype, "_newParentDepartmentId", {
            get: $util.oneOfGetter($oneOfFields = ["newParentDepartmentId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new UpdateDepartmentData instance using the specified properties.
         * @function create
         * @memberof departmentmanager.UpdateDepartmentData
         * @static
         * @param {departmentmanager.IUpdateDepartmentData=} [properties] Properties to set
         * @returns {departmentmanager.UpdateDepartmentData} UpdateDepartmentData instance
         */
        UpdateDepartmentData.create = function create(properties) {
            return new UpdateDepartmentData(properties);
        };

        /**
         * Encodes the specified UpdateDepartmentData message. Does not implicitly {@link departmentmanager.UpdateDepartmentData.verify|verify} messages.
         * @function encode
         * @memberof departmentmanager.UpdateDepartmentData
         * @static
         * @param {departmentmanager.IUpdateDepartmentData} message UpdateDepartmentData message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        UpdateDepartmentData.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.newOrganizationId != null && Object.hasOwnProperty.call(message, "newOrganizationId"))
                writer.uint32(/* id 1, wireType 0 =*/8).int64(message.newOrganizationId);
            if (message.newParentDepartmentId != null && Object.hasOwnProperty.call(message, "newParentDepartmentId"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.newParentDepartmentId);
            if (message.newNames != null && message.newNames.length)
                for (var i = 0; i < message.newNames.length; ++i)
                    $root.departmentmanager.DepartmentName.encode(message.newNames[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified UpdateDepartmentData message, length delimited. Does not implicitly {@link departmentmanager.UpdateDepartmentData.verify|verify} messages.
         * @function encodeDelimited
         * @memberof departmentmanager.UpdateDepartmentData
         * @static
         * @param {departmentmanager.IUpdateDepartmentData} message UpdateDepartmentData message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        UpdateDepartmentData.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an UpdateDepartmentData message from the specified reader or buffer.
         * @function decode
         * @memberof departmentmanager.UpdateDepartmentData
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {departmentmanager.UpdateDepartmentData} UpdateDepartmentData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        UpdateDepartmentData.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.departmentmanager.UpdateDepartmentData();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.newOrganizationId = reader.int64();
                    break;
                case 2:
                    message.newParentDepartmentId = reader.string();
                    break;
                case 3:
                    if (!(message.newNames && message.newNames.length))
                        message.newNames = [];
                    message.newNames.push($root.departmentmanager.DepartmentName.decode(reader, reader.uint32()));
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an UpdateDepartmentData message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof departmentmanager.UpdateDepartmentData
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {departmentmanager.UpdateDepartmentData} UpdateDepartmentData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        UpdateDepartmentData.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an UpdateDepartmentData message.
         * @function verify
         * @memberof departmentmanager.UpdateDepartmentData
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        UpdateDepartmentData.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            var properties = {};
            if (message.newOrganizationId != null && message.hasOwnProperty("newOrganizationId")) {
                properties.updateOrganizationId = 1;
                if (!$util.isInteger(message.newOrganizationId) && !(message.newOrganizationId && $util.isInteger(message.newOrganizationId.low) && $util.isInteger(message.newOrganizationId.high)))
                    return "newOrganizationId: integer|Long expected";
            }
            if (message.newParentDepartmentId != null && message.hasOwnProperty("newParentDepartmentId")) {
                properties._newParentDepartmentId = 1;
                if (!$util.isString(message.newParentDepartmentId))
                    return "newParentDepartmentId: string expected";
            }
            if (message.newNames != null && message.hasOwnProperty("newNames")) {
                if (!Array.isArray(message.newNames))
                    return "newNames: array expected";
                for (var i = 0; i < message.newNames.length; ++i) {
                    var error = $root.departmentmanager.DepartmentName.verify(message.newNames[i]);
                    if (error)
                        return "newNames." + error;
                }
            }
            return null;
        };

        /**
         * Creates an UpdateDepartmentData message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof departmentmanager.UpdateDepartmentData
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {departmentmanager.UpdateDepartmentData} UpdateDepartmentData
         */
        UpdateDepartmentData.fromObject = function fromObject(object) {
            if (object instanceof $root.departmentmanager.UpdateDepartmentData)
                return object;
            var message = new $root.departmentmanager.UpdateDepartmentData();
            if (object.newOrganizationId != null)
                if ($util.Long)
                    (message.newOrganizationId = $util.Long.fromValue(object.newOrganizationId)).unsigned = false;
                else if (typeof object.newOrganizationId === "string")
                    message.newOrganizationId = parseInt(object.newOrganizationId, 10);
                else if (typeof object.newOrganizationId === "number")
                    message.newOrganizationId = object.newOrganizationId;
                else if (typeof object.newOrganizationId === "object")
                    message.newOrganizationId = new $util.LongBits(object.newOrganizationId.low >>> 0, object.newOrganizationId.high >>> 0).toNumber();
            if (object.newParentDepartmentId != null)
                message.newParentDepartmentId = String(object.newParentDepartmentId);
            if (object.newNames) {
                if (!Array.isArray(object.newNames))
                    throw TypeError(".departmentmanager.UpdateDepartmentData.newNames: array expected");
                message.newNames = [];
                for (var i = 0; i < object.newNames.length; ++i) {
                    if (typeof object.newNames[i] !== "object")
                        throw TypeError(".departmentmanager.UpdateDepartmentData.newNames: object expected");
                    message.newNames[i] = $root.departmentmanager.DepartmentName.fromObject(object.newNames[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from an UpdateDepartmentData message. Also converts values to other types if specified.
         * @function toObject
         * @memberof departmentmanager.UpdateDepartmentData
         * @static
         * @param {departmentmanager.UpdateDepartmentData} message UpdateDepartmentData
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        UpdateDepartmentData.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.newNames = [];
            if (message.newOrganizationId != null && message.hasOwnProperty("newOrganizationId")) {
                if (typeof message.newOrganizationId === "number")
                    object.newOrganizationId = options.longs === String ? String(message.newOrganizationId) : message.newOrganizationId;
                else
                    object.newOrganizationId = options.longs === String ? $util.Long.prototype.toString.call(message.newOrganizationId) : options.longs === Number ? new $util.LongBits(message.newOrganizationId.low >>> 0, message.newOrganizationId.high >>> 0).toNumber() : message.newOrganizationId;
                if (options.oneofs)
                    object.updateOrganizationId = "newOrganizationId";
            }
            if (message.newParentDepartmentId != null && message.hasOwnProperty("newParentDepartmentId")) {
                object.newParentDepartmentId = message.newParentDepartmentId;
                if (options.oneofs)
                    object._newParentDepartmentId = "newParentDepartmentId";
            }
            if (message.newNames && message.newNames.length) {
                object.newNames = [];
                for (var j = 0; j < message.newNames.length; ++j)
                    object.newNames[j] = $root.departmentmanager.DepartmentName.toObject(message.newNames[j], options);
            }
            return object;
        };

        /**
         * Converts this UpdateDepartmentData to JSON.
         * @function toJSON
         * @memberof departmentmanager.UpdateDepartmentData
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        UpdateDepartmentData.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return UpdateDepartmentData;
    })();

    departmentmanager.DepartmentName = (function() {

        /**
         * Properties of a DepartmentName.
         * @memberof departmentmanager
         * @interface IDepartmentName
         * @property {string|null} [languageCode] DepartmentName languageCode
         * @property {string|null} [name] DepartmentName name
         */

        /**
         * Constructs a new DepartmentName.
         * @memberof departmentmanager
         * @classdesc Represents a DepartmentName.
         * @implements IDepartmentName
         * @constructor
         * @param {departmentmanager.IDepartmentName=} [properties] Properties to set
         */
        function DepartmentName(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * DepartmentName languageCode.
         * @member {string} languageCode
         * @memberof departmentmanager.DepartmentName
         * @instance
         */
        DepartmentName.prototype.languageCode = "";

        /**
         * DepartmentName name.
         * @member {string} name
         * @memberof departmentmanager.DepartmentName
         * @instance
         */
        DepartmentName.prototype.name = "";

        /**
         * Creates a new DepartmentName instance using the specified properties.
         * @function create
         * @memberof departmentmanager.DepartmentName
         * @static
         * @param {departmentmanager.IDepartmentName=} [properties] Properties to set
         * @returns {departmentmanager.DepartmentName} DepartmentName instance
         */
        DepartmentName.create = function create(properties) {
            return new DepartmentName(properties);
        };

        /**
         * Encodes the specified DepartmentName message. Does not implicitly {@link departmentmanager.DepartmentName.verify|verify} messages.
         * @function encode
         * @memberof departmentmanager.DepartmentName
         * @static
         * @param {departmentmanager.IDepartmentName} message DepartmentName message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DepartmentName.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.languageCode != null && Object.hasOwnProperty.call(message, "languageCode"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.languageCode);
            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.name);
            return writer;
        };

        /**
         * Encodes the specified DepartmentName message, length delimited. Does not implicitly {@link departmentmanager.DepartmentName.verify|verify} messages.
         * @function encodeDelimited
         * @memberof departmentmanager.DepartmentName
         * @static
         * @param {departmentmanager.IDepartmentName} message DepartmentName message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DepartmentName.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DepartmentName message from the specified reader or buffer.
         * @function decode
         * @memberof departmentmanager.DepartmentName
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {departmentmanager.DepartmentName} DepartmentName
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DepartmentName.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.departmentmanager.DepartmentName();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.languageCode = reader.string();
                    break;
                case 2:
                    message.name = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DepartmentName message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof departmentmanager.DepartmentName
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {departmentmanager.DepartmentName} DepartmentName
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DepartmentName.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DepartmentName message.
         * @function verify
         * @memberof departmentmanager.DepartmentName
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DepartmentName.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.languageCode != null && message.hasOwnProperty("languageCode"))
                if (!$util.isString(message.languageCode))
                    return "languageCode: string expected";
            if (message.name != null && message.hasOwnProperty("name"))
                if (!$util.isString(message.name))
                    return "name: string expected";
            return null;
        };

        /**
         * Creates a DepartmentName message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof departmentmanager.DepartmentName
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {departmentmanager.DepartmentName} DepartmentName
         */
        DepartmentName.fromObject = function fromObject(object) {
            if (object instanceof $root.departmentmanager.DepartmentName)
                return object;
            var message = new $root.departmentmanager.DepartmentName();
            if (object.languageCode != null)
                message.languageCode = String(object.languageCode);
            if (object.name != null)
                message.name = String(object.name);
            return message;
        };

        /**
         * Creates a plain object from a DepartmentName message. Also converts values to other types if specified.
         * @function toObject
         * @memberof departmentmanager.DepartmentName
         * @static
         * @param {departmentmanager.DepartmentName} message DepartmentName
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DepartmentName.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.languageCode = "";
                object.name = "";
            }
            if (message.languageCode != null && message.hasOwnProperty("languageCode"))
                object.languageCode = message.languageCode;
            if (message.name != null && message.hasOwnProperty("name"))
                object.name = message.name;
            return object;
        };

        /**
         * Converts this DepartmentName to JSON.
         * @function toJSON
         * @memberof departmentmanager.DepartmentName
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DepartmentName.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return DepartmentName;
    })();

    departmentmanager.DepartmentUsersCount = (function() {

        /**
         * Properties of a DepartmentUsersCount.
         * @memberof departmentmanager
         * @interface IDepartmentUsersCount
         * @property {number|null} [organizationId] DepartmentUsersCount organizationId
         * @property {string|null} [departmentId] DepartmentUsersCount departmentId
         * @property {number|null} [usersCount] DepartmentUsersCount usersCount
         */

        /**
         * Constructs a new DepartmentUsersCount.
         * @memberof departmentmanager
         * @classdesc Represents a DepartmentUsersCount.
         * @implements IDepartmentUsersCount
         * @constructor
         * @param {departmentmanager.IDepartmentUsersCount=} [properties] Properties to set
         */
        function DepartmentUsersCount(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * DepartmentUsersCount organizationId.
         * @member {number} organizationId
         * @memberof departmentmanager.DepartmentUsersCount
         * @instance
         */
        DepartmentUsersCount.prototype.organizationId = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * DepartmentUsersCount departmentId.
         * @member {string} departmentId
         * @memberof departmentmanager.DepartmentUsersCount
         * @instance
         */
        DepartmentUsersCount.prototype.departmentId = "";

        /**
         * DepartmentUsersCount usersCount.
         * @member {number} usersCount
         * @memberof departmentmanager.DepartmentUsersCount
         * @instance
         */
        DepartmentUsersCount.prototype.usersCount = 0;

        /**
         * Creates a new DepartmentUsersCount instance using the specified properties.
         * @function create
         * @memberof departmentmanager.DepartmentUsersCount
         * @static
         * @param {departmentmanager.IDepartmentUsersCount=} [properties] Properties to set
         * @returns {departmentmanager.DepartmentUsersCount} DepartmentUsersCount instance
         */
        DepartmentUsersCount.create = function create(properties) {
            return new DepartmentUsersCount(properties);
        };

        /**
         * Encodes the specified DepartmentUsersCount message. Does not implicitly {@link departmentmanager.DepartmentUsersCount.verify|verify} messages.
         * @function encode
         * @memberof departmentmanager.DepartmentUsersCount
         * @static
         * @param {departmentmanager.IDepartmentUsersCount} message DepartmentUsersCount message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DepartmentUsersCount.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.organizationId != null && Object.hasOwnProperty.call(message, "organizationId"))
                writer.uint32(/* id 1, wireType 0 =*/8).int64(message.organizationId);
            if (message.departmentId != null && Object.hasOwnProperty.call(message, "departmentId"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.departmentId);
            if (message.usersCount != null && Object.hasOwnProperty.call(message, "usersCount"))
                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.usersCount);
            return writer;
        };

        /**
         * Encodes the specified DepartmentUsersCount message, length delimited. Does not implicitly {@link departmentmanager.DepartmentUsersCount.verify|verify} messages.
         * @function encodeDelimited
         * @memberof departmentmanager.DepartmentUsersCount
         * @static
         * @param {departmentmanager.IDepartmentUsersCount} message DepartmentUsersCount message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DepartmentUsersCount.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DepartmentUsersCount message from the specified reader or buffer.
         * @function decode
         * @memberof departmentmanager.DepartmentUsersCount
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {departmentmanager.DepartmentUsersCount} DepartmentUsersCount
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DepartmentUsersCount.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.departmentmanager.DepartmentUsersCount();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.organizationId = reader.int64();
                    break;
                case 2:
                    message.departmentId = reader.string();
                    break;
                case 3:
                    message.usersCount = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DepartmentUsersCount message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof departmentmanager.DepartmentUsersCount
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {departmentmanager.DepartmentUsersCount} DepartmentUsersCount
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DepartmentUsersCount.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DepartmentUsersCount message.
         * @function verify
         * @memberof departmentmanager.DepartmentUsersCount
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DepartmentUsersCount.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.organizationId != null && message.hasOwnProperty("organizationId"))
                if (!$util.isInteger(message.organizationId) && !(message.organizationId && $util.isInteger(message.organizationId.low) && $util.isInteger(message.organizationId.high)))
                    return "organizationId: integer|Long expected";
            if (message.departmentId != null && message.hasOwnProperty("departmentId"))
                if (!$util.isString(message.departmentId))
                    return "departmentId: string expected";
            if (message.usersCount != null && message.hasOwnProperty("usersCount"))
                if (!$util.isInteger(message.usersCount))
                    return "usersCount: integer expected";
            return null;
        };

        /**
         * Creates a DepartmentUsersCount message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof departmentmanager.DepartmentUsersCount
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {departmentmanager.DepartmentUsersCount} DepartmentUsersCount
         */
        DepartmentUsersCount.fromObject = function fromObject(object) {
            if (object instanceof $root.departmentmanager.DepartmentUsersCount)
                return object;
            var message = new $root.departmentmanager.DepartmentUsersCount();
            if (object.organizationId != null)
                if ($util.Long)
                    (message.organizationId = $util.Long.fromValue(object.organizationId)).unsigned = false;
                else if (typeof object.organizationId === "string")
                    message.organizationId = parseInt(object.organizationId, 10);
                else if (typeof object.organizationId === "number")
                    message.organizationId = object.organizationId;
                else if (typeof object.organizationId === "object")
                    message.organizationId = new $util.LongBits(object.organizationId.low >>> 0, object.organizationId.high >>> 0).toNumber();
            if (object.departmentId != null)
                message.departmentId = String(object.departmentId);
            if (object.usersCount != null)
                message.usersCount = object.usersCount | 0;
            return message;
        };

        /**
         * Creates a plain object from a DepartmentUsersCount message. Also converts values to other types if specified.
         * @function toObject
         * @memberof departmentmanager.DepartmentUsersCount
         * @static
         * @param {departmentmanager.DepartmentUsersCount} message DepartmentUsersCount
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DepartmentUsersCount.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.organizationId = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.organizationId = options.longs === String ? "0" : 0;
                object.departmentId = "";
                object.usersCount = 0;
            }
            if (message.organizationId != null && message.hasOwnProperty("organizationId"))
                if (typeof message.organizationId === "number")
                    object.organizationId = options.longs === String ? String(message.organizationId) : message.organizationId;
                else
                    object.organizationId = options.longs === String ? $util.Long.prototype.toString.call(message.organizationId) : options.longs === Number ? new $util.LongBits(message.organizationId.low >>> 0, message.organizationId.high >>> 0).toNumber() : message.organizationId;
            if (message.departmentId != null && message.hasOwnProperty("departmentId"))
                object.departmentId = message.departmentId;
            if (message.usersCount != null && message.hasOwnProperty("usersCount"))
                object.usersCount = message.usersCount;
            return object;
        };

        /**
         * Converts this DepartmentUsersCount to JSON.
         * @function toJSON
         * @memberof departmentmanager.DepartmentUsersCount
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DepartmentUsersCount.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return DepartmentUsersCount;
    })();

    departmentmanager.CreateDepartmentRequest = (function() {

        /**
         * Properties of a CreateDepartmentRequest.
         * @memberof departmentmanager
         * @interface ICreateDepartmentRequest
         * @property {departmentmanager.IDepartmentData|null} [departmentData] CreateDepartmentRequest departmentData
         * @property {Array.<number>|null} [departmentResponsibleUserIds] CreateDepartmentRequest departmentResponsibleUserIds
         */

        /**
         * Constructs a new CreateDepartmentRequest.
         * @memberof departmentmanager
         * @classdesc Represents a CreateDepartmentRequest.
         * @implements ICreateDepartmentRequest
         * @constructor
         * @param {departmentmanager.ICreateDepartmentRequest=} [properties] Properties to set
         */
        function CreateDepartmentRequest(properties) {
            this.departmentResponsibleUserIds = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * CreateDepartmentRequest departmentData.
         * @member {departmentmanager.IDepartmentData|null|undefined} departmentData
         * @memberof departmentmanager.CreateDepartmentRequest
         * @instance
         */
        CreateDepartmentRequest.prototype.departmentData = null;

        /**
         * CreateDepartmentRequest departmentResponsibleUserIds.
         * @member {Array.<number>} departmentResponsibleUserIds
         * @memberof departmentmanager.CreateDepartmentRequest
         * @instance
         */
        CreateDepartmentRequest.prototype.departmentResponsibleUserIds = $util.emptyArray;

        /**
         * Creates a new CreateDepartmentRequest instance using the specified properties.
         * @function create
         * @memberof departmentmanager.CreateDepartmentRequest
         * @static
         * @param {departmentmanager.ICreateDepartmentRequest=} [properties] Properties to set
         * @returns {departmentmanager.CreateDepartmentRequest} CreateDepartmentRequest instance
         */
        CreateDepartmentRequest.create = function create(properties) {
            return new CreateDepartmentRequest(properties);
        };

        /**
         * Encodes the specified CreateDepartmentRequest message. Does not implicitly {@link departmentmanager.CreateDepartmentRequest.verify|verify} messages.
         * @function encode
         * @memberof departmentmanager.CreateDepartmentRequest
         * @static
         * @param {departmentmanager.ICreateDepartmentRequest} message CreateDepartmentRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CreateDepartmentRequest.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.departmentData != null && Object.hasOwnProperty.call(message, "departmentData"))
                $root.departmentmanager.DepartmentData.encode(message.departmentData, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.departmentResponsibleUserIds != null && message.departmentResponsibleUserIds.length) {
                writer.uint32(/* id 2, wireType 2 =*/18).fork();
                for (var i = 0; i < message.departmentResponsibleUserIds.length; ++i)
                    writer.int64(message.departmentResponsibleUserIds[i]);
                writer.ldelim();
            }
            return writer;
        };

        /**
         * Encodes the specified CreateDepartmentRequest message, length delimited. Does not implicitly {@link departmentmanager.CreateDepartmentRequest.verify|verify} messages.
         * @function encodeDelimited
         * @memberof departmentmanager.CreateDepartmentRequest
         * @static
         * @param {departmentmanager.ICreateDepartmentRequest} message CreateDepartmentRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CreateDepartmentRequest.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a CreateDepartmentRequest message from the specified reader or buffer.
         * @function decode
         * @memberof departmentmanager.CreateDepartmentRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {departmentmanager.CreateDepartmentRequest} CreateDepartmentRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CreateDepartmentRequest.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.departmentmanager.CreateDepartmentRequest();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.departmentData = $root.departmentmanager.DepartmentData.decode(reader, reader.uint32());
                    break;
                case 2:
                    if (!(message.departmentResponsibleUserIds && message.departmentResponsibleUserIds.length))
                        message.departmentResponsibleUserIds = [];
                    if ((tag & 7) === 2) {
                        var end2 = reader.uint32() + reader.pos;
                        while (reader.pos < end2)
                            message.departmentResponsibleUserIds.push(reader.int64());
                    } else
                        message.departmentResponsibleUserIds.push(reader.int64());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a CreateDepartmentRequest message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof departmentmanager.CreateDepartmentRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {departmentmanager.CreateDepartmentRequest} CreateDepartmentRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CreateDepartmentRequest.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a CreateDepartmentRequest message.
         * @function verify
         * @memberof departmentmanager.CreateDepartmentRequest
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        CreateDepartmentRequest.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.departmentData != null && message.hasOwnProperty("departmentData")) {
                var error = $root.departmentmanager.DepartmentData.verify(message.departmentData);
                if (error)
                    return "departmentData." + error;
            }
            if (message.departmentResponsibleUserIds != null && message.hasOwnProperty("departmentResponsibleUserIds")) {
                if (!Array.isArray(message.departmentResponsibleUserIds))
                    return "departmentResponsibleUserIds: array expected";
                for (var i = 0; i < message.departmentResponsibleUserIds.length; ++i)
                    if (!$util.isInteger(message.departmentResponsibleUserIds[i]) && !(message.departmentResponsibleUserIds[i] && $util.isInteger(message.departmentResponsibleUserIds[i].low) && $util.isInteger(message.departmentResponsibleUserIds[i].high)))
                        return "departmentResponsibleUserIds: integer|Long[] expected";
            }
            return null;
        };

        /**
         * Creates a CreateDepartmentRequest message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof departmentmanager.CreateDepartmentRequest
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {departmentmanager.CreateDepartmentRequest} CreateDepartmentRequest
         */
        CreateDepartmentRequest.fromObject = function fromObject(object) {
            if (object instanceof $root.departmentmanager.CreateDepartmentRequest)
                return object;
            var message = new $root.departmentmanager.CreateDepartmentRequest();
            if (object.departmentData != null) {
                if (typeof object.departmentData !== "object")
                    throw TypeError(".departmentmanager.CreateDepartmentRequest.departmentData: object expected");
                message.departmentData = $root.departmentmanager.DepartmentData.fromObject(object.departmentData);
            }
            if (object.departmentResponsibleUserIds) {
                if (!Array.isArray(object.departmentResponsibleUserIds))
                    throw TypeError(".departmentmanager.CreateDepartmentRequest.departmentResponsibleUserIds: array expected");
                message.departmentResponsibleUserIds = [];
                for (var i = 0; i < object.departmentResponsibleUserIds.length; ++i)
                    if ($util.Long)
                        (message.departmentResponsibleUserIds[i] = $util.Long.fromValue(object.departmentResponsibleUserIds[i])).unsigned = false;
                    else if (typeof object.departmentResponsibleUserIds[i] === "string")
                        message.departmentResponsibleUserIds[i] = parseInt(object.departmentResponsibleUserIds[i], 10);
                    else if (typeof object.departmentResponsibleUserIds[i] === "number")
                        message.departmentResponsibleUserIds[i] = object.departmentResponsibleUserIds[i];
                    else if (typeof object.departmentResponsibleUserIds[i] === "object")
                        message.departmentResponsibleUserIds[i] = new $util.LongBits(object.departmentResponsibleUserIds[i].low >>> 0, object.departmentResponsibleUserIds[i].high >>> 0).toNumber();
            }
            return message;
        };

        /**
         * Creates a plain object from a CreateDepartmentRequest message. Also converts values to other types if specified.
         * @function toObject
         * @memberof departmentmanager.CreateDepartmentRequest
         * @static
         * @param {departmentmanager.CreateDepartmentRequest} message CreateDepartmentRequest
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        CreateDepartmentRequest.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.departmentResponsibleUserIds = [];
            if (options.defaults)
                object.departmentData = null;
            if (message.departmentData != null && message.hasOwnProperty("departmentData"))
                object.departmentData = $root.departmentmanager.DepartmentData.toObject(message.departmentData, options);
            if (message.departmentResponsibleUserIds && message.departmentResponsibleUserIds.length) {
                object.departmentResponsibleUserIds = [];
                for (var j = 0; j < message.departmentResponsibleUserIds.length; ++j)
                    if (typeof message.departmentResponsibleUserIds[j] === "number")
                        object.departmentResponsibleUserIds[j] = options.longs === String ? String(message.departmentResponsibleUserIds[j]) : message.departmentResponsibleUserIds[j];
                    else
                        object.departmentResponsibleUserIds[j] = options.longs === String ? $util.Long.prototype.toString.call(message.departmentResponsibleUserIds[j]) : options.longs === Number ? new $util.LongBits(message.departmentResponsibleUserIds[j].low >>> 0, message.departmentResponsibleUserIds[j].high >>> 0).toNumber() : message.departmentResponsibleUserIds[j];
            }
            return object;
        };

        /**
         * Converts this CreateDepartmentRequest to JSON.
         * @function toJSON
         * @memberof departmentmanager.CreateDepartmentRequest
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        CreateDepartmentRequest.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return CreateDepartmentRequest;
    })();

    departmentmanager.DepartmentsResponse = (function() {

        /**
         * Properties of a DepartmentsResponse.
         * @memberof departmentmanager
         * @interface IDepartmentsResponse
         * @property {Array.<departmentmanager.IDepartment>|null} [departments] DepartmentsResponse departments
         * @property {Array.<departmentmanager.IDepartmentUsersCount>|null} [usersCount] DepartmentsResponse usersCount
         */

        /**
         * Constructs a new DepartmentsResponse.
         * @memberof departmentmanager
         * @classdesc Represents a DepartmentsResponse.
         * @implements IDepartmentsResponse
         * @constructor
         * @param {departmentmanager.IDepartmentsResponse=} [properties] Properties to set
         */
        function DepartmentsResponse(properties) {
            this.departments = [];
            this.usersCount = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * DepartmentsResponse departments.
         * @member {Array.<departmentmanager.IDepartment>} departments
         * @memberof departmentmanager.DepartmentsResponse
         * @instance
         */
        DepartmentsResponse.prototype.departments = $util.emptyArray;

        /**
         * DepartmentsResponse usersCount.
         * @member {Array.<departmentmanager.IDepartmentUsersCount>} usersCount
         * @memberof departmentmanager.DepartmentsResponse
         * @instance
         */
        DepartmentsResponse.prototype.usersCount = $util.emptyArray;

        /**
         * Creates a new DepartmentsResponse instance using the specified properties.
         * @function create
         * @memberof departmentmanager.DepartmentsResponse
         * @static
         * @param {departmentmanager.IDepartmentsResponse=} [properties] Properties to set
         * @returns {departmentmanager.DepartmentsResponse} DepartmentsResponse instance
         */
        DepartmentsResponse.create = function create(properties) {
            return new DepartmentsResponse(properties);
        };

        /**
         * Encodes the specified DepartmentsResponse message. Does not implicitly {@link departmentmanager.DepartmentsResponse.verify|verify} messages.
         * @function encode
         * @memberof departmentmanager.DepartmentsResponse
         * @static
         * @param {departmentmanager.IDepartmentsResponse} message DepartmentsResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DepartmentsResponse.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.departments != null && message.departments.length)
                for (var i = 0; i < message.departments.length; ++i)
                    $root.departmentmanager.Department.encode(message.departments[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.usersCount != null && message.usersCount.length)
                for (var i = 0; i < message.usersCount.length; ++i)
                    $root.departmentmanager.DepartmentUsersCount.encode(message.usersCount[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified DepartmentsResponse message, length delimited. Does not implicitly {@link departmentmanager.DepartmentsResponse.verify|verify} messages.
         * @function encodeDelimited
         * @memberof departmentmanager.DepartmentsResponse
         * @static
         * @param {departmentmanager.IDepartmentsResponse} message DepartmentsResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DepartmentsResponse.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DepartmentsResponse message from the specified reader or buffer.
         * @function decode
         * @memberof departmentmanager.DepartmentsResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {departmentmanager.DepartmentsResponse} DepartmentsResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DepartmentsResponse.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.departmentmanager.DepartmentsResponse();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    if (!(message.departments && message.departments.length))
                        message.departments = [];
                    message.departments.push($root.departmentmanager.Department.decode(reader, reader.uint32()));
                    break;
                case 2:
                    if (!(message.usersCount && message.usersCount.length))
                        message.usersCount = [];
                    message.usersCount.push($root.departmentmanager.DepartmentUsersCount.decode(reader, reader.uint32()));
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DepartmentsResponse message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof departmentmanager.DepartmentsResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {departmentmanager.DepartmentsResponse} DepartmentsResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DepartmentsResponse.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DepartmentsResponse message.
         * @function verify
         * @memberof departmentmanager.DepartmentsResponse
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DepartmentsResponse.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.departments != null && message.hasOwnProperty("departments")) {
                if (!Array.isArray(message.departments))
                    return "departments: array expected";
                for (var i = 0; i < message.departments.length; ++i) {
                    var error = $root.departmentmanager.Department.verify(message.departments[i]);
                    if (error)
                        return "departments." + error;
                }
            }
            if (message.usersCount != null && message.hasOwnProperty("usersCount")) {
                if (!Array.isArray(message.usersCount))
                    return "usersCount: array expected";
                for (var i = 0; i < message.usersCount.length; ++i) {
                    var error = $root.departmentmanager.DepartmentUsersCount.verify(message.usersCount[i]);
                    if (error)
                        return "usersCount." + error;
                }
            }
            return null;
        };

        /**
         * Creates a DepartmentsResponse message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof departmentmanager.DepartmentsResponse
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {departmentmanager.DepartmentsResponse} DepartmentsResponse
         */
        DepartmentsResponse.fromObject = function fromObject(object) {
            if (object instanceof $root.departmentmanager.DepartmentsResponse)
                return object;
            var message = new $root.departmentmanager.DepartmentsResponse();
            if (object.departments) {
                if (!Array.isArray(object.departments))
                    throw TypeError(".departmentmanager.DepartmentsResponse.departments: array expected");
                message.departments = [];
                for (var i = 0; i < object.departments.length; ++i) {
                    if (typeof object.departments[i] !== "object")
                        throw TypeError(".departmentmanager.DepartmentsResponse.departments: object expected");
                    message.departments[i] = $root.departmentmanager.Department.fromObject(object.departments[i]);
                }
            }
            if (object.usersCount) {
                if (!Array.isArray(object.usersCount))
                    throw TypeError(".departmentmanager.DepartmentsResponse.usersCount: array expected");
                message.usersCount = [];
                for (var i = 0; i < object.usersCount.length; ++i) {
                    if (typeof object.usersCount[i] !== "object")
                        throw TypeError(".departmentmanager.DepartmentsResponse.usersCount: object expected");
                    message.usersCount[i] = $root.departmentmanager.DepartmentUsersCount.fromObject(object.usersCount[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a DepartmentsResponse message. Also converts values to other types if specified.
         * @function toObject
         * @memberof departmentmanager.DepartmentsResponse
         * @static
         * @param {departmentmanager.DepartmentsResponse} message DepartmentsResponse
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DepartmentsResponse.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults) {
                object.departments = [];
                object.usersCount = [];
            }
            if (message.departments && message.departments.length) {
                object.departments = [];
                for (var j = 0; j < message.departments.length; ++j)
                    object.departments[j] = $root.departmentmanager.Department.toObject(message.departments[j], options);
            }
            if (message.usersCount && message.usersCount.length) {
                object.usersCount = [];
                for (var j = 0; j < message.usersCount.length; ++j)
                    object.usersCount[j] = $root.departmentmanager.DepartmentUsersCount.toObject(message.usersCount[j], options);
            }
            return object;
        };

        /**
         * Converts this DepartmentsResponse to JSON.
         * @function toJSON
         * @memberof departmentmanager.DepartmentsResponse
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DepartmentsResponse.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return DepartmentsResponse;
    })();

    departmentmanager.DepartmentUsersResponse = (function() {

        /**
         * Properties of a DepartmentUsersResponse.
         * @memberof departmentmanager
         * @interface IDepartmentUsersResponse
         * @property {Array.<number>|null} [usersId] DepartmentUsersResponse usersId
         */

        /**
         * Constructs a new DepartmentUsersResponse.
         * @memberof departmentmanager
         * @classdesc Represents a DepartmentUsersResponse.
         * @implements IDepartmentUsersResponse
         * @constructor
         * @param {departmentmanager.IDepartmentUsersResponse=} [properties] Properties to set
         */
        function DepartmentUsersResponse(properties) {
            this.usersId = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * DepartmentUsersResponse usersId.
         * @member {Array.<number>} usersId
         * @memberof departmentmanager.DepartmentUsersResponse
         * @instance
         */
        DepartmentUsersResponse.prototype.usersId = $util.emptyArray;

        /**
         * Creates a new DepartmentUsersResponse instance using the specified properties.
         * @function create
         * @memberof departmentmanager.DepartmentUsersResponse
         * @static
         * @param {departmentmanager.IDepartmentUsersResponse=} [properties] Properties to set
         * @returns {departmentmanager.DepartmentUsersResponse} DepartmentUsersResponse instance
         */
        DepartmentUsersResponse.create = function create(properties) {
            return new DepartmentUsersResponse(properties);
        };

        /**
         * Encodes the specified DepartmentUsersResponse message. Does not implicitly {@link departmentmanager.DepartmentUsersResponse.verify|verify} messages.
         * @function encode
         * @memberof departmentmanager.DepartmentUsersResponse
         * @static
         * @param {departmentmanager.IDepartmentUsersResponse} message DepartmentUsersResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DepartmentUsersResponse.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.usersId != null && message.usersId.length) {
                writer.uint32(/* id 1, wireType 2 =*/10).fork();
                for (var i = 0; i < message.usersId.length; ++i)
                    writer.int64(message.usersId[i]);
                writer.ldelim();
            }
            return writer;
        };

        /**
         * Encodes the specified DepartmentUsersResponse message, length delimited. Does not implicitly {@link departmentmanager.DepartmentUsersResponse.verify|verify} messages.
         * @function encodeDelimited
         * @memberof departmentmanager.DepartmentUsersResponse
         * @static
         * @param {departmentmanager.IDepartmentUsersResponse} message DepartmentUsersResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DepartmentUsersResponse.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DepartmentUsersResponse message from the specified reader or buffer.
         * @function decode
         * @memberof departmentmanager.DepartmentUsersResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {departmentmanager.DepartmentUsersResponse} DepartmentUsersResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DepartmentUsersResponse.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.departmentmanager.DepartmentUsersResponse();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    if (!(message.usersId && message.usersId.length))
                        message.usersId = [];
                    if ((tag & 7) === 2) {
                        var end2 = reader.uint32() + reader.pos;
                        while (reader.pos < end2)
                            message.usersId.push(reader.int64());
                    } else
                        message.usersId.push(reader.int64());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DepartmentUsersResponse message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof departmentmanager.DepartmentUsersResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {departmentmanager.DepartmentUsersResponse} DepartmentUsersResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DepartmentUsersResponse.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DepartmentUsersResponse message.
         * @function verify
         * @memberof departmentmanager.DepartmentUsersResponse
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DepartmentUsersResponse.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.usersId != nul