import { buildSchemaSync, ContainerType } from 'type-graphql';
import { UserResolver } from './resolvers/UserResolver';
import { OrganizationResolver } from './resolvers/OrganizationResolver';
import { DepartmentResolver } from './resolvers/DepartmentResolver';
import { SimpleResolver } from './resolvers/SimpleResolver';

export const buildSchema = (container: ContainerType) => {
    return buildSchemaSync({
        resolvers: [
            UserResolver,
            OrganizationResolver,
            DepartmentResolver,
            SimpleResolver,
        ],
        container,
    });
};
