import { Arg, Int, Mutation, Query, Resolver } from 'type-graphql';
import { inject, injectable } from 'inversify';
import { TYPES } from 'typings/TYPES';
import { UserService } from 'services/UserService';
import { CreateUserInput, UpdateUserInput, User } from 'gql/schema';

@injectable()
@Resolver(User)
export class UserResolver {
    public constructor(
        @inject(TYPES.UserService) private userService: UserService,
    ) {}

    @Query(() => User)
    public async user(@Arg('id', () => Int) id: number) {
        const user = await this.userService.findOne(id);
        if (!user) {
            throw new Error(`No user with id: ${id}`);
        }
        return user;
    }

    @Query(() => [User])
    public async users() {
        return this.userService.findAll();
    }

    @Mutation(() => User)
    public async createUser(@Arg('input') input: CreateUserInput) {
        return this.userService.createUser(input);
    }

    @Mutation(() => User)
    public async updateUser(
        @Arg('id', () => Int) id: number,
        @Arg('input') input: UpdateUserInput,
    ) {
        return this.userService.updateUser(id, input);
    }

    @Mutation(() => User)
    public async archiveUser(@Arg('id', () => Int) id: number) {
        return this.userService.archiveUser(id);
    }
}
