import { CreateDepartmentDto } from 'services/Department';
import { Field, InputType, Int } from 'type-graphql';
import { DepartmentNameInput } from './DepartmentNameInput';

@InputType()
export class CreateDepartmentInput implements CreateDepartmentDto {
    @Field(() => Int)
    organizationId!: number;

    @Field({ nullable: true })
    parentDepartmentId?: string;

    @Field(() => [DepartmentNameInput])
    names!: DepartmentNameInput[];

    @Field(() => [Int])
    responsibleIds!: number[];
}
