import { DepartmentDto } from 'services/Department';
import { Field, Int, ObjectType } from 'type-graphql';
import { DepartmentName } from './DepartmentName';

@ObjectType()
export class Department implements DepartmentDto {
    @Field()
    id!: string;

    @Field(() => Int)
    organizationId!: number;

    @Field()
    parentDepartmentId!: string;

    @Field(() => [DepartmentName])
    names!: DepartmentName[];

    @Field(() => Int)
    usersCount?: number | undefined;
}
