import { Field, InputType, Int } from 'type-graphql';
import { UpdateDepartmentDto } from 'services/Department';
import { DepartmentNameInput } from './DepartmentNameInput';

@InputType()
export class UpdateDepartmentInput implements UpdateDepartmentDto {
    @Field(() => Int, { nullable: true })
    organizationId?: number;

    @Field({ nullable: true })
    parentDepartmentId?: string;

    @Field(() => [DepartmentNameInput], { nullable: true })
    names?: DepartmentNameInput[];
}
