import { ProtobufJSContext } from '@yandex-int/apphost-lib';
import cookie from 'cookie';
import { NAppHostHttp } from '@crm/protos';

const { THttpRequest } = NAppHostHttp;

export async function request(ctx: ProtobufJSContext): Promise<void> {
    const data = await ctx.allIncomingChunks();

    const httpRequest = data
        .getOnlyItem('proto_http_request')
        .parseProto(THttpRequest);
    const cookieHeader = httpRequest.Headers.find(
        header => String(header.Name).toLowerCase() === 'cookie',
    );

    if (!cookieHeader) {
        throw new Error('Has no cookie header');
    }

    if (!cookieHeader.Value) {
        throw new Error('Cookie is empty');
    }

    const cookies = cookie.parse(cookieHeader.Value);

    if (!cookies.Session_id) {
        throw new Error('Has no Session_id');
    }

    const hostHeader = httpRequest.Headers.find(
        header => String(header.Name).toLowerCase() === 'host',
    ) ?? { Name: '', Value: '' };

    const blackboxSearchParams = new URLSearchParams();
    blackboxSearchParams.set('method', 'sessionid');
    blackboxSearchParams.set('sessionid', cookies.Session_id);
    blackboxSearchParams.set('host', hostHeader.Value ?? '');
    blackboxSearchParams.set('userip', httpRequest.RemoteIP);
    blackboxSearchParams.set('format', 'json');
    blackboxSearchParams.set('get_user_ticket', 'yes');

    const blackboxHttpRequestProto = THttpRequest.fromObject({
        Method: THttpRequest.EMethod.Get,
        Scheme: THttpRequest.EScheme.Https,
        Path: `?${blackboxSearchParams}`,
    });

    ctx.sendProtoItem(
        'blackbox_http_request',
        THttpRequest,
        blackboxHttpRequestProto,
    );
}
