import { inject, injectable } from 'inversify';
import { BaseMiddleware } from '@crm/apphost';
import { TYPES } from 'typings/TYPES';
import { Config } from 'services/Config';
import { ProtobufJSContext } from '@yandex-int/apphost-lib';
import { NAppHostHttp } from '@crm/protos';
import got from 'got';

const { THttpResponse } = NAppHostHttp;

@injectable()
export class Hello extends BaseMiddleware<ProtobufJSContext> {
    constructor(@inject(TYPES.Config) private config: Config) {
        super();
    }

    public async handler(ctx: ProtobufJSContext) {
        const page = await got(`${this.config.pathToStatic}/index.html`).text();

        const httpResponseProto = THttpResponse.fromObject({
            Content: Buffer.from(page),
            Headers: [
                { Name: 'Content-Type', Value: 'text/html; charset=UTF-8' },
            ],
            StatusCode: 200,
        });

        ctx.sendProtoItem(
            'proto_http_response',
            THttpResponse,
            httpResponseProto,
        );
    }
}
