/* eslint-disable @typescript-eslint/no-unused-vars */
import {
    BindingContext,
    ContextDataStorage,
    Location,
    BindingItem,
} from '@yandex-int/apphost-lib/src/types/binding';
import { ContextDataStorageTest } from './ContextDataStorageTest';

export class BindingContextTest implements BindingContext {
    private protobufItems: BindingItem[] = [];
    public readonly outputStorage: ContextDataStorageTest;

    constructor(private storage: ContextDataStorage) {
        this.outputStorage = new ContextDataStorageTest(this.protobufItems);
    }

    addItem(item: unknown, type: string): this {
        throw new Error('Method not implemented.');
    }
    addProtobufItem(item: Buffer, type: string): this {
        this.protobufItems.push({ data: item, type });

        return this;
    }
    addRawJSONItem(item: unknown, type: string): this {
        return this;
    }
    addFlag(flag: string): this {
        throw new Error('Method not implemented.');
    }
    addLogLine(line: string): this {
        throw new Error('Method not implemented.');
    }
    getLocation(): Location {
        throw new Error('Method not implemented.');
    }
    getRawRequestData(): Buffer {
        throw new Error('Method not implemented.');
    }
    checkInputFlag(flag: string, source: string): boolean {
        throw new Error('Method not implemented.');
    }
    checkOutputFlag(flag: string): boolean {
        throw new Error('Method not implemented.');
    }
    isJSONToProtoEnabled(): boolean {
        return false;
    }
    isProtoToJSONEnabled(): boolean {
        return false;
    }
    extractStorage(): ContextDataStorage {
        return this.storage;
    }
}
