import {
    ContextDataStorage,
    BindingItem,
} from '@yandex-int/apphost-lib/src/types/binding';

export class ContextDataStorageTest implements ContextDataStorage {
    constructor(private items: BindingItem[] = []) {}

    getAllRawItems(): BindingItem[] {
        return this.items;
    }
    getRawItems(type: string): BindingItem[] {
        return this.items.filter(item => item.type === type);
    }
    getFirstRawItem(type: string): BindingItem | undefined {
        return this.items.find(item => item.type === type);
    }
    getLastRawItem(type: string): BindingItem | undefined {
        return this.items
            .slice()
            .reverse()
            .find(item => item.type === type);
    }
}
