import { injectable } from 'inversify';

@injectable()
export class Config {
    private static instance: Config | null = null;

    public static defaultSalt = '0';

    public static defaultGallifreyUrl =
        'https://hamster.crm.apphost.in.yandex-team.ru';

    static getInstance(): Config {
        if (!Config.instance) {
            Config.instance = new Config();
        }

        return Config.instance;
    }

    readonly allowedTVMServiceIds: number[] = [];
    readonly tvmApiUrl: string;
    readonly tvmApiToken: string;
    readonly tvmSelf: string;
    readonly gallifreyUrl: string;
    readonly appKey: string;
    readonly pathToStatic: string;

    constructor() {
        this.allowedTVMServiceIds = (process.env.ALLOWED_TVM_SERVICE_IDS ?? '')
            .split(',')
            .map(Number);
        this.tvmSelf = process.env.TVM_SELF ?? '';
        this.tvmApiUrl = process.env.DEPLOY_TVM_TOOL_URL ?? '';
        this.tvmApiToken = process.env.TVMTOOL_LOCAL_AUTHTOKEN ?? '';
        this.gallifreyUrl =
            process.env.GALLIFREY_URL ?? Config.defaultGallifreyUrl;
        this.appKey = process.env.APP_KEY ?? Config.defaultSalt;

        this.pathToStatic = process.env.MDS_STATIC_BUILD_PATH ?? '';
        if (this.pathToStatic.startsWith('s3://')) {
            const mdsEndpoint = process.env.MDS_ENDPOINT ?? '';
            this.pathToStatic = mdsEndpoint + this.pathToStatic.slice(4);
        }
    }
}
