// https://wiki.yandex-team.ru/passport/tvm2/tvm-daemon#apiv2
import { injectable } from 'inversify';
import {
    TVMServiceTicketCheck,
    TVMApiClient as ITVMApiClient,
    TVMServiceTicketResponse,
} from 'typings/TVMApiClient';

@injectable()
export class NullTVMApiClient implements ITVMApiClient {
    checkServiceTicket(): Promise<TVMServiceTicketCheck> {
        return Promise.resolve({
            status: 'ok',
            src: -1,
            debug_string: '',
            logging_string: '',
            roles: '',
        });
    }

    getTickets(): Promise<
        Record<string, TVMServiceTicketResponse | undefined>
    > {
        return Promise.resolve({
            gallifrey: {
                ticket: '',
                tvm_id: -1,
            },
        });
    }
}
