/* eslint-disable camelcase */

export interface TVMApiClientOptions {
    self: string;
    serverUrl: string;
    token: string;
    allowedTVMServiceIds?: number[];
}

export interface TVMApiClientGetTicketsOptions {
    dsts: string[];
}

export interface TVMServiceTicketResponse {
    error?: string;
    ticket?: string;
    // eslint-disable-next-line camelcase
    tvm_id: number;
}

export interface TVMServicePingResponse {
    status: string;
    error?: string;
}

export interface TVMApiClientCheckOptions {
    serviceTicket?: string;
    userTicket?: string;
}

export interface TVMTicketsCheckResponse {
    status: string;
    error?: string;
    service: TVMServiceTicketCheck;
}

export interface TVMServiceTicketCheck {
    status: string;
    error?: string;
    src: number;
    debug_string: string;
    logging_string: string;
    roles: unknown;
}

export interface TVMApiClient {
    checkServiceTicket(serviceTicket: string): Promise<TVMServiceTicketCheck>;
    getTickets(
        options: TVMApiClientGetTicketsOptions,
    ): Promise<Record<string, TVMServiceTicketResponse | undefined>>;
}
