import { RequestError } from '@yandex-int/apphost-lib';
import { Logger } from '@yandex-int/yandex-logger';
import { injectable, inject } from 'inversify';
import {
    TYPES as ApphostTypes,
    BaseMiddleware,
    BaseContext,
    NextFunction,
} from '@crm/apphost';
import { NAppHostProtocol } from '@crm/protos';
import { TYPES } from '../typings/TYPES';
import { TVMApiClient } from '../typings/TVMApiClient';

@injectable()
export class TVMCheckMiddleware<
    Context extends BaseContext,
> extends BaseMiddleware<Context> {
    constructor(
        @inject(ApphostTypes.Logger) private logger: Logger,
        @inject(ApphostTypes.Request)
        private request: NAppHostProtocol.TServiceRequest,
        @inject(TYPES.TVMClient) private tvmClient: TVMApiClient,
    ) {
        super();
    }

    public async handler(_ctx: Context, next: NextFunction) {
        this.logger.info(this.request, 'TVMCheckMiddleware request');
        try {
            await this.tvmClient.checkServiceTicket(this.request.Ticket);
        } catch (error) {
            if (error instanceof Error) {
                throw new RequestError(error.message);
            }

            throw new RequestError('Unknown service ticket check error');
        }

        await next();
    }
}
