import { AsyncLocalStorage } from 'async_hooks';
import { injectable, inject } from 'inversify';
import {
    TYPES as ApphostTypes,
    BaseMiddleware,
    BaseContext,
    NextFunction,
    AsyncLocalStorageStore,
} from '@crm/apphost';
import { TYPES } from '../typings/TYPES';
import { TVMApiClient } from '../typings/TVMApiClient';

@injectable()
export class TVMServiceTicketMiddleware<
    Context extends BaseContext,
> extends BaseMiddleware<Context> {
    constructor(
        @inject(ApphostTypes.AsyncLocalStorage)
        private asyncLocalStorage: AsyncLocalStorage<AsyncLocalStorageStore>,
        @inject(TYPES.TVMClient) private tvmClient: TVMApiClient,
    ) {
        super();
    }

    public async handler(_ctx: Context, next: NextFunction) {
        const serviceTickets = await this.tvmClient.getTickets({
            dsts: ['gallifrey'],
        });
        const tvmServiceTicket = serviceTickets.gallifrey?.ticket || '';
        const store = this.asyncLocalStorage.getStore();
        store?.set('gallifrey_service_ticket', tvmServiceTicket);

        await next();
    }
}
