import {
    RequestError,
    AbstractContext,
    AbstractIncomingChunk,
    Item,
} from '@yandex-int/apphost-lib';
import { Handler } from 'typings/Handler';
import { TVMApiClient } from 'typings/TVMApiClient';
import { NAppHostProtocol } from '@crm/protos';

export interface CreateTVMCheckMiddlewareOptions {
    tvmClient: TVMApiClient;
}

export const createTVMCheckMiddleware =
    <TContext extends AbstractContext<AbstractIncomingChunk<Item>>>(
        options: CreateTVMCheckMiddlewareOptions,
    ): Handler<TContext> =>
    async (ctx: TContext) => {
        const request = NAppHostProtocol.TServiceRequest.decode(
            ctx.getRawRequestData(),
        );

        if (!request.Ticket) {
            throw new RequestError('No service ticket');
        }

        try {
            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
            await options.tvmClient.checkServiceTicket(request.Ticket);
        } catch (error) {
            if (error instanceof Error) {
                throw new RequestError(error.message);
            }

            throw new RequestError('Unknown service ticket check error');
        }
    };
