export const hideSecretValue = (str: string): string => {
    const len = str.length;

    if (!len) {
        return '';
    }

    const visibleCharsOnEdge = Math.floor(len / 4);

    if (!visibleCharsOnEdge) {
        return 'XXX';
    }

    return `${str.slice(0, visibleCharsOnEdge)}XXX${str.slice(
        -visibleCharsOnEdge,
    )}`;
};
