const path = require('path');
const webpack = require('webpack');
const { getCert } = require('@yandex-int/yandex-internal-cert');

module.exports = {
    target: 'node',
    mode: process.env.NODE_ENV,
    context: path.resolve(__dirname),
    entry: './src/index.ts',
    optimization: {
        minimize: false,
    },
    module: {
        rules: [
            {
                test: /\.tsx?$/,
                use: 'ts-loader',
                exclude: /node_modules/,
            },
        ],
    },
    resolve: {
        modules: [path.resolve(__dirname, 'src'), 'node_modules'],
        extensions: ['.tsx', '.ts', '.js', '.json'],
    },
    output: {
        filename: 'index.js',
        path: path.resolve(__dirname, 'dist'),
    },
    externals: {
        '@yandex-int/apphost-lib': 'commonjs2 @yandex-int/apphost-lib',
        '@yandex-int/yson': 'commonjs2 @yandex-int/yson',
    },
    plugins: [
        new webpack.DefinePlugin({
            CA: JSON.stringify(String(getCert())),
        }),
    ],
};
