# imaskjs
vanilla javascript input mask

[![Build Status](https://travis-ci.com/uNmAnNeR/imaskjs.svg?branch=master)](https://travis-ci.com/uNmAnNeR/imaskjs)
[![Financial Contributors on Open Collective](https://opencollective.com/imask/all/badge.svg?label=financial+contributors)](https://opencollective.com/imask) [![Coverage Status](https://coveralls.io/repos/github/uNmAnNeR/imaskjs/badge.svg?branch=master)](https://coveralls.io/github/uNmAnNeR/imaskjs?branch=master)
[![npm version](https://badge.fury.io/js/imask.svg)](https://badge.fury.io/jas/imask)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)
[![lerna](https://img.shields.io/badge/maintained%20with-lerna-cc00ff.svg)](https://lernajs.io/)

<a href="https://opencollective.com/imask/donate" target="_blank">
  <img src="https://opencollective.com/imask/donate/button.png?color=blue" width=300 />
</a>

## Features
* get and set *raw* and *unmasked* values easily
* no external dependencies
* supports *[overwrite](https://imask.js.org/guide.html#overwrite)* mode
* supports *web components*
* supports *contenteditable*
* **[RegExp](https://imask.js.org/guide.html#masked-base)** mask
* **[Function](https://imask.js.org/guide.html#masked-function)** mask
* **[Number](https://imask.js.org/guide.html#masked-number)** mask (integer and decimal)
* **[Date](https://imask.js.org/guide.html#masked-date)** mask (various format support, *autofix* mode)
* **[Dynamic/on-the-fly](https://imask.js.org/guide.html#masked-dynamic)** mask
* **[Pattern](https://imask.js.org/guide.html#masked-pattern)** mask
  - show placeholder always and only when necessary
  - unmasked value can contain fixed parts
  - optional input parts (greedy)
  - custom definitions
  - reusable blocks
  - **[Enum](https://imask.js.org/guide.html#masked-enum)** and **[Range](https://imask.js.org/guide.html#masked-range)** masks
* convert and format values with **[pipe](https://imask.js.org/guide.html#pipe)**

## Plugins
* [Vue plugin](https://github.com/uNmAnNeR/imaskjs/tree/master/packages/vue-imask)
* [Angular plugin](https://github.com/uNmAnNeR/imaskjs/tree/master/packages/angular-imask)
* [React plugin](https://github.com/uNmAnNeR/imaskjs/tree/master/packages/react-imask)
* [React Native plugin](https://github.com/uNmAnNeR/imaskjs/tree/master/packages/react-native-imask)
* [Svelte plugin](https://github.com/uNmAnNeR/imaskjs/tree/master/packages/svelte-imask)

## Install
`npm install imask` and `import IMask from 'imask';`

or use CDN:

`<script src="https://unpkg.com/imask"></script>`

## Build & Test
`npm run make`

## Compatibility
Supports all major browsers and IE11+ [need to support older?](https://imask.js.org/guide.html#support-older)

## Getting help
- [Documentation and examples](https://imask.js.org/)
- check answers on [stackoverflow.com](https://stackoverflow.com)
- ask question in [discussions](https://github.com/uNmAnNeR/imaskjs/discussions)
- [Телега если быстро и коротко](https://t.me/imaskjs)

## Support Development
[Paypal](https://www.paypal.me/alexeykryazhev/3)

## Contributors

### Code Contributors

This project exists thanks to all the people who contribute. [[Contribute](CONTRIBUTING.md)].
<a href="https://github.com/uNmAnNeR/imaskjs/graphs/contributors"><img src="https://opencollective.com/imask/contributors.svg?width=890&button=false" /></a>

### Financial Contributors

Become a financial contributor and help us sustain our community. [[Contribute](https://opencollective.com/imask/contribute)]

#### Individuals

<a href="https://opencollective.com/imask"><img src="https://opencollective.com/imask/individuals.svg?width=890"></a>

#### Organizations

Support this project with your organization. Your logo will show up here with a link to your website. [[Contribute](https://opencollective.com/imask/contribute)]

<a href="https://opencollective.com/imask/organization/0/website"><img src="https://opencollective.com/imask/organization/0/avatar.svg"></a>
<a href="https://opencollective.com/imask/organization/1/website"><img src="https://opencollective.com/imask/organization/1/avatar.svg"></a>
<a href="https://opencollective.com/imask/organization/2/website"><img src="https://opencollective.com/imask/organization/2/avatar.svg"></a>
<a href="https://opencollective.com/imask/organization/3/website"><img src="https://opencollective.com/imask/organization/3/avatar.svg"></a>
<a href="https://opencollective.com/imask/organization/4/website"><img src="https://opencollective.com/imask/organization/4/avatar.svg"></a>
<a href="https://opencollective.com/imask/organization/5/website"><img src="https://opencollective.com/imask/organization/5/avatar.svg"></a>
<a href="https://opencollective.com/imask/organization/6/website"><img src="https://opencollective.com/imask/organization/6/avatar.svg"></a>
<a href="https://opencollective.com/imask/organization/7/website"><img src="https://opencollective.com/imask/organization/7/avatar.svg"></a>
<a href="https://opencollective.com/imask/organization/8/website"><img src="https://opencollective.com/imask/organization/8/avatar.svg"></a>
<a href="https://opencollective.com/imask/organization/9/website"><img src="https://opencollective.com/imask/organization/9/avatar.svg"></a>
