import IMask from './imask.js';
export { default as InputMask } from './controls/input.js';

export { default as Masked } from './masked/base.js';
export { default as MaskedPattern } from './masked/pattern.js';
export { default as MaskedEnum } from './masked/enum.js';
export { default as MaskedRange } from './masked/range.js';
export { default as MaskedNumber } from './masked/number.js';
export { default as MaskedDate } from './masked/date.js';
export { default as MaskedRegExp } from './masked/regexp.js';
export { default as MaskedFunction } from './masked/function.js';
export { default as MaskedDynamic } from './masked/dynamic.js';
export { default as createMask } from './masked/factory.js';
export { default as MaskElement } from './controls/mask-element.js';
export { default as HTMLMaskElement } from './controls/html-mask-element.js';
export { default as HTMLContenteditableMaskElement } from './controls/html-contenteditable-mask-element.js';
export { createPipe, pipe, PIPE_TYPE } from './masked/pipe.js';

try {
    globalThis.IMask = IMask;
} catch(e) {}
export default IMask;
