import React from 'react';
import { Grid } from '../components/Grid';
import { Select } from './Select';
import { StatefulSelect } from './StatefulSelect';
import { SelectOption } from '../types/SelectOption';

const options: SelectOption[] = [
  {
    id: 1,
    text: 'Option 1',
  },
  {
    id: 2,
    text: 'Option 2',
  },
  {
    id: 3,
    text: 'Option 1343423',
  },
  {
    id: 4,
    text: 'Option 25432',
  },
  {
    id: 5,
    text: 'Option 1343423',
  },
  {
    id: 6,
    text: 'Option 25432',
  },
  {
    id: 7,
    text: 'Option 1343423',
  },
  {
    id: 8,
    text: 'Option 25432',
  },
  {
    id: 9,
    text: 'Option 25432',
  },
  {
    id: 10,
    text: 'Option 1343423',
  },
  {
    id: 11,
    text: 'Option 25432',
  },
];

export const Default = () => {
  return (
    <div style={{ padding: '400px 0' }}>
      <Grid>
        <StatefulSelect
          label="Longer label"
          onLoad={() => {
            return new Promise((resolve) => {
              setTimeout(() => resolve(options), 3000);
            });
          }}
          defaultValue={{
            id: 1,
            text: 'option',
          }}
        />
        <StatefulSelect
          label="Longer label"
          onLoad={() => options.slice(0, 3)}
          defaultValue={{
            id: 2,
            text: 'option',
          }}
        />
        <StatefulSelect
          label="Longer label"
          onLoad={() => []}
          defaultValue={{
            id: 1,
            text: 'option',
          }}
        />
      </Grid>

      <button>index</button>
    </div>
  );
};

export default {
  title: 'Attribute2/Select',
  component: Select,
};
