import React, { FC, useState, useCallback } from 'react';
import { Select } from './Select';
import { SelectEditingValue, StatefulSelectProps } from './Select.types';

export const StatefulSelect: FC<StatefulSelectProps> = (props) => {
  const [isEditing, setEditing] = useState(false);
  const [value, setValue] = useState<SelectEditingValue>(props.defaultValue);

  const handleChange = useCallback((newValue: SelectEditingValue) => {
    setValue(newValue);
    setEditing(false);
  }, []);

  return (
    <Select
      {...props}
      isEditing={isEditing}
      onEditingChange={setEditing}
      label={props.label}
      readingValue={value && value.text}
      editingValue={value}
      onChange={handleChange}
    />
  );
};
