import React, { FC, useState } from 'react';
import { StatefulSuggestSelectProps, SuggestSelectEditingValue } from './SuggestSelect.types';
import { SuggestSelect } from './SuggestSelect';

export const StatefulSuggestSelect: FC<StatefulSuggestSelectProps> = (props) => {
  const [isEditing, setEditing] = useState(false);
  const [value, setValue] = useState<SuggestSelectEditingValue>(props.defaultValue);

  return (
    <SuggestSelect
      {...props}
      isEditing={isEditing}
      onEditingChange={setEditing}
      readingValue={value}
      editingValue={value}
      onChange={setValue}
    />
  );
};
