import React from "react";
import { Grid } from "../components/Grid";
import { StatefulSuggestSelect } from "./StatefulSuggestSelect";
import { SelectOption } from "../types/SelectOption";

const options: SelectOption[] = [
    {
        id: 1,
        text: "a",
    },
    {
        id: 2,
        text: "ab",
    },
    {
        id: 3,
        text: "ad",
    },
    {
        id: 4,
        text: "ac",
    },
    {
        id: 5,
        text: "b",
    },
    {
        id: 6,
        text: "ba",
    },
    {
        id: 7,
        text: "bc",
    },
    {
        id: 8,
        text: "bca",
    },
    {
        id: 9,
        text: "bcd",
    },
    {
        id: 10,
        text: "aaa",
    },
    {
        id: 11,
        text: "bbb",
    },
];

const loadOptions = (text: string) => {
    return new Promise<SelectOption[]>((resolve) => {
        setTimeout(() => {
            resolve(options.filter((option) => option.text.includes(text)));
        }, 800);
    });
};

export const Default = () => {
    return (
        <div style={{ padding: "400px 0" }}>
            <Grid>
                <StatefulSuggestSelect
                    label="Longer label"
                    onLoad={loadOptions}
                    defaultValue={{
                        id: 1,
                        text: "a",
                    }}
                />
                <StatefulSuggestSelect
                    label="Longer label"
                    onLoad={loadOptions}
                    defaultValue={{
                        id: 2,
                        text: "ab",
                    }}
                />
                <StatefulSuggestSelect
                    label="Longer label"
                    onLoad={loadOptions}
                    defaultValue={{
                        id: 3,
                        text: "ad",
                    }}
                />
            </Grid>

            <button>index</button>
        </div>
    );
};

export default {
    title: "Attribute2/SuggestSelect",
};
