import { ReadingProps } from "../types/ReadingProps";
import { EditingProps } from "../types/EditingProps";
import { EntireProps } from "../types/EntireProps";
import { StatefulProps } from "../types/StatefulProps";
import { SelectOption } from "../types/SelectOption";

export type SuggestSelectReadingValue = SelectOption | null;
export type SuggestSelectEditingValue = SelectOption | null;

export type SuggestSelectReadingProps = ReadingProps<SuggestSelectReadingValue>;
export interface SuggestSelectEditingProps
    extends EditingProps<SuggestSelectEditingValue> {
    onLoad?: (text: string) => Promise<SelectOption[]> | SelectOption[];
    canDelete?: boolean;
}

export type SuggestSelectProps = EntireProps<
    SuggestSelectReadingProps,
    SuggestSelectEditingProps
>;
export type StatefulSuggestSelectProps = StatefulProps<SuggestSelectProps>;
