import React, { useCallback } from "react";
import { stopEditingEvent } from "../../../events";
import { LengthOneAdapterProps } from "./LengthOneAdapter.types";
import { SuggestSelectMultiple } from "../SuggestSelectMultiple";

export const LengthOneAdapter = <T extends {}>(
    props: LengthOneAdapterProps<T>
) => {
    const {
        readingValue,
        editingValue,
        onChange,
        onEditingChange,
        onEvent,
        component: Component = SuggestSelectMultiple,
    } = props;

    const handleChange = useCallback(
        (value: T[]) => {
            if (!value.length) {
                onChange?.(null);
            } else {
                onChange?.(value[value.length - 1]);
                onEvent?.(stopEditingEvent());
                onEditingChange?.(false);
            }
        },
        [onChange, onEditingChange]
    );

    return (
        <Component<T>
            {...props}
            readingValue={readingValue == null ? [] : [readingValue]}
            editingValue={editingValue == null ? [] : [editingValue]}
            onChange={handleChange}
            onEditingChange={onEditingChange}
        />
    );
};
