import React, { useState } from 'react';
import {
  StatefulSuggestSelectMultipleProps,
  SuggestSelectMultipleEditingValue,
} from './SuggestSelectMultiple.types';
import { SuggestSelectMultiple } from './SuggestSelectMultiple';

export const StatefulSuggestSelectMultiple = <T extends {}>(
  props: StatefulSuggestSelectMultipleProps<T>,
) => {
  const [isEditing, setEditing] = useState(false);
  const [value, setValue] = useState<SuggestSelectMultipleEditingValue<T>>(props.defaultValue);

  return (
    <SuggestSelectMultiple<T>
      {...props}
      isEditing={isEditing}
      onEditingChange={setEditing}
      readingValue={value}
      editingValue={value}
      onChange={setValue}
    />
  );
};
