import React from "react";
import { Text } from "../../lego2/Text";
import { Bubble } from "../../Bubble";
import { Grid } from "../components/Grid";
import { StatefulSuggestSelectMultiple } from "./StatefulSuggestSelectMultiple";
import { SelectOption } from "../types/SelectOption";

const options: SelectOption[] = [
    {
        id: 1,
        text: "a",
    },
    {
        id: 2,
        text: "ab",
    },
    {
        id: 3,
        text: "ad",
    },
    {
        id: 4,
        text: "ac",
    },
    {
        id: 5,
        text: "b",
    },
    {
        id: 6,
        text: "ba",
    },
    {
        id: 7,
        text: "bc",
    },
    {
        id: 8,
        text: "bca",
    },
    {
        id: 9,
        text: "bcd",
    },
    {
        id: 10,
        text: "aaa",
    },
    {
        id: 11,
        text: "bbb",
    },
];

const tags = [
    {
        id: 1,
        text: "Personal tag",
        type: "Personal",
    },
    {
        id: 2,
        text: "Common tag",
        type: "Shared",
    },
];

const wait = (ms: number) =>
    new Promise<void>((resolve) => setTimeout(resolve, ms));

const loadOptions = async (text: string) => {
    await wait(800);
    return options.filter((option) => option.text.includes(text));
};

const loadTags = async (text: string) => {
    await wait(800);
    return tags.filter((tag) => tag.text.includes(text));
};

export const Default = () => {
    return (
        <div style={{ padding: "400px 0" }}>
            <Grid>
                <StatefulSuggestSelectMultiple
                    label="Default"
                    onLoad={loadOptions}
                    defaultValue={[options[0]]}
                />
                <StatefulSuggestSelectMultiple
                    label="Override reading row rendering"
                    renderReadingRow={(item) => (
                        <Text
                            style={{ width: "100%" }}
                            color="success"
                            typography="control-m"
                        >
                            {item.text}
                        </Text>
                    )}
                    onLoad={loadOptions}
                    defaultValue={[options[1]]}
                />
                <StatefulSuggestSelectMultiple
                    label="Override popup item rendering"
                    renderPopupItem={(item) => (
                        <Text color="success" typography="control-m">
                            {item.text}
                        </Text>
                    )}
                    onLoad={loadOptions}
                    defaultValue={[options[2]]}
                />
                <StatefulSuggestSelectMultiple
                    label="Override selected bubble rendering"
                    renderSelectedBubble={(item, props) => (
                        <Bubble {...props}>
                            <Text color="success" typography="control-m">
                                {item.text}
                            </Text>
                        </Bubble>
                    )}
                    onLoad={loadOptions}
                    defaultValue={[options[2]]}
                />
            </Grid>

            <button>index</button>
        </div>
    );
};

export default {
    title: "Attribute2/SuggestSelectMultiple",
};
