import { ReactElement, ReactNode } from "react";
import { Instance } from "@popperjs/core";
import { LoadingPopupProps } from "../../LoadingPopup";
import { Event } from "../../types/Event";
import { EditingProps } from "../types/EditingProps";
import { EntireProps } from "../types/EntireProps";
import { StatefulProps } from "../types/StatefulProps";
import { SelectOption } from "../types/SelectOption";
import { KeyValueMultipleReadingProps } from "../components/KeyValueMultipleReading";
import { BubbleProps } from "../../Bubble";

export interface SuggestSelectMultipleEditingInstance {
    reload(): void;
    resetText(): void;
}

export { RenderReadingRowProps } from "../components/KeyValueMultipleReading";
export type SuggestSelectMultipleReadingValue<T> = T[];
export type SuggestSelectMultipleEditingValue<T> = T[];

export type SuggestSelectMultipleReadingProps<T = SelectOption> =
    KeyValueMultipleReadingProps<T>;
export type RenderPopupMenuProps<T = SelectOption> = Pick<
    LoadingPopupProps,
    "isLoading" | "isVisible" | "anchor" | "popperRef" | "onClose"
> & {
    text: string;
    onChange: (key: number | string | T) => void;
    items: T[];
    isFocused?: boolean;
    onEvent?: (event: Event) => void;
};

export interface SuggestSelectMultipleEditingProps<T = SelectOption>
    extends EditingProps<SuggestSelectMultipleEditingValue<T>> {
    onLoad?: (text: string) => Promise<T[]> | T[];
    getKey?: (item: T) => string | number;
    renderSelectedBubble?: (item: T, props: BubbleProps) => ReactElement;
    renderPopupItem?: (item: T) => ReactElement;
    renderPopupMenu?: (props: RenderPopupMenuProps<T>) => ReactElement;
    popperRef?: (instance: Instance) => void;
    instanceRef?: (instance: SuggestSelectMultipleEditingInstance) => void;
    canListenKeyboard?: boolean;
    canFocusMenu?: boolean;
    canDelete?: boolean;
    isContentEditableDisabled?: boolean;
    appendAddon?: ReactNode;
}

export type SuggestSelectMultipleProps<T = SelectOption> = EntireProps<
    SuggestSelectMultipleReadingProps<T>,
    SuggestSelectMultipleEditingProps<T>
>;
export type StatefulSuggestSelectMultipleProps<T = SelectOption> =
    StatefulProps<SuggestSelectMultipleProps<T>>;
