import React, { FC, useState, useCallback } from 'react';
import { Textinput } from './Textinput';
import { StatefulTextinputProps, TextinputEditingValue } from './Textinput.types';

export const StatefulTextinput: FC<StatefulTextinputProps> = (props) => {
  const [isEditing, setEditing] = useState(false);
  const [value, setValue] = useState<TextinputEditingValue>(props.defaultValue);

  const handleChange = useCallback((newValue: string) => {
    setValue(newValue);
    setEditing(false);
  }, []);

  return (
    <Textinput
      {...props}
      isEditing={isEditing}
      onEditingChange={setEditing}
      label={props.label}
      readingValue={value}
      editingValue={value}
      onChange={handleChange}
    />
  );
};
