import React, { FC } from 'react';
import cx from 'classnames';
import { EditingAreaProps } from './EditingArea.types';
import css from './EditingArea.module.css';

export const EditingArea: FC<EditingAreaProps> = (props) => {
  const { name, display, tabIndex, innerRef, children } = props;

  const className = cx(css.EditingArea, props.className, {
    [css.EditingArea_display]: display,
  });

  return (
    <div
      data-testid={`attribute_${name}`}
      hidden={!display}
      className={className}
      ref={innerRef}
      tabIndex={tabIndex}
    >
      {children}
    </div>
  );
};
