import React, { FC, useState, useMemo, useCallback } from "react";
import { FocusScope } from "../../../FocusScope";
import { insideAttributesKeyboardContext } from "../InsideAttributesKeyboardContext";
import { GridTemplate } from "../GridTemplate";
import { GridProps } from "./Grid.types";

const Provider = insideAttributesKeyboardContext.Provider;

export const Grid: FC<GridProps> = ({ children, innerRef }) => {
    const [
        attributesHandlingKeyboardCount,
        setAttributesHandlingKeyboardCount,
    ] = useState(0);

    const startHandling = useCallback(() => {
        setAttributesHandlingKeyboardCount((prev) => prev + 1);
        return () => {
            setAttributesHandlingKeyboardCount((prev) => prev - 1);
        };
    }, []);

    const providerValue = useMemo(
        () => ({
            startHandling,
        }),
        [startHandling]
    );

    return (
        <FocusScope canListenKeyboard={attributesHandlingKeyboardCount === 0}>
            <Provider value={providerValue}>
                <GridTemplate innerRef={innerRef}>{children}</GridTemplate>
            </Provider>
        </FocusScope>
    );
};
