import React, { FC, memo } from 'react';
import cx from 'classnames';
import { GridTemplateProps } from './GridTemplate.types';
import css from './GridTemplate.module.css';

export const GridTemplate: FC<GridTemplateProps> = memo((props) => {
  const { children, display = true, innerRef, full, ...rest } = props;

  const className = cx(css.GridTemplate, props.className, {
    [css.GridTemplate_full]: full,
    [css.GridTemplate_display]: display,
  });

  return (
    <div {...rest} hidden={!display} ref={innerRef} className={className}>
      {children}
    </div>
  );
});
