import React, { useCallback, Fragment } from "react";
import Button from "../../../lego2/Button";
import { useDividableList } from "../../../useDividableList";
import { Label } from "../../components/Label";
import { Value } from "../../components/Value";
import { Row } from "./Row";
import { KeyValueMultipleReadingProps } from "./KeyValueMultipleReading.types";
import { KeyValueReading, RenderProps } from "../KeyValueReading";
import { SelectOption } from "../../types/SelectOption";
import css from "./KeyValueMultipleReading.module.css";

const renderSelectOption = <T extends {}>(item: T) => (
    <Row item={item as unknown as SelectOption} />
);
const getOptionId = <T extends {}>(item: T) =>
    (item as unknown as SelectOption).id;

export const KeyValueMultipleReading = <T extends {}>(
    props: KeyValueMultipleReadingProps<T>
) => {
    const {
        label,
        readingValue,
        isReadingLoading = false,
        renderReadingRow = renderSelectOption,
        getKey = getOptionId,
    } = props;

    const {
        left: visibleValues,
        right: hiddenValues,
        collapse: showAllValues,
    } = useDividableList(readingValue);

    const renderKeyValue = useCallback(
        (props: RenderProps) => {
            return (
                <>
                    <Label>{label}</Label>
                    <Value
                        className={css.KeyValueMultipleReading__value}
                        isEmpty={!readingValue.length}
                        isLoading={isReadingLoading}
                    >
                        {visibleValues.map((item) => (
                            <Fragment key={getKey(item)}>
                                {renderReadingRow(item, props)}
                            </Fragment>
                        ))}
                        {hiddenValues.length > 0 && (
                            <Button
                                tabIndex={-1}
                                onClick={(event) => {
                                    props.onEssentialClick(event);
                                    showAllValues();
                                }}
                                view="clear"
                                className={
                                    css.KeyValueMultipleReading__showAllButton
                                }
                            >
                                Показать все
                            </Button>
                        )}
                    </Value>
                </>
            );
        },
        [visibleValues, hiddenValues, label, readingValue, isReadingLoading]
    );

    return <KeyValueReading<T[]> {...props} render={renderKeyValue} />;
};
