import React, { FC, memo } from "react";
import { Text } from "../../../lego2/Text";
import { PartContainer } from "../PartContainer";
import { LabelProps } from "./Label.types";
import css from "./Label.module.css";

export const Label: FC<LabelProps> = memo((props) => {
    const { children } = props;

    return (
        <PartContainer className={css.Label} aria-label="label">
            <Text typography="body-short-m" className={css.Label__text}>
                {children}
            </Text>
        </PartContainer>
    );
});
