import React, { FC } from 'react';
import cx from 'classnames';
import { PartContainerProps } from './PartContainer.types';
import css from './PartContainer.module.css';

export const PartContainer: FC<PartContainerProps> = (props) => {
  const { children, style, ...rest } = props;

  const className = cx(css.PartContainer, props.className);

  return (
    <div {...rest} className={className} style={style}>
      {children}
    </div>
  );
};
