import React, { FC } from "react";
import cx from "classnames";
import Spin from "../../../lego2/Spin";
import { Text } from "../../../lego2/Text";
import { ValueProps } from "./Value.types";
import { PartContainer } from "../PartContainer";
import css from "./Value.module.css";

export const Value: FC<ValueProps> = (props) => {
    const {
        children,
        padding,
        isEmpty = !children,
        isLoading = false,
        ...restProps
    } = props;

    const className = cx(css.Value, props.className);

    const style = {
        ...props.style,
        padding,
    };

    return (
        <PartContainer
            {...restProps}
            className={className}
            style={style}
            aria-label="value"
        >
            {isEmpty && !isLoading && (
                <Text typography="body-short-m" color="secondary">
                    –
                </Text>
            )}
            {!isEmpty && !isLoading && children}
            {isLoading && <Spin progress view="default" size="xxs" />}
        </PartContainer>
    );
};
