import { EntireProps } from './EntireProps';
import { ReadingProps } from './ReadingProps';
import { EditingProps } from './EditingProps';

export type StatefulProps<
  EP extends EntireProps<ReadingProps<unknown>, EditingProps<unknown>>,
  DV = EP['editingValue']
> = Omit<EP, 'isEditing' | 'readingValue' | 'editingValue'> & {
  defaultValue: DV;
};
