import { useState, useCallback } from 'react';

export const useListLoad = <T extends {}>(props: {
  onLoad?: (text?: string) => T[] | Promise<T[]>;
}) => {
  const { onLoad } = props;

  const [isLoading, setLoading] = useState(false);
  const [list, setList] = useState<T[]>([]);

  const handleLoad = useCallback((text?: string) => {
    if (!onLoad) {
      return;
    }

    const result = onLoad(text);
    if (result instanceof Promise) {
      setLoading(true);
      result
        .then((newList) => {
          setList(newList);
        })
        .finally(() => {
          setLoading(false);
        });
    } else {
      setList(result);
    }
  }, []);

  return {
    list,
    handleLoad,
    isLoading,
  } as const;
};
