import { ComponentType } from "react";
import { Event } from "../types/Event";

export type AttributesSchemeRow<C extends string = string, F = {}> = {
    name: string;
    access?: number;
    backendUpdateKey?: string;
    label: string;
    component: C;
    fieldProps?: any;
} & F;

export type AttributesScheme = AttributesSchemeRow[];

export interface AttributeComponentCallbackProps<V extends unknown = unknown>
    extends Record<string, unknown> {
    value?: V;
    isDisabled?: boolean;
}

export type ComponentsProperty = Record<
    string,
    {
        render?: ComponentType<AttributeComponentProps>;
        getProps?: (
            attribute: AttributesSchemeRow
        ) => AttributeComponentCallbackProps<unknown>;
        changeHandler?: (
            attribute: AttributesSchemeRow,
            value: unknown
        ) => Promise<void | void[]>;
    }
>;

export interface AttributesBySchemeProps {
    scheme: AttributesScheme;
    components?: ComponentsProperty;
    getCommon?: (
        attribute: AttributesSchemeRow
    ) => AttributeComponentCallbackProps<unknown>;
    onCommonChange?: (
        attribute: AttributesSchemeRow,
        value: unknown
    ) => Promise<void>;
    onEvent?: (attribute: AttributesSchemeRow | null, event: Event) => void;
}

export interface AttributeComponentProps<
    P extends AttributesSchemeRow = AttributesSchemeRow,
    V extends unknown = unknown,
    CV extends unknown = V
> {
    attribute: P;
    value?: V;
    isDisabled?: boolean;
    onChange: (attribute: P, newValue: CV) => Promise<void>;
    onEvent?: (attribute: P, event: Event) => void;
}
