import React, { useState, useCallback, FC } from "react";
import {
    Textinput as TextinputAttribute,
    TextinputEditingValue,
} from "../../Attribute2";
import { Event } from "../../types/Event";
import { stopEditingEvent } from "../../events";
import { AttributeComponentProps } from "../AttributesByScheme.types";

export const Textinput: FC<
    AttributeComponentProps & {
        isMultiline?: boolean;
    }
> = (props) => {
    const { attribute, onChange, isDisabled, onEvent, isMultiline } = props;
    const rawValue = (props.value as string) || "";
    const [isReadingLoading, setReadingLoading] = useState(false);
    const [isEditing, setEditing] = useState(false);

    const value = rawValue.toString();

    const emitEvent = useCallback(
        (event: Event) => {
            onEvent?.(attribute, event);
        },
        [onEvent]
    );

    const handleChange = useCallback(
        async (newValue: TextinputEditingValue) => {
            setReadingLoading(true);
            setEditing(false);
            emitEvent(stopEditingEvent());
            try {
                await onChange(attribute, newValue);
            } finally {
                setReadingLoading(false);
            }
        },
        [onChange, emitEvent]
    );

    return (
        <TextinputAttribute
            label={attribute.label}
            name={attribute.name}
            isMultiline={isMultiline}
            isEditing={isEditing}
            onEditingChange={setEditing}
            onChange={handleChange}
            editingValue={value}
            readingValue={value}
            isReadingLoading={isReadingLoading}
            isDisabled={isDisabled}
            onEvent={emitEvent}
        />
    );
};
