import React, { FC, useEffect, useRef, useCallback } from "react";
import { Instance } from "@popperjs/core";
import Spin from "../lego2/Spin";
import { Popup } from "../Popup";
import { LoadingPopupProps } from "./LoadingPopup.types";
import css from "./LoadingPopup.module.css";

export const LoadingPopup: FC<LoadingPopupProps> = (props) => {
    const {
        anchor,
        isVisible,
        isLoading,
        popperRef: outerPopperRef,
        children,
        onClose,
        scope,
    } = props;

    const popperRef = useRef<Instance>();

    useEffect(() => {
        popperRef.current?.update();
    }, [isLoading]);

    const handlePopperRef = useCallback(
        (instance: Instance) => {
            outerPopperRef?.(instance);
            popperRef.current = instance;
        },
        [outerPopperRef]
    );

    return (
        <Popup
            className={css.LoadingPopup}
            anchor={anchor}
            isVisible={isVisible}
            popperRef={handlePopperRef}
            onClose={onClose}
            scope={scope}
        >
            {isLoading && (
                <Spin view="default" position="center" progress size="xxs" />
            )}
            {!isLoading && children}
        </Popup>
    );
};
