import React, { PureComponent } from "react";
import Button from "../../lego2/Button";
import Icon from "../../lego2/Icon";
import cx from "classnames";
import { CloseButtonProps } from "./CloseButton.types";
import css from "./CloseButton.module.css";

export default class CloseButton extends PureComponent<CloseButtonProps> {
    getIconCls = (iconCls) => {
        return (
            <Icon
                className={cx(iconCls, css.CloseButton__icon)}
                svg="arrowShortDouble"
            />
        );
    };

    render() {
        const { onClose, direction } = this.props;

        return (
            <Button
                data-testid="close-panel-button"
                onClick={onClose}
                size="xs"
                pin="brick-brick"
                view="clear"
                icon={this.getIconCls}
                className={cx(css.CloseButton, css[`CloseButton_${direction}`])}
            />
        );
    }
}
