import React, { useRef, useState } from "react";
import cx from "classnames";
import Popup from "../../lego2/Popup";
import Icon from "../../lego2/Icon";
import { Text } from "../../lego2/Text";
import Button from "../../lego2/Button";
import { HeaderProps } from "./Header.types";
import CloseButton from "../CloseButton";
import { Pin } from "../Pin";
import css from "./Header.module.css";

const actionsButtonIconProvider = (iconCls: string) => (
    <Icon
        svg="ellipsis"
        svgSize="ml"
        className={cx(iconCls, css.Header__actionsIcon)}
    />
);

export const Header: React.FC<HeaderProps> = ({
    hasToggleButton,
    hasPinButton,
    panel,
    renderPopupActions,
    pin,
    name,
    position,
    onClose,
}) => {
    const actionsButtonRef = useRef<HTMLElement>(null);
    const [isVisible, setVisible] = useState(false);

    return (
        <div className={css.Header}>
            {panel && (
                <Text
                    className={css.Header__title}
                    weight="medium"
                    typography="body-long-xl"
                >
                    {panel.title}
                </Text>
            )}
            {renderPopupActions && (
                <>
                    <Button
                        size="xs"
                        view="clear"
                        className={css.Header__actionsButton}
                        title="Дополнительные действия"
                        icon={actionsButtonIconProvider}
                        onClick={() => setVisible((prev) => !prev)}
                        innerRef={actionsButtonRef}
                    />
                    <Popup
                        view="default"
                        visible={isVisible}
                        target="anchor"
                        anchor={actionsButtonRef}
                        onClose={() => setVisible(false)}
                    >
                        {renderPopupActions()}
                    </Popup>
                </>
            )}
            {hasPinButton && <Pin name={name} pin={pin} />}
            {hasToggleButton && (
                <CloseButton direction={position} onClose={onClose} />
            )}
        </div>
    );
};
