import React, { PureComponent } from "react";
import Button from "../../lego2/Button";
import { PanelButtonProps } from "./PanelButton.types";

export default class PanelButton extends PureComponent<PanelButtonProps> {
    private readonly setPanelId: () => void;
    constructor(props) {
        super(props);
        const { panel, setPanelId } = this.props;
        this.setPanelId = setPanelId(panel.id);
    }

    render() {
        const { panel, currentPanelId } = this.props;
        return (
            <Button
                onClick={this.setPanelId}
                size="m"
                direction={Button.Direction.Vertical}
                view={panel.id === currentPanelId ? "pseudo" : "clear"}
            >
                {panel.title}
            </Button>
        );
    }
}
