import React, { FC } from "react";
import cx from "classnames";
import Button from "../lego2/Button";
import Icon2 from "../lego2/Icon";
import css from "./Pin.module.css";

interface Props {
    className?: string;
    name: string;
    pin?: boolean;
    onClick?: (name: string, pin: boolean) => void;
}

export const Pin: FC<Props> = (props) => {
    const { className, onClick, name, pin } = props;

    const getIconCls = (iconCls) => (
        <Icon2 className={cx(iconCls, css.PinButton__icon)} svg="pin" />
    );

    const handleClick = () => {
        onClick?.(name, !pin);
    };

    return (
        <Button
            size="xs"
            view={props.pin ? "default" : "clear"}
            className={cx(css.PinButton, className)}
            onClick={handleClick}
            pin="brick-brick"
            title="Закрепить"
            icon={getIconCls}
        />
    );
};
