import * as React from "react";
import { Size } from "../Resizable";

export type PanelId = number | string;

export enum Position {
    Right = "right",
    Left = "left",
}

export enum Tone {
    White = "white",
    Neowhite = "neowhite",
    Superlight = "superlight",
}

export interface PanelScheme {
    id: PanelId;
    title: string;
    content: React.ReactNode;
    /**
     * @deprecated Use mountMode
     * Work as 'lazy' for mountMode
     * */
    keepMount?: boolean;
    /**
     * Mount mode for panel
     * lazy - mount on show, keep mounted on hide
     * always - mount on mount root node, keep mounted on hide
     *
     * by default – mount on show, unmount on hide
     * */
    mountMode?: "lazy" | "always";
    padding?: boolean;
    overflow?: boolean;
}

export interface Settings {
    pin?: boolean;
    panelId?: PanelId | null;
}

export interface PanelStateChangeData {
    details: {
        visibilityState: "visible" | "hidden";
        panelName: string;
        panelId: PanelId | undefined;
        panelTitle: string | undefined;
    };
}

export interface CommonProps {
    defaultSize?: Size;
    size: Size;
    minWidth?: number;
    maxWidth?: number;
    panels: PanelScheme[];
    name: string;
    className?: string;
    wrapClassName?: string;
    contentClassName?: string;
    hasToggleButton?: boolean;
    hasPinButton?: boolean;
    renderPopupActions?: () => React.ReactNode;
    canResize?: boolean;
    onSizeChange?: (size: Size) => void;
    isNewDesign?: boolean;
    width?: "max";
    hidden?: boolean;
    onPinClick?: (name: string, pin: boolean) => void;
    onPanelStateChange?: (
        data: PanelStateChangeData,
        element: HTMLDivElement | null
    ) => void;
    htmlAttributes?: Omit<React.HTMLAttributes<HTMLDivElement>, "className">;
}

export interface PanelProps extends CommonProps {
    pin?: boolean;
    position: Position;
    tone: Tone;
    panelId?: PanelId;
    setPanelId: (panelId: PanelId) => void;
}
